/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.palette;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import org.netbeans.modules.palette.Utils;
import org.netbeans.modules.palette.ui.PalettePanel;
import org.netbeans.spi.palette.PaletteController;
import org.netbeans.spi.palette.PaletteSwitch;
import org.netbeans.spi.palette.PaletteVisibility;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.windows.TopComponent;

final class PaletteTopComponent
extends TopComponent
implements PropertyChangeListener {
    static final long serialVersionUID = 4248268998485315735L;
    private static PaletteTopComponent instance;

    private PaletteTopComponent() {
        this.setName(Utils.getBundleString("CTL_Component_palette"));
        this.setToolTipText(Utils.getBundleString("HINT_PaletteComponent"));
        this.setIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/palette/resources/palette.png"));
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(505, 88));
        this.add(PalettePanel.getDefault().getScrollPane(), "Center");
        this.putClientProperty("keepPreferredSizeWhenSlideIn", Boolean.TRUE);
    }

    public void requestActive() {
        super.requestActive();
        PalettePanel.getDefault().requestFocusInWindow();
    }

    public static synchronized PaletteTopComponent getDefault() {
        if (instance == null) {
            instance = new PaletteTopComponent();
        }
        return instance;
    }

    public int getPersistenceType() {
        return 0;
    }

    public void componentOpened() {
        PaletteSwitch paletteSwitch = PaletteSwitch.getDefault();
        paletteSwitch.addPropertyChangeListener(this);
        PaletteController paletteController = paletteSwitch.getCurrentPalette();
        this.setPaletteController(paletteController);
        if (Utils.isOpenedByUser(this)) {
            PaletteVisibility.setVisible(paletteController, true);
        }
    }

    public void componentClosed() {
        PaletteSwitch paletteSwitch = PaletteSwitch.getDefault();
        paletteSwitch.removePropertyChangeListener(this);
        PaletteController paletteController = paletteSwitch.getCurrentPalette();
        PaletteVisibility.setVisible(paletteController, false);
    }

    public Object writeReplace() {
        return new ResolvableHelper();
    }

    protected String preferredID() {
        return "CommonPalette";
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("component_palette_contents".equals(propertyChangeEvent.getPropertyName())) {
            PaletteController paletteController = (PaletteController)propertyChangeEvent.getNewValue();
            this.setPaletteController(paletteController);
        }
    }

    private void setPaletteController(PaletteController paletteController) {
        if (null != paletteController) {
            PalettePanel.getDefault().setContent(paletteController, paletteController.getModel(), paletteController.getSettings());
        } else {
            PalettePanel.getDefault().setContent(null, null, null);
        }
    }

    public HelpCtx getHelpCtx() {
        return PalettePanel.getDefault().getHelpCtx();
    }

    static final class ResolvableHelper
    implements Serializable {
        static final long serialVersionUID = 7424646018839457788L;

        ResolvableHelper() {
        }

        public Object readResolve() {
            return PaletteTopComponent.getDefault();
        }
    }
}

