/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.util.JRLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JasperRunManager {
    public static String runReportToPdfFile(String sourceFileName, Map<String, Object> params, Connection conn) throws JRException {
        File sourceFile = new File(sourceFileName);
        JasperReport jasperReport = (JasperReport)JRLoader.loadObject(sourceFile);
        Map<String, Object> parameters = JasperFillManager.setFileResolver(sourceFile, params);
        JasperPrint jasperPrint = JasperFillManager.fillReport(jasperReport, parameters, conn);
        File destFile = new File(sourceFile.getParent(), jasperPrint.getName() + ".pdf");
        String destFileName = destFile.toString();
        JasperExportManager.exportReportToPdfFile(jasperPrint, destFileName);
        return destFileName;
    }

    public static String runReportToPdfFile(String sourceFileName, Map<String, Object> params) throws JRException {
        File sourceFile = new File(sourceFileName);
        JasperReport jasperReport = (JasperReport)JRLoader.loadObject(sourceFile);
        Map<String, Object> parameters = JasperFillManager.setFileResolver(sourceFile, params);
        JasperPrint jasperPrint = JasperFillManager.fillReport(jasperReport, parameters);
        File destFile = new File(sourceFile.getParent(), jasperPrint.getName() + ".pdf");
        String destFileName = destFile.toString();
        JasperExportManager.exportReportToPdfFile(jasperPrint, destFileName);
        return destFileName;
    }

    public static void runReportToPdfFile(String sourceFileName, String destFileName, Map<String, Object> parameters, Connection conn) throws JRException {
        JasperPrint jasperPrint = JasperFillManager.fillReport(sourceFileName, parameters, conn);
        JasperExportManager.exportReportToPdfFile(jasperPrint, destFileName);
    }

    public static void runReportToPdfFile(String sourceFileName, String destFileName, Map<String, Object> parameters) throws JRException {
        JasperPrint jasperPrint = JasperFillManager.fillReport(sourceFileName, parameters);
        JasperExportManager.exportReportToPdfFile(jasperPrint, destFileName);
    }

    public static void runReportToPdfStream(InputStream inputStream, OutputStream outputStream, Map<String, Object> parameters, Connection conn) throws JRException {
        JasperPrint jasperPrint = JasperFillManager.fillReport(inputStream, parameters, conn);
        JasperExportManager.exportReportToPdfStream(jasperPrint, outputStream);
    }

    public static void runReportToPdfStream(InputStream inputStream, OutputStream outputStream, Map<String, Object> parameters) throws JRException {
        JasperPrint jasperPrint = JasperFillManager.fillReport(inputStream, parameters);
        JasperExportManager.exportReportToPdfStream(jasperPrint, outputStream);
    }

    public static byte[] runReportToPdf(String sourceFileName, Map<String, Object> parameters, Connection conn) throws JRException {
        JasperPrint jasperPrint = JasperFillManager.fillReport(sourceFileName, parameters, conn);
        return JasperExportManager.exportReportToPdf(jasperPrint);
    }

    public static byte[] runReportToPdf(String sourceFileName, Map<String, Object> parameters) throws JRException {
        JasperPrint jasperPrint = JasperFillManager.fillReport(sourceFileName, parameters);
        return JasperExportManager.exportReportToPdf(jasperPrint);
    }

    public static byte[] runReportToPdf(InputStream inputStream, Map<String, Object> parameters, Connection conn) throws JRException {
        JasperPrint jasperPrint = JasperFillManager.fillReport(inputStream, parameters, conn);
        return JasperExportManager.exportReportToPdf(jasperPrint);
    }

    public static byte[] runReportToPdf(InputStream inputStream, Map<String, Object> parameters) throws JRException {
        JasperPrint jasperPrint = JasperFillManager.fillReport(inputStream, parameters);
        return JasperExportManager.exportReportToPdf(jasperPrint);
    }

    public static byte[] runReportToPdf(JasperReport jasperReport, Map<String, Object> parameters, Connection conn) throws JRException {
        JasperPrint jasperPrint = JasperFillManager.fillReport(jasperReport, parameters, conn);
        return JasperExportManager.exportReportToPdf(jasperPrint);
    }

    public static byte[] runReportToPdf(JasperReport jasperReport, Map<String, Object> parameters) throws JRException {
        JasperPrint jasperPrint = JasperFillManager.fillReport(jasperReport, parameters);
        return JasperExportManager.exportReportToPdf(jasperPrint);
    }

    public static String runReportToPdfFile(String sourceFileName, Map<String, Object> params, JRDataSource jrDataSource) throws JRException {
        File sourceFile = new File(sourceFileName);
        JasperReport jasperReport = (JasperReport)JRLoader.loadObject(sourceFile);
        Map<String, Object> parameters = JasperFillManager.setFileResolver(sourceFile, params);
        JasperPrint jasperPrint = JasperFillManager.fillReport(jasperReport, parameters, jrDataSource);
        File destFile = new File(sourceFile.getParent(), jasperPrint.getName() + ".pdf");
        String destFileName = destFile.toString();
        JasperExportManager.exportReportToPdfFile(jasperPrint, destFileName);
        return destFileName;
    }

    public static void runReportToPdfFile(String sourceFileName, String destFileName, Map<String, Object> parameters, JRDataSource jrDataSource) throws JRException {
        JasperPrint jasperPrint = JasperFillManager.fillReport(sourceFileName, parameters, jrDataSource);
        JasperExportManager.exportReportToPdfFile(jasperPrint, destFileName);
    }

    public static void runReportToPdfStream(InputStream inputStream, OutputStream outputStream, Map<String, Object> parameters, JRDataSource jrDataSource) throws JRException {
        JasperPrint jasperPrint = JasperFillManager.fillReport(inputStream, parameters, jrDataSource);
        JasperExportManager.exportReportToPdfStream(jasperPrint, outputStream);
    }

    public static byte[] runReportToPdf(String sourceFileName, Map<String, Object> parameters, JRDataSource jrDataSource) throws JRException {
        JasperPrint jasperPrint = JasperFillManager.fillReport(sourceFileName, parameters, jrDataSource);
        return JasperExportManager.exportReportToPdf(jasperPrint);
    }

    public static byte[] runReportToPdf(InputStream inputStream, Map<String, Object> parameters, JRDataSource jrDataSource) throws JRException {
        JasperPrint jasperPrint = JasperFillManager.fillReport(inputStream, parameters, jrDataSource);
        return JasperExportManager.exportReportToPdf(jasperPrint);
    }

    public static byte[] runReportToPdf(JasperReport jasperReport, Map<String, Object> parameters, JRDataSource jrDataSource) throws JRException {
        JasperPrint jasperPrint = JasperFillManager.fillReport(jasperReport, parameters, jrDataSource);
        return JasperExportManager.exportReportToPdf(jasperPrint);
    }

    public static String runReportToHtmlFile(String sourceFileName, Map<String, Object> params, Connection conn) throws JRException {
        File sourceFile = new File(sourceFileName);
        JasperReport jasperReport = (JasperReport)JRLoader.loadObject(sourceFile);
        Map<String, Object> parameters = JasperFillManager.setFileResolver(sourceFile, params);
        JasperPrint jasperPrint = JasperFillManager.fillReport(jasperReport, parameters, conn);
        File destFile = new File(sourceFile.getParent(), jasperPrint.getName() + ".html");
        String destFileName = destFile.toString();
        JasperExportManager.exportReportToHtmlFile(jasperPrint, destFileName);
        return destFileName;
    }

    public static String runReportToHtmlFile(String sourceFileName, Map<String, Object> params) throws JRException {
        File sourceFile = new File(sourceFileName);
        JasperReport jasperReport = (JasperReport)JRLoader.loadObject(sourceFile);
        Map<String, Object> parameters = JasperFillManager.setFileResolver(sourceFile, params);
        JasperPrint jasperPrint = JasperFillManager.fillReport(jasperReport, parameters);
        File destFile = new File(sourceFile.getParent(), jasperPrint.getName() + ".html");
        String destFileName = destFile.toString();
        JasperExportManager.exportReportToHtmlFile(jasperPrint, destFileName);
        return destFileName;
    }

    public static void runReportToHtmlFile(String sourceFileName, String destFileName, Map<String, Object> parameters, Connection conn) throws JRException {
        JasperPrint jasperPrint = JasperFillManager.fillReport(sourceFileName, parameters, conn);
        JasperExportManager.exportReportToHtmlFile(jasperPrint, destFileName);
    }

    public static void runReportToHtmlFile(String sourceFileName, String destFileName, Map<String, Object> parameters) throws JRException {
        JasperPrint jasperPrint = JasperFillManager.fillReport(sourceFileName, parameters);
        JasperExportManager.exportReportToHtmlFile(jasperPrint, destFileName);
    }

    public static String runReportToHtmlFile(String sourceFileName, Map<String, Object> params, JRDataSource jrDataSource) throws JRException {
        File sourceFile = new File(sourceFileName);
        JasperReport jasperReport = (JasperReport)JRLoader.loadObject(sourceFile);
        Map<String, Object> parameters = JasperFillManager.setFileResolver(sourceFile, params);
        JasperPrint jasperPrint = JasperFillManager.fillReport(jasperReport, parameters, jrDataSource);
        File destFile = new File(sourceFile.getParent(), jasperPrint.getName() + ".html");
        String destFileName = destFile.toString();
        JasperExportManager.exportReportToHtmlFile(jasperPrint, destFileName);
        return destFileName;
    }

    public static void runReportToHtmlFile(String sourceFileName, String destFileName, Map<String, Object> parameters, JRDataSource jrDataSource) throws JRException {
        JasperPrint jasperPrint = JasperFillManager.fillReport(sourceFileName, parameters, jrDataSource);
        JasperExportManager.exportReportToHtmlFile(jasperPrint, destFileName);
    }

    private JasperRunManager() {
    }
}

