/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.sort;

import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import net.sf.jasperreports.components.sort.AbstractFieldComparator;
import net.sf.jasperreports.components.sort.FilterTypeDateOperatorsEnum;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.util.FormatUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldDateComparator
extends AbstractFieldComparator<Date> {
    public FieldDateComparator(String filterPattern, Locale locale, TimeZone timeZone) {
        this.formatter = this.getFormatFactory().createDateFormat(filterPattern, locale, timeZone);
    }

    @Override
    public void initValues() throws Exception {
        if (this.valueStart != null && this.valueStart.length() > 0) {
            this.compareStart = FormatUtils.getFormattedDate((DateFormat)this.formatter, this.valueStart, ((Date)this.compareTo).getClass());
        }
        if (this.valueEnd != null && this.valueEnd.length() > 0) {
            this.compareEnd = FormatUtils.getFormattedDate((DateFormat)this.formatter, this.valueEnd, ((Date)this.compareTo).getClass());
        }
    }

    @Override
    public boolean compare(String filterTypeOperator) {
        boolean defaultResult;
        boolean result = defaultResult = true;
        boolean resultPart1 = true;
        boolean resultPart2 = true;
        try {
            this.initValues();
        }
        catch (Exception e) {
            throw new JRRuntimeException(e);
        }
        FilterTypeDateOperatorsEnum dateEnum = FilterTypeDateOperatorsEnum.getByEnumConstantName(filterTypeOperator);
        switch (dateEnum) {
            case EQUALS: {
                result = this.compareStart != null ? ((Date)this.compareTo).compareTo((Date)this.compareStart) == 0 : defaultResult;
                break;
            }
            case IS_AFTER: {
                result = this.compareStart != null ? ((Date)this.compareTo).compareTo((Date)this.compareStart) > 0 : defaultResult;
                break;
            }
            case IS_BEFORE: {
                result = this.compareStart != null ? ((Date)this.compareTo).compareTo((Date)this.compareStart) < 0 : defaultResult;
                break;
            }
            case IS_BETWEEN: {
                boolean bl = this.compareStart != null ? ((Date)this.compareTo).compareTo((Date)this.compareStart) >= 0 : (resultPart1 = defaultResult);
                resultPart2 = this.compareEnd != null ? ((Date)this.compareTo).compareTo((Date)this.compareEnd) <= 0 : defaultResult;
                result = resultPart1 && resultPart2;
                break;
            }
            case IS_NOT_BETWEEN: {
                boolean bl = this.compareStart != null ? ((Date)this.compareTo).compareTo((Date)this.compareStart) >= 0 : (resultPart1 = defaultResult);
                resultPart2 = this.compareEnd != null ? ((Date)this.compareTo).compareTo((Date)this.compareEnd) <= 0 : defaultResult;
                result = !resultPart1 || !resultPart2;
                break;
            }
            case IS_NOT_EQUAL_TO: {
                result = this.compareStart != null ? ((Date)this.compareTo).compareTo((Date)this.compareStart) != 0 : defaultResult;
                break;
            }
            case IS_ON_OR_AFTER: {
                result = this.compareStart != null ? ((Date)this.compareTo).compareTo((Date)this.compareStart) >= 0 : defaultResult;
                break;
            }
            case IS_ON_OR_BEFORE: {
                result = this.compareStart != null ? ((Date)this.compareTo).compareTo((Date)this.compareStart) <= 0 : defaultResult;
            }
        }
        return result;
    }
}

