/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jrx;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.connection.IReportConnectionFactory;
import com.jaspersoft.ireport.designer.data.queryexecuters.QueryExecuterDef;
import com.jaspersoft.ireport.locale.I18n;
import com.jaspersoft.jrx.JRTxtExporterFactory;
import com.jaspersoft.jrx.JRXMLDataSourceConnectionFactory;
import com.jaspersoft.jrx.json.JsonDataSourceConnectionFactory;
import java.io.File;
import java.io.FilenameFilter;
import java.util.List;
import java.util.ResourceBundle;
import org.openide.modules.InstalledFileLocator;
import org.openide.modules.ModuleInstall;

public class Installer
extends ModuleInstall {
    public void restored() {
        I18n.addBundleLocation((ResourceBundle)ResourceBundle.getBundle("/com/jaspersoft/jrx/Bundle"));
        List classpath = IReportManager.getInstance().getClasspath();
        File libDir = InstalledFileLocator.getDefault().locate("modules/ext", null, false);
        if (libDir != null && libDir.isDirectory()) {
            File[] jars = libDir.listFiles(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    if (name.toLowerCase().startsWith("jasperreports-extensions-") && name.toLowerCase().endsWith(".jar")) {
                        return true;
                    }
                    return name.toLowerCase().startsWith("jasperreports-json") || name.toLowerCase().endsWith(".jar");
                }
            });
            for (int i = 0; i < jars.length; ++i) {
                if (classpath.contains(jars[i].getPath())) continue;
                classpath.add(jars[i].getPath());
            }
            IReportManager.getInstance().setClasspath(classpath);
        }
        IReportManager.getInstance().addConnectionImplementationFactory((IReportConnectionFactory)new JRXMLDataSourceConnectionFactory());
        System.out.println("Adding JSON data source...");
        System.out.flush();
        IReportManager.getInstance().addConnectionImplementationFactory((IReportConnectionFactory)new JsonDataSourceConnectionFactory());
        QueryExecuterDef qed = new QueryExecuterDef("xpath2", "com.jaspersoft.jrx.query.JRXPathQueryExecuterFactory", "com.jaspersoft.ireport.designer.data.fieldsproviders.XMLFieldsProvider");
        IReportManager.getInstance().addQueryExecuterDef(qed, false);
        QueryExecuterDef qedPlSQL = new QueryExecuterDef("plsql", "com.jaspersoft.jrx.query.PlSqlQueryExecuterFactory", "com.jaspersoft.ireport.designer.data.fieldsproviders.SQLFieldsProvider");
        QueryExecuterDef qedjson = new QueryExecuterDef("json", "net.sf.jasperreports.engine.query.JsonQueryExecuterFactory", "com.jaspersoft.ireport.designer.data.fieldsproviders.SQLFieldsProvider");
        QueryExecuterDef qedJSON = new QueryExecuterDef("JSON", "net.sf.jasperreports.engine.query.JsonQueryExecuterFactory", "com.jaspersoft.ireport.designer.data.fieldsproviders.SQLFieldsProvider");
        IReportManager.getInstance().addQueryExecuterDef(qedjson, false);
        IReportManager.getInstance().addQueryExecuterDef(qedJSON, false);
        IReportManager.getInstance().addQueryExecuterDef(qedPlSQL, false);
        IReportManager.getInstance().getExporterFactories().add(new JRTxtExporterFactory());
    }
}

