/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.visualeditor.querybuilder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.netbeans.api.db.sql.support.SQLIdentifiers;
import org.netbeans.modules.db.sql.visualeditor.Log;
import org.netbeans.modules.db.sql.visualeditor.parser.ParseException;
import org.netbeans.modules.db.sql.visualeditor.querybuilder.QueryBuilderMetaData;
import org.netbeans.modules.db.sql.visualeditor.querymodel.And;
import org.netbeans.modules.db.sql.visualeditor.querymodel.Column;
import org.netbeans.modules.db.sql.visualeditor.querymodel.ColumnProvider;
import org.netbeans.modules.db.sql.visualeditor.querymodel.Expression;
import org.netbeans.modules.db.sql.visualeditor.querymodel.ExpressionList;
import org.netbeans.modules.db.sql.visualeditor.querymodel.From;
import org.netbeans.modules.db.sql.visualeditor.querymodel.GroupBy;
import org.netbeans.modules.db.sql.visualeditor.querymodel.Having;
import org.netbeans.modules.db.sql.visualeditor.querymodel.JoinTable;
import org.netbeans.modules.db.sql.visualeditor.querymodel.Or;
import org.netbeans.modules.db.sql.visualeditor.querymodel.OrderBy;
import org.netbeans.modules.db.sql.visualeditor.querymodel.Predicate;
import org.netbeans.modules.db.sql.visualeditor.querymodel.Query;
import org.netbeans.modules.db.sql.visualeditor.querymodel.SQLQueryFactory;
import org.netbeans.modules.db.sql.visualeditor.querymodel.Select;
import org.netbeans.modules.db.sql.visualeditor.querymodel.Table;
import org.netbeans.modules.db.sql.visualeditor.querymodel.Value;
import org.netbeans.modules.db.sql.visualeditor.querymodel.Where;

class QueryModel {
    private static boolean DEBUG = false;
    private Query _query = null;
    private QueryBuilderMetaData qbMetaData;
    private SQLIdentifiers.Quoter quoter;

    QueryModel(SQLIdentifiers.Quoter quoter) {
        this.quoter = quoter;
    }

    void parse(String string) throws ParseException {
        this._query = SQLQueryFactory.parse(string);
    }

    String genText() {
        Log.getLogger().entering("QueryModel", "genText");
        if (DEBUG) {
            new Throwable().printStackTrace();
        }
        if (this._query == null) {
            return null;
        }
        return this._query.genText(this.quoter);
    }

    Select getSelect() {
        return this._query.getSelect();
    }

    From getFrom() {
        return this._query.getFrom();
    }

    Where getWhere() {
        return this._query == null ? null : this._query.getWhere();
    }

    GroupBy getGroupBy() {
        return this._query.getGroupBy();
    }

    OrderBy getOrderBy() {
        return this._query.getOrderBy();
    }

    Having getHaving() {
        return this._query.getHaving();
    }

    void setSelect(Select select) {
        this._query.setSelect(select);
    }

    void setFrom(From from) {
        this._query.setFrom(from);
    }

    void setWhere(Where where) {
        this._query.setWhere(where);
    }

    void setGroupBy(GroupBy groupBy) {
        this._query.setGroupBy(groupBy);
    }

    void setOrderBy(OrderBy orderBy) {
        this._query.setOrderBy(orderBy);
    }

    void setHaving(Having having) {
        this._query.setHaving(having);
    }

    void removeGroupBy() {
        this.setGroupBy(null);
    }

    boolean hasGroupBy() {
        return this._query.getGroupBy() != null;
    }

    void insertTable(JoinTable joinTable) {
        this._query.getFrom().addTable(joinTable);
    }

    void removeTable(String string) {
        Log.getLogger().entering("QueryModel", "removeTable", string);
        this._query.removeTable(string);
    }

    void replaceStar(ColumnProvider columnProvider) {
        Log.getLogger().entering("QueryModel", "replaceStar");
        this._query.replaceStar(columnProvider);
    }

    void addColumn(String string, String string2) {
        this._query.addColumn(string, string2);
    }

    void removeColumn(String string, String string2) {
        this._query.removeColumn(string, string2);
    }

    Expression findCond(String string, String string2, String string3, String string4) {
        return this._query.getWhere().findExpression(string, string2, string3, string4);
    }

    Table findTable(String string) {
        if (this._query != null && this._query.getFrom() != null) {
            return this._query.getFrom().findTable(string);
        }
        return null;
    }

    Column findSelectColumn(String string, String string2) {
        ArrayList arrayList = new ArrayList();
        this._query.getSelect().getReferencedColumns(arrayList);
        for (int i = 0; i < arrayList.size(); ++i) {
            Column column = (Column)arrayList.get(i);
            if (!column.matches(string, string2)) continue;
            return column;
        }
        return null;
    }

    String getFullTableName(String string) {
        if (this._query != null && this._query.getFrom() != null && string != null) {
            return this._query.getFrom().getFullTableName(string);
        }
        return null;
    }

    String genUniqueName(String string) {
        if (this.findTable(string) == null) {
            return null;
        }
        String[] stringArray = string.split("\\.");
        String string2 = stringArray.length > 1 ? stringArray[1] : stringArray[0];
        int n = 1;
        String string3;
        while (this.findTable(string3 = string2 + "_" + n) != null) {
            ++n;
        }
        return string3;
    }

    void addSortSpecification(String string, String string2, String string3, int n) {
        OrderBy orderBy = this.getOrderBy();
        if (orderBy == null) {
            orderBy = SQLQueryFactory.createOrderBy();
            this.setOrderBy(orderBy);
        }
        orderBy.removeSortSpecification(string, string2);
        orderBy.addSortSpecification(string, string2, string3, n);
    }

    void removeSortSpecification(String string, String string2) {
        OrderBy orderBy = this.getOrderBy();
        if (orderBy != null) {
            orderBy.removeSortSpecification(string, string2);
        }
    }

    int getSortCount() {
        OrderBy orderBy = this.getOrderBy();
        if (orderBy == null) {
            return 0;
        }
        return orderBy.getSortSpecificationCount();
    }

    void setDerivedColName(String string, String string2, String string3) {
        Column column = this.findSelectColumn(string, string2);
        if (column != null) {
            column.setDerivedColName(string3);
        }
    }

    void removeDerivedColName(String string, String string2) {
        this.setDerivedColName(string, string2, null);
    }

    boolean isParameterized() {
        Where where = this.getWhere();
        if (where == null) {
            return false;
        }
        return where.isParameterized();
    }

    void getParameterizedPredicates(Collection collection) {
        Where where = this.getWhere();
        if (where == null) {
            return;
        }
        Expression expression = where.getExpression();
        this.getParameterized(expression, collection);
    }

    private void getParameterized(Expression expression, Collection collection) {
        block4: {
            Value value;
            Value value2;
            block5: {
                block3: {
                    if (!(expression instanceof ExpressionList)) break block3;
                    for (int i = 0; i < ((ExpressionList)expression).size(); ++i) {
                        Expression expression2 = ((ExpressionList)expression).getExpression(i);
                        this.getParameterized(expression2, collection);
                    }
                    break block4;
                }
                if (!expression.isParameterized() || !(expression instanceof Predicate)) break block4;
                Predicate predicate = (Predicate)expression;
                value2 = predicate.getVal1();
                value = predicate.getVal2();
                if (!value2.isParameterized()) break block5;
                String string = value2.genText(this.quoter);
                for (int i = 0; i < string.length(); ++i) {
                    if (string.charAt(i) != '?') continue;
                    collection.add(value.genText(this.quoter));
                }
                break block4;
            }
            if (!value.isParameterized()) break block4;
            String string = value.genText(this.quoter);
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) != '?') continue;
                collection.add(value2.genText(this.quoter));
            }
        }
    }

    void renameTableSpec(String string, String string2) {
        Log.getLogger().entering("QueryModel", "renameTableSpec", new Object[]{string, string2});
        this._query.renameTableSpec(string, string2);
    }

    JoinTable findJoinTable(String string, String string2, String string3, String string4) {
        return this._query.getFrom().findJoinTable(string, string2, string3, string4);
    }

    public void getColumnNames(String string, Collection collection) {
        ArrayList arrayList = new ArrayList();
        this.getSelect().getReferencedColumns(arrayList);
        for (int i = 0; i < arrayList.size(); ++i) {
            Column column;
            Object e = arrayList.get(i);
            if (!(e instanceof Column) || (column = (Column)e) == null) continue;
            String string2 = column.getColumnName();
            String string3 = column.getTableSpec();
            if (string2 == null || string3 == null || !string2.equals("*") && !string3.equals(string)) continue;
            collection.add(string2);
        }
    }

    void addGroupBy() {
        ArrayList arrayList = new ArrayList();
        this.getSelect().getReferencedColumns(arrayList);
        this.setGroupBy(SQLQueryFactory.createGroupBy(arrayList));
    }

    void addRelationships(JoinTable joinTable, List list) {
        if (list.isEmpty()) {
            return;
        }
        String[] stringArray = (String[])list.get(0);
        String string = this._query.getFrom().getTableSpec(stringArray[0]);
        String string2 = this._query.getFrom().getTableSpec(stringArray[2]);
        String string3 = this._query.getFrom().getPreviousTableFullName();
        if (stringArray[0].equals(string3) || stringArray[2].equals(string3)) {
            joinTable.addJoinCondition(stringArray);
        } else {
            this.addOrCreateAndExpression(SQLQueryFactory.createPredicate(stringArray));
        }
        for (int i = 1; i < list.size(); ++i) {
            stringArray = (String[])list.get(i);
            this.addOrCreateAndExpression(SQLQueryFactory.createPredicate(stringArray));
        }
    }

    void removeCondition(Predicate predicate) {
        Where where = this.getWhere();
        if (where == null || where.getExpression() == null) {
            return;
        }
        Expression expression = this.getWhere().getExpression();
        if ((expression = this.removeConditionFromExpression(predicate, expression)) == null) {
            where.resetExpression();
            this._query.setWhere(null);
        } else {
            where.replaceExpression(expression);
        }
    }

    private Expression removeConditionFromExpression(Predicate predicate, Expression expression) {
        Value value = predicate.getVal1();
        Value value2 = predicate.getVal2();
        if (expression instanceof Predicate) {
            Predicate predicate2 = (Predicate)expression;
            Value value3 = predicate2.getVal1();
            Value value4 = predicate2.getVal2();
            if (value3 instanceof Column && value4 instanceof Column && value instanceof Column && value2 instanceof Column) {
                Column column = (Column)value3;
                Column column2 = (Column)value4;
                Column column3 = (Column)value;
                Column column4 = (Column)value2;
                if (column.equals(column3) && column2.equals(column4)) {
                    return null;
                }
            }
        } else if (expression instanceof ExpressionList) {
            int n;
            ExpressionList expressionList = (ExpressionList)expression;
            for (n = expressionList.size() - 1; n >= 0; --n) {
                Expression expression2 = this.removeConditionFromExpression(predicate, expressionList.getExpression(n));
                if (expression2 == null) {
                    expressionList.removeExpression(n);
                    continue;
                }
                expressionList.replaceExpression(n, expression2);
            }
            n = expressionList.size();
            if (n == 0) {
                return null;
            }
            if (n == 1) {
                return expressionList.getExpression(0);
            }
        }
        return expression;
    }

    int getCriteriaCount() {
        Expression expression;
        Where where = this.getWhere();
        if (where != null && (expression = where.getExpression()) != null) {
            if (expression instanceof And) {
                return ((ExpressionList)expression).size();
            }
            return 1;
        }
        return 0;
    }

    void removeJoinNode(String string, String string2, String string3, String string4) {
        JoinTable joinTable;
        if (this.getFrom() != null && (joinTable = this.getFrom().findJoinTable(string, string2, string3, string4)) != null) {
            joinTable.setJoinType(null);
            joinTable.setExpression(null);
        }
    }

    void removeCriteria(String string, String string2, int n) {
        Where where = this.getWhere();
        if (where != null) {
            Expression expression = where.getExpression();
            if (expression == null) {
                return;
            }
            if ((expression = this.removeCriteriaFromExpression(string, string2, expression, n)) == null) {
                where.resetExpression();
                this._query.setWhere(null);
            } else {
                where.replaceExpression(expression);
            }
        }
    }

    private Expression removeCriteriaFromExpression(String string, String string2, Expression expression, int n) {
        if (expression instanceof Predicate) {
            Predicate predicate = (Predicate)expression;
            Value value = predicate.getVal1();
            Value value2 = predicate.getVal2();
            if (predicate.isCriterion() && (value instanceof Column && ((Column)value).matches(string, string2) || value2 instanceof Column && ((Column)value2).matches(string, string2))) {
                return null;
            }
        } else if (n > 0 && expression instanceof ExpressionList) {
            int n2;
            --n;
            ExpressionList expressionList = (ExpressionList)expression;
            for (n2 = expressionList.size() - 1; n2 >= 0; --n2) {
                Expression expression2 = this.removeCriteriaFromExpression(string, string2, expressionList.getExpression(n2), n);
                if (expression2 == null) {
                    expressionList.removeExpression(n2);
                    continue;
                }
                expressionList.replaceExpression(n2, expression2);
            }
            n2 = expressionList.size();
            if (n2 == 0) {
                return null;
            }
            if (n2 == 1) {
                return expressionList.getExpression(0);
            }
        }
        return expression;
    }

    void addCriteria(String string, String string2, Predicate predicate) {
        Where where;
        if (DEBUG) {
            System.out.println("Entering QueryModel.addCriteriaOrder () tableSpec = " + string + " ColumnName = " + string2 + " Predicate = " + predicate + "\n");
        }
        if ((where = this.getWhere()) == null) {
            this.setWhere(SQLQueryFactory.createWhere(predicate));
        } else {
            Expression expression = where.getExpression();
            if (expression == null) {
                where.replaceExpression(predicate);
            } else {
                this.addOrCreateAndExpression(predicate);
            }
        }
    }

    void replaceCriteria(String string, String string2, Predicate predicate, int n) {
        Where where;
        Expression expression;
        --n;
        if (DEBUG) {
            System.out.println("Entering QueryModel.replaceCriteria () tableSpec = " + string + " ColumnName = " + string2 + " Predicate = " + predicate + " Order = " + n + "\n");
        }
        if ((expression = (where = this.getWhere()).getExpression()) instanceof ExpressionList) {
            ((ExpressionList)expression).replaceExpression(n, predicate);
        } else {
            where.replaceExpression(predicate);
        }
    }

    void addCriteria(String string, String string2, Predicate predicate, int n) {
        Where where;
        Expression expression;
        --n;
        if (DEBUG) {
            System.out.println("Entering QueryModel.addCriteriaOrder () tableSpec = " + string + " ColumnName = " + string2 + " Predicate = " + predicate + " Order = " + n + "\n");
        }
        if ((expression = (where = this.getWhere()).getExpression()) instanceof And) {
            ((ExpressionList)expression).addExpression(n, predicate);
        } else if (expression == null) {
            where.replaceExpression(predicate);
        } else {
            expression = n == 0 ? SQLQueryFactory.createAnd(predicate, expression) : SQLQueryFactory.createAnd(expression, predicate);
            this.getWhere().replaceExpression(expression);
        }
    }

    void addOrCreateAndExpression(Predicate predicate) {
        Expression expression;
        if (this.getWhere() != null && (expression = this.getWhere().getExpression()) != null) {
            if (expression instanceof And) {
                And and = (And)expression;
                and.addExpression(predicate);
            } else {
                expression = SQLQueryFactory.createAnd(expression, predicate);
                this.getWhere().replaceExpression(expression);
            }
            return;
        }
        this.setWhere(SQLQueryFactory.createWhere(predicate));
    }

    void addOrCreateOrExpression(Predicate predicate) {
        Expression expression;
        if (this.getWhere() != null && (expression = this.getWhere().getExpression()) != null) {
            if (expression instanceof Or) {
                Or or = (Or)expression;
                or.addExpression(predicate);
                return;
            }
            expression = SQLQueryFactory.createOr(expression, predicate);
            this.getWhere().replaceExpression(expression);
            return;
        }
        this.setWhere(SQLQueryFactory.createWhere(predicate));
    }
}

