/*
 * Decompiled with CFR 0.152.
 */
package rex.graphics.datasourcetree.elements;

import javax.swing.ImageIcon;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import rex.graphics.datasourcetree.elements.DataSourceTreeElement;
import rex.metadata.ServerMetadata;
import rex.utils.DOM;
import rex.utils.I18n;
import rex.utils.S;

public class CubeElement
implements DataSourceTreeElement {
    private String dataSourceInfo;
    private String catalogName;
    private String cubeName;
    private String cubeType;
    private String lastSchemaUpdate;
    private String lastDataUpdate;
    private String isDrillthroughEnabled;
    private String isLinkable;
    private String isWriteEnabled;
    private String isSQLEnabled;
    private ServerMetadata parent;
    static ImageIcon icon = S.getAppIcon("cube.gif");

    public CubeElement(ServerMetadata svm, Node rowNode, String myDataSourceInfo) {
        this.parent = svm;
        this.dataSourceInfo = myDataSourceInfo;
        NodeList nl = rowNode.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            if (nl.item(i).getNodeType() != 1) continue;
            if (nl.item(i).getNodeName().equals("CATALOG_NAME")) {
                this.catalogName = DOM.getTextFromDOMElement(nl.item(i));
                continue;
            }
            if (nl.item(i).getNodeName().equals("CUBE_NAME")) {
                this.cubeName = DOM.getTextFromDOMElement(nl.item(i));
                continue;
            }
            if (nl.item(i).getNodeName().equals("CUBE_TYPE")) {
                this.cubeType = DOM.getTextFromDOMElement(nl.item(i));
                continue;
            }
            if (nl.item(i).getNodeName().equals("LAST_SCHEMA_UPDATE")) {
                this.lastSchemaUpdate = DOM.getTextFromDOMElement(nl.item(i));
                continue;
            }
            if (nl.item(i).getNodeName().equals("LAST_DATA_UPDATE")) {
                this.lastDataUpdate = DOM.getTextFromDOMElement(nl.item(i));
                continue;
            }
            if (nl.item(i).getNodeName().equals("IS_DRILLTHROUGH_ENABLED")) {
                this.isDrillthroughEnabled = DOM.getTextFromDOMElement(nl.item(i));
                continue;
            }
            if (nl.item(i).getNodeName().equals("IS_LINKABLE")) {
                this.isLinkable = DOM.getTextFromDOMElement(nl.item(i));
                continue;
            }
            if (nl.item(i).getNodeName().equals("IS_WRITE_ENABLED")) {
                this.isWriteEnabled = DOM.getTextFromDOMElement(nl.item(i));
                continue;
            }
            if (!nl.item(i).getNodeName().equals("IS_SQL_ENABLED")) continue;
            this.isSQLEnabled = DOM.getTextFromDOMElement(nl.item(i));
        }
    }

    public DataSourceTreeElement[] getChildren() {
        return null;
    }

    public String toString() {
        if (this.cubeName == null) {
            return I18n.getString("toolTip.notInitialized");
        }
        return "" + this.cubeName;
    }

    public ImageIcon getIcon() {
        return icon;
    }

    public String getToolTip() {
        if (this.catalogName == null) {
            return I18n.getString("toolTip.notInitialized");
        }
        return "" + this.cubeName + I18n.getString("toolTip.type") + this.cubeType + I18n.getString("toolTip.lastSchemaUpdate") + this.lastSchemaUpdate + I18n.getString("toolTip.lastDataUpdate") + this.lastDataUpdate;
    }

    public String[] getPopUpActionList() {
        return new String[]{I18n.getString("menu.explore1"), I18n.getString("menu.explore2"), I18n.getString("menu.explore3")};
    }

    public ServerMetadata getServerMetaData() {
        return this.parent;
    }

    public String getDataSourceInfo() {
        return this.dataSourceInfo;
    }

    public String getCubeName() {
        return this.cubeName;
    }

    public String getCatalogName() {
        return this.catalogName;
    }
}

