/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.welcome;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.locale.I18n;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.JEditorPane;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.StatusDisplayer;
import org.openide.util.NbBundle;

public class WebContentPanel
extends JPanel {
    private String contentUrl = null;
    private JEditorPane jEditorPane1;
    private JMenuItem jMenuItem1;
    private JPopupMenu jPopupMenu1;

    public WebContentPanel(final String url) {
        this.initComponents();
        this.contentUrl = url;
        this.jEditorPane1.setContentType("text/html");
        URL img_url = this.getClass().getResource("/com/jaspersoft/ireport/designer/welcome/loader.gif");
        if (IReportManager.getInstance().isNoNetwork()) {
            this.jEditorPane1.setText("<html><body><br><br><font color=\"#AAAAAA\">Network disabled</font><br><br></body></html>");
        } else {
            this.jEditorPane1.setText("<html><body><br><br><img src=\"" + img_url + "\"><br><br></body></html>");
        }
        this.jEditorPane1.addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ENTERED) {
                    StatusDisplayer.getDefault().setStatusText(e.getURL().toString());
                } else if (e.getEventType() == HyperlinkEvent.EventType.EXITED) {
                    StatusDisplayer.getDefault().setStatusText("");
                } else if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    try {
                        HtmlBrowser.URLDisplayer displayer = HtmlBrowser.URLDisplayer.getDefault();
                        if (displayer != null) {
                            displayer.showURL(e.getURL());
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
        if (!IReportManager.getInstance().isNoNetwork()) {
            new Thread(new Runnable(){

                public void run() {
                    try {
                        WebContentPanel.this.jEditorPane1.setPage(url);
                    }
                    catch (Throwable ex) {
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                WebContentPanel.this.jEditorPane1.setText("<html><body><br><br><font face=\"Arial\" size=\"-1\" color=\"888888\">" + I18n.getString("error.loading.web.resource") + "</font><br><br></body></html>");
                            }
                        });
                    }
                }
            }).start();
        }
        this.jEditorPane1.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                WebContentPanel.this.updateUI();
            }

            public void removeUpdate(DocumentEvent e) {
                WebContentPanel.this.updateUI();
            }

            public void changedUpdate(DocumentEvent e) {
                WebContentPanel.this.updateUI();
            }
        });
    }

    private void initComponents() {
        this.jPopupMenu1 = new JPopupMenu();
        this.jMenuItem1 = new JMenuItem();
        this.jEditorPane1 = new JEditorPane();
        this.jMenuItem1.setText(NbBundle.getMessage(WebContentPanel.class, (String)"WebContentPanel.jMenuItem1.text"));
        this.jMenuItem1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                WebContentPanel.this.jMenuItem1ActionPerformed(evt);
            }
        });
        this.jPopupMenu1.add(this.jMenuItem1);
        this.setMinimumSize(new Dimension(300, 250));
        this.setLayout(new BorderLayout());
        this.jEditorPane1.setBorder(null);
        this.jEditorPane1.setEditable(false);
        this.jEditorPane1.setComponentPopupMenu(this.jPopupMenu1);
        this.add((Component)this.jEditorPane1, "Center");
    }

    private void jMenuItem1ActionPerformed(ActionEvent evt) {
        new Thread(new Runnable(){

            public void run() {
                try {
                    WebContentPanel.this.jEditorPane1.setPage(WebContentPanel.this.getContentUrl());
                }
                catch (Throwable ex) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            WebContentPanel.this.jEditorPane1.setText("<html><body><br><br><font face=\"Arial\" size=\"-1\" color=\"888888\">" + I18n.getString("error.loading.web.resource") + "</font><br><br></body></html>");
                        }
                    });
                }
            }
        }).start();
    }

    public String getContentUrl() {
        return this.contentUrl;
    }

    public void setContentUrl(String contentUrl) {
        this.contentUrl = contentUrl;
    }
}

