/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.utils;

import com.jaspersoft.ireport.locale.I18n;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import org.openide.awt.Actions;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.actions.Presenter;
import org.openide.util.lookup.Lookups;

public class SubMenuAction
extends AbstractAction
implements HelpCtx.Provider,
Presenter.Popup {
    private static Map<String, SubMenuAction> nodeActionsMap = new HashMap<String, SubMenuAction>();
    private JMenu menu = null;
    private String layerPath = null;

    public static SubMenuAction getAction(String layerPath) {
        SubMenuAction action = null;
        if (!nodeActionsMap.containsKey(layerPath)) {
            action = new SubMenuAction(layerPath);
            nodeActionsMap.put(layerPath, action);
        } else {
            action = nodeActionsMap.get(layerPath);
        }
        return action;
    }

    private SubMenuAction(String layerPath) {
        this.layerPath = layerPath;
    }

    public String getName() {
        return I18n.getString(this.getLayerPath());
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public JMenuItem getPopupPresenter() {
        this.menu = new JMenu(this.getName());
        FileObject nodesFileObject = Repository.getDefault().getDefaultFileSystem().getRoot().getFileObject(this.getLayerPath());
        if (nodesFileObject == null) {
            return null;
        }
        DataFolder nodesDataFolder = DataFolder.findFolder((FileObject)nodesFileObject);
        if (nodesDataFolder == null) {
            return null;
        }
        Lookup lookup = Lookups.forPath((String)this.getLayerPath());
        Collection nodeActions = lookup.lookupAll(Object.class);
        Lookup context = Lookup.getDefault();
        for (Object obj : nodeActions) {
            if (obj instanceof Action) {
                JMenuItem mi = new JMenuItem();
                Actions.connect((JMenuItem)mi, (Action)((Action)obj), (boolean)true);
                Icon icon = (Icon)((Action)obj).getValue("SmallIcon");
                if (icon != null) {
                    mi.setIcon(icon);
                }
                this.menu.add(mi);
                continue;
            }
            if (!(obj instanceof JSeparator)) continue;
            this.menu.add((JSeparator)obj);
        }
        return this.menu;
    }

    public String getLayerPath() {
        return this.layerPath;
    }

    public void setLayerPath(String layerPath) {
        this.layerPath = layerPath;
    }

    public void actionPerformed(ActionEvent arg0) {
    }
}

