/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.tools;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.editor.ExpressionContext;
import com.jaspersoft.ireport.designer.tools.JRSubreportReturnValueDialog;
import com.jaspersoft.ireport.designer.tools.SubreportReturnValueCellRenderer;
import com.jaspersoft.ireport.locale.I18n;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import net.sf.jasperreports.engine.design.JRDesignSubreportReturnValue;
import net.sf.jasperreports.engine.design.JRDesignVariable;
import org.jdesktop.swingx.JXTable;

public class SubreportReturnValuesPanel
extends JPanel {
    private List returnValues = new ArrayList();
    private ExpressionContext expressionContext = null;
    private JButton jButtonAdd;
    private JButton jButtonDelete;
    private JButton jButtonModify;
    private JLabel jLabelTitle;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JTable jTable;

    public ExpressionContext getExpressionContext() {
        return this.expressionContext;
    }

    public void setExpressionContext(ExpressionContext expressionContext) {
        this.expressionContext = expressionContext;
    }

    public List getReturnValues() {
        return this.returnValues;
    }

    public void setReturnValues(List oldReturnVariables) {
        this.returnValues.clear();
        DefaultTableModel model = (DefaultTableModel)this.jTable.getModel();
        for (JRDesignSubreportReturnValue oldReturnValue : oldReturnVariables) {
            JRDesignSubreportReturnValue returnValue = new JRDesignSubreportReturnValue();
            returnValue.setSubreportVariable(oldReturnValue.getSubreportVariable());
            returnValue.setCalculation(oldReturnValue.getCalculationValue());
            returnValue.setIncrementerFactoryClassName(oldReturnValue.getIncrementerFactoryClassName());
            returnValue.setToVariable(oldReturnValue.getToVariable());
            this.returnValues.add(returnValue);
            model.addRow(new Object[]{returnValue, returnValue.getToVariable()});
        }
    }

    public SubreportReturnValuesPanel() {
        this.initComponents();
        DefaultListSelectionModel dlsm = (DefaultListSelectionModel)this.jTable.getSelectionModel();
        dlsm.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                SubreportReturnValuesPanel.this.jTableSelectionValueChanged(e);
            }
        });
        this.jTable.getColumnModel().getColumn(0).setCellRenderer(new SubreportReturnValueCellRenderer());
        this.jLabelTitle.setText(I18n.getString("SubreportReturnValuesPanel.jLabelTitle.text"));
        this.jButtonAdd.setText(I18n.getString("Global.Button.Add"));
        this.jButtonModify.setText(I18n.getString("SubreportParametersPanel.jButtonModify.text"));
        this.jButtonDelete.setText(I18n.getString("Global.Button.Delete"));
    }

    public void jTableSelectionValueChanged(ListSelectionEvent e) {
        if (this.jTable.getSelectedRowCount() > 0) {
            this.jButtonModify.setEnabled(true);
            this.jButtonDelete.setEnabled(true);
        } else {
            this.jButtonModify.setEnabled(false);
            this.jButtonDelete.setEnabled(false);
        }
    }

    private void initComponents() {
        this.jLabelTitle = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jTable = new JXTable();
        this.jPanel1 = new JPanel();
        this.jButtonAdd = new JButton();
        this.jButtonModify = new JButton();
        this.jButtonDelete = new JButton();
        this.setLayout(new GridBagLayout());
        this.jLabelTitle.setText(I18n.getString("SubreportParametersPanel.jLabelTitle.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 0, 4);
        this.add((Component)this.jLabelTitle, gridBagConstraints);
        this.jScrollPane1.setPreferredSize(new Dimension(375, 275));
        this.jTable.setModel(new DefaultTableModel(new Object[0][], new String[]{"Subreport Variable", "Destination Variable"}){
            boolean[] canEdit;
            {
                this.canEdit = new boolean[]{false, false};
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.jTable.setOpaque(false);
        this.jTable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                SubreportReturnValuesPanel.this.jTableMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTable);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.jButtonAdd.setText(I18n.getString("Global.Button.Add"));
        this.jButtonAdd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SubreportReturnValuesPanel.this.jButtonAddActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 4);
        this.jPanel1.add((Component)this.jButtonAdd, gridBagConstraints);
        this.jButtonModify.setText(I18n.getString("SubreportParametersPanel.jButtonModify.text"));
        this.jButtonModify.setEnabled(false);
        this.jButtonModify.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SubreportReturnValuesPanel.this.jButtonModifyActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 4);
        this.jPanel1.add((Component)this.jButtonModify, gridBagConstraints);
        this.jButtonDelete.setText(I18n.getString("Global.Button.Delete"));
        this.jButtonDelete.setEnabled(false);
        this.jButtonDelete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SubreportReturnValuesPanel.this.jButtonDeleteActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 4);
        this.jPanel1.add((Component)this.jButtonDelete, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.add((Component)this.jPanel1, gridBagConstraints);
    }

    private void jButtonAddActionPerformed(ActionEvent evt) {
        List localVariables = IReportManager.getInstance().getActiveReport().getVariablesList();
        int count = 0;
        for (int i = 0; count == 0 && i < localVariables.size(); ++i) {
            JRDesignVariable var = (JRDesignVariable)localVariables.get(i);
            if (var.isSystemDefined()) continue;
            ++count;
        }
        if (count == 0) {
            JOptionPane.showMessageDialog(this, I18n.getString("SubreportReturnValuesPanel.Message.Warning"), I18n.getString("SubreportReturnValuesPanel.Message.Error"), 2);
            return;
        }
        Window pWin = SwingUtilities.getWindowAncestor(this);
        JRSubreportReturnValueDialog jrpd = null;
        jrpd = pWin instanceof Dialog ? new JRSubreportReturnValueDialog((Dialog)pWin) : new JRSubreportReturnValueDialog((Frame)pWin);
        jrpd.updateVariables();
        jrpd.setVisible(true);
        if (jrpd.getDialogResult() == 0) {
            JRDesignSubreportReturnValue returnValue = jrpd.getSubreportReturnValue();
            this.returnValues.add(returnValue);
            DefaultTableModel model = (DefaultTableModel)this.jTable.getModel();
            model.addRow(new Object[]{returnValue, returnValue.getToVariable()});
        }
    }

    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        DefaultTableModel model = (DefaultTableModel)this.jTable.getModel();
        while (this.jTable.getSelectedRow() >= 0) {
            int row = this.jTable.getSelectedRow();
            row = ((JXTable)this.jTable).convertRowIndexToModel(row);
            this.returnValues.remove(model.getValueAt(row, 0));
            model.removeRow(row);
        }
    }

    private void jButtonModifyActionPerformed(ActionEvent evt) {
        DefaultTableModel model = (DefaultTableModel)this.jTable.getModel();
        int row = this.jTable.getSelectedRow();
        if (row < 0) {
            return;
        }
        row = ((JXTable)this.jTable).convertRowIndexToModel(row);
        JRDesignSubreportReturnValue oldReturnValue = (JRDesignSubreportReturnValue)model.getValueAt(row, 0);
        Window pWin = SwingUtilities.windowForComponent(this);
        JRSubreportReturnValueDialog jrpd = null;
        jrpd = pWin instanceof Dialog ? new JRSubreportReturnValueDialog((Dialog)pWin) : (pWin instanceof Frame ? new JRSubreportReturnValueDialog((Frame)pWin) : new JRSubreportReturnValueDialog((Dialog)null));
        jrpd.setSubreportReturnValue(oldReturnValue);
        jrpd.setVisible(true);
        if (jrpd.getDialogResult() == 0) {
            JRDesignSubreportReturnValue newReturnValue = jrpd.getSubreportReturnValue();
            this.returnValues.set(row, newReturnValue);
            model.setValueAt(newReturnValue, row, 0);
            model.setValueAt(newReturnValue.getToVariable(), row, 1);
            this.jTable.updateUI();
        }
    }

    private void jTableMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2 && SwingUtilities.isLeftMouseButton(evt) && this.jTable.getSelectedRowCount() > 0) {
            this.jButtonModifyActionPerformed(null);
        }
    }
}

