/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.sheet.editors;

import com.jaspersoft.ireport.locale.I18n;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class JRImportDialog
extends JDialog {
    String originalName = null;
    private String[] currentImports = null;
    private JButton jButtonCancel;
    private JButton jButtonOK;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JPanel jPanelExpression;
    private JTextField jTextFieldName;
    private int dialogResult;

    public JRImportDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.applyI18n();
        KeyStroke escape = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction escapeAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                JRImportDialog.this.jButtonCancelActionPerformed(e);
            }
        };
        this.getRootPane().getInputMap(2).put(escape, I18n.getString("Global.Pane.Escape"));
        this.getRootPane().getActionMap().put(I18n.getString("Global.Pane.Escape"), escapeAction);
        this.jTextFieldName.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                JRImportDialog.this.checkImport();
            }

            public void removeUpdate(DocumentEvent e) {
                JRImportDialog.this.checkImport();
            }

            public void changedUpdate(DocumentEvent e) {
                JRImportDialog.this.checkImport();
            }
        });
        this.getRootPane().setDefaultButton(this.jButtonOK);
        this.setTitle(I18n.getString("JRImportDialog.title"));
    }

    public void checkImport() {
        String text = this.jTextFieldName.getText();
        this.jButtonOK.setEnabled(true);
        this.jLabel2.setText(" ");
        if (text.trim().length() == 0 || !text.matches("(\\bstatic\\b(\\s)+)?(\\p{Alpha}\\p{Alnum}*\\_*\\.)*(\\p{Alpha}\\p{Alnum}*\\_*)(\\.\\*)?")) {
            this.jLabel2.setText(I18n.getString("JRImportDialog.invalidImport"));
            this.jButtonOK.setEnabled(false);
            return;
        }
        if (text.equals(this.originalName)) {
            return;
        }
        if (this.getCurrentImports() != null) {
            for (int i = 0; i < this.getCurrentImports().length; ++i) {
                String ci = this.getCurrentImports()[i].trim();
                if (ci.equals(this.originalName) || !ci.equals(text)) continue;
                this.jLabel2.setText(I18n.getString("JRImportDialog.importAlreadyPresent"));
                this.jButtonOK.setEnabled(false);
                return;
            }
        }
    }

    void setImports(String[] imports) {
        this.currentImports = imports;
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jTextFieldName = new JTextField();
        this.jPanelExpression = new JPanel();
        this.jLabel2 = new JLabel();
        this.jPanel1 = new JPanel();
        this.jButtonOK = new JButton();
        this.jButtonCancel = new JButton();
        this.setTitle("Add/modify property");
        this.setModal(true);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                JRImportDialog.this.closeDialog(evt);
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.jLabel1.setText("Import");
        this.jLabel1.setMaximumSize(new Dimension(1000, 100));
        this.jLabel1.setMinimumSize(new Dimension(100, 15));
        this.jLabel1.setPreferredSize(new Dimension(100, 15));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.getContentPane().add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.getContentPane().add((Component)this.jTextFieldName, gridBagConstraints);
        this.jPanelExpression.setMinimumSize(new Dimension(10, 50));
        this.jPanelExpression.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.getContentPane().add((Component)this.jPanelExpression, gridBagConstraints);
        this.jLabel2.setForeground(new Color(204, 0, 0));
        this.jLabel2.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jLabel2, gridBagConstraints);
        this.jPanel1.setMinimumSize(new Dimension(200, 35));
        this.jPanel1.setPreferredSize(new Dimension(250, 35));
        this.jPanel1.setLayout(new FlowLayout(2));
        this.jButtonOK.setMnemonic('o');
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRImportDialog.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jButtonOK);
        this.jButtonCancel.setMnemonic('c');
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRImportDialog.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jButtonCancel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screenSize.width - 515) / 2, (screenSize.height - 147) / 2, 515, 147);
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.setDialogResult(2);
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (this.jTextFieldName.getText().trim().length() <= 0) {
            JOptionPane.showMessageDialog(this, I18n.getString("JRImportDialog.Message.Warning"), "", 2);
            return;
        }
        this.setVisible(false);
        this.setDialogResult(0);
        this.dispose();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.setDialogResult(-1);
        this.dispose();
    }

    public String getImport() {
        return this.jTextFieldName.getText();
    }

    public void setImport(String imp) {
        this.originalName = imp;
        this.jTextFieldName.setText(imp);
    }

    public int getDialogResult() {
        return this.dialogResult;
    }

    public void setDialogResult(int dialogResult) {
        this.dialogResult = dialogResult;
    }

    public void applyI18n() {
    }

    public String[] getCurrentImports() {
        return this.currentImports;
    }

    public void setCurrentImports(String[] currentImports) {
        this.currentImports = currentImports;
    }
}

