/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.crosstab;

import com.jaspersoft.ireport.designer.ModelUtils;
import com.jaspersoft.ireport.designer.crosstab.CellInfo;
import javax.swing.JButton;
import net.sf.jasperreports.crosstabs.design.JRCrosstabOrigin;

public class JCellButton
extends JButton {
    private CellInfo cellInfo = null;

    public JCellButton(CellInfo cellInfo) {
        this.setToolTipText(ModelUtils.nameOf(cellInfo.getCellContents()));
        this.cellInfo = cellInfo;
        this.refreshText();
    }

    public void refreshText() {
        JRCrosstabOrigin origin = this.cellInfo.getCellContents().getOrigin();
        switch (origin.getType()) {
            case 1: {
                this.setText("H");
                break;
            }
            case 7: {
                this.setText("D/D");
                break;
            }
            case 5: {
                this.setText("CH");
                break;
            }
            case 6: {
                this.setText("TCH");
                break;
            }
            case 3: {
                this.setText("RH");
                break;
            }
            case 4: {
                this.setText("TRH");
                break;
            }
            case 2: {
                this.setText("NDC");
            }
        }
        this.setText("<html>" + this.getText() + " [" + this.getCellInfo().getX() + "," + this.getCellInfo().getY() + "]<br>(" + this.getCellInfo().getLeft() + "," + this.getCellInfo().getTop() + "," + this.getCellInfo().getCellContents().getWidth() + "," + this.getCellInfo().getCellContents().getHeight() + ")");
    }

    public CellInfo getCellInfo() {
        return this.cellInfo;
    }

    public void setCellInfo(CellInfo cellInfo) {
        this.cellInfo = cellInfo;
    }
}

