/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.connection.gui;

import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class TableExcelNumberCellRenderer
extends DefaultTableCellRenderer {
    static final String digits = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (value != null && value instanceof Integer) {
            int val = (Integer)value;
            String number = "" + digits.charAt(val % 26);
            while (val > 0) {
                int index = (val /= 26) % 26 - 1;
                if (val == 0) break;
                if (val % 26 == 0) {
                    val -= 26;
                    index = 25;
                }
                number = digits.charAt(index) + number;
            }
            label.setText(this.getText() + " (" + number + ")");
        }
        return label;
    }
}

