/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.List;

final class LineReader {
    private final CharBuffer input;
    private final List<LineSeparator> separators;

    LineReader(CharBuffer charBuffer) {
        this.input = charBuffer;
        this.separators = new ArrayList<LineSeparator>(100);
    }

    StringBuilder readText() {
        int n = this.input.length();
        StringBuilder stringBuilder = new StringBuilder(n);
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            char c = this.input.get();
            if (!bl) {
                if (c == '\n') {
                    stringBuilder.append('\n');
                    this.recordSeparator(LineSeparator.LF);
                    continue;
                }
                if (c == '\r') {
                    bl = true;
                    continue;
                }
                stringBuilder.append(c);
                continue;
            }
            stringBuilder.append('\n');
            if (c == '\n') {
                this.recordSeparator(LineSeparator.CRLF);
                bl = false;
                continue;
            }
            if (c == '\r') {
                this.recordSeparator(LineSeparator.CR);
                continue;
            }
            stringBuilder.append(c);
            this.recordSeparator(LineSeparator.CR);
            bl = false;
        }
        if (bl) {
            stringBuilder.append('\n');
            this.recordSeparator(LineSeparator.CR);
        }
        assert (!this.input.hasRemaining());
        return stringBuilder;
    }

    private void recordSeparator(LineSeparator lineSeparator) {
        this.separators.add(lineSeparator);
    }

    LineSeparator[] getLineSeparators() {
        return this.separators.toArray(new LineSeparator[this.separators.size()]);
    }

    void clear() {
        this.separators.clear();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum LineSeparator {
        CR("\r"),
        LF("\n"),
        CRLF("\r\n");

        private final String sepString;

        private LineSeparator(String string2) {
            this.sepString = string2;
        }

        public String getString() {
            return this.sepString;
        }
    }
}

