/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.sort;

import java.util.Locale;
import net.sf.jasperreports.engine.DatasetFilter;
import net.sf.jasperreports.engine.EvaluationType;
import net.sf.jasperreports.engine.fill.DatasetFillContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FieldFilter
implements DatasetFilter {
    private static final Log log = LogFactory.getLog(FieldFilter.class);
    private final String field;
    private String filterValue;
    private DatasetFillContext context;
    private Locale locale;

    public FieldFilter(String field, String filterValue) {
        this.field = field;
        this.filterValue = filterValue;
    }

    public void init(DatasetFillContext context) {
        this.context = context;
        this.locale = context.getLocale();
        this.filterValue = this.filterValue.toLowerCase(this.locale);
    }

    public boolean matches(EvaluationType evaluation) {
        Object value = this.context.getFieldValue(this.field, evaluation);
        if (value == null) {
            return false;
        }
        if (!(value instanceof String)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Not filtering non-String value for " + this.field));
            }
            return true;
        }
        String fieldValue = (String)value;
        fieldValue = fieldValue.toLowerCase();
        return fieldValue.contains(this.filterValue);
    }
}

