/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.components.sort.properties;

import com.jaspersoft.ireport.designer.sheet.Tag;
import com.jaspersoft.ireport.designer.sheet.editors.ComboBoxPropertyEditor;
import com.jaspersoft.ireport.designer.sheet.properties.IntegerProperty;
import com.jaspersoft.ireport.locale.I18n;
import java.beans.PropertyEditor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.components.sort.SortComponent;

public final class HandlerFontSizeProperty
extends IntegerProperty {
    private final SortComponent component;
    private ComboBoxPropertyEditor editor;

    public HandlerFontSizeProperty(SortComponent component) {
        super((Object)component);
        this.component = component;
        this.setValue("canEditAsText", true);
    }

    public PropertyEditor getPropertyEditor() {
        if (this.editor == null) {
            this.editor = new ComboBoxPropertyEditor(true, this.getTagList());
        }
        return this.editor;
    }

    public String getName() {
        return "handlerFontSize";
    }

    public String getDisplayName() {
        return I18n.getString((String)"Global.Property.HandlerFontSize");
    }

    public String getShortDescription() {
        return I18n.getString((String)"Global.Property.HandlerFontSize.desc");
    }

    public Integer getInteger() {
        if (this.component.getHandlerFontSize() == null) {
            return new Integer(0);
        }
        try {
            return new Integer(this.component.getHandlerFontSize());
        }
        catch (Exception ex) {
            System.out.println("Invalid font size: " + this.component.getHandlerFontSize());
            ex.printStackTrace();
            return this.getDefaultInteger();
        }
    }

    public Integer getOwnInteger() {
        return this.getInteger();
    }

    public Integer getDefaultInteger() {
        return 0;
    }

    public void validateInteger(Integer value) {
        if (value != null && value < 0) {
            throw new IllegalArgumentException("The font size must be more than 0, or 0 to use the default: " + value);
        }
    }

    public void setInteger(Integer value) {
        System.out.println("Setting value to: " + value);
        if (value != null && value == 0) {
            value = null;
        }
        this.component.setHandlerFontSize(value == null ? null : value.toString());
    }

    private List getTagList() {
        ArrayList<Tag> tags = new ArrayList<Tag>();
        tags.add(new Tag((Object)new Integer(0), "Default"));
        int i = 6;
        while (i < 100) {
            tags.add(new Tag((Object)new Integer(i), "" + i));
            if (i < 16) {
                ++i;
                continue;
            }
            if (i < 32) {
                i += 2;
                continue;
            }
            if (i < 48) {
                i += 4;
                continue;
            }
            if (i < 72) {
                i += 6;
                continue;
            }
            i += 8;
        }
        return tags;
    }

    public boolean isDefaultValue() {
        return this.component.getHandlerFontSize() == null;
    }

    public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
        this.setValue(0);
    }

    public boolean supportsDefaultValue() {
        return true;
    }

    public void validate(Object value) {
        if (value != null) {
            this.validateInteger(null);
        }
        System.out.println("validating " + value + " of type " + value.getClass());
        if (value instanceof Integer) {
            this.validateInteger((Integer)value);
        } else if (value instanceof String) {
            this.validateInteger(new Integer("" + value));
        }
    }

    public void setPropertyValue(Object value) {
        if (value != null) {
            this.setInteger(null);
        }
        if (value instanceof Integer) {
            this.setInteger((Integer)value);
        } else if (value instanceof String) {
            this.setInteger(new Integer("" + value));
        }
    }
}

