/*
 * Decompiled with CFR 0.152.
 */
package mondrian.xmla;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import mondrian.olap.Category;
import mondrian.olap.Connection;
import mondrian.olap.Cube;
import mondrian.olap.Dimension;
import mondrian.olap.DimensionType;
import mondrian.olap.FunTable;
import mondrian.olap.Hierarchy;
import mondrian.olap.HierarchyBase;
import mondrian.olap.Id;
import mondrian.olap.Level;
import mondrian.olap.LevelType;
import mondrian.olap.Member;
import mondrian.olap.MondrianProperties;
import mondrian.olap.MondrianServer;
import mondrian.olap.NamedSet;
import mondrian.olap.OlapElement;
import mondrian.olap.Property;
import mondrian.olap.Role;
import mondrian.olap.Schema;
import mondrian.olap.SchemaReader;
import mondrian.olap.Util;
import mondrian.olap.fun.FunInfo;
import mondrian.rolap.RolapAggregator;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapLevel;
import mondrian.rolap.RolapMember;
import mondrian.rolap.RolapMemberBase;
import mondrian.rolap.RolapSchema;
import mondrian.xmla.DataSourcesConfig;
import mondrian.xmla.Enumeration;
import mondrian.xmla.PropertyDefinition;
import mondrian.xmla.Rowset;
import mondrian.xmla.SaxWriter;
import mondrian.xmla.XmlaException;
import mondrian.xmla.XmlaHandler;
import mondrian.xmla.XmlaRequest;
import mondrian.xmla.XmlaResponse;
import mondrian.xmla.XmlaUtil;
import org.olap4j.impl.Olap4jUtil;
import org.olap4j.metadata.Member;
import org.olap4j.metadata.Property;
import org.olap4j.metadata.XmlaConstant;
import org.olap4j.metadata.XmlaConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
enum RowsetDefinition {
    DISCOVER_DATASOURCES(0, "Returns a list of XML for Analysis data sources available on the server or Web Service.", new Column[]{DiscoverDatasourcesRowset.access$000(), DiscoverDatasourcesRowset.access$100(), DiscoverDatasourcesRowset.access$200(), DiscoverDatasourcesRowset.access$300(), DiscoverDatasourcesRowset.access$400(), DiscoverDatasourcesRowset.access$500(), DiscoverDatasourcesRowset.access$600()}, null){

        public Rowset getRowset(XmlaRequest request, XmlaHandler handler) {
            return new DiscoverDatasourcesRowset(request, handler);
        }
    }
    ,
    DISCOVER_SCHEMA_ROWSETS(2, "Returns the names, values, and other information of all supported RequestType enumeration values.", new Column[]{DiscoverSchemaRowsetsRowset.access$800(), DiscoverSchemaRowsetsRowset.access$900(), DiscoverSchemaRowsetsRowset.access$1000(), DiscoverSchemaRowsetsRowset.access$1100()}, null){

        public Rowset getRowset(XmlaRequest request, XmlaHandler handler) {
            return new DiscoverSchemaRowsetsRowset(request, handler);
        }

        protected void writeRowsetXmlSchemaRowDef(SaxWriter writer) {
            writer.startElement("xsd:complexType", "name", "row");
            writer.startElement("xsd:sequence");
            for (Column column : this.columnDefinitions) {
                String name = XmlaUtil.encodeElementName(column.name);
                if (column == DiscoverSchemaRowsetsRowset.Restrictions) {
                    writer.startElement("xsd:element", "sql:field", column.name, "name", name, "minOccurs", 0, "maxOccurs", "unbounded");
                    writer.startElement("xsd:complexType");
                    writer.startElement("xsd:sequence");
                    writer.element("xsd:element", "name", "Name", "type", "xsd:string", "sql:field", "Name");
                    writer.element("xsd:element", "name", "Type", "type", "xsd:string", "sql:field", "Type");
                    writer.endElement();
                    writer.endElement();
                    writer.endElement();
                    continue;
                }
                String xsdType = column.type.columnType;
                Object[] attrs = column.nullable ? (column.unbounded ? new Object[]{"sql:field", column.name, "name", name, "type", xsdType, "minOccurs", 0, "maxOccurs", "unbounded"} : new Object[]{"sql:field", column.name, "name", name, "type", xsdType, "minOccurs", 0}) : (column.unbounded ? new Object[]{"sql:field", column.name, "name", name, "type", xsdType, "maxOccurs", "unbounded"} : new Object[]{"sql:field", column.name, "name", name, "type", xsdType});
                writer.element("xsd:element", attrs);
            }
            writer.endElement();
            writer.endElement();
        }
    }
    ,
    DISCOVER_ENUMERATORS(3, "Returns a list of names, data types, and enumeration values for enumerators supported by the provider of a specific data source.", new Column[]{DiscoverEnumeratorsRowset.access$1200(), DiscoverEnumeratorsRowset.access$1300(), DiscoverEnumeratorsRowset.access$1400(), DiscoverEnumeratorsRowset.access$1500(), DiscoverEnumeratorsRowset.access$1600(), DiscoverEnumeratorsRowset.access$1700()}, null){

        public Rowset getRowset(XmlaRequest request, XmlaHandler handler) {
            return new DiscoverEnumeratorsRowset(request, handler);
        }
    }
    ,
    DISCOVER_PROPERTIES(1, "Returns a list of information and values about the requested properties that are supported by the specified data source provider.", new Column[]{DiscoverPropertiesRowset.access$1800(), DiscoverPropertiesRowset.access$1900(), DiscoverPropertiesRowset.access$2000(), DiscoverPropertiesRowset.access$2100(), DiscoverPropertiesRowset.access$2200(), DiscoverPropertiesRowset.access$2300()}, null){

        public Rowset getRowset(XmlaRequest request, XmlaHandler handler) {
            return new DiscoverPropertiesRowset(request, handler);
        }
    }
    ,
    DISCOVER_KEYWORDS(4, "Returns an XML list of keywords reserved by the provider.", new Column[]{DiscoverKeywordsRowset.access$2400()}, null){

        public Rowset getRowset(XmlaRequest request, XmlaHandler handler) {
            return new DiscoverKeywordsRowset(request, handler);
        }
    }
    ,
    DISCOVER_LITERALS(5, "Returns information about literals supported by the provider.", new Column[]{DiscoverLiteralsRowset.access$2500(), DiscoverLiteralsRowset.access$2600(), DiscoverLiteralsRowset.access$2700(), DiscoverLiteralsRowset.access$2800(), DiscoverLiteralsRowset.access$2900()}, null){

        public Rowset getRowset(XmlaRequest request, XmlaHandler handler) {
            return new DiscoverLiteralsRowset(request, handler);
        }
    }
    ,
    DBSCHEMA_CATALOGS(6, "Returns information about literals supported by the provider.", new Column[]{DbschemaCatalogsRowset.access$3000(), DbschemaCatalogsRowset.access$3100(), DbschemaCatalogsRowset.access$3200(), DbschemaCatalogsRowset.access$3300()}, new Column[]{DbschemaCatalogsRowset.access$3000()}){

        public Rowset getRowset(XmlaRequest request, XmlaHandler handler) {
            return new DbschemaCatalogsRowset(request, handler);
        }
    }
    ,
    DBSCHEMA_COLUMNS(7, null, new Column[]{DbschemaColumnsRowset.access$3400(), DbschemaColumnsRowset.access$3500(), DbschemaColumnsRowset.access$3600(), DbschemaColumnsRowset.access$3700(), DbschemaColumnsRowset.access$3800(), DbschemaColumnsRowset.access$3900(), DbschemaColumnsRowset.access$4000(), DbschemaColumnsRowset.access$4100(), DbschemaColumnsRowset.access$4200(), DbschemaColumnsRowset.access$4300(), DbschemaColumnsRowset.access$4400(), DbschemaColumnsRowset.access$4500(), DbschemaColumnsRowset.access$4600()}, new Column[]{DbschemaColumnsRowset.access$3400(), DbschemaColumnsRowset.access$3500(), DbschemaColumnsRowset.access$3600()}){

        public Rowset getRowset(XmlaRequest request, XmlaHandler handler) {
            return new DbschemaColumnsRowset(request, handler);
        }
    }
    ,
    DBSCHEMA_PROVIDER_TYPES(8, null, new Column[]{DbschemaProviderTypesRowset.access$4700(), DbschemaProviderTypesRowset.access$4800(), DbschemaProviderTypesRowset.access$4900(), DbschemaProviderTypesRowset.access$5000(), DbschemaProviderTypesRowset.access$5100(), DbschemaProviderTypesRowset.access$5200(), DbschemaProviderTypesRowset.access$5300(), DbschemaProviderTypesRowset.access$5400(), DbschemaProviderTypesRowset.access$5500(), DbschemaProviderTypesRowset.access$5600(), DbschemaProviderTypesRowset.access$5700(), DbschemaProviderTypesRowset.access$5800(), DbschemaProviderTypesRowset.access$5900()}, new Column[]{DbschemaProviderTypesRowset.access$4800()}){

        public Rowset getRowset(XmlaRequest request, XmlaHandler handler) {
            return new DbschemaProviderTypesRowset(request, handler);
        }
    }
    ,
    DBSCHEMA_SCHEMATA(8, null, new Column[]{DbschemaSchemataRowset.access$6000(), DbschemaSchemataRowset.access$6100(), DbschemaSchemataRowset.access$6200()}, new Column[]{DbschemaSchemataRowset.access$6000(), DbschemaSchemataRowset.access$6100(), DbschemaSchemataRowset.access$6200()}){

        public Rowset getRowset(XmlaRequest request, XmlaHandler handler) {
            return new DbschemaSchemataRowset(request, handler);
        }
    }
    ,
    DBSCHEMA_TABLES(9, null, new Column[]{DbschemaTablesRowset.access$6300(), DbschemaTablesRowset.access$6400(), DbschemaTablesRowset.access$6500(), DbschemaTablesRowset.access$6600(), DbschemaTablesRowset.access$6700(), DbschemaTablesRowset.access$6800(), DbschemaTablesRowset.access$6900(), DbschemaTablesRowset.access$7000(), DbschemaTablesRowset.access$7100()}, new Column[]{DbschemaTablesRowset.access$6600(), DbschemaTablesRowset.access$6300(), DbschemaTablesRowset.access$6400(), DbschemaTablesRowset.access$6500()}){

        public Rowset getRowset(XmlaRequest request, XmlaHandler handler) {
            return new DbschemaTablesRowset(request, handler);
        }
    }
    ,
    DBSCHEMA_TABLES_INFO(10, null, new Column[]{DbschemaTablesInfoRowset.access$7200(), DbschemaTablesInfoRowset.access$7300(), DbschemaTablesInfoRowset.access$7400(), DbschemaTablesInfoRowset.access$7500(), DbschemaTablesInfoRowset.access$7600(), DbschemaTablesInfoRowset.access$7700(), DbschemaTablesInfoRowset.access$7800(), DbschemaTablesInfoRowset.access$7900(), DbschemaTablesInfoRowset.access$8000(), DbschemaTablesInfoRowset.access$8100(), DbschemaTablesInfoRowset.access$8200(), DbschemaTablesInfoRowset.access$8300(), DbschemaTablesInfoRowset.access$8400(), DbschemaTablesInfoRowset.access$8500()}, null){

        public Rowset getRowset(XmlaRequest request, XmlaHandler handler) {
            return new DbschemaTablesInfoRowset(request, handler);
        }
    }
    ,
    MDSCHEMA_ACTIONS(11, null, new Column[]{MdschemaActionsRowset.access$8600(), MdschemaActionsRowset.access$8700(), MdschemaActionsRowset.access$8800(), MdschemaActionsRowset.access$8900(), MdschemaActionsRowset.access$9000(), MdschemaActionsRowset.access$9100()}, new Column[]{MdschemaActionsRowset.access$8600(), MdschemaActionsRowset.access$8700(), MdschemaActionsRowset.access$8800(), MdschemaActionsRowset.access$8900()}){

        public Rowset getRowset(XmlaRequest request, XmlaHandler handler) {
            return new MdschemaActionsRowset(request, handler);
        }
    }
    ,
    MDSCHEMA_CUBES(12, null, new Column[]{MdschemaCubesRowset.access$9200(), MdschemaCubesRowset.access$9300(), MdschemaCubesRowset.access$9400(), MdschemaCubesRowset.access$9500(), MdschemaCubesRowset.access$9600(), MdschemaCubesRowset.access$9700(), MdschemaCubesRowset.access$9800(), MdschemaCubesRowset.access$9900(), MdschemaCubesRowset.access$10000(), MdschemaCubesRowset.access$10100(), MdschemaCubesRowset.access$10200(), MdschemaCubesRowset.access$10300(), MdschemaCubesRowset.access$10400(), MdschemaCubesRowset.access$10500(), MdschemaCubesRowset.access$10600(), MdschemaCubesRowset.access$10700(), MdschemaCubesRowset.access$10800(), MdschemaCubesRowset.access$10900()}, new Column[]{MdschemaCubesRowset.access$9200(), MdschemaCubesRowset.access$9300(), MdschemaCubesRowset.access$9400()}){

        public Rowset getRowset(XmlaRequest request, XmlaHandler handler) {
            return new MdschemaCubesRowset(request, handler);
        }
    }
    ,
    MDSCHEMA_DIMENSIONS(13, null, new Column[]{MdschemaDimensionsRowset.access$11000(), MdschemaDimensionsRowset.access$11100(), MdschemaDimensionsRowset.access$11200(), MdschemaDimensionsRowset.access$11300(), MdschemaDimensionsRowset.access$11400(), MdschemaDimensionsRowset.access$11500(), MdschemaDimensionsRowset.access$11600(), MdschemaDimensionsRowset.access$11700(), MdschemaDimensionsRowset.access$11800(), MdschemaDimensionsRowset.access$11900(), MdschemaDimensionsRowset.access$12000(), MdschemaDimensionsRowset.access$12100(), MdschemaDimensionsRowset.access$12200(), MdschemaDimensionsRowset.access$12300(), MdschemaDimensionsRowset.access$12400(), MdschemaDimensionsRowset.access$12500(), MdschemaDimensionsRowset.access$12600(), MdschemaDimensionsRowset.access$12700()}, new Column[]{MdschemaDimensionsRowset.access$11000(), MdschemaDimensionsRowset.access$11100(), MdschemaDimensionsRowset.access$11200(), MdschemaDimensionsRowset.access$11300()}){

        public Rowset getRowset(XmlaRequest request, XmlaHandler handler) {
            return new MdschemaDimensionsRowset(request, handler);
        }
    }
    ,
    MDSCHEMA_FUNCTIONS(14, null, new Column[]{MdschemaFunctionsRowset.access$12800(), MdschemaFunctionsRowset.access$12900(), MdschemaFunctionsRowset.access$13000(), MdschemaFunctionsRowset.access$13100(), MdschemaFunctionsRowset.access$13200(), MdschemaFunctionsRowset.access$13300(), MdschemaFunctionsRowset.access$13400(), MdschemaFunctionsRowset.access$13500()}, new Column[]{MdschemaFunctionsRowset.access$13400(), MdschemaFunctionsRowset.access$13300(), MdschemaFunctionsRowset.access$12800(), MdschemaFunctionsRowset.access$13200()}){

        public Rowset getRowset(XmlaRequest request, XmlaHandler handler) {
            return new MdschemaFunctionsRowset(request, handler);
        }
    }
    ,
    MDSCHEMA_HIERARCHIES(15, null, new Column[]{MdschemaHierarchiesRowset.access$13600(), MdschemaHierarchiesRowset.access$13700(), MdschemaHierarchiesRowset.access$13800(), MdschemaHierarchiesRowset.access$13900(), MdschemaHierarchiesRowset.access$14000(), MdschemaHierarchiesRowset.access$14100(), MdschemaHierarchiesRowset.access$14200(), MdschemaHierarchiesRowset.access$14300(), MdschemaHierarchiesRowset.access$14400(), MdschemaHierarchiesRowset.access$14500(), MdschemaHierarchiesRowset.access$14600(), MdschemaHierarchiesRowset.access$14700(), MdschemaHierarchiesRowset.access$14800(), MdschemaHierarchiesRowset.access$14900(), MdschemaHierarchiesRowset.access$15000(), MdschemaHierarchiesRowset.access$15100(), MdschemaHierarchiesRowset.access$15200(), MdschemaHierarchiesRowset.access$15300(), MdschemaHierarchiesRowset.access$15400(), MdschemaHierarchiesRowset.access$15500(), MdschemaHierarchiesRowset.access$15600(), MdschemaHierarchiesRowset.access$15700()}, new Column[]{MdschemaHierarchiesRowset.access$13600(), MdschemaHierarchiesRowset.access$13700(), MdschemaHierarchiesRowset.access$13800(), MdschemaHierarchiesRowset.access$13900(), MdschemaHierarchiesRowset.access$14000()}){

        public Rowset getRowset(XmlaRequest request, XmlaHandler handler) {
            return new MdschemaHierarchiesRowset(request, handler);
        }
    }
    ,
    MDSCHEMA_LEVELS(16, null, new Column[]{MdschemaLevelsRowset.access$15800(), MdschemaLevelsRowset.access$15900(), MdschemaLevelsRowset.access$16000(), MdschemaLevelsRowset.access$16100(), MdschemaLevelsRowset.access$16200(), MdschemaLevelsRowset.access$16300(), MdschemaLevelsRowset.access$16400(), MdschemaLevelsRowset.access$16500(), MdschemaLevelsRowset.access$16600(), MdschemaLevelsRowset.access$16700(), MdschemaLevelsRowset.access$16800(), MdschemaLevelsRowset.access$16900(), MdschemaLevelsRowset.access$17000(), MdschemaLevelsRowset.access$17100(), MdschemaLevelsRowset.access$17200(), MdschemaLevelsRowset.access$17300()}, new Column[]{MdschemaLevelsRowset.access$15800(), MdschemaLevelsRowset.access$15900(), MdschemaLevelsRowset.access$16000(), MdschemaLevelsRowset.access$16100(), MdschemaLevelsRowset.access$16200(), MdschemaLevelsRowset.access$16700()}){

        public Rowset getRowset(XmlaRequest request, XmlaHandler handler) {
            return new MdschemaLevelsRowset(request, handler);
        }
    }
    ,
    MDSCHEMA_MEASURES(17, null, new Column[]{MdschemaMeasuresRowset.access$17400(), MdschemaMeasuresRowset.access$17500(), MdschemaMeasuresRowset.access$17600(), MdschemaMeasuresRowset.access$17700(), MdschemaMeasuresRowset.access$17800(), MdschemaMeasuresRowset.access$17900(), MdschemaMeasuresRowset.access$18000(), MdschemaMeasuresRowset.access$18100(), MdschemaMeasuresRowset.access$18200(), MdschemaMeasuresRowset.access$18300(), MdschemaMeasuresRowset.access$18400(), MdschemaMeasuresRowset.access$18500(), MdschemaMeasuresRowset.access$18600()}, new Column[]{MdschemaMeasuresRowset.access$17400(), MdschemaMeasuresRowset.access$17500(), MdschemaMeasuresRowset.access$17600(), MdschemaMeasuresRowset.access$17700()}){

        public Rowset getRowset(XmlaRequest request, XmlaHandler handler) {
            return new MdschemaMeasuresRowset(request, handler);
        }
    }
    ,
    MDSCHEMA_MEMBERS(18, null, new Column[]{MdschemaMembersRowset.access$18700(), MdschemaMembersRowset.access$18800(), MdschemaMembersRowset.access$18900(), MdschemaMembersRowset.access$19000(), MdschemaMembersRowset.access$19100(), MdschemaMembersRowset.access$19200(), MdschemaMembersRowset.access$19300(), MdschemaMembersRowset.access$19400(), MdschemaMembersRowset.access$19500(), MdschemaMembersRowset.access$19600(), MdschemaMembersRowset.access$19700(), MdschemaMembersRowset.access$19800(), MdschemaMembersRowset.access$19900(), MdschemaMembersRowset.access$20000(), MdschemaMembersRowset.access$20100(), MdschemaMembersRowset.access$20200(), MdschemaMembersRowset.access$20300(), MdschemaMembersRowset.access$20400(), MdschemaMembersRowset.access$20500()}, new Column[]{MdschemaMembersRowset.access$18700(), MdschemaMembersRowset.access$18800(), MdschemaMembersRowset.access$18900(), MdschemaMembersRowset.access$19000(), MdschemaMembersRowset.access$19100(), MdschemaMembersRowset.access$19200(), MdschemaMembersRowset.access$19300(), MdschemaMembersRowset.access$19400()}){

        public Rowset getRowset(XmlaRequest request, XmlaHandler handler) {
            return new MdschemaMembersRowset(request, handler);
        }
    }
    ,
    MDSCHEMA_PROPERTIES(19, null, new Column[]{MdschemaPropertiesRowset.access$20600(), MdschemaPropertiesRowset.access$20700(), MdschemaPropertiesRowset.access$20800(), MdschemaPropertiesRowset.access$20900(), MdschemaPropertiesRowset.access$21000(), MdschemaPropertiesRowset.access$21100(), MdschemaPropertiesRowset.access$21200(), MdschemaPropertiesRowset.access$21300(), MdschemaPropertiesRowset.access$21400(), MdschemaPropertiesRowset.access$21500(), MdschemaPropertiesRowset.access$21600(), MdschemaPropertiesRowset.access$21700(), MdschemaPropertiesRowset.access$21800()}, null){

        public Rowset getRowset(XmlaRequest request, XmlaHandler handler) {
            return new MdschemaPropertiesRowset(request, handler);
        }
    }
    ,
    MDSCHEMA_SETS(20, null, new Column[]{MdschemaSetsRowset.access$21900(), MdschemaSetsRowset.access$22000(), MdschemaSetsRowset.access$22100(), MdschemaSetsRowset.access$22200(), MdschemaSetsRowset.access$22300()}, new Column[]{MdschemaSetsRowset.access$21900(), MdschemaSetsRowset.access$22000(), MdschemaSetsRowset.access$22100()}){

        public Rowset getRowset(XmlaRequest request, XmlaHandler handler) {
            return new MdschemaSetsRowset(request, handler);
        }
    };

    final transient Column[] columnDefinitions;
    final transient Column[] sortColumnDefinitions;
    private static final String dateModified = "2005-01-25T17:35:32";
    private final String description;
    static final String UUID_PATTERN = "[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}";

    private RowsetDefinition(int ordinal, String description, Column[] columnDefinitions, Column[] sortColumnDefinitions) {
        Util.discard((int)ordinal);
        this.description = description;
        this.columnDefinitions = columnDefinitions;
        this.sortColumnDefinitions = sortColumnDefinitions;
    }

    public abstract Rowset getRowset(XmlaRequest var1, XmlaHandler var2);

    public Column lookupColumn(String name) {
        for (Column columnDefinition : this.columnDefinitions) {
            if (!columnDefinition.name.equals(name)) continue;
            return columnDefinition;
        }
        return null;
    }

    Comparator<Rowset.Row> getComparator() {
        if (this.sortColumnDefinitions == null) {
            return null;
        }
        return new Comparator<Rowset.Row>(){

            @Override
            public int compare(Rowset.Row row1, Rowset.Row row2) {
                for (Column sortColumn : RowsetDefinition.this.sortColumnDefinitions) {
                    int v;
                    Comparable val1 = (Comparable)row1.get(sortColumn.name);
                    Comparable val2 = (Comparable)row2.get(sortColumn.name);
                    if (val1 == null && val2 == null) continue;
                    if (val1 == null) {
                        return -1;
                    }
                    if (val2 == null) {
                        return 1;
                    }
                    if (!(val1 instanceof String && val2 instanceof String ? (v = ((String)((Object)val1)).compareToIgnoreCase((String)((Object)val2))) != 0 : (v = val1.compareTo(val2)) != 0)) continue;
                    return v;
                }
                return 0;
            }
        };
    }

    void writeRowsetXmlSchema(SaxWriter writer) {
        this.writeRowsetXmlSchemaTop(writer);
        this.writeRowsetXmlSchemaRowDef(writer);
        this.writeRowsetXmlSchemaBottom(writer);
    }

    protected void writeRowsetXmlSchemaTop(SaxWriter writer) {
        writer.startElement("xsd:schema", "xmlns:xsd", "http://www.w3.org/2001/XMLSchema", "xmlns", "urn:schemas-microsoft-com:xml-analysis:rowset", "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance", "xmlns:sql", "urn:schemas-microsoft-com:xml-sql", "targetNamespace", "urn:schemas-microsoft-com:xml-analysis:rowset", "elementFormDefault", "qualified");
        writer.startElement("xsd:element", "name", "root");
        writer.startElement("xsd:complexType");
        writer.startElement("xsd:sequence");
        writer.element("xsd:element", "name", "row", "type", "row", "minOccurs", 0, "maxOccurs", "unbounded");
        writer.endElement();
        writer.endElement();
        writer.endElement();
        writer.startElement("xsd:simpleType", "name", "uuid");
        writer.startElement("xsd:restriction", "base", "xsd:string");
        writer.element("xsd:pattern", "value", UUID_PATTERN);
        writer.endElement();
        writer.endElement();
    }

    protected void writeRowsetXmlSchemaRowDef(SaxWriter writer) {
        writer.startElement("xsd:complexType", "name", "row");
        writer.startElement("xsd:sequence");
        for (Column column : this.columnDefinitions) {
            String name = XmlaUtil.encodeElementName(column.name);
            String xsdType = column.type.columnType;
            Object[] attrs = column.nullable ? (column.unbounded ? new Object[]{"sql:field", column.name, "name", name, "type", xsdType, "minOccurs", 0, "maxOccurs", "unbounded"} : new Object[]{"sql:field", column.name, "name", name, "type", xsdType, "minOccurs", 0}) : (column.unbounded ? new Object[]{"sql:field", column.name, "name", name, "type", xsdType, "maxOccurs", "unbounded"} : new Object[]{"sql:field", column.name, "name", name, "type", xsdType});
            writer.element("xsd:element", attrs);
        }
        writer.endElement();
        writer.endElement();
    }

    protected void writeRowsetXmlSchemaBottom(SaxWriter writer) {
        writer.endElement();
    }

    private static XmlaConstants.DBType getDBTypeFromProperty(Property prop) {
        switch (prop.getType()) {
            case TYPE_STRING: {
                return XmlaConstants.DBType.WSTR;
            }
            case TYPE_NUMERIC: {
                return XmlaConstants.DBType.R8;
            }
            case TYPE_BOOLEAN: {
                return XmlaConstants.DBType.BOOL;
            }
        }
        return XmlaConstants.DBType.WSTR;
    }

    public String getDescription() {
        return this.description;
    }

    static int getDimensionType(Dimension dim) {
        if (dim.isMeasures()) {
            return 2;
        }
        if (DimensionType.TimeDimension.equals((Object)dim.getDimensionType())) {
            return 1;
        }
        return 3;
    }

    private static boolean canAccess(SchemaReader schemaReader, OlapElement elem) {
        Role role = schemaReader.getRole();
        return role.canAccess(elem);
    }

    private static <T extends Comparable> List<T> sort(Collection<T> collection) {
        Object[] a = collection.toArray(new Object[collection.size()]);
        Arrays.sort(a);
        return Util.cast(Arrays.asList(a));
    }

    private static <T> List<T> sortArray(T[] a, Comparator<T> comparator) {
        Object[] a2 = (Object[])a.clone();
        Arrays.sort(a2, comparator);
        return Arrays.asList(a2);
    }

    static void serialize(StringBuilder buf, Collection<String> strings) {
        int k = 0;
        for (String name : RowsetDefinition.sort(strings)) {
            if (k++ > 0) {
                buf.append(',');
            }
            buf.append(name);
        }
    }

    static List<Cube> sortedCubes(Schema schema) {
        Cube[] cubes = schema.getCubes();
        return RowsetDefinition.sortArray(cubes, new Comparator<Cube>(){

            @Override
            public int compare(Cube o1, Cube o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
    }

    private static String getHierarchyName(Hierarchy hierarchy) {
        String hierarchyName = hierarchy.getName();
        if (MondrianProperties.instance().SsasCompatibleNaming.get() && !hierarchyName.equals(hierarchy.getDimension().getName())) {
            hierarchyName = hierarchy.getDimension().getName() + "." + hierarchyName;
        }
        return hierarchyName;
    }

    private static XmlaRequest wrapRequest(XmlaRequest request, Map<Column, String> map) {
        final HashMap<String, Object> restrictionsMap = new HashMap<String, Object>(request.getRestrictions());
        for (Map.Entry<Column, String> entry : map.entrySet()) {
            restrictionsMap.put(entry.getKey().name, Collections.singletonList(entry.getValue()));
        }
        return new DelegatingXmlaRequest(request){

            @Override
            public Map<String, Object> getRestrictions() {
                return restrictionsMap;
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DelegatingXmlaRequest
    implements XmlaRequest {
        protected final XmlaRequest request;

        public DelegatingXmlaRequest(XmlaRequest request) {
            this.request = request;
        }

        @Override
        public XmlaConstants.Method getMethod() {
            return this.request.getMethod();
        }

        @Override
        public Map<String, String> getProperties() {
            return this.request.getProperties();
        }

        @Override
        public Map<String, Object> getRestrictions() {
            return this.request.getRestrictions();
        }

        @Override
        public String getStatement() {
            return this.request.getStatement();
        }

        @Override
        public String getRoleName() {
            return this.request.getRoleName();
        }

        @Override
        public Role getRole() {
            return this.request.getRole();
        }

        @Override
        public String getRequestType() {
            return this.request.getRequestType();
        }

        @Override
        public boolean isDrillThrough() {
            return this.request.isDrillThrough();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MdschemaPropertiesRowset
    extends Rowset {
        private final Rowset.RestrictionTest catalogRT = this.getRestrictionTest(CatalogName);
        private final Rowset.RestrictionTest schemaNameRT = this.getRestrictionTest(SchemaName);
        private final Rowset.RestrictionTest cubeNameRT = this.getRestrictionTest(CubeName);
        private final Rowset.RestrictionTest dimensionUniqueNameRT = this.getRestrictionTest(DimensionUniqueName);
        private final Rowset.RestrictionTest hierarchyUniqueNameRT = this.getRestrictionTest(HierarchyUniqueName);
        private final Rowset.RestrictionTest propertyNameRT = this.getRestrictionTest(PropertyName);
        private static final Column CatalogName = new Column("CATALOG_NAME", Type.String, null, true, true, "The name of the database.");
        private static final Column SchemaName = new Column("SCHEMA_NAME", Type.String, null, true, true, "The name of the schema to which this property belongs.");
        private static final Column CubeName = new Column("CUBE_NAME", Type.String, null, true, true, "The name of the cube.");
        private static final Column DimensionUniqueName = new Column("DIMENSION_UNIQUE_NAME", Type.String, null, true, true, "The unique name of the dimension.");
        private static final Column HierarchyUniqueName = new Column("HIERARCHY_UNIQUE_NAME", Type.String, null, true, true, "The unique name of the hierarchy.");
        private static final Column LevelUniqueName = new Column("LEVEL_UNIQUE_NAME", Type.String, null, true, true, "The unique name of the level to which this property belongs.");
        private static final Column MemberUniqueName = new Column("MEMBER_UNIQUE_NAME", Type.String, null, true, true, "The unique name of the member to which the property belongs.");
        private static final Column PropertyName = new Column("PROPERTY_NAME", Type.String, null, true, false, "Name of the property.");
        private static final Column PropertyType = new Column("PROPERTY_TYPE", Type.Short, null, true, false, "A bitmap that specifies the type of the property");
        private static final Column PropertyCaption = new Column("PROPERTY_CAPTION", Type.String, null, false, false, "A label or caption associated with the property, used primarily for display purposes.");
        private static final Column DataType = new Column("DATA_TYPE", Type.UnsignedShort, null, false, false, "Data type of the property.");
        private static final Column PropertyContentType = new Column("PROPERTY_CONTENT_TYPE", Type.Short, null, true, true, "The type of the property.");
        private static final Column Description = new Column("DESCRIPTION", Type.String, null, false, true, "A human-readable description of the measure.");

        MdschemaPropertiesRowset(XmlaRequest request, XmlaHandler handler) {
            super(MDSCHEMA_PROPERTIES, request, handler);
        }

        private void populate2(List<Rowset.Row> rows) {
            DataSourcesConfig.DataSource ds = this.handler.getDataSource(this.request);
            DataSourcesConfig.Catalog[] catalogs = this.handler.getCatalogs(this.request, ds);
            String roleName = this.request.getRoleName();
            Role role = this.request.getRole();
            for (DataSourcesConfig.Catalog dsCatalog : catalogs) {
                String catalogName;
                Connection connection;
                if (dsCatalog == null || dsCatalog.definition == null || (connection = this.handler.getConnection(dsCatalog, role, roleName)) == null || !this.catalogRT.passes(catalogName = dsCatalog.name)) continue;
                this.populateCatalog(connection, catalogName, rows);
            }
        }

        @Override
        public void populate(XmlaResponse response, List<Rowset.Row> rows) throws XmlaException {
            List list = (List)this.restrictions.get(MdschemaPropertiesRowset.PropertyType.name);
            Set typeFlags = list == null ? Olap4jUtil.enumSetOf((Enum)Property.TypeFlag.MEMBER, (Enum[])new Property.TypeFlag[0]) : Property.TypeFlag.getDictionary().forMask(Integer.valueOf((String)list.get(0)).intValue());
            for (Property.TypeFlag typeFlag : typeFlags) {
                switch (typeFlag) {
                    case MEMBER: {
                        this.populate2(rows);
                        break;
                    }
                    case CELL: {
                        this.populateCell(rows);
                        break;
                    }
                }
            }
        }

        private void populateCell(List<Rowset.Row> rows) {
            for (Property.StandardCellProperty property : Property.StandardCellProperty.values()) {
                Rowset.Row row = new Rowset.Row();
                row.set(MdschemaPropertiesRowset.PropertyType.name, Property.TypeFlag.getDictionary().toMask(property.getType()));
                row.set(MdschemaPropertiesRowset.PropertyName.name, property.name());
                row.set(MdschemaPropertiesRowset.PropertyCaption.name, property.getCaption(null));
                row.set(MdschemaPropertiesRowset.DataType.name, property.getDatatype().xmlaOrdinal());
                this.addRow(row, rows);
            }
        }

        protected void populateCatalog(Connection connection, String catalogName, List<Rowset.Row> rows) throws XmlaException {
            Schema schema = connection.getSchema();
            if (!this.schemaNameRT.passes(schema.getName())) {
                return;
            }
            for (Cube cube : RowsetDefinition.sortedCubes(schema)) {
                if (!this.cubeNameRT.passes(cube.getName())) continue;
                SchemaReader schemaReader = cube.getSchemaReader(connection.getRole());
                this.populateCube(schemaReader, catalogName, cube, rows);
            }
        }

        protected void populateCube(SchemaReader schemaReader, String catalogName, Cube cube, List<Rowset.Row> rows) throws XmlaException {
            if (this.isRestricted(LevelUniqueName)) {
                String levelUniqueName = this.getRestrictionValueAsString(LevelUniqueName);
                if (levelUniqueName == null) {
                    return;
                }
                List<Id.Segment> nameParts = Util.parseIdentifier(levelUniqueName);
                Hierarchy hier = cube.lookupHierarchy(nameParts.get(0), false);
                if (hier == null) {
                    return;
                }
                for (Level level : schemaReader.getHierarchyLevels(hier)) {
                    if (!level.getUniqueName().equals(levelUniqueName)) continue;
                    this.populateLevel(schemaReader, catalogName, cube, level, rows);
                    break;
                }
            } else {
                for (Dimension dimension : cube.getDimensions()) {
                    String uniqueName = dimension.getUniqueName();
                    if (!this.dimensionUniqueNameRT.passes(uniqueName)) continue;
                    this.populateDimension(schemaReader, catalogName, cube, dimension, rows);
                }
            }
        }

        private void populateDimension(SchemaReader schemaReader, String catalogName, Cube cube, Dimension dimension, List<Rowset.Row> rows) {
            Hierarchy[] hierarchies;
            for (Hierarchy hierarchy : hierarchies = dimension.getHierarchies()) {
                String unique = hierarchy.getUniqueName();
                if (!this.hierarchyUniqueNameRT.passes(unique)) continue;
                this.populateHierarchy(schemaReader, catalogName, cube, hierarchy, rows);
            }
        }

        private void populateHierarchy(SchemaReader schemaReader, String catalogName, Cube cube, Hierarchy hierarchy, List<Rowset.Row> rows) {
            for (Level level : schemaReader.getHierarchyLevels(hierarchy)) {
                this.populateLevel(schemaReader, catalogName, cube, level, rows);
            }
        }

        private void populateLevel(SchemaReader schemaReader, String catalogName, Cube cube, Level level, List<Rowset.Row> rows) {
            Property[] properties;
            for (Property property : properties = level.getProperties()) {
                if (property.isInternal() || !this.propertyNameRT.passes(property.getName())) continue;
                this.outputProperty(schemaReader, property, catalogName, cube, level, rows);
            }
        }

        private void outputProperty(SchemaReader schemaReader, Property property, String catalogName, Cube cube, Level level, List<Rowset.Row> rows) {
            Hierarchy hierarchy = level.getHierarchy();
            Dimension dimension = hierarchy.getDimension();
            String propertyName = property.getName();
            Rowset.Row row = new Rowset.Row();
            row.set(MdschemaPropertiesRowset.CatalogName.name, catalogName);
            row.set(MdschemaPropertiesRowset.SchemaName.name, cube.getSchema().getName());
            row.set(MdschemaPropertiesRowset.CubeName.name, cube.getName());
            row.set(MdschemaPropertiesRowset.DimensionUniqueName.name, dimension.getUniqueName());
            row.set(MdschemaPropertiesRowset.HierarchyUniqueName.name, hierarchy.getUniqueName());
            row.set(MdschemaPropertiesRowset.LevelUniqueName.name, level.getUniqueName());
            row.set(MdschemaPropertiesRowset.PropertyName.name, propertyName);
            row.set(MdschemaPropertiesRowset.PropertyType.name, Property.TypeFlag.MEMBER.xmlaOrdinal());
            row.set(MdschemaPropertiesRowset.PropertyContentType.name, Property.ContentType.REGULAR.xmlaOrdinal());
            row.set(MdschemaPropertiesRowset.PropertyCaption.name, property.getCaption());
            XmlaConstants.DBType dbType = RowsetDefinition.getDBTypeFromProperty(property);
            row.set(MdschemaPropertiesRowset.DataType.name, dbType.xmlaOrdinal());
            String desc = cube.getName() + " Cube - " + RowsetDefinition.getHierarchyName(hierarchy) + " Hierarchy - " + level.getName() + " Level - " + property.getName() + " Property";
            row.set(MdschemaPropertiesRowset.Description.name, desc);
            this.addRow(row, rows);
        }

        @Override
        protected void setProperty(PropertyDefinition propertyDef, String value) {
            switch (propertyDef) {
                case Content: {
                    break;
                }
                default: {
                    super.setProperty(propertyDef, value);
                }
            }
        }

        static /* synthetic */ Column access$20600() {
            return CatalogName;
        }

        static /* synthetic */ Column access$20700() {
            return SchemaName;
        }

        static /* synthetic */ Column access$20800() {
            return CubeName;
        }

        static /* synthetic */ Column access$20900() {
            return DimensionUniqueName;
        }

        static /* synthetic */ Column access$21000() {
            return HierarchyUniqueName;
        }

        static /* synthetic */ Column access$21100() {
            return LevelUniqueName;
        }

        static /* synthetic */ Column access$21200() {
            return MemberUniqueName;
        }

        static /* synthetic */ Column access$21300() {
            return PropertyName;
        }

        static /* synthetic */ Column access$21400() {
            return PropertyCaption;
        }

        static /* synthetic */ Column access$21500() {
            return PropertyType;
        }

        static /* synthetic */ Column access$21600() {
            return DataType;
        }

        static /* synthetic */ Column access$21700() {
            return PropertyContentType;
        }

        static /* synthetic */ Column access$21800() {
            return Description;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MdschemaSetsRowset
    extends Rowset {
        private final Rowset.RestrictionTest catalogRT = this.getRestrictionTest(CatalogName);
        private final Rowset.RestrictionTest schemaNameRT = this.getRestrictionTest(SchemaName);
        private final Rowset.RestrictionTest cubeNameRT = this.getRestrictionTest(CubeName);
        private final Rowset.RestrictionTest setNameRT = this.getRestrictionTest(SetName);
        private static final String GLOBAL_SCOPE = "1";
        private static final Column CatalogName = new Column("CATALOG_NAME", Type.String, null, true, true, null);
        private static final Column SchemaName = new Column("SCHEMA_NAME", Type.String, null, true, true, null);
        private static final Column CubeName = new Column("CUBE_NAME", Type.String, null, true, false, null);
        private static final Column SetName = new Column("SET_NAME", Type.String, null, true, false, null);
        private static final Column SetCaption = new Column("SET_CAPTION", Type.String, null, true, true, null);
        private static final Column Scope = new Column("SCOPE", Type.Integer, null, true, false, null);
        private static final Column Description = new Column("DESCRIPTION", Type.String, null, false, true, "A human-readable description of the measure.");

        MdschemaSetsRowset(XmlaRequest request, XmlaHandler handler) {
            super(MDSCHEMA_SETS, request, handler);
        }

        @Override
        public void populate(XmlaResponse response, List<Rowset.Row> rows) throws XmlaException {
            DataSourcesConfig.DataSource ds = this.handler.getDataSource(this.request);
            DataSourcesConfig.Catalog[] catalogs = this.handler.getCatalogs(this.request, ds);
            String roleName = this.request.getRoleName();
            Role role = this.request.getRole();
            for (DataSourcesConfig.Catalog dsCatalog : catalogs) {
                String catalogName;
                Connection connection;
                if (dsCatalog == null || dsCatalog.definition == null || (connection = this.handler.getConnection(dsCatalog, role, roleName)) == null || !this.catalogRT.passes(catalogName = dsCatalog.name)) continue;
                this.processCatalog(connection, catalogName, rows);
            }
        }

        private void processCatalog(Connection connection, String catalogName, List<Rowset.Row> rows) {
            Cube[] cubes;
            Schema schema = connection.getSchema();
            if (!this.schemaNameRT.passes(schema.getName())) {
                return;
            }
            for (Cube cube : cubes = connection.getSchemaReader().getCubes()) {
                if (!this.cubeNameRT.passes(cube.getName())) continue;
                this.populateNamedSets(cube, catalogName, rows);
            }
        }

        private void populateNamedSets(Cube cube, String catalogName, List<Rowset.Row> rows) {
            for (NamedSet namedSet : cube.getNamedSets()) {
                if (!this.setNameRT.passes(namedSet.getUniqueName())) continue;
                Rowset.Row row = new Rowset.Row();
                row.set(MdschemaSetsRowset.CatalogName.name, catalogName);
                row.set(MdschemaSetsRowset.SchemaName.name, cube.getSchema().getName());
                row.set(MdschemaSetsRowset.CubeName.name, cube.getName());
                row.set(MdschemaSetsRowset.SetName.name, namedSet.getUniqueName());
                row.set(MdschemaSetsRowset.Scope.name, GLOBAL_SCOPE);
                row.set(MdschemaSetsRowset.Description.name, namedSet.getDescription());
                this.addRow(row, rows);
            }
        }

        static /* synthetic */ Column access$22200() {
            return SetName;
        }

        static /* synthetic */ Column access$22300() {
            return Scope;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MdschemaMembersRowset
    extends Rowset {
        private final Rowset.RestrictionTest catalogRT = this.getRestrictionTest(CatalogName);
        private final Rowset.RestrictionTest schemaNameRT = this.getRestrictionTest(SchemaName);
        private final Rowset.RestrictionTest cubeNameRT = this.getRestrictionTest(CubeName);
        private final Rowset.RestrictionTest dimensionUniqueNameRT = this.getRestrictionTest(DimensionUniqueName);
        private final Rowset.RestrictionTest hierarchyUniqueNameRT = this.getRestrictionTest(HierarchyUniqueName);
        private final Rowset.RestrictionTest memberNameRT = this.getRestrictionTest(MemberName);
        private final Rowset.RestrictionTest memberUniqueNameRT = this.getRestrictionTest(MemberUniqueName);
        private final Rowset.RestrictionTest memberTypeRT = this.getRestrictionTest(MemberType);
        private static final Column CatalogName = new Column("CATALOG_NAME", Type.String, null, true, true, "The name of the catalog to which this member belongs.");
        private static final Column SchemaName = new Column("SCHEMA_NAME", Type.String, null, true, true, "The name of the schema to which this member belongs.");
        private static final Column CubeName = new Column("CUBE_NAME", Type.String, null, true, false, "Name of the cube to which this member belongs.");
        private static final Column DimensionUniqueName = new Column("DIMENSION_UNIQUE_NAME", Type.String, null, true, false, "Unique name of the dimension to which this member belongs.");
        private static final Column HierarchyUniqueName = new Column("HIERARCHY_UNIQUE_NAME", Type.String, null, true, false, "Unique name of the hierarchy. If the member belongs to more than one hierarchy, there is one row for each hierarchy to which it belongs.");
        private static final Column LevelUniqueName = new Column("LEVEL_UNIQUE_NAME", Type.String, null, true, false, " Unique name of the level to which the member belongs.");
        private static final Column LevelNumber = new Column("LEVEL_NUMBER", Type.UnsignedInteger, null, true, false, "The distance of the member from the root of the hierarchy.");
        private static final Column MemberOrdinal = new Column("MEMBER_ORDINAL", Type.UnsignedInteger, null, false, false, "Ordinal number of the member. Sort rank of the member when members of this dimension are sorted in their natural sort order. If providers do not have the concept of natural ordering, this should be the rank when sorted by MEMBER_NAME.");
        private static final Column MemberName = new Column("MEMBER_NAME", Type.String, null, true, false, "Name of the member.");
        private static final Column MemberUniqueName = new Column("MEMBER_UNIQUE_NAME", Type.StringSometimesArray, null, true, false, " Unique name of the member.");
        private static final Column MemberType = new Column("MEMBER_TYPE", Type.Integer, null, true, false, "Type of the member.");
        private static final Column MemberGuid = new Column("MEMBER_GUID", Type.UUID, null, false, true, "Memeber GUID.");
        private static final Column MemberCaption = new Column("MEMBER_CAPTION", Type.String, null, true, false, "A label or caption associated with the member.");
        private static final Column ChildrenCardinality = new Column("CHILDREN_CARDINALITY", Type.UnsignedInteger, null, false, false, "Number of children that the member has.");
        private static final Column ParentLevel = new Column("PARENT_LEVEL", Type.UnsignedInteger, null, false, false, "The distance of the member's parent from the root level of the hierarchy.");
        private static final Column ParentUniqueName = new Column("PARENT_UNIQUE_NAME", Type.String, null, false, true, "Unique name of the member's parent.");
        private static final Column ParentCount = new Column("PARENT_COUNT", Type.UnsignedInteger, null, false, false, "Number of parents that this member has.");
        private static final Column TreeOp_ = new Column("TREE_OP", Type.Enumeration, Enumeration.TREE_OP, true, true, "Tree Operation");
        private static final Column Depth = new Column("DEPTH", Type.Integer, null, false, true, "depth");

        MdschemaMembersRowset(XmlaRequest request, XmlaHandler handler) {
            super(MDSCHEMA_MEMBERS, request, handler);
        }

        @Override
        public void populate(XmlaResponse response, List<Rowset.Row> rows) throws XmlaException {
            DataSourcesConfig.DataSource ds = this.handler.getDataSource(this.request);
            DataSourcesConfig.Catalog[] catalogs = this.handler.getCatalogs(this.request, ds);
            String roleName = this.request.getRoleName();
            Role role = this.request.getRole();
            for (DataSourcesConfig.Catalog dsCatalog : catalogs) {
                String catalogName;
                Connection connection;
                if (dsCatalog == null || dsCatalog.definition == null || (connection = this.handler.getConnection(dsCatalog, role, roleName)) == null || !this.catalogRT.passes(catalogName = dsCatalog.name)) continue;
                this.populateCatalog(connection, catalogName, rows);
            }
        }

        protected void populateCatalog(Connection connection, String catalogName, List<Rowset.Row> rows) throws XmlaException {
            Schema schema = connection.getSchema();
            if (!this.schemaNameRT.passes(schema.getName())) {
                return;
            }
            for (Cube cube : RowsetDefinition.sortedCubes(schema)) {
                SchemaReader schemaReader;
                if (!this.cubeNameRT.passes(cube.getName())) continue;
                if (this.isRestricted(MemberUniqueName)) {
                    schemaReader = cube.getSchemaReader(null);
                    this.outputUniqueMemberName(schemaReader, catalogName, cube, rows);
                    continue;
                }
                schemaReader = cube.getSchemaReader(connection.getRole());
                this.populateCube(schemaReader, catalogName, cube, rows);
            }
        }

        protected void populateCube(SchemaReader schemaReader, String catalogName, Cube cube, List<Rowset.Row> rows) throws XmlaException {
            if (this.isRestricted(LevelUniqueName)) {
                Level[] levels;
                String levelUniqueName = this.getRestrictionValueAsString(LevelUniqueName);
                if (levelUniqueName == null) {
                    return;
                }
                List<Id.Segment> nameParts = Util.parseIdentifier(levelUniqueName);
                Hierarchy hier = cube.lookupHierarchy(nameParts.get(0), false);
                if (hier == null) {
                    return;
                }
                for (Level level : levels = hier.getLevels()) {
                    if (!level.getUniqueName().equals(levelUniqueName)) continue;
                    List<Member> members = cube.getSchemaReader(null).getLevelMembers(level, true);
                    this.outputMembers(schemaReader, members, catalogName, cube, rows);
                }
            } else {
                for (Dimension dimension : cube.getDimensions()) {
                    String uniqueName = dimension.getUniqueName();
                    if (!this.dimensionUniqueNameRT.passes(uniqueName)) continue;
                    this.populateDimension(schemaReader, catalogName, cube, dimension, rows);
                }
            }
        }

        protected void populateDimension(SchemaReader schemaReader, String catalogName, Cube cube, Dimension dimension, List<Rowset.Row> rows) throws XmlaException {
            Hierarchy[] hierarchies;
            for (Hierarchy hierarchy : hierarchies = dimension.getHierarchies()) {
                String uniqueName = hierarchy.getUniqueName();
                if (!this.hierarchyUniqueNameRT.passes(uniqueName)) continue;
                this.populateHierarchy(schemaReader, catalogName, cube, hierarchy, rows);
            }
        }

        protected void populateHierarchy(SchemaReader schemaReader, String catalogName, Cube cube, Hierarchy hierarchy, List<Rowset.Row> rows) throws XmlaException {
            if (this.isRestricted(LevelNumber)) {
                int levelNumber = this.getRestrictionValueAsInt(LevelNumber);
                if (levelNumber == -1) {
                    LOGGER.warn((Object)"RowsetDefinition.populateHierarchy: LevelNumber invalid");
                    return;
                }
                Level[] levels = hierarchy.getLevels();
                if (levelNumber >= levels.length) {
                    LOGGER.warn((Object)("RowsetDefinition.populateHierarchy: LevelNumber (" + levelNumber + ") is greater than number of levels (" + levels.length + ") for hierarchy \"" + hierarchy.getUniqueName() + "\""));
                    return;
                }
                Level level = levels[levelNumber];
                List<Member> members = schemaReader.getLevelMembers(level, false);
                this.outputMembers(schemaReader, members, catalogName, cube, rows);
            } else {
                List<List<Member>> membersArray = RolapMemberBase.getAllMembers(schemaReader, hierarchy);
                for (List<Member> members : membersArray) {
                    this.outputMembers(schemaReader, members, catalogName, cube, rows);
                }
            }
        }

        private static boolean mask(int value, int mask) {
            return (value & mask) == mask;
        }

        private void populateMember(SchemaReader schemaReader, String catalogName, Cube cube, Member member, int treeOp, List<Rowset.Row> rows) {
            List<Member> children;
            Member parent;
            if (MdschemaMembersRowset.mask(treeOp, Member.TreeOp.SELF.xmlaOrdinal())) {
                this.outputMember(schemaReader, member, catalogName, cube, rows);
            }
            if (MdschemaMembersRowset.mask(treeOp, Member.TreeOp.SIBLINGS.xmlaOrdinal())) {
                parent = schemaReader.getMemberParent(member);
                List<Member> siblings = parent == null ? schemaReader.getHierarchyRootMembers(member.getHierarchy()) : schemaReader.getMemberChildren(parent);
                for (Member sibling : siblings) {
                    if (sibling.equals(member)) continue;
                    this.populateMember(schemaReader, catalogName, cube, sibling, Member.TreeOp.SELF.xmlaOrdinal(), rows);
                }
            }
            if (MdschemaMembersRowset.mask(treeOp, Member.TreeOp.DESCENDANTS.xmlaOrdinal())) {
                children = schemaReader.getMemberChildren(member);
                for (Member child : children) {
                    this.populateMember(schemaReader, catalogName, cube, child, Member.TreeOp.SELF.xmlaOrdinal() | Member.TreeOp.DESCENDANTS.xmlaOrdinal(), rows);
                }
            } else if (MdschemaMembersRowset.mask(treeOp, Member.TreeOp.CHILDREN.xmlaOrdinal())) {
                children = schemaReader.getMemberChildren(member);
                for (Member child : children) {
                    this.populateMember(schemaReader, catalogName, cube, child, Member.TreeOp.SELF.xmlaOrdinal(), rows);
                }
            }
            if (MdschemaMembersRowset.mask(treeOp, Member.TreeOp.ANCESTORS.xmlaOrdinal())) {
                parent = schemaReader.getMemberParent(member);
                if (parent != null) {
                    this.populateMember(schemaReader, catalogName, cube, parent, Member.TreeOp.SELF.xmlaOrdinal() | Member.TreeOp.ANCESTORS.xmlaOrdinal(), rows);
                }
            } else if (MdschemaMembersRowset.mask(treeOp, Member.TreeOp.PARENT.xmlaOrdinal()) && (parent = schemaReader.getMemberParent(member)) != null) {
                this.populateMember(schemaReader, catalogName, cube, parent, Member.TreeOp.SELF.xmlaOrdinal(), rows);
            }
        }

        @Override
        protected ArrayList<Column> pruneRestrictions(ArrayList<Column> list) {
            if (list.contains(TreeOp_)) {
                list.remove(TreeOp_);
                list.remove(MemberUniqueName);
            }
            return list;
        }

        private void outputMembers(SchemaReader schemaReader, List<Member> members, String catalogName, Cube cube, List<Rowset.Row> rows) {
            for (Member member : members) {
                this.outputMember(schemaReader, member, catalogName, cube, rows);
            }
        }

        private void outputUniqueMemberName(SchemaReader schemaReader, String catalogName, Cube cube, List<Rowset.Row> rows) {
            Object unameRestrictions = this.restrictions.get(MdschemaMembersRowset.MemberUniqueName.name);
            List<String> list = unameRestrictions instanceof String ? Collections.singletonList((String)unameRestrictions) : (List<String>)unameRestrictions;
            for (String memberUniqueName : list) {
                List<Id.Segment> nameParts = Util.parseIdentifier(memberUniqueName);
                Member member = schemaReader.getMemberByUniqueName(nameParts, false);
                if (member == null) {
                    return;
                }
                if (this.isRestricted(TreeOp_)) {
                    int treeOp = this.getRestrictionValueAsInt(TreeOp_);
                    if (treeOp == -1) {
                        return;
                    }
                    this.populateMember(schemaReader, catalogName, cube, member, treeOp, rows);
                    continue;
                }
                this.outputMember(schemaReader, member, catalogName, cube, rows);
            }
        }

        private void outputMember(SchemaReader schemaReader, Member member, String catalogName, Cube cube, List<Rowset.Row> rows) {
            Boolean visible;
            if (!RowsetDefinition.canAccess(schemaReader, member)) {
                return;
            }
            if (!this.memberNameRT.passes(member.getName())) {
                return;
            }
            if (!this.memberTypeRT.passes((Object)member.getMemberType())) {
                return;
            }
            if (member.getOrdinal() == -1) {
                RolapMemberBase.setOrdinals(schemaReader, member);
            }
            if ((visible = (Boolean)member.getPropertyValue(Property.VISIBLE.name)) == null) {
                visible = true;
            }
            if (!visible.booleanValue() && !XmlaUtil.shouldEmitInvisibleMembers(this.request)) {
                return;
            }
            Level level = member.getLevel();
            Hierarchy hierarchy = level.getHierarchy();
            Dimension dimension = hierarchy.getDimension();
            int adjustedLevelDepth = level.getDepth();
            Role.HierarchyAccess hierarchyAccess = schemaReader.getRole().getAccessDetails(hierarchy);
            if (hierarchyAccess != null) {
                adjustedLevelDepth -= hierarchyAccess.getTopLevelDepth();
            }
            Rowset.Row row = new Rowset.Row();
            row.set(MdschemaMembersRowset.CatalogName.name, catalogName);
            row.set(MdschemaMembersRowset.SchemaName.name, cube.getSchema().getName());
            row.set(MdschemaMembersRowset.CubeName.name, cube.getName());
            row.set(MdschemaMembersRowset.DimensionUniqueName.name, dimension.getUniqueName());
            row.set(MdschemaMembersRowset.HierarchyUniqueName.name, hierarchy.getUniqueName());
            row.set(MdschemaMembersRowset.LevelUniqueName.name, level.getUniqueName());
            row.set(MdschemaMembersRowset.LevelNumber.name, adjustedLevelDepth);
            row.set(MdschemaMembersRowset.MemberOrdinal.name, member.getOrdinal());
            row.set(MdschemaMembersRowset.MemberName.name, member.getName());
            row.set(MdschemaMembersRowset.MemberUniqueName.name, member.getUniqueName());
            row.set(MdschemaMembersRowset.MemberType.name, member.getMemberType().ordinal());
            row.set(MdschemaMembersRowset.MemberCaption.name, member.getCaption());
            row.set(MdschemaMembersRowset.ChildrenCardinality.name, member.getPropertyValue(Property.CHILDREN_CARDINALITY.name));
            row.set(MdschemaMembersRowset.ChildrenCardinality.name, 100);
            if (adjustedLevelDepth == 0) {
                row.set(MdschemaMembersRowset.ParentLevel.name, 0);
            } else {
                row.set(MdschemaMembersRowset.ParentLevel.name, adjustedLevelDepth - 1);
                Member parentMember = member.getParentMember();
                if (parentMember != null) {
                    row.set(MdschemaMembersRowset.ParentUniqueName.name, parentMember.getUniqueName());
                }
            }
            row.set(MdschemaMembersRowset.ParentCount.name, member.getParentMember() == null ? 0 : 1);
            row.set(MdschemaMembersRowset.Depth.name, member.getDepth());
            this.addRow(row, rows);
        }

        @Override
        protected void setProperty(PropertyDefinition propertyDef, String value) {
            switch (propertyDef) {
                case Content: {
                    break;
                }
                default: {
                    super.setProperty(propertyDef, value);
                }
            }
        }

        static /* synthetic */ Column access$18700() {
            return CatalogName;
        }

        static /* synthetic */ Column access$18800() {
            return SchemaName;
        }

        static /* synthetic */ Column access$18900() {
            return CubeName;
        }

        static /* synthetic */ Column access$19000() {
            return DimensionUniqueName;
        }

        static /* synthetic */ Column access$19100() {
            return HierarchyUniqueName;
        }

        static /* synthetic */ Column access$19200() {
            return LevelUniqueName;
        }

        static /* synthetic */ Column access$19300() {
            return LevelNumber;
        }

        static /* synthetic */ Column access$19400() {
            return MemberOrdinal;
        }

        static /* synthetic */ Column access$19500() {
            return MemberName;
        }

        static /* synthetic */ Column access$19600() {
            return MemberUniqueName;
        }

        static /* synthetic */ Column access$19700() {
            return MemberType;
        }

        static /* synthetic */ Column access$19800() {
            return MemberGuid;
        }

        static /* synthetic */ Column access$19900() {
            return MemberCaption;
        }

        static /* synthetic */ Column access$20000() {
            return ChildrenCardinality;
        }

        static /* synthetic */ Column access$20100() {
            return ParentLevel;
        }

        static /* synthetic */ Column access$20200() {
            return ParentUniqueName;
        }

        static /* synthetic */ Column access$20300() {
            return ParentCount;
        }

        static /* synthetic */ Column access$20400() {
            return TreeOp_;
        }

        static /* synthetic */ Column access$20500() {
            return Depth;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MdschemaMeasuresRowset
    extends Rowset {
        public static final int MDMEASURE_AGGR_UNKNOWN = 0;
        public static final int MDMEASURE_AGGR_SUM = 1;
        public static final int MDMEASURE_AGGR_COUNT = 2;
        public static final int MDMEASURE_AGGR_MIN = 3;
        public static final int MDMEASURE_AGGR_MAX = 4;
        public static final int MDMEASURE_AGGR_AVG = 5;
        public static final int MDMEASURE_AGGR_VAR = 6;
        public static final int MDMEASURE_AGGR_STD = 7;
        public static final int MDMEASURE_AGGR_CALCULATED = 127;
        private final Rowset.RestrictionTest catalogRT = this.getRestrictionTest(CatalogName);
        private final Rowset.RestrictionTest schemaNameRT = this.getRestrictionTest(SchemaName);
        private final Rowset.RestrictionTest cubeNameRT = this.getRestrictionTest(CubeName);
        private final Rowset.RestrictionTest measureUniqueNameRT;
        private final Rowset.RestrictionTest measureNameRT = this.getRestrictionTest(MeasureName);
        private static final Column CatalogName = new Column("CATALOG_NAME", Type.String, null, true, true, "The name of the catalog to which this measure belongs.");
        private static final Column SchemaName = new Column("SCHEMA_NAME", Type.String, null, true, true, "The name of the schema to which this measure belongs.");
        private static final Column CubeName = new Column("CUBE_NAME", Type.String, null, true, false, "The name of the cube to which this measure belongs.");
        private static final Column MeasureName = new Column("MEASURE_NAME", Type.String, null, true, false, "The name of the measure.");
        private static final Column MeasureUniqueName = new Column("MEASURE_UNIQUE_NAME", Type.String, null, true, false, "The Unique name of the measure.");
        private static final Column MeasureCaption = new Column("MEASURE_CAPTION", Type.String, null, false, false, "A label or caption associated with the measure.");
        private static final Column MeasureGuid = new Column("MEASURE_GUID", Type.UUID, null, false, true, "Measure GUID.");
        private static final Column MeasureAggregator = new Column("MEASURE_AGGREGATOR", Type.Integer, null, false, false, "How a measure was derived.");
        private static final Column DataType = new Column("DATA_TYPE", Type.UnsignedShort, null, false, false, "Data type of the measure.");
        private static final Column MeasureIsVisible = new Column("MEASURE_IS_VISIBLE", Type.Boolean, null, false, false, "A Boolean that always returns True. If the measure is not visible, it will not be included in the schema rowset.");
        private static final Column LevelsList = new Column("LEVELS_LIST", Type.String, null, false, true, "A string that always returns NULL. EXCEPT that SQL Server returns non-null values!!!");
        private static final Column Description = new Column("DESCRIPTION", Type.String, null, false, true, "A human-readable description of the measure.");
        private static final Column FormatString = new Column("DEFAULT_FORMAT_STRING", Type.String, null, false, true, "The default format string for the measure.");

        MdschemaMeasuresRowset(XmlaRequest request, XmlaHandler handler) {
            super(MDSCHEMA_MEASURES, request, handler);
            this.measureUniqueNameRT = this.getRestrictionTest(MeasureUniqueName);
        }

        @Override
        public void populate(XmlaResponse response, List<Rowset.Row> rows) throws XmlaException {
            DataSourcesConfig.DataSource ds = this.handler.getDataSource(this.request);
            DataSourcesConfig.Catalog[] catalogs = this.handler.getCatalogs(this.request, ds);
            String roleName = this.request.getRoleName();
            Role role = this.request.getRole();
            for (DataSourcesConfig.Catalog dsCatalog : catalogs) {
                String catalogName;
                Connection connection;
                if (dsCatalog == null || dsCatalog.definition == null || (connection = this.handler.getConnection(dsCatalog, role, roleName)) == null || !this.catalogRT.passes(catalogName = dsCatalog.name)) continue;
                this.populateCatalog(connection, catalogName, rows);
            }
        }

        protected void populateCatalog(Connection connection, String catalogName, List<Rowset.Row> rows) throws XmlaException {
            StringBuilder buf = new StringBuilder(100);
            Schema schema = connection.getSchema();
            if (!this.schemaNameRT.passes(schema.getName())) {
                return;
            }
            for (Cube cube : RowsetDefinition.sortedCubes(schema)) {
                String name;
                if (!this.cubeNameRT.passes(cube.getName())) continue;
                SchemaReader schemaReader = cube.getSchemaReader(connection.getRole());
                Dimension measuresDimension = cube.getDimensions()[0];
                Hierarchy measuresHierarchy = measuresDimension.getHierarchies()[0];
                Level measuresLevel = measuresHierarchy.getLevels()[0];
                buf.setLength(0);
                int j = 0;
                for (Dimension dimension : cube.getDimensions()) {
                    if (dimension.isMeasures()) continue;
                    for (Hierarchy hierarchy : dimension.getHierarchies()) {
                        Level[] levels = hierarchy.getLevels();
                        Level lastLevel = levels[levels.length - 1];
                        if (j++ > 0) {
                            buf.append(',');
                        }
                        buf.append(lastLevel.getUniqueName());
                    }
                }
                String levelListStr = buf.toString();
                List<Member> storedMembers = schemaReader.getLevelMembers(measuresLevel, false);
                for (Member member : storedMembers) {
                    name = member.getName();
                    String unique = member.getUniqueName();
                    if (!this.measureNameRT.passes(name) || !this.measureUniqueNameRT.passes(unique)) continue;
                    this.populateMember(schemaReader, catalogName, member, cube, levelListStr, rows);
                }
                for (Member member : schemaReader.getCalculatedMembers(measuresHierarchy)) {
                    name = member.getName();
                    String unique = member.getUniqueName();
                    if (!this.measureNameRT.passes(name) || !this.measureUniqueNameRT.passes(unique)) continue;
                    this.populateMember(schemaReader, catalogName, member, cube, null, rows);
                }
            }
        }

        private void populateMember(SchemaReader schemaReader, String catalogName, Member member, Cube cube, String levelListStr, List<Rowset.Row> rows) {
            if (!RowsetDefinition.canAccess(schemaReader, member)) {
                return;
            }
            Boolean visible = (Boolean)member.getPropertyValue(Property.VISIBLE.name);
            if (visible == null) {
                visible = true;
            }
            if (!visible.booleanValue() && !XmlaUtil.shouldEmitInvisibleMembers(this.request)) {
                return;
            }
            String desc = member.getDescription();
            if (desc == null) {
                desc = cube.getName() + " Cube - " + member.getName() + " Member";
            }
            String formatString = (String)member.getPropertyValue(Property.FORMAT_STRING.name);
            Rowset.Row row = new Rowset.Row();
            row.set(MdschemaMeasuresRowset.CatalogName.name, catalogName);
            row.set(MdschemaMeasuresRowset.SchemaName.name, cube.getSchema().getName());
            row.set(MdschemaMeasuresRowset.CubeName.name, cube.getName());
            row.set(MdschemaMeasuresRowset.MeasureName.name, member.getName());
            row.set(MdschemaMeasuresRowset.MeasureUniqueName.name, member.getUniqueName());
            row.set(MdschemaMeasuresRowset.MeasureCaption.name, member.getCaption());
            Object aggProp = member.getPropertyValue(Property.AGGREGATION_TYPE.getName());
            int aggNumber = 0;
            if (aggProp != null) {
                RolapAggregator agg = (RolapAggregator)aggProp;
                if (agg == RolapAggregator.Sum) {
                    aggNumber = 1;
                } else if (agg == RolapAggregator.Count) {
                    aggNumber = 2;
                } else if (agg == RolapAggregator.Min) {
                    aggNumber = 3;
                } else if (agg == RolapAggregator.Max) {
                    aggNumber = 4;
                } else if (agg == RolapAggregator.Avg) {
                    aggNumber = 5;
                }
            } else {
                aggNumber = 127;
            }
            row.set(MdschemaMeasuresRowset.MeasureAggregator.name, aggNumber);
            XmlaConstants.DBType dbType = XmlaConstants.DBType.WSTR;
            String datatype = (String)member.getPropertyValue(Property.DATATYPE.getName());
            if (datatype != null) {
                dbType = datatype.equals("Integer") ? XmlaConstants.DBType.I4 : (datatype.equals("Numeric") ? XmlaConstants.DBType.R8 : XmlaConstants.DBType.WSTR);
            }
            row.set(MdschemaMeasuresRowset.DataType.name, dbType.xmlaOrdinal());
            row.set(MdschemaMeasuresRowset.MeasureIsVisible.name, visible);
            if (levelListStr != null) {
                row.set(MdschemaMeasuresRowset.LevelsList.name, levelListStr);
            }
            row.set(MdschemaMeasuresRowset.Description.name, desc);
            row.set(MdschemaMeasuresRowset.FormatString.name, formatString);
            this.addRow(row, rows);
        }

        @Override
        protected void setProperty(PropertyDefinition propertyDef, String value) {
            switch (propertyDef) {
                case Content: {
                    break;
                }
                default: {
                    super.setProperty(propertyDef, value);
                }
            }
        }

        static /* synthetic */ Column access$17700() {
            return MeasureName;
        }

        static /* synthetic */ Column access$17800() {
            return MeasureUniqueName;
        }

        static /* synthetic */ Column access$17900() {
            return MeasureCaption;
        }

        static /* synthetic */ Column access$18000() {
            return MeasureGuid;
        }

        static /* synthetic */ Column access$18100() {
            return MeasureAggregator;
        }

        static /* synthetic */ Column access$18200() {
            return DataType;
        }

        static /* synthetic */ Column access$18300() {
            return MeasureIsVisible;
        }

        static /* synthetic */ Column access$18400() {
            return LevelsList;
        }

        static /* synthetic */ Column access$18500() {
            return Description;
        }

        static /* synthetic */ Column access$18600() {
            return FormatString;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MdschemaLevelsRowset
    extends Rowset {
        private final Rowset.RestrictionTest catalogRT = this.getRestrictionTest(CatalogName);
        private final Rowset.RestrictionTest schemaNameRT = this.getRestrictionTest(SchemaName);
        private final Rowset.RestrictionTest cubeNameRT = this.getRestrictionTest(CubeName);
        private final Rowset.RestrictionTest dimensionUniqueNameRT = this.getRestrictionTest(DimensionUniqueName);
        private final Rowset.RestrictionTest hierarchyUniqueNameRT = this.getRestrictionTest(HierarchyUniqueName);
        private final Rowset.RestrictionTest levelUniqueNameRT = this.getRestrictionTest(LevelUniqueName);
        private final Rowset.RestrictionTest levelNameRT = this.getRestrictionTest(LevelName);
        public static final int MDLEVEL_TYPE_UNKNOWN = 0;
        public static final int MDLEVEL_TYPE_REGULAR = 0;
        public static final int MDLEVEL_TYPE_ALL = 1;
        public static final int MDLEVEL_TYPE_CALCULATED = 2;
        public static final int MDLEVEL_TYPE_TIME = 4;
        public static final int MDLEVEL_TYPE_RESERVED1 = 8;
        public static final int MDLEVEL_TYPE_TIME_YEARS = 20;
        public static final int MDLEVEL_TYPE_TIME_HALF_YEAR = 36;
        public static final int MDLEVEL_TYPE_TIME_QUARTERS = 68;
        public static final int MDLEVEL_TYPE_TIME_MONTHS = 132;
        public static final int MDLEVEL_TYPE_TIME_WEEKS = 260;
        public static final int MDLEVEL_TYPE_TIME_DAYS = 516;
        public static final int MDLEVEL_TYPE_TIME_HOURS = 772;
        public static final int MDLEVEL_TYPE_TIME_MINUTES = 1028;
        public static final int MDLEVEL_TYPE_TIME_SECONDS = 2052;
        public static final int MDLEVEL_TYPE_TIME_UNDEFINED = 4100;
        private static final Column CatalogName = new Column("CATALOG_NAME", Type.String, null, true, true, "The name of the catalog to which this level belongs.");
        private static final Column SchemaName = new Column("SCHEMA_NAME", Type.String, null, true, true, "The name of the schema to which this level belongs.");
        private static final Column CubeName = new Column("CUBE_NAME", Type.String, null, true, false, "The name of the cube to which this level belongs.");
        private static final Column DimensionUniqueName = new Column("DIMENSION_UNIQUE_NAME", Type.String, null, true, false, "The unique name of the dimension to which this level belongs.");
        private static final Column HierarchyUniqueName = new Column("HIERARCHY_UNIQUE_NAME", Type.String, null, true, false, "The unique name of the hierarchy.");
        private static final Column LevelName = new Column("LEVEL_NAME", Type.String, null, true, false, "The name of the level.");
        private static final Column LevelUniqueName = new Column("LEVEL_UNIQUE_NAME", Type.String, null, true, false, "The properly escaped unique name of the level.");
        private static final Column LevelGuid = new Column("LEVEL_GUID", Type.UUID, null, false, true, "Level GUID.");
        private static final Column LevelCaption = new Column("LEVEL_CAPTION", Type.String, null, false, false, "A label or caption associated with the hierarchy.");
        private static final Column LevelNumber = new Column("LEVEL_NUMBER", Type.UnsignedInteger, null, false, false, "The distance of the level from the root of the hierarchy. Root level is zero (0).");
        private static final Column LevelCardinality = new Column("LEVEL_CARDINALITY", Type.UnsignedInteger, null, false, false, "The number of members in the level. This value can be an approximation of the real cardinality.");
        private static final Column LevelType = new Column("LEVEL_TYPE", Type.Integer, null, false, false, "Type of the level");
        private static final Column CustomRollupSettings = new Column("CUSTOM_ROLLUP_SETTINGS", Type.Integer, null, false, false, "A bitmap that specifies the custom rollup options.");
        private static final Column LevelUniqueSettings = new Column("LEVEL_UNIQUE_SETTINGS", Type.Integer, null, false, false, "A bitmap that specifies which columns contain unique values, if the level only has members with unique names or keys.");
        private static final Column LevelIsVisible = new Column("LEVEL_IS_VISIBLE", Type.Boolean, null, false, false, "A Boolean that indicates whether the level is visible.");
        private static final Column Description = new Column("DESCRIPTION", Type.String, null, false, true, "A human-readable description of the level. NULL if no description exists.");

        MdschemaLevelsRowset(XmlaRequest request, XmlaHandler handler) {
            super(MDSCHEMA_LEVELS, request, handler);
        }

        @Override
        public void populate(XmlaResponse response, List<Rowset.Row> rows) throws XmlaException {
            DataSourcesConfig.DataSource ds = this.handler.getDataSource(this.request);
            DataSourcesConfig.Catalog[] catalogs = this.handler.getCatalogs(this.request, ds);
            String roleName = this.request.getRoleName();
            Role role = this.request.getRole();
            for (DataSourcesConfig.Catalog dsCatalog : catalogs) {
                Connection connection;
                String catalogName;
                if (dsCatalog == null || dsCatalog.definition == null || !this.catalogRT.passes(catalogName = dsCatalog.name) || (connection = this.handler.getConnection(dsCatalog, role, roleName)) == null) continue;
                this.populateCatalog(connection, catalogName, rows);
            }
        }

        protected void populateCatalog(Connection connection, String catalogName, List<Rowset.Row> rows) throws XmlaException {
            Schema schema = connection.getSchema();
            if (!this.schemaNameRT.passes(schema.getName())) {
                return;
            }
            for (Cube cube : RowsetDefinition.sortedCubes(schema)) {
                if (!this.cubeNameRT.passes(cube.getName())) continue;
                SchemaReader schemaReader = cube.getSchemaReader(connection.getRole());
                this.populateCube(schemaReader, catalogName, cube, rows);
            }
        }

        protected void populateCube(SchemaReader schemaReader, String catalogName, Cube cube, List<Rowset.Row> rows) throws XmlaException {
            for (Dimension dimension : cube.getDimensions()) {
                String uniqueName = dimension.getUniqueName();
                if (!this.dimensionUniqueNameRT.passes(uniqueName)) continue;
                this.populateDimension(schemaReader, catalogName, cube, dimension, rows);
            }
        }

        protected void populateDimension(SchemaReader schemaReader, String catalogName, Cube cube, Dimension dimension, List<Rowset.Row> rows) throws XmlaException {
            Hierarchy[] hierarchies;
            for (Hierarchy hierarchy : hierarchies = dimension.getHierarchies()) {
                String uniqueName = hierarchy.getUniqueName();
                if (!this.hierarchyUniqueNameRT.passes(uniqueName)) continue;
                this.populateHierarchy(schemaReader, catalogName, cube, hierarchy, rows);
            }
        }

        protected void populateHierarchy(SchemaReader schemaReader, String catalogName, Cube cube, Hierarchy hierarchy, List<Rowset.Row> rows) throws XmlaException {
            for (Level level : schemaReader.getHierarchyLevels(hierarchy)) {
                String uniqueName = level.getUniqueName();
                String name = level.getName();
                if (!this.levelUniqueNameRT.passes(uniqueName) || !this.levelNameRT.passes(name)) continue;
                this.outputLevel(schemaReader, catalogName, cube, hierarchy, level, rows);
            }
        }

        protected boolean outputLevel(SchemaReader schemaReader, String catalogName, Cube cube, Hierarchy hierarchy, Level level, List<Rowset.Row> rows) throws XmlaException {
            if (!RowsetDefinition.canAccess(schemaReader, level)) {
                return false;
            }
            String desc = level.getDescription();
            if (desc == null) {
                desc = cube.getName() + " Cube - " + RowsetDefinition.getHierarchyName(hierarchy) + " Hierarchy - " + level.getName() + " Level";
            }
            int adjustedLevelDepth = level.getDepth();
            Role.HierarchyAccess hierarchyAccess = schemaReader.getRole().getAccessDetails(hierarchy);
            if (hierarchyAccess != null) {
                adjustedLevelDepth -= hierarchyAccess.getTopLevelDepth();
            }
            Rowset.Row row = new Rowset.Row();
            row.set(MdschemaLevelsRowset.CatalogName.name, catalogName);
            row.set(MdschemaLevelsRowset.SchemaName.name, cube.getSchema().getName());
            row.set(MdschemaLevelsRowset.CubeName.name, cube.getName());
            row.set(MdschemaLevelsRowset.DimensionUniqueName.name, hierarchy.getDimension().getUniqueName());
            row.set(MdschemaLevelsRowset.HierarchyUniqueName.name, hierarchy.getUniqueName());
            row.set(MdschemaLevelsRowset.LevelName.name, level.getName());
            row.set(MdschemaLevelsRowset.LevelUniqueName.name, level.getUniqueName());
            row.set(MdschemaLevelsRowset.LevelCaption.name, level.getCaption());
            row.set(MdschemaLevelsRowset.LevelNumber.name, adjustedLevelDepth);
            int n = schemaReader.getLevelCardinality(level, true, true);
            row.set(MdschemaLevelsRowset.LevelCardinality.name, n);
            row.set(MdschemaLevelsRowset.LevelType.name, this.getLevelType(level));
            row.set(MdschemaLevelsRowset.CustomRollupSettings.name, 0);
            if (level instanceof RolapLevel) {
                RolapLevel rl = (RolapLevel)level;
                row.set(MdschemaLevelsRowset.LevelUniqueSettings.name, (rl.isUnique() ? 1 : 0) + (rl.isAll() ? 2 : 0));
            } else {
                row.set(MdschemaLevelsRowset.LevelUniqueSettings.name, level.isAll() ? 2 : 0);
            }
            row.set(MdschemaLevelsRowset.LevelIsVisible.name, true);
            row.set(MdschemaLevelsRowset.Description.name, desc);
            this.addRow(row, rows);
            return true;
        }

        private int getLevelType(Level lev) {
            int ret = 0;
            if (lev.isAll()) {
                ret |= 1;
            }
            LevelType type = lev.getLevelType();
            switch (type) {
                case Regular: {
                    ret |= 0;
                    break;
                }
                case TimeYears: {
                    ret |= 0x14;
                    break;
                }
                case TimeHalfYear: {
                    ret |= 0x24;
                    break;
                }
                case TimeQuarters: {
                    ret |= 0x44;
                    break;
                }
                case TimeMonths: {
                    ret |= 0x84;
                    break;
                }
                case TimeWeeks: {
                    ret |= 0x104;
                    break;
                }
                case TimeDays: {
                    ret |= 0x204;
                    break;
                }
                case TimeHours: {
                    ret |= 0x304;
                    break;
                }
                case TimeMinutes: {
                    ret |= 0x404;
                    break;
                }
                case TimeSeconds: {
                    ret |= 0x804;
                    break;
                }
                case TimeUndefined: {
                    ret |= 0x1004;
                    break;
                }
                default: {
                    ret |= 0;
                }
            }
            return ret;
        }

        @Override
        protected void setProperty(PropertyDefinition propertyDef, String value) {
            switch (propertyDef) {
                case Content: {
                    break;
                }
                default: {
                    super.setProperty(propertyDef, value);
                }
            }
        }

        static /* synthetic */ Column access$16300() {
            return LevelName;
        }

        static /* synthetic */ Column access$16400() {
            return LevelUniqueName;
        }

        static /* synthetic */ Column access$16500() {
            return LevelGuid;
        }

        static /* synthetic */ Column access$16600() {
            return LevelCaption;
        }

        static /* synthetic */ Column access$16700() {
            return LevelNumber;
        }

        static /* synthetic */ Column access$16800() {
            return LevelCardinality;
        }

        static /* synthetic */ Column access$16900() {
            return LevelType;
        }

        static /* synthetic */ Column access$17000() {
            return CustomRollupSettings;
        }

        static /* synthetic */ Column access$17100() {
            return LevelUniqueSettings;
        }

        static /* synthetic */ Column access$17200() {
            return LevelIsVisible;
        }

        static /* synthetic */ Column access$17300() {
            return Description;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MdschemaHierarchiesRowset
    extends Rowset {
        private final Rowset.RestrictionTest catalogRT = this.getRestrictionTest(CatalogName);
        private final Rowset.RestrictionTest schemaNameRT = this.getRestrictionTest(SchemaName);
        private final Rowset.RestrictionTest cubeNameRT = this.getRestrictionTest(CubeName);
        private final Rowset.RestrictionTest dimensionUniqueNameRT = this.getRestrictionTest(DimensionUniqueName);
        private final Rowset.RestrictionTest hierarchyUniqueNameRT = this.getRestrictionTest(HierarchyUniqueName);
        private final Rowset.RestrictionTest hierarchyNameRT = this.getRestrictionTest(HierarchyName);
        private static final Column CatalogName = new Column("CATALOG_NAME", Type.String, null, true, true, "The name of the catalog to which this hierarchy belongs.");
        private static final Column SchemaName = new Column("SCHEMA_NAME", Type.String, null, true, true, "Not supported");
        private static final Column CubeName = new Column("CUBE_NAME", Type.String, null, true, false, "The name of the cube to which this hierarchy belongs.");
        private static final Column DimensionUniqueName = new Column("DIMENSION_UNIQUE_NAME", Type.String, null, true, false, "The unique name of the dimension to which this hierarchy belongs.");
        private static final Column HierarchyName = new Column("HIERARCHY_NAME", Type.String, null, true, false, "The name of the hierarchy. Blank if there is only a single hierarchy in the dimension.");
        private static final Column HierarchyUniqueName = new Column("HIERARCHY_UNIQUE_NAME", Type.String, null, true, false, "The unique name of the hierarchy.");
        private static final Column HierarchyGuid = new Column("HIERARCHY_GUID", Type.UUID, null, false, true, "Hierarchy GUID.");
        private static final Column HierarchyCaption = new Column("HIERARCHY_CAPTION", Type.String, null, false, false, "A label or a caption associated with the hierarchy.");
        private static final Column DimensionType = new Column("DIMENSION_TYPE", Type.Short, null, false, false, "The type of the dimension.");
        private static final Column HierarchyCardinality = new Column("HIERARCHY_CARDINALITY", Type.UnsignedInteger, null, false, false, "The number of members in the hierarchy.");
        private static final Column DefaultMember = new Column("DEFAULT_MEMBER", Type.String, null, false, true, "The default member for this hierarchy.");
        private static final Column AllMember = new Column("ALL_MEMBER", Type.String, null, false, true, "The member at the highest level of rollup in the hierarchy.");
        private static final Column Description = new Column("DESCRIPTION", Type.String, null, false, true, "A human-readable description of the hierarchy. NULL if no description exists.");
        private static final Column Structure = new Column("STRUCTURE", Type.Short, null, false, false, "The structure of the hierarchy.");
        private static final Column IsVirtual = new Column("IS_VIRTUAL", Type.Boolean, null, false, false, "Always returns False.");
        private static final Column IsReadWrite = new Column("IS_READWRITE", Type.Boolean, null, false, false, "A Boolean that indicates whether the Write Back to dimension column is enabled.");
        private static final Column DimensionUniqueSettings = new Column("DIMENSION_UNIQUE_SETTINGS", Type.Integer, null, false, false, "Always returns MDDIMENSIONS_MEMBER_KEY_UNIQUE (1).");
        private static final Column DimensionIsVisible = new Column("DIMENSION_IS_VISIBLE", Type.Boolean, null, false, false, "Always returns true.");
        private static final Column HierarchyOrdinal = new Column("HIERARCHY_ORDINAL", Type.UnsignedInteger, null, false, false, "The ordinal number of the hierarchy across all hierarchies of the cube.");
        private static final Column DimensionIsShared = new Column("DIMENSION_IS_SHARED", Type.Boolean, null, false, false, "Always returns true.");
        private static final Column Levels = new Column("LEVELS", Type.Rowset, null, false, true, "Levels in this hierarchy.");
        private static final Column ParentChild = new Column("PARENT_CHILD", Type.Boolean, null, false, true, "Is hierarchy a parent.");

        MdschemaHierarchiesRowset(XmlaRequest request, XmlaHandler handler) {
            super(MDSCHEMA_HIERARCHIES, request, handler);
        }

        @Override
        public void populate(XmlaResponse response, List<Rowset.Row> rows) throws XmlaException {
            DataSourcesConfig.DataSource ds = this.handler.getDataSource(this.request);
            DataSourcesConfig.Catalog[] catalogs = this.handler.getCatalogs(this.request, ds);
            String roleName = this.request.getRoleName();
            Role role = this.request.getRole();
            for (DataSourcesConfig.Catalog dsCatalog : catalogs) {
                Connection connection;
                String catalogName;
                if (dsCatalog == null || dsCatalog.definition == null || !this.catalogRT.passes(catalogName = dsCatalog.name) || (connection = this.handler.getConnection(dsCatalog, role, roleName)) == null) continue;
                this.populateCatalog(connection, catalogName, rows);
            }
        }

        protected void populateCatalog(Connection connection, String catalogName, List<Rowset.Row> rows) throws XmlaException {
            Schema schema = connection.getSchema();
            if (!this.schemaNameRT.passes(schema.getName())) {
                return;
            }
            for (Cube cube : RowsetDefinition.sortedCubes(schema)) {
                if (!this.cubeNameRT.passes(cube.getName())) continue;
                SchemaReader schemaReader = cube.getSchemaReader(connection.getRole());
                this.populateCube(schemaReader, catalogName, cube, rows);
            }
        }

        protected void populateCube(SchemaReader schemaReader, String catalogName, Cube cube, List<Rowset.Row> rows) throws XmlaException {
            int ordinal = 0;
            for (Dimension dimension : cube.getDimensions()) {
                String unique = dimension.getUniqueName();
                boolean genOutput = this.dimensionUniqueNameRT.passes(unique);
                ordinal = this.populateDimension(genOutput, schemaReader, catalogName, cube, dimension, ordinal, rows);
            }
        }

        protected int populateDimension(boolean genOutput, SchemaReader schemaReader, String catalogName, Cube cube, Dimension dimension, int ordinal, List<Rowset.Row> rows) throws XmlaException {
            Hierarchy[] hierarchies;
            for (Hierarchy hierarchy : hierarchies = dimension.getHierarchies()) {
                if (genOutput) {
                    String unique = hierarchy.getUniqueName();
                    if (this.hierarchyNameRT.passes(hierarchy.getName()) && this.hierarchyUniqueNameRT.passes(unique)) {
                        this.populateHierarchy(schemaReader, catalogName, cube, dimension, (HierarchyBase)hierarchy, ordinal++, rows);
                        continue;
                    }
                    ++ordinal;
                    continue;
                }
                ++ordinal;
            }
            return ordinal;
        }

        protected void populateHierarchy(SchemaReader schemaReader, String catalogName, Cube cube, Dimension dimension, HierarchyBase hierarchy, int ordinal, List<Rowset.Row> rows) throws XmlaException {
            if (!RowsetDefinition.canAccess(schemaReader, hierarchy)) {
                return;
            }
            String desc = hierarchy.getDescription();
            if (desc == null) {
                desc = cube.getName() + " Cube - " + RowsetDefinition.getHierarchyName(hierarchy) + " Hierarchy";
            }
            Rowset.Row row = new Rowset.Row();
            row.set(MdschemaHierarchiesRowset.CatalogName.name, catalogName);
            row.set(MdschemaHierarchiesRowset.SchemaName.name, cube.getSchema().getName());
            row.set(MdschemaHierarchiesRowset.CubeName.name, cube.getName());
            row.set(MdschemaHierarchiesRowset.DimensionUniqueName.name, dimension.getUniqueName());
            row.set(MdschemaHierarchiesRowset.HierarchyName.name, hierarchy.getName());
            row.set(MdschemaHierarchiesRowset.HierarchyUniqueName.name, hierarchy.getUniqueName());
            row.set(MdschemaHierarchiesRowset.HierarchyCaption.name, hierarchy.getCaption());
            row.set(MdschemaHierarchiesRowset.DimensionType.name, RowsetDefinition.getDimensionType(dimension));
            int cardinality = RolapMemberBase.getHierarchyCardinality(schemaReader, hierarchy);
            row.set(MdschemaHierarchiesRowset.HierarchyCardinality.name, cardinality);
            row.set(MdschemaHierarchiesRowset.DefaultMember.name, hierarchy.getDefaultMember());
            if (hierarchy.hasAll()) {
                row.set(MdschemaHierarchiesRowset.AllMember.name, Util.makeFqName(hierarchy, hierarchy.getAllMemberName()));
            }
            row.set(MdschemaHierarchiesRowset.Description.name, desc);
            row.set(MdschemaHierarchiesRowset.Structure.name, hierarchy.isRagged() ? 1 : 0);
            row.set(MdschemaHierarchiesRowset.IsVirtual.name, false);
            row.set(MdschemaHierarchiesRowset.IsReadWrite.name, false);
            row.set(MdschemaHierarchiesRowset.DimensionUniqueSettings.name, 0);
            row.set(MdschemaHierarchiesRowset.DimensionIsVisible.name, true);
            row.set(MdschemaHierarchiesRowset.HierarchyOrdinal.name, ordinal);
            row.set(MdschemaHierarchiesRowset.DimensionIsShared.name, true);
            RolapLevel nonAllFirstLevel = (RolapLevel)hierarchy.getLevels()[hierarchy.hasAll() ? 1 : 0];
            row.set(MdschemaHierarchiesRowset.ParentChild.name, nonAllFirstLevel.isParentChild());
            if (this.deep) {
                row.set(MdschemaHierarchiesRowset.Levels.name, new MdschemaLevelsRowset(RowsetDefinition.wrapRequest(this.request, Olap4jUtil.mapOf((Object)MdschemaLevelsRowset.CatalogName, (Object)catalogName, (Object[])new Object[]{MdschemaLevelsRowset.SchemaName, cube.getSchema().getName(), MdschemaLevelsRowset.CubeName, cube.getName(), MdschemaLevelsRowset.DimensionUniqueName, dimension.getUniqueName(), MdschemaLevelsRowset.HierarchyUniqueName, hierarchy.getUniqueName()})), this.handler));
            }
            this.addRow(row, rows);
        }

        @Override
        protected void setProperty(PropertyDefinition propertyDef, String value) {
            switch (propertyDef) {
                case Content: {
                    break;
                }
                default: {
                    super.setProperty(propertyDef, value);
                }
            }
        }

        static /* synthetic */ Column access$14000() {
            return HierarchyName;
        }

        static /* synthetic */ Column access$14100() {
            return HierarchyUniqueName;
        }

        static /* synthetic */ Column access$14200() {
            return HierarchyGuid;
        }

        static /* synthetic */ Column access$14300() {
            return HierarchyCaption;
        }

        static /* synthetic */ Column access$14400() {
            return DimensionType;
        }

        static /* synthetic */ Column access$14500() {
            return HierarchyCardinality;
        }

        static /* synthetic */ Column access$14600() {
            return DefaultMember;
        }

        static /* synthetic */ Column access$14700() {
            return AllMember;
        }

        static /* synthetic */ Column access$14800() {
            return Description;
        }

        static /* synthetic */ Column access$14900() {
            return Structure;
        }

        static /* synthetic */ Column access$15000() {
            return IsVirtual;
        }

        static /* synthetic */ Column access$15100() {
            return IsReadWrite;
        }

        static /* synthetic */ Column access$15200() {
            return DimensionUniqueSettings;
        }

        static /* synthetic */ Column access$15300() {
            return DimensionIsVisible;
        }

        static /* synthetic */ Column access$15400() {
            return HierarchyOrdinal;
        }

        static /* synthetic */ Column access$15500() {
            return DimensionIsShared;
        }

        static /* synthetic */ Column access$15600() {
            return ParentChild;
        }

        static /* synthetic */ Column access$15700() {
            return Levels;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MdschemaFunctionsRowset
    extends Rowset {
        private final Rowset.RestrictionTest functionNameRT = this.getRestrictionTest(FunctionName);
        private static final Column FunctionName = new Column("FUNCTION_NAME", Type.String, null, true, false, "The name of the function.");
        private static final Column Description = new Column("DESCRIPTION", Type.String, null, false, true, "A description of the function.");
        private static final Column ParameterList = new Column("PARAMETER_LIST", Type.String, null, false, true, "A comma delimited list of parameters.");
        private static final Column ReturnType = new Column("RETURN_TYPE", Type.Integer, null, false, false, "The VARTYPE of the return data type of the function.");
        private static final Column Origin = new Column("ORIGIN", Type.Integer, null, true, false, "The origin of the function:  1 for MDX functions.  2 for user-defined functions.");
        private static final Column InterfaceName = new Column("INTERFACE_NAME", Type.String, null, true, false, "The name of the interface for user-defined functions");
        private static final Column LibraryName = new Column("LIBRARY_NAME", Type.String, null, true, true, "The name of the type library for user-defined functions. NULL for MDX functions.");
        private static final Column Caption = new Column("CAPTION", Type.String, null, false, true, "The display caption for the function.");

        MdschemaFunctionsRowset(XmlaRequest request, XmlaHandler handler) {
            super(MDSCHEMA_FUNCTIONS, request, handler);
        }

        @Override
        public void populate(XmlaResponse response, List<Rowset.Row> rows) throws XmlaException {
            DataSourcesConfig.DataSource ds = this.handler.getDataSource(this.request);
            DataSourcesConfig.Catalog[] catalogs = this.handler.getCatalogs(this.request, ds);
            String roleName = this.request.getRoleName();
            Role role = this.request.getRole();
            for (DataSourcesConfig.Catalog dsCatalog : catalogs) {
                Connection connection;
                if (dsCatalog == null || dsCatalog.definition == null || (connection = this.handler.getConnection(dsCatalog, role, roleName)) == null) continue;
                Schema schema = connection.getSchema();
                FunTable funTable = schema.getFunTable();
                StringBuilder buf = new StringBuilder(50);
                List<FunInfo> functions = funTable.getFunInfoList();
                block4: for (FunInfo fi : functions) {
                    switch (fi.getSyntax()) {
                        case Empty: 
                        case Internal: 
                        case Parentheses: {
                            continue block4;
                        }
                    }
                    if (!this.functionNameRT.passes(fi.getName())) continue;
                    int[][] paramCategories = fi.getParameterCategories();
                    int[] returnCategories = fi.getReturnCategories();
                    String description = fi.getDescription();
                    if (description != null) {
                        description = Util.replace(fi.getDescription(), "\r", "");
                    }
                    if (paramCategories == null || paramCategories.length == 0) {
                        Rowset.Row row = new Rowset.Row();
                        row.set(MdschemaFunctionsRowset.FunctionName.name, fi.getName());
                        row.set(MdschemaFunctionsRowset.Description.name, description);
                        row.set(MdschemaFunctionsRowset.ParameterList.name, "(none)");
                        row.set(MdschemaFunctionsRowset.ReturnType.name, 1);
                        row.set(MdschemaFunctionsRowset.Origin.name, 1);
                        row.set(MdschemaFunctionsRowset.InterfaceName.name, "");
                        row.set(MdschemaFunctionsRowset.Caption.name, fi.getName());
                        this.addRow(row, rows);
                        continue;
                    }
                    for (int i = 0; i < paramCategories.length; ++i) {
                        int[] pc = paramCategories[i];
                        int returnCategory = returnCategories[i];
                        Rowset.Row row = new Rowset.Row();
                        row.set(MdschemaFunctionsRowset.FunctionName.name, fi.getName());
                        row.set(MdschemaFunctionsRowset.Description.name, description);
                        buf.setLength(0);
                        for (int j = 0; j < pc.length; ++j) {
                            int v = pc[j];
                            if (j > 0) {
                                buf.append(", ");
                            }
                            buf.append(Category.instance.getDescription(v & 0x1F));
                        }
                        row.set(MdschemaFunctionsRowset.ParameterList.name, buf.toString());
                        VarType varType = VarType.forCategory(returnCategory);
                        row.set(MdschemaFunctionsRowset.ReturnType.name, varType.ordinal());
                        row.set(MdschemaFunctionsRowset.Origin.name, 1);
                        row.set(MdschemaFunctionsRowset.InterfaceName.name, "");
                        row.set(MdschemaFunctionsRowset.Caption.name, fi.getName());
                        this.addRow(row, rows);
                    }
                }
            }
        }

        @Override
        protected void setProperty(PropertyDefinition propertyDef, String value) {
            switch (propertyDef) {
                case Content: {
                    break;
                }
                default: {
                    super.setProperty(propertyDef, value);
                }
            }
        }

        static /* synthetic */ Column access$12800() {
            return FunctionName;
        }

        static /* synthetic */ Column access$12900() {
            return Description;
        }

        static /* synthetic */ Column access$13000() {
            return ParameterList;
        }

        static /* synthetic */ Column access$13100() {
            return ReturnType;
        }

        static /* synthetic */ Column access$13200() {
            return Origin;
        }

        static /* synthetic */ Column access$13300() {
            return InterfaceName;
        }

        static /* synthetic */ Column access$13400() {
            return LibraryName;
        }

        static /* synthetic */ Column access$13500() {
            return Caption;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static enum VarType {
            Empty("Uninitialized (default)"),
            Null("Contains no valid data"),
            Integer("Integer subtype"),
            Long("Long subtype"),
            Single("Single subtype"),
            Double("Double subtype"),
            Currency("Currency subtype"),
            Date("Date subtype"),
            String("String subtype"),
            Object("Object subtype"),
            Error("Error subtype"),
            Boolean("Boolean subtype"),
            Variant("Variant subtype"),
            DataObject("DataObject subtype"),
            Decimal("Decimal subtype"),
            Byte("Byte subtype"),
            Array("Array subtype");


            static VarType forCategory(int category) {
                switch (category) {
                    case 0: {
                        return Empty;
                    }
                    case 1: {
                        return Array;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 6: 
                    case 8: 
                    case 10: 
                    case 12: 
                    case 13: {
                        return Variant;
                    }
                    case 5: {
                        return Boolean;
                    }
                    case 7: {
                        return Double;
                    }
                    case 9: 
                    case 11: 
                    case 64: {
                        return String;
                    }
                    case 18: {
                        return Date;
                    }
                    case 15: 
                    case 31: {
                        return Integer;
                    }
                }
                return Empty;
            }

            private VarType(String description) {
                Util.discard((Object)description);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MdschemaDimensionsRowset
    extends Rowset {
        private final Rowset.RestrictionTest catalogRT = this.getRestrictionTest(CatalogName);
        private final Rowset.RestrictionTest schemaNameRT = this.getRestrictionTest(SchemaName);
        private final Rowset.RestrictionTest cubeNameRT = this.getRestrictionTest(CubeName);
        private final Rowset.RestrictionTest dimensionUniqueNameRT = this.getRestrictionTest(DimensionUniqueName);
        private final Rowset.RestrictionTest dimensionNameRT = this.getRestrictionTest(DimensionName);
        public static final int MD_DIMTYPE_OTHER = 3;
        public static final int MD_DIMTYPE_MEASURE = 2;
        public static final int MD_DIMTYPE_TIME = 1;
        private static final Column CatalogName = new Column("CATALOG_NAME", Type.String, null, true, true, "The name of the database.");
        private static final Column SchemaName = new Column("SCHEMA_NAME", Type.String, null, true, true, "Not supported.");
        private static final Column CubeName = new Column("CUBE_NAME", Type.String, null, true, false, "The name of the cube.");
        private static final Column DimensionName = new Column("DIMENSION_NAME", Type.String, null, true, false, "The name of the dimension.");
        private static final Column DimensionUniqueName = new Column("DIMENSION_UNIQUE_NAME", Type.String, null, true, false, "The unique name of the dimension.");
        private static final Column DimensionGuid = new Column("DIMENSION_GUID", Type.UUID, null, false, true, "Not supported.");
        private static final Column DimensionCaption = new Column("DIMENSION_CAPTION", Type.String, null, false, false, "The caption of the dimension.");
        private static final Column DimensionOrdinal = new Column("DIMENSION_ORDINAL", Type.UnsignedInteger, null, false, false, "The position of the dimension within the cube.");
        private static final Column DimensionType = new Column("DIMENSION_TYPE", Type.Short, null, false, false, "The type of the dimension.");
        private static final Column DimensionCardinality = new Column("DIMENSION_CARDINALITY", Type.UnsignedInteger, null, false, false, "The number of members in the key attribute.");
        private static final Column DefaultHierarchy = new Column("DEFAULT_HIERARCHY", Type.String, null, false, false, "A hierarchy from the dimension. Preserved for backwards compatibility.");
        private static final Column Description = new Column("DESCRIPTION", Type.String, null, false, true, "A user-friendly description of the dimension.");
        private static final Column IsVirtual = new Column("IS_VIRTUAL", Type.Boolean, null, false, true, "Always FALSE.");
        private static final Column IsReadWrite = new Column("IS_READWRITE", Type.Boolean, null, false, true, "A Boolean that indicates whether the dimension is write-enabled.");
        private static final Column DimensionUniqueSettings = new Column("DIMENSION_UNIQUE_SETTINGS", Type.Integer, null, false, true, "A bitmap that specifies which columns contain unique values if the dimension contains only members with unique names.");
        private static final Column DimensionMasterUniqueName = new Column("DIMENSION_MASTER_UNIQUE_NAME", Type.String, null, false, true, "Always NULL.");
        private static final Column DimensionIsVisible = new Column("DIMENSION_IS_VISIBLE", Type.Boolean, null, false, true, "Always TRUE.");
        private static final Column Hierarchies = new Column("HIERARCHIES", Type.Rowset, null, false, true, "Hierarchies in this dimension.");

        MdschemaDimensionsRowset(XmlaRequest request, XmlaHandler handler) {
            super(MDSCHEMA_DIMENSIONS, request, handler);
        }

        @Override
        public void populate(XmlaResponse response, List<Rowset.Row> rows) throws XmlaException {
            DataSourcesConfig.DataSource ds = this.handler.getDataSource(this.request);
            DataSourcesConfig.Catalog[] catalogs = this.handler.getCatalogs(this.request, ds);
            String roleName = this.request.getRoleName();
            Role role = this.request.getRole();
            for (DataSourcesConfig.Catalog dsCatalog : catalogs) {
                Connection connection;
                String catalogName;
                if (dsCatalog == null || dsCatalog.definition == null || !this.catalogRT.passes(catalogName = dsCatalog.name) || (connection = this.handler.getConnection(dsCatalog, role, roleName)) == null) continue;
                this.populateCatalog(connection, catalogName, rows);
            }
        }

        protected void populateCatalog(Connection connection, String catalogName, List<Rowset.Row> rows) throws XmlaException {
            Schema schema = connection.getSchema();
            if (!this.schemaNameRT.passes(schema.getName())) {
                return;
            }
            for (Cube cube : RowsetDefinition.sortedCubes(schema)) {
                if (!this.cubeNameRT.passes(cube.getName())) continue;
                SchemaReader schemaReader = cube.getSchemaReader(connection.getRole());
                this.populateCube(schemaReader, catalogName, cube, rows);
            }
        }

        protected void populateCube(SchemaReader schemaReader, String catalogName, Cube cube, List<Rowset.Row> rows) throws XmlaException {
            for (Dimension dimension : cube.getDimensions()) {
                String name = dimension.getName();
                String unique = dimension.getUniqueName();
                if (!this.dimensionNameRT.passes(name) || !this.dimensionUniqueNameRT.passes(unique)) continue;
                this.populateDimension(schemaReader, catalogName, cube, dimension, rows);
            }
        }

        protected void populateDimension(SchemaReader schemaReader, String catalogName, Cube cube, Dimension dimension, List<Rowset.Row> rows) throws XmlaException {
            if (!RowsetDefinition.canAccess(schemaReader, dimension)) {
                return;
            }
            String desc = dimension.getDescription();
            if (desc == null) {
                desc = cube.getName() + " Cube - " + dimension.getName() + " Dimension";
            }
            Rowset.Row row = new Rowset.Row();
            row.set(MdschemaDimensionsRowset.CatalogName.name, catalogName);
            row.set(MdschemaDimensionsRowset.SchemaName.name, cube.getSchema().getName());
            row.set(MdschemaDimensionsRowset.CubeName.name, cube.getName());
            row.set(MdschemaDimensionsRowset.DimensionName.name, dimension.getName());
            row.set(MdschemaDimensionsRowset.DimensionUniqueName.name, dimension.getUniqueName());
            row.set(MdschemaDimensionsRowset.DimensionCaption.name, dimension.getCaption());
            row.set(MdschemaDimensionsRowset.DimensionOrdinal.name, MdschemaDimensionsRowset.getDimensionOrdinal(cube, dimension));
            row.set(MdschemaDimensionsRowset.DimensionType.name, RowsetDefinition.getDimensionType(dimension));
            Hierarchy firstHierarchy = dimension.getHierarchies()[0];
            Level[] levels = firstHierarchy.getLevels();
            Level lastLevel = levels[levels.length - 1];
            int n = schemaReader.getLevelCardinality(lastLevel, true, true);
            row.set(MdschemaDimensionsRowset.DimensionCardinality.name, n + 1);
            row.set(MdschemaDimensionsRowset.DefaultHierarchy.name, dimension.getUniqueName());
            row.set(MdschemaDimensionsRowset.Description.name, desc);
            row.set(MdschemaDimensionsRowset.IsVirtual.name, false);
            row.set(MdschemaDimensionsRowset.IsReadWrite.name, false);
            row.set(MdschemaDimensionsRowset.DimensionUniqueSettings.name, 0);
            row.set(MdschemaDimensionsRowset.DimensionIsVisible.name, true);
            if (this.deep) {
                row.set(MdschemaDimensionsRowset.Hierarchies.name, new MdschemaHierarchiesRowset(RowsetDefinition.wrapRequest(this.request, Olap4jUtil.mapOf((Object)MdschemaHierarchiesRowset.CatalogName, (Object)catalogName, (Object[])new Object[]{MdschemaHierarchiesRowset.SchemaName, cube.getSchema().getName(), MdschemaHierarchiesRowset.CubeName, cube.getName(), MdschemaHierarchiesRowset.DimensionUniqueName, dimension.getUniqueName()})), this.handler));
            }
            this.addRow(row, rows);
        }

        private static int getDimensionOrdinal(Cube cube, Dimension dimension) {
            return Arrays.asList(cube.getDimensions()).indexOf(dimension);
        }

        @Override
        protected void setProperty(PropertyDefinition propertyDef, String value) {
            switch (propertyDef) {
                case Content: {
                    break;
                }
                default: {
                    super.setProperty(propertyDef, value);
                }
            }
        }

        static /* synthetic */ Column access$11300() {
            return DimensionName;
        }

        static /* synthetic */ Column access$11400() {
            return DimensionUniqueName;
        }

        static /* synthetic */ Column access$11500() {
            return DimensionGuid;
        }

        static /* synthetic */ Column access$11600() {
            return DimensionCaption;
        }

        static /* synthetic */ Column access$11700() {
            return DimensionOrdinal;
        }

        static /* synthetic */ Column access$11800() {
            return DimensionType;
        }

        static /* synthetic */ Column access$11900() {
            return DimensionCardinality;
        }

        static /* synthetic */ Column access$12000() {
            return DefaultHierarchy;
        }

        static /* synthetic */ Column access$12100() {
            return Description;
        }

        static /* synthetic */ Column access$12200() {
            return IsVirtual;
        }

        static /* synthetic */ Column access$12300() {
            return IsReadWrite;
        }

        static /* synthetic */ Column access$12400() {
            return DimensionUniqueSettings;
        }

        static /* synthetic */ Column access$12500() {
            return DimensionMasterUniqueName;
        }

        static /* synthetic */ Column access$12600() {
            return DimensionIsVisible;
        }

        static /* synthetic */ Column access$12700() {
            return Hierarchies;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MdschemaCubesRowset
    extends Rowset {
        private final Rowset.RestrictionTest catalogNameRT = this.getRestrictionTest(CatalogName);
        private final Rowset.RestrictionTest schemaNameRT = this.getRestrictionTest(SchemaName);
        private final Rowset.RestrictionTest cubeNameRT = this.getRestrictionTest(CubeName);
        private static final String MD_CUBTYPE_CUBE = "CUBE";
        private static final String MD_CUBTYPE_VIRTUAL_CUBE = "VIRTUAL CUBE";
        private static final Column CatalogName = new Column("CATALOG_NAME", Type.String, null, true, true, "The name of the catalog to which this cube belongs.");
        private static final Column SchemaName = new Column("SCHEMA_NAME", Type.String, null, true, true, "The name of the schema to which this cube belongs.");
        private static final Column CubeName = new Column("CUBE_NAME", Type.String, null, true, false, "Name of the cube.");
        private static final Column CubeType = new Column("CUBE_TYPE", Type.String, null, true, false, "Cube type.");
        private static final Column CubeGuid = new Column("CUBE_GUID", Type.UUID, null, false, true, "Cube type.");
        private static final Column CreatedOn = new Column("CREATED_ON", Type.DateTime, null, false, true, "Date and time of cube creation.");
        private static final Column LastSchemaUpdate = new Column("LAST_SCHEMA_UPDATE", Type.DateTime, null, false, true, "Date and time of last schema update.");
        private static final Column SchemaUpdatedBy = new Column("SCHEMA_UPDATED_BY", Type.String, null, false, true, "User ID of the person who last updated the schema.");
        private static final Column LastDataUpdate = new Column("LAST_DATA_UPDATE", Type.DateTime, null, false, true, "Date and time of last data update.");
        private static final Column DataUpdatedBy = new Column("DATA_UPDATED_BY", Type.String, null, false, true, "User ID of the person who last updated the data.");
        private static final Column IsDrillthroughEnabled = new Column("IS_DRILLTHROUGH_ENABLED", Type.Boolean, null, false, false, "Describes whether DRILLTHROUGH can be performed on the members of a cube");
        private static final Column IsWriteEnabled = new Column("IS_WRITE_ENABLED", Type.Boolean, null, false, false, "Describes whether a cube is write-enabled");
        private static final Column IsLinkable = new Column("IS_LINKABLE", Type.Boolean, null, false, false, "Describes whether a cube can be used in a linked cube");
        private static final Column IsSqlEnabled = new Column("IS_SQL_ENABLED", Type.Boolean, null, false, false, "Describes whether or not SQL can be used on the cube");
        private static final Column Description = new Column("DESCRIPTION", Type.String, null, false, true, "A user-friendly description of the dimension.");
        private static final Column Dimensions = new Column("DIMENSIONS", Type.Rowset, null, false, true, "Dimensions in this cube.");
        private static final Column Sets = new Column("SETS", Type.Rowset, null, false, true, "Sets in this cube.");
        private static final Column Measures = new Column("MEASURES", Type.Rowset, null, false, true, "Measures in this cube.");

        MdschemaCubesRowset(XmlaRequest request, XmlaHandler handler) {
            super(MDSCHEMA_CUBES, request, handler);
        }

        @Override
        public void populate(XmlaResponse response, List<Rowset.Row> rows) throws XmlaException {
            DataSourcesConfig.DataSource ds = this.handler.getDataSource(this.request);
            DataSourcesConfig.Catalog[] catalogs = this.handler.getCatalogs(this.request, ds);
            String roleName = this.request.getRoleName();
            Role role = this.request.getRole();
            for (DataSourcesConfig.Catalog dsCatalog : catalogs) {
                Schema schema;
                String catalogName;
                Connection connection;
                if (dsCatalog == null || dsCatalog.definition == null || (connection = this.handler.getConnection(dsCatalog, role, roleName)) == null || !this.catalogNameRT.passes(catalogName = dsCatalog.name) || !this.schemaNameRT.passes((schema = connection.getSchema()).getName())) continue;
                for (Cube cube : RowsetDefinition.sortedCubes(schema)) {
                    if (!RowsetDefinition.canAccess(schema.getSchemaReader(), cube) || !this.cubeNameRT.passes(cube.getName())) continue;
                    String desc = cube.getDescription();
                    if (desc == null) {
                        desc = catalogName + " Schema - " + cube.getName() + " Cube";
                    }
                    Rowset.Row row = new Rowset.Row();
                    row.set(MdschemaCubesRowset.CatalogName.name, catalogName);
                    row.set(MdschemaCubesRowset.SchemaName.name, schema.getName());
                    row.set(MdschemaCubesRowset.CubeName.name, cube.getName());
                    row.set(MdschemaCubesRowset.CubeType.name, ((RolapCube)cube).isVirtual() ? MD_CUBTYPE_VIRTUAL_CUBE : MD_CUBTYPE_CUBE);
                    row.set(MdschemaCubesRowset.IsDrillthroughEnabled.name, true);
                    row.set(MdschemaCubesRowset.IsWriteEnabled.name, false);
                    row.set(MdschemaCubesRowset.IsLinkable.name, false);
                    row.set(MdschemaCubesRowset.IsSqlEnabled.name, false);
                    row.set(MdschemaCubesRowset.Description.name, desc);
                    SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
                    String formattedDate = formatter.format((Object)schema.getSchemaLoadDate());
                    row.set(MdschemaCubesRowset.LastSchemaUpdate.name, formattedDate);
                    if (this.deep) {
                        row.set(MdschemaCubesRowset.Dimensions.name, new MdschemaDimensionsRowset(RowsetDefinition.wrapRequest(this.request, Olap4jUtil.mapOf((Object)MdschemaDimensionsRowset.CatalogName, (Object)catalogName, (Object[])new Object[]{MdschemaDimensionsRowset.SchemaName, schema.getName(), MdschemaDimensionsRowset.CubeName, cube.getName()})), this.handler));
                        row.set(MdschemaCubesRowset.Sets.name, new MdschemaSetsRowset(RowsetDefinition.wrapRequest(this.request, Olap4jUtil.mapOf((Object)MdschemaSetsRowset.CatalogName, (Object)catalogName, (Object[])new Object[]{MdschemaSetsRowset.SchemaName, schema.getName(), MdschemaSetsRowset.CubeName, cube.getName()})), this.handler));
                        row.set(MdschemaCubesRowset.Measures.name, new MdschemaMeasuresRowset(RowsetDefinition.wrapRequest(this.request, Olap4jUtil.mapOf((Object)MdschemaMeasuresRowset.CatalogName, (Object)catalogName, (Object[])new Object[]{MdschemaMeasuresRowset.SchemaName, schema.getName(), MdschemaMeasuresRowset.CubeName, cube.getName()})), this.handler));
                    }
                    this.addRow(row, rows);
                }
            }
        }

        @Override
        protected void setProperty(PropertyDefinition propertyDef, String value) {
            switch (propertyDef) {
                case Content: {
                    break;
                }
                default: {
                    super.setProperty(propertyDef, value);
                }
            }
        }

        static /* synthetic */ Column access$9200() {
            return CatalogName;
        }

        static /* synthetic */ Column access$9300() {
            return SchemaName;
        }

        static /* synthetic */ Column access$9400() {
            return CubeName;
        }

        static /* synthetic */ Column access$9500() {
            return CubeType;
        }

        static /* synthetic */ Column access$9600() {
            return CubeGuid;
        }

        static /* synthetic */ Column access$9700() {
            return CreatedOn;
        }

        static /* synthetic */ Column access$9800() {
            return LastSchemaUpdate;
        }

        static /* synthetic */ Column access$9900() {
            return SchemaUpdatedBy;
        }

        static /* synthetic */ Column access$10000() {
            return LastDataUpdate;
        }

        static /* synthetic */ Column access$10100() {
            return DataUpdatedBy;
        }

        static /* synthetic */ Column access$10200() {
            return IsDrillthroughEnabled;
        }

        static /* synthetic */ Column access$10300() {
            return IsWriteEnabled;
        }

        static /* synthetic */ Column access$10400() {
            return IsLinkable;
        }

        static /* synthetic */ Column access$10500() {
            return IsSqlEnabled;
        }

        static /* synthetic */ Column access$10600() {
            return Description;
        }

        static /* synthetic */ Column access$10700() {
            return Dimensions;
        }

        static /* synthetic */ Column access$10800() {
            return Sets;
        }

        static /* synthetic */ Column access$10900() {
            return Measures;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MdschemaActionsRowset
    extends Rowset {
        private static final Column CatalogName = new Column("CATALOG_NAME", Type.String, null, true, true, "The name of the catalog to which this action belongs.");
        private static final Column SchemaName = new Column("SCHEMA_NAME", Type.String, null, true, true, "The name of the schema to which this action belongs.");
        private static final Column CubeName = new Column("CUBE_NAME", Type.String, null, true, false, "The name of the cube to which this action belongs.");
        private static final Column ActionName = new Column("ACTION_NAME", Type.String, null, true, false, "The name of the action.");
        private static final Column Coordinate = new Column("COORDINATE", Type.String, null, true, false, null);
        private static final Column CoordinateType = new Column("COORDINATE_TYPE", Type.Integer, null, true, false, null);

        MdschemaActionsRowset(XmlaRequest request, XmlaHandler handler) {
            super(MDSCHEMA_ACTIONS, request, handler);
        }

        @Override
        public void populate(XmlaResponse response, List<Rowset.Row> rows) throws XmlaException {
        }

        static /* synthetic */ Column access$8600() {
            return CatalogName;
        }

        static /* synthetic */ Column access$8700() {
            return SchemaName;
        }

        static /* synthetic */ Column access$8800() {
            return CubeName;
        }

        static /* synthetic */ Column access$8900() {
            return ActionName;
        }

        static /* synthetic */ Column access$9000() {
            return Coordinate;
        }

        static /* synthetic */ Column access$9100() {
            return CoordinateType;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DbschemaTablesInfoRowset
    extends Rowset {
        private static final Column TableCatalog = new Column("TABLE_CATALOG", Type.String, null, true, true, "Catalog name. NULL if the provider does not support catalogs.");
        private static final Column TableSchema = new Column("TABLE_SCHEMA", Type.String, null, true, true, "Unqualified schema name. NULL if the provider does not support schemas.");
        private static final Column TableName = new Column("TABLE_NAME", Type.String, null, true, false, "Table name.");
        private static final Column TableType = new Column("TABLE_TYPE", Type.String, null, true, false, "Table type. One of the following or a provider-specific value: ALIAS, TABLE, SYNONYM, SYSTEM TABLE, VIEW, GLOBAL TEMPORARY, LOCAL TEMPORARY, EXTERNAL TABLE, SYSTEM VIEW");
        private static final Column TableGuid = new Column("TABLE_GUID", Type.UUID, null, false, true, "GUID that uniquely identifies the table. Providers that do not use GUIDs to identify tables should return NULL in this column.");
        private static final Column Bookmarks = new Column("BOOKMARKS", Type.Boolean, null, false, false, "Whether this table supports bookmarks. Allways is false.");
        private static final Column BookmarkType = new Column("BOOKMARK_TYPE", Type.Integer, null, false, true, "Default bookmark type supported on this table.");
        private static final Column BookmarkDataType = new Column("BOOKMARK_DATATYPE", Type.UnsignedShort, null, false, true, "The indicator of the bookmark's native data type.");
        private static final Column BookmarkMaximumLength = new Column("BOOKMARK_MAXIMUM_LENGTH", Type.UnsignedInteger, null, false, true, "Maximum length of the bookmark in bytes.");
        private static final Column BookmarkInformation = new Column("BOOKMARK_INFORMATION", Type.UnsignedInteger, null, false, true, "A bitmask specifying additional information about bookmarks over the rowset. ");
        private static final Column TableVersion = new Column("TABLE_VERSION", Type.Long, null, false, true, "Version number for this table or NULL if the provider does not support returning table version information.");
        private static final Column Cardinality = new Column("CARDINALITY", Type.UnsignedLong, null, false, false, "Cardinality (number of rows) of the table.");
        private static final Column Description = new Column("DESCRIPTION", Type.String, null, false, true, "Human-readable description of the table.");
        private static final Column TablePropId = new Column("TABLE_PROPID", Type.UnsignedInteger, null, false, true, "Property ID of the table. Return null.");

        DbschemaTablesInfoRowset(XmlaRequest request, XmlaHandler handler) {
            super(DBSCHEMA_TABLES_INFO, request, handler);
        }

        @Override
        public void populate(XmlaResponse response, List<Rowset.Row> rows) throws XmlaException {
            DataSourcesConfig.DataSource ds = this.handler.getDataSource(this.request);
            DataSourcesConfig.Catalog[] catalogs = this.handler.getCatalogs(this.request, ds);
            String roleName = this.request.getRoleName();
            Role role = this.request.getRole();
            for (DataSourcesConfig.Catalog dsCatalog : catalogs) {
                Connection connection;
                if (dsCatalog == null || dsCatalog.definition == null || (connection = this.handler.getConnection(dsCatalog, role, roleName)) == null) continue;
                Schema schema = connection.getSchema();
                String catalogName = dsCatalog.name;
                for (Cube cube1 : RowsetDefinition.sortedCubes(schema)) {
                    RolapCube cube = (RolapCube)cube1;
                    String cubeName = cube.getName();
                    String desc = cube.getDescription();
                    if (desc == null) {
                        desc = catalogName + " - " + cubeName + " Cube";
                    }
                    int cardinality = 1000000;
                    String version = "null";
                    Rowset.Row row = new Rowset.Row();
                    row.set(DbschemaTablesInfoRowset.TableCatalog.name, catalogName);
                    row.set(DbschemaTablesInfoRowset.TableName.name, cubeName);
                    row.set(DbschemaTablesInfoRowset.TableType.name, "TABLE");
                    row.set(DbschemaTablesInfoRowset.Bookmarks.name, false);
                    row.set(DbschemaTablesInfoRowset.TableVersion.name, version);
                    row.set(DbschemaTablesInfoRowset.Cardinality.name, cardinality);
                    row.set(DbschemaTablesInfoRowset.Description.name, desc);
                    this.addRow(row, rows);
                }
            }
        }

        @Override
        protected void setProperty(PropertyDefinition propertyDef, String value) {
            switch (propertyDef) {
                case Content: {
                    break;
                }
                default: {
                    super.setProperty(propertyDef, value);
                }
            }
        }

        static /* synthetic */ Column access$7200() {
            return TableCatalog;
        }

        static /* synthetic */ Column access$7300() {
            return TableSchema;
        }

        static /* synthetic */ Column access$7400() {
            return TableName;
        }

        static /* synthetic */ Column access$7500() {
            return TableType;
        }

        static /* synthetic */ Column access$7600() {
            return TableGuid;
        }

        static /* synthetic */ Column access$7700() {
            return Bookmarks;
        }

        static /* synthetic */ Column access$7800() {
            return BookmarkType;
        }

        static /* synthetic */ Column access$7900() {
            return BookmarkDataType;
        }

        static /* synthetic */ Column access$8000() {
            return BookmarkMaximumLength;
        }

        static /* synthetic */ Column access$8100() {
            return BookmarkInformation;
        }

        static /* synthetic */ Column access$8200() {
            return TableVersion;
        }

        static /* synthetic */ Column access$8300() {
            return Cardinality;
        }

        static /* synthetic */ Column access$8400() {
            return Description;
        }

        static /* synthetic */ Column access$8500() {
            return TablePropId;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DbschemaTablesRowset
    extends Rowset {
        private final Rowset.RestrictionTest tableCatalogRT = this.getRestrictionTest(TableCatalog);
        private final Rowset.RestrictionTest tableNameRT = this.getRestrictionTest(TableName);
        private final Rowset.RestrictionTest tableTypeRT = this.getRestrictionTest(TableType);
        private static final Column TableCatalog = new Column("TABLE_CATALOG", Type.String, null, true, false, "The name of the catalog to which this object belongs.");
        private static final Column TableSchema = new Column("TABLE_SCHEMA", Type.String, null, true, true, "The name of the cube to which this object belongs.");
        private static final Column TableName = new Column("TABLE_NAME", Type.String, null, true, false, "The name of the object, if TABLE_TYPE is TABLE.");
        private static final Column TableType = new Column("TABLE_TYPE", Type.String, null, true, false, "The type of the table. TABLE indicates the object is a measure group. SYSTEM TABLE indicates the object is a dimension.");
        private static final Column TableGuid = new Column("TABLE_GUID", Type.UUID, null, false, true, "Not supported.");
        private static final Column Description = new Column("DESCRIPTION", Type.String, null, false, true, "A human-readable description of the object.");
        private static final Column TablePropId = new Column("TABLE_PROPID", Type.UnsignedInteger, null, false, true, "Not supported.");
        private static final Column DateCreated = new Column("DATE_CREATED", Type.DateTime, null, false, true, "Not supported.");
        private static final Column DateModified = new Column("DATE_MODIFIED", Type.DateTime, null, false, true, "The date the object was last modified.");

        DbschemaTablesRowset(XmlaRequest request, XmlaHandler handler) {
            super(DBSCHEMA_TABLES, request, handler);
        }

        @Override
        public void populate(XmlaResponse response, List<Rowset.Row> rows) throws XmlaException {
            DataSourcesConfig.DataSource ds = this.handler.getDataSource(this.request);
            DataSourcesConfig.Catalog[] catalogs = this.handler.getCatalogs(this.request, ds);
            String roleName = this.request.getRoleName();
            Role role = this.request.getRole();
            for (DataSourcesConfig.Catalog dsCatalog : catalogs) {
                Connection connection;
                if (dsCatalog == null || dsCatalog.definition == null || (connection = this.handler.getConnection(dsCatalog, role, roleName)) == null) continue;
                Schema schema = connection.getSchema();
                String catalogName = dsCatalog.name;
                if (!this.tableCatalogRT.passes(catalogName)) continue;
                for (Cube cube1 : RowsetDefinition.sortedCubes(schema)) {
                    RolapCube cube = (RolapCube)cube1;
                    String cubeName = cube.getName();
                    if (!this.tableNameRT.passes(cubeName)) continue;
                    SchemaReader schemaReader = cube.getSchemaReader(connection.getRole());
                    String desc = cube.getDescription();
                    if (desc == null) {
                        desc = catalogName + " - " + cubeName + " Cube";
                    }
                    if (this.tableTypeRT.passes("TABLE")) {
                        Rowset.Row row = new Rowset.Row();
                        row.set(DbschemaTablesRowset.TableCatalog.name, catalogName);
                        row.set(DbschemaTablesRowset.TableName.name, cubeName);
                        row.set(DbschemaTablesRowset.TableType.name, "TABLE");
                        row.set(DbschemaTablesRowset.Description.name, desc);
                        this.addRow(row, rows);
                    }
                    if (!this.tableTypeRT.passes("SYSTEM TABLE")) continue;
                    for (Dimension dimension : cube.getDimensions()) {
                        Hierarchy[] hierarchies;
                        if (dimension.isMeasures()) continue;
                        for (Hierarchy hierarchy1 : hierarchies = dimension.getHierarchies()) {
                            HierarchyBase hierarchy = (HierarchyBase)hierarchy1;
                            this.populateHierarchy(schemaReader, cube, hierarchy, rows);
                        }
                    }
                }
            }
        }

        private void populateHierarchy(SchemaReader schemaReader, RolapCube cube, HierarchyBase hierarchy, List<Rowset.Row> rows) {
            Level[] levels;
            if (!RowsetDefinition.canAccess(schemaReader, hierarchy)) {
                return;
            }
            for (Level level : levels = hierarchy.getLevels()) {
                this.populateLevel(cube, hierarchy, level, rows);
            }
        }

        private void populateLevel(RolapCube cube, HierarchyBase hierarchy, Level level, List<Rowset.Row> rows) {
            String schemaName = cube.getSchema().getName();
            String cubeName = cube.getName();
            String hierarchyName = RowsetDefinition.getHierarchyName(hierarchy);
            String levelName = level.getName();
            String tableName = cubeName + ':' + hierarchyName + ':' + levelName;
            String desc = level.getDescription();
            if (desc == null) {
                desc = schemaName + " - " + cubeName + " Cube - " + hierarchyName + " Hierarchy - " + levelName + " Level";
            }
            Rowset.Row row = new Rowset.Row();
            row.set(DbschemaTablesRowset.TableCatalog.name, schemaName);
            row.set(DbschemaTablesRowset.TableName.name, tableName);
            row.set(DbschemaTablesRowset.TableType.name, "SYSTEM TABLE");
            row.set(DbschemaTablesRowset.Description.name, desc);
            this.addRow(row, rows);
        }

        @Override
        protected void setProperty(PropertyDefinition propertyDef, String value) {
            switch (propertyDef) {
                case Content: {
                    break;
                }
                default: {
                    super.setProperty(propertyDef, value);
                }
            }
        }

        static /* synthetic */ Column access$6300() {
            return TableCatalog;
        }

        static /* synthetic */ Column access$6400() {
            return TableSchema;
        }

        static /* synthetic */ Column access$6500() {
            return TableName;
        }

        static /* synthetic */ Column access$6600() {
            return TableType;
        }

        static /* synthetic */ Column access$6700() {
            return TableGuid;
        }

        static /* synthetic */ Column access$6800() {
            return Description;
        }

        static /* synthetic */ Column access$6900() {
            return TablePropId;
        }

        static /* synthetic */ Column access$7000() {
            return DateCreated;
        }

        static /* synthetic */ Column access$7100() {
            return DateModified;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DbschemaSchemataRowset
    extends Rowset {
        private final Rowset.RestrictionTest catalogNameRT = this.getRestrictionTest(CatalogName);
        private static final Column CatalogName = new Column("CATALOG_NAME", Type.String, null, true, false, "The provider-specific data type name.");
        private static final Column SchemaName = new Column("SCHEMA_NAME", Type.String, null, true, false, "The indicator of the data type.");
        private static final Column SchemaOwner = new Column("SCHEMA_OWNER", Type.String, null, true, false, "The length of a non-numeric column. If the data type is numeric, this is the upper bound on the maximum precision of the data type.");

        DbschemaSchemataRowset(XmlaRequest request, XmlaHandler handler) {
            super(DBSCHEMA_SCHEMATA, request, handler);
        }

        @Override
        public void populate(XmlaResponse response, List<Rowset.Row> rows) throws XmlaException {
            DataSourcesConfig.DataSource ds = this.handler.getDataSource(this.request);
            DataSourcesConfig.Catalog[] catalogs = ds.catalogs.catalogs;
            String roleName = this.request.getRoleName();
            Role role = this.request.getRole();
            for (DataSourcesConfig.Catalog dsCatalog : catalogs) {
                Connection connection;
                if (dsCatalog == null || dsCatalog.definition == null || (connection = this.handler.getConnection(dsCatalog, role, roleName)) == null || !this.catalogNameRT.passes(dsCatalog.name)) continue;
                Schema schema = connection.getSchema();
                Rowset.Row row = new Rowset.Row();
                row.set(DbschemaSchemataRowset.CatalogName.name, dsCatalog.name);
                row.set(DbschemaSchemataRowset.SchemaName.name, schema.getName());
                row.set(DbschemaSchemataRowset.SchemaOwner.name, "");
                this.addRow(row, rows);
            }
        }

        @Override
        protected void setProperty(PropertyDefinition propertyDef, String value) {
            switch (propertyDef) {
                case Content: {
                    break;
                }
                default: {
                    super.setProperty(propertyDef, value);
                }
            }
        }

        static /* synthetic */ Column access$6000() {
            return CatalogName;
        }

        static /* synthetic */ Column access$6100() {
            return SchemaName;
        }

        static /* synthetic */ Column access$6200() {
            return SchemaOwner;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DbschemaProviderTypesRowset
    extends Rowset {
        private final Rowset.RestrictionTest dataTypeRT = this.getRestrictionTest(DataType);
        private static final Column TypeName = new Column("TYPE_NAME", Type.String, null, false, false, "The provider-specific data type name.");
        private static final Column DataType = new Column("DATA_TYPE", Type.UnsignedShort, null, true, false, "The indicator of the data type.");
        private static final Column ColumnSize = new Column("COLUMN_SIZE", Type.UnsignedInteger, null, false, false, "The length of a non-numeric column. If the data type is numeric, this is the upper bound on the maximum precision of the data type.");
        private static final Column LiteralPrefix = new Column("LITERAL_PREFIX", Type.String, null, false, true, "The character or characters used to prefix a literal of this type in a text command.");
        private static final Column LiteralSuffix = new Column("LITERAL_SUFFIX", Type.String, null, false, true, "The character or characters used to suffix a literal of this type in a text command.");
        private static final Column IsNullable = new Column("IS_NULLABLE", Type.Boolean, null, false, true, "A Boolean that indicates whether the data type is nullable. NULL-- indicates that it is not known whether the data type is nullable.");
        private static final Column CaseSensitive = new Column("CASE_SENSITIVE", Type.Boolean, null, false, true, "A Boolean that indicates whether the data type is a characters type and case-sensitive.");
        private static final Column Searchable = new Column("SEARCHABLE", Type.UnsignedInteger, null, false, true, "An integer indicating how the data type can be used in searches if the provider supports ICommandText; otherwise, NULL.");
        private static final Column UnsignedAttribute = new Column("UNSIGNED_ATTRIBUTE", Type.Boolean, null, false, true, "A Boolean that indicates whether the data type is unsigned.");
        private static final Column FixedPrecScale = new Column("FIXED_PREC_SCALE", Type.Boolean, null, false, true, "A Boolean that indicates whether the data type has a fixed precision and scale.");
        private static final Column AutoUniqueValue = new Column("AUTO_UNIQUE_VALUE", Type.Boolean, null, false, true, "A Boolean that indicates whether the data type is autoincrementing.");
        private static final Column IsLong = new Column("IS_LONG", Type.Boolean, null, false, true, "A Boolean that indicates whether the data type is a binary large object (BLOB) and has very long data.");
        private static final Column BestMatch = new Column("BEST_MATCH", Type.Boolean, null, true, true, "A Boolean that indicates whether the data type is a best match.");

        DbschemaProviderTypesRowset(XmlaRequest request, XmlaHandler handler) {
            super(DBSCHEMA_PROVIDER_TYPES, request, handler);
        }

        @Override
        public void populate(XmlaResponse response, List<Rowset.Row> rows) throws XmlaException {
            Rowset.Row row;
            Integer dt = XmlaConstants.DBType.I4.xmlaOrdinal();
            if (this.dataTypeRT.passes(dt)) {
                row = new Rowset.Row();
                row.set(DbschemaProviderTypesRowset.TypeName.name, XmlaConstants.DBType.I4.userName);
                row.set(DbschemaProviderTypesRowset.DataType.name, dt);
                row.set(DbschemaProviderTypesRowset.ColumnSize.name, 8);
                row.set(DbschemaProviderTypesRowset.IsNullable.name, true);
                row.set(DbschemaProviderTypesRowset.Searchable.name, null);
                row.set(DbschemaProviderTypesRowset.UnsignedAttribute.name, false);
                row.set(DbschemaProviderTypesRowset.FixedPrecScale.name, false);
                row.set(DbschemaProviderTypesRowset.AutoUniqueValue.name, false);
                row.set(DbschemaProviderTypesRowset.IsLong.name, false);
                row.set(DbschemaProviderTypesRowset.BestMatch.name, true);
                this.addRow(row, rows);
            }
            if (this.dataTypeRT.passes(dt = Integer.valueOf(XmlaConstants.DBType.R8.xmlaOrdinal()))) {
                row = new Rowset.Row();
                row.set(DbschemaProviderTypesRowset.TypeName.name, XmlaConstants.DBType.R8.userName);
                row.set(DbschemaProviderTypesRowset.DataType.name, dt);
                row.set(DbschemaProviderTypesRowset.ColumnSize.name, 16);
                row.set(DbschemaProviderTypesRowset.IsNullable.name, true);
                row.set(DbschemaProviderTypesRowset.Searchable.name, null);
                row.set(DbschemaProviderTypesRowset.UnsignedAttribute.name, false);
                row.set(DbschemaProviderTypesRowset.FixedPrecScale.name, false);
                row.set(DbschemaProviderTypesRowset.AutoUniqueValue.name, false);
                row.set(DbschemaProviderTypesRowset.IsLong.name, false);
                row.set(DbschemaProviderTypesRowset.BestMatch.name, true);
                this.addRow(row, rows);
            }
            if (this.dataTypeRT.passes(dt = Integer.valueOf(XmlaConstants.DBType.CY.xmlaOrdinal()))) {
                row = new Rowset.Row();
                row.set(DbschemaProviderTypesRowset.TypeName.name, XmlaConstants.DBType.CY.userName);
                row.set(DbschemaProviderTypesRowset.DataType.name, dt);
                row.set(DbschemaProviderTypesRowset.ColumnSize.name, 8);
                row.set(DbschemaProviderTypesRowset.IsNullable.name, true);
                row.set(DbschemaProviderTypesRowset.Searchable.name, null);
                row.set(DbschemaProviderTypesRowset.UnsignedAttribute.name, false);
                row.set(DbschemaProviderTypesRowset.FixedPrecScale.name, false);
                row.set(DbschemaProviderTypesRowset.AutoUniqueValue.name, false);
                row.set(DbschemaProviderTypesRowset.IsLong.name, false);
                row.set(DbschemaProviderTypesRowset.BestMatch.name, true);
                this.addRow(row, rows);
            }
            if (this.dataTypeRT.passes(dt = Integer.valueOf(XmlaConstants.DBType.BOOL.xmlaOrdinal()))) {
                row = new Rowset.Row();
                row.set(DbschemaProviderTypesRowset.TypeName.name, XmlaConstants.DBType.BOOL.userName);
                row.set(DbschemaProviderTypesRowset.DataType.name, dt);
                row.set(DbschemaProviderTypesRowset.ColumnSize.name, 1);
                row.set(DbschemaProviderTypesRowset.IsNullable.name, true);
                row.set(DbschemaProviderTypesRowset.Searchable.name, null);
                row.set(DbschemaProviderTypesRowset.UnsignedAttribute.name, false);
                row.set(DbschemaProviderTypesRowset.FixedPrecScale.name, false);
                row.set(DbschemaProviderTypesRowset.AutoUniqueValue.name, false);
                row.set(DbschemaProviderTypesRowset.IsLong.name, false);
                row.set(DbschemaProviderTypesRowset.BestMatch.name, true);
                this.addRow(row, rows);
            }
            if (this.dataTypeRT.passes(dt = Integer.valueOf(XmlaConstants.DBType.I8.xmlaOrdinal()))) {
                row = new Rowset.Row();
                row.set(DbschemaProviderTypesRowset.TypeName.name, XmlaConstants.DBType.I8.userName);
                row.set(DbschemaProviderTypesRowset.DataType.name, dt);
                row.set(DbschemaProviderTypesRowset.ColumnSize.name, 16);
                row.set(DbschemaProviderTypesRowset.IsNullable.name, true);
                row.set(DbschemaProviderTypesRowset.Searchable.name, null);
                row.set(DbschemaProviderTypesRowset.UnsignedAttribute.name, false);
                row.set(DbschemaProviderTypesRowset.FixedPrecScale.name, false);
                row.set(DbschemaProviderTypesRowset.AutoUniqueValue.name, false);
                row.set(DbschemaProviderTypesRowset.IsLong.name, false);
                row.set(DbschemaProviderTypesRowset.BestMatch.name, true);
                this.addRow(row, rows);
            }
            if (this.dataTypeRT.passes(dt = Integer.valueOf(XmlaConstants.DBType.WSTR.xmlaOrdinal()))) {
                row = new Rowset.Row();
                row.set(DbschemaProviderTypesRowset.TypeName.name, XmlaConstants.DBType.WSTR.userName);
                row.set(DbschemaProviderTypesRowset.DataType.name, dt);
                row.set(DbschemaProviderTypesRowset.ColumnSize.name, 255);
                row.set(DbschemaProviderTypesRowset.LiteralPrefix.name, "\"");
                row.set(DbschemaProviderTypesRowset.LiteralSuffix.name, "\"");
                row.set(DbschemaProviderTypesRowset.IsNullable.name, true);
                row.set(DbschemaProviderTypesRowset.CaseSensitive.name, false);
                row.set(DbschemaProviderTypesRowset.Searchable.name, null);
                row.set(DbschemaProviderTypesRowset.FixedPrecScale.name, false);
                row.set(DbschemaProviderTypesRowset.AutoUniqueValue.name, false);
                row.set(DbschemaProviderTypesRowset.IsLong.name, false);
                row.set(DbschemaProviderTypesRowset.BestMatch.name, true);
                this.addRow(row, rows);
            }
        }

        @Override
        protected void setProperty(PropertyDefinition propertyDef, String value) {
            switch (propertyDef) {
                case Content: {
                    break;
                }
                default: {
                    super.setProperty(propertyDef, value);
                }
            }
        }

        static /* synthetic */ Column access$4700() {
            return TypeName;
        }

        static /* synthetic */ Column access$4800() {
            return DataType;
        }

        static /* synthetic */ Column access$4900() {
            return ColumnSize;
        }

        static /* synthetic */ Column access$5000() {
            return LiteralPrefix;
        }

        static /* synthetic */ Column access$5100() {
            return LiteralSuffix;
        }

        static /* synthetic */ Column access$5200() {
            return IsNullable;
        }

        static /* synthetic */ Column access$5300() {
            return CaseSensitive;
        }

        static /* synthetic */ Column access$5400() {
            return Searchable;
        }

        static /* synthetic */ Column access$5500() {
            return UnsignedAttribute;
        }

        static /* synthetic */ Column access$5600() {
            return FixedPrecScale;
        }

        static /* synthetic */ Column access$5700() {
            return AutoUniqueValue;
        }

        static /* synthetic */ Column access$5800() {
            return IsLong;
        }

        static /* synthetic */ Column access$5900() {
            return BestMatch;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DbschemaColumnsRowset
    extends Rowset {
        private final Rowset.RestrictionTest tableCatalogRT = this.getRestrictionTest(TableCatalog);
        private final Rowset.RestrictionTest tableNameRT = this.getRestrictionTest(TableName);
        private final Rowset.RestrictionTest columnNameRT = this.getRestrictionTest(ColumnName);
        private static final Column TableCatalog = new Column("TABLE_CATALOG", Type.String, null, true, false, "The name of the Database.");
        private static final Column TableSchema = new Column("TABLE_SCHEMA", Type.String, null, true, true, null);
        private static final Column TableName = new Column("TABLE_NAME", Type.String, null, true, false, "The name of the cube.");
        private static final Column ColumnName = new Column("COLUMN_NAME", Type.String, null, true, false, "The name of the attribute hierarchy or measure.");
        private static final Column OrdinalPosition = new Column("ORDINAL_POSITION", Type.UnsignedInteger, null, false, false, "The position of the column, beginning with 1.");
        private static final Column ColumnHasDefault = new Column("COLUMN_HAS_DEFAULT", Type.Boolean, null, false, true, "Not supported.");
        private static final Column ColumnFlags = new Column("COLUMN_FLAGS", Type.UnsignedInteger, null, false, false, "A DBCOLUMNFLAGS bitmask indicating column properties.");
        private static final Column IsNullable = new Column("IS_NULLABLE", Type.Boolean, null, false, false, "Always returns false.");
        private static final Column DataType = new Column("DATA_TYPE", Type.UnsignedShort, null, false, false, "The data type of the column. Returns a string for dimension columns and a variant for measures.");
        private static final Column CharacterMaximumLength = new Column("CHARACTER_MAXIMUM_LENGTH", Type.UnsignedInteger, null, false, true, "The maximum possible length of a value within the column.");
        private static final Column CharacterOctetLength = new Column("CHARACTER_OCTET_LENGTH", Type.UnsignedInteger, null, false, true, "The maximum possible length of a value within the column, in bytes, for character or binary columns.");
        private static final Column NumericPrecision = new Column("NUMERIC_PRECISION", Type.UnsignedShort, null, false, true, "The maximum precision of the column for numeric data types other than DBTYPE_VARNUMERIC.");
        private static final Column NumericScale = new Column("NUMERIC_SCALE", Type.Short, null, false, true, "The number of digits to the right of the decimal point for DBTYPE_DECIMAL, DBTYPE_NUMERIC, DBTYPE_VARNUMERIC. Otherwise, this is NULL.");

        DbschemaColumnsRowset(XmlaRequest request, XmlaHandler handler) {
            super(DBSCHEMA_COLUMNS, request, handler);
        }

        @Override
        public void populate(XmlaResponse response, List<Rowset.Row> rows) throws XmlaException {
            DataSourcesConfig.DataSource ds = this.handler.getDataSource(this.request);
            DataSourcesConfig.Catalog[] catalogs = ds.catalogs.catalogs;
            String roleName = this.request.getRoleName();
            Role role = this.request.getRole();
            for (DataSourcesConfig.Catalog dsCatalog : catalogs) {
                Connection connection;
                if (dsCatalog == null || dsCatalog.definition == null || (connection = this.handler.getConnection(dsCatalog, role, roleName)) == null) continue;
                Schema schema = connection.getSchema();
                String catalogName = dsCatalog.name;
                if (!this.tableCatalogRT.passes(catalogName)) continue;
                boolean emitInvisibleMembers = XmlaUtil.shouldEmitInvisibleMembers(this.request);
                int ordinalPosition = 1;
                for (Cube cube1 : RowsetDefinition.sortedCubes(schema)) {
                    RolapCube cube = (RolapCube)cube1;
                    SchemaReader schemaReader = cube.getSchemaReader(connection.getRole());
                    String cubeName = cube.getName();
                    if (!this.tableNameRT.passes(cubeName)) continue;
                    for (Dimension dimension : cube.getDimensions()) {
                        Hierarchy[] hierarchies;
                        for (Hierarchy hierarchy : hierarchies = dimension.getHierarchies()) {
                            ordinalPosition = this.populateHierarchy(schemaReader, cube, (HierarchyBase)hierarchy, ordinalPosition, rows);
                        }
                    }
                    List<RolapMember> rms = cube.getMeasuresMembers();
                    for (int k = 1; k < rms.size(); ++k) {
                        RolapMember member = rms.get(k);
                        Boolean visible = (Boolean)member.getPropertyValue(Property.VISIBLE.name);
                        if (visible == null) {
                            visible = true;
                        }
                        if (!emitInvisibleMembers && !visible.booleanValue()) continue;
                        String memberName = member.getName();
                        if (!this.columnNameRT.passes("Measures:" + memberName)) continue;
                        Rowset.Row row = new Rowset.Row();
                        row.set(DbschemaColumnsRowset.TableCatalog.name, catalogName);
                        row.set(DbschemaColumnsRowset.TableName.name, cubeName);
                        row.set(DbschemaColumnsRowset.ColumnName.name, "Measures:" + memberName);
                        row.set(DbschemaColumnsRowset.OrdinalPosition.name, ordinalPosition++);
                        row.set(DbschemaColumnsRowset.ColumnHasDefault.name, false);
                        row.set(DbschemaColumnsRowset.ColumnFlags.name, 0);
                        row.set(DbschemaColumnsRowset.IsNullable.name, false);
                        row.set(DbschemaColumnsRowset.DataType.name, XmlaConstants.DBType.R8.xmlaOrdinal());
                        row.set(DbschemaColumnsRowset.NumericPrecision.name, 16);
                        row.set(DbschemaColumnsRowset.NumericScale.name, 255);
                        this.addRow(row, rows);
                    }
                }
            }
        }

        private int populateHierarchy(SchemaReader schemaReader, RolapCube cube, HierarchyBase hierarchy, int ordinalPosition, List<Rowset.Row> rows) {
            if (!RowsetDefinition.canAccess(schemaReader, hierarchy)) {
                return ordinalPosition;
            }
            String schemaName = cube.getSchema().getName();
            String cubeName = cube.getName();
            String hierarchyName = hierarchy.getName();
            if (hierarchy.hasAll()) {
                Rowset.Row row = new Rowset.Row();
                row.set(DbschemaColumnsRowset.TableCatalog.name, schemaName);
                row.set(DbschemaColumnsRowset.TableName.name, cubeName);
                row.set(DbschemaColumnsRowset.ColumnName.name, hierarchyName + ":(All)!NAME");
                row.set(DbschemaColumnsRowset.OrdinalPosition.name, ordinalPosition++);
                row.set(DbschemaColumnsRowset.ColumnHasDefault.name, false);
                row.set(DbschemaColumnsRowset.ColumnFlags.name, 0);
                row.set(DbschemaColumnsRowset.IsNullable.name, false);
                row.set(DbschemaColumnsRowset.DataType.name, XmlaConstants.DBType.WSTR.xmlaOrdinal());
                row.set(DbschemaColumnsRowset.CharacterMaximumLength.name, 0);
                row.set(DbschemaColumnsRowset.CharacterOctetLength.name, 0);
                this.addRow(row, rows);
                row = new Rowset.Row();
                row.set(DbschemaColumnsRowset.TableCatalog.name, schemaName);
                row.set(DbschemaColumnsRowset.TableName.name, cubeName);
                row.set(DbschemaColumnsRowset.ColumnName.name, hierarchyName + ":(All)!UNIQUE_NAME");
                row.set(DbschemaColumnsRowset.OrdinalPosition.name, ordinalPosition++);
                row.set(DbschemaColumnsRowset.ColumnHasDefault.name, false);
                row.set(DbschemaColumnsRowset.ColumnFlags.name, 0);
                row.set(DbschemaColumnsRowset.IsNullable.name, false);
                row.set(DbschemaColumnsRowset.DataType.name, XmlaConstants.DBType.WSTR.xmlaOrdinal());
                row.set(DbschemaColumnsRowset.CharacterMaximumLength.name, 0);
                row.set(DbschemaColumnsRowset.CharacterOctetLength.name, 0);
                this.addRow(row, rows);
            }
            for (Level level : schemaReader.getHierarchyLevels(hierarchy)) {
                ordinalPosition = this.populateLevel(cube, hierarchy, level, ordinalPosition, rows);
            }
            return ordinalPosition;
        }

        private int populateLevel(Cube cube, HierarchyBase hierarchy, Level level, int ordinalPosition, List<Rowset.Row> rows) {
            Property[] props;
            String schemaName = cube.getSchema().getName();
            String cubeName = cube.getName();
            String hierarchyName = hierarchy.getName();
            String levelName = level.getName();
            Rowset.Row row = new Rowset.Row();
            row.set(DbschemaColumnsRowset.TableCatalog.name, schemaName);
            row.set(DbschemaColumnsRowset.TableName.name, cubeName);
            row.set(DbschemaColumnsRowset.ColumnName.name, hierarchyName + ':' + levelName + "!NAME");
            row.set(DbschemaColumnsRowset.OrdinalPosition.name, ordinalPosition++);
            row.set(DbschemaColumnsRowset.ColumnHasDefault.name, false);
            row.set(DbschemaColumnsRowset.ColumnFlags.name, 0);
            row.set(DbschemaColumnsRowset.IsNullable.name, false);
            row.set(DbschemaColumnsRowset.DataType.name, XmlaConstants.DBType.WSTR.xmlaOrdinal());
            row.set(DbschemaColumnsRowset.CharacterMaximumLength.name, 0);
            row.set(DbschemaColumnsRowset.CharacterOctetLength.name, 0);
            this.addRow(row, rows);
            row = new Rowset.Row();
            row.set(DbschemaColumnsRowset.TableCatalog.name, schemaName);
            row.set(DbschemaColumnsRowset.TableName.name, cubeName);
            row.set(DbschemaColumnsRowset.ColumnName.name, hierarchyName + ':' + levelName + "!UNIQUE_NAME");
            row.set(DbschemaColumnsRowset.OrdinalPosition.name, ordinalPosition++);
            row.set(DbschemaColumnsRowset.ColumnHasDefault.name, false);
            row.set(DbschemaColumnsRowset.ColumnFlags.name, 0);
            row.set(DbschemaColumnsRowset.IsNullable.name, false);
            row.set(DbschemaColumnsRowset.DataType.name, XmlaConstants.DBType.WSTR.xmlaOrdinal());
            row.set(DbschemaColumnsRowset.CharacterMaximumLength.name, 0);
            row.set(DbschemaColumnsRowset.CharacterOctetLength.name, 0);
            this.addRow(row, rows);
            for (Property prop : props = level.getProperties()) {
                String propName = prop.getName();
                row = new Rowset.Row();
                row.set(DbschemaColumnsRowset.TableCatalog.name, schemaName);
                row.set(DbschemaColumnsRowset.TableName.name, cubeName);
                row.set(DbschemaColumnsRowset.ColumnName.name, hierarchyName + ':' + levelName + '!' + propName);
                row.set(DbschemaColumnsRowset.OrdinalPosition.name, ordinalPosition++);
                row.set(DbschemaColumnsRowset.ColumnHasDefault.name, false);
                row.set(DbschemaColumnsRowset.ColumnFlags.name, 0);
                row.set(DbschemaColumnsRowset.IsNullable.name, false);
                XmlaConstants.DBType dbType = RowsetDefinition.getDBTypeFromProperty(prop);
                row.set(DbschemaColumnsRowset.DataType.name, dbType.xmlaOrdinal());
                switch (prop.getType()) {
                    case TYPE_STRING: {
                        row.set(DbschemaColumnsRowset.CharacterMaximumLength.name, 0);
                        row.set(DbschemaColumnsRowset.CharacterOctetLength.name, 0);
                        break;
                    }
                    case TYPE_NUMERIC: {
                        row.set(DbschemaColumnsRowset.NumericPrecision.name, 16);
                        row.set(DbschemaColumnsRowset.NumericScale.name, 255);
                        break;
                    }
                    case TYPE_BOOLEAN: {
                        row.set(DbschemaColumnsRowset.NumericPrecision.name, 255);
                        row.set(DbschemaColumnsRowset.NumericScale.name, 255);
                        break;
                    }
                    case TYPE_OTHER: {
                        row.set(DbschemaColumnsRowset.CharacterMaximumLength.name, 0);
                        row.set(DbschemaColumnsRowset.CharacterOctetLength.name, 0);
                    }
                }
                this.addRow(row, rows);
            }
            return ordinalPosition;
        }

        @Override
        protected void setProperty(PropertyDefinition propertyDef, String value) {
            switch (propertyDef) {
                case Content: {
                    break;
                }
                default: {
                    super.setProperty(propertyDef, value);
                }
            }
        }

        static /* synthetic */ Column access$3400() {
            return TableCatalog;
        }

        static /* synthetic */ Column access$3500() {
            return TableSchema;
        }

        static /* synthetic */ Column access$3600() {
            return TableName;
        }

        static /* synthetic */ Column access$3700() {
            return ColumnName;
        }

        static /* synthetic */ Column access$3800() {
            return OrdinalPosition;
        }

        static /* synthetic */ Column access$3900() {
            return ColumnHasDefault;
        }

        static /* synthetic */ Column access$4000() {
            return ColumnFlags;
        }

        static /* synthetic */ Column access$4100() {
            return IsNullable;
        }

        static /* synthetic */ Column access$4200() {
            return DataType;
        }

        static /* synthetic */ Column access$4300() {
            return CharacterMaximumLength;
        }

        static /* synthetic */ Column access$4400() {
            return CharacterOctetLength;
        }

        static /* synthetic */ Column access$4500() {
            return NumericPrecision;
        }

        static /* synthetic */ Column access$4600() {
            return NumericScale;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DbschemaCatalogsRowset
    extends Rowset {
        private final Rowset.RestrictionTest catalogNameRT = this.getRestrictionTest(CatalogName);
        private static final Column CatalogName = new Column("CATALOG_NAME", Type.String, null, true, false, "Catalog name. Cannot be NULL.");
        private static final Column Description = new Column("DESCRIPTION", Type.String, null, false, false, "Human-readable description of the catalog.");
        private static final Column Roles = new Column("ROLES", Type.String, null, false, false, "A comma delimited list of roles to which the current user belongs. An asterisk (*) is included as a role if the current user is a server or database administrator. Username is appended to ROLES if one of the roles uses dynamic security.");
        private static final Column DateModified = new Column("DATE_MODIFIED", Type.DateTime, null, false, true, "The date that the catalog was last modified.");

        DbschemaCatalogsRowset(XmlaRequest request, XmlaHandler handler) {
            super(DBSCHEMA_CATALOGS, request, handler);
        }

        @Override
        public void populate(XmlaResponse response, List<Rowset.Row> rows) throws XmlaException {
            DataSourcesConfig.DataSource ds = this.handler.getDataSource(this.request);
            DataSourcesConfig.Catalog[] catalogs = ds.catalogs.catalogs;
            String roleName = this.request.getRoleName();
            Role role = this.request.getRole();
            for (DataSourcesConfig.Catalog dsCatalog : catalogs) {
                Connection connection;
                if (dsCatalog == null || dsCatalog.definition == null || (connection = this.handler.getConnection(dsCatalog, role, roleName)) == null || !this.catalogNameRT.passes(dsCatalog.name)) continue;
                Schema schema = connection.getSchema();
                Rowset.Row row = new Rowset.Row();
                row.set(DbschemaCatalogsRowset.CatalogName.name, dsCatalog.name);
                row.set(DbschemaCatalogsRowset.Description.name, "No description available");
                StringBuilder buf = new StringBuilder(100);
                RowsetDefinition.serialize(buf, ((RolapSchema)schema).roleNames());
                row.set(DbschemaCatalogsRowset.Roles.name, buf.toString());
                this.addRow(row, rows);
            }
        }

        @Override
        protected void setProperty(PropertyDefinition propertyDef, String value) {
            switch (propertyDef) {
                case Content: {
                    break;
                }
                default: {
                    super.setProperty(propertyDef, value);
                }
            }
        }

        static /* synthetic */ Column access$3000() {
            return CatalogName;
        }

        static /* synthetic */ Column access$3100() {
            return Description;
        }

        static /* synthetic */ Column access$3200() {
            return Roles;
        }

        static /* synthetic */ Column access$3300() {
            return DateModified;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DiscoverLiteralsRowset
    extends Rowset {
        private static final Column LiteralName = new Column("LiteralName", Type.StringSometimesArray, null, true, false, "The name of the literal described in the row.\nExample: DBLITERAL_LIKE_PERCENT");
        private static final Column LiteralValue = new Column("LiteralValue", Type.String, null, false, true, "Contains the actual literal value.\nExample, if LiteralName is DBLITERAL_LIKE_PERCENT and the percent character (%) is used to match zero or more characters in a LIKE clause, this column's value would be \"%\".");
        private static final Column LiteralInvalidChars = new Column("LiteralInvalidChars", Type.String, null, false, true, "The characters, in the literal, that are not valid.\nFor example, if table names can contain anything other than a numeric character, this string would be \"0123456789\".");
        private static final Column LiteralInvalidStartingChars = new Column("LiteralInvalidStartingChars", Type.String, null, false, true, "The characters that are not valid as the first character of the literal. If the literal can start with any valid character, this is null.");
        private static final Column LiteralMaxLength = new Column("LiteralMaxLength", Type.Integer, null, false, true, "The maximum number of characters in the literal. If there is no maximum or the maximum is unknown, the value is ?1.");

        DiscoverLiteralsRowset(XmlaRequest request, XmlaHandler handler) {
            super(DISCOVER_LITERALS, request, handler);
        }

        @Override
        public void populate(XmlaResponse response, List<Rowset.Row> rows) throws XmlaException {
            this.populate(XmlaConstants.Literal.class, rows, new Comparator<XmlaConstants.Literal>(){

                @Override
                public int compare(XmlaConstants.Literal o1, XmlaConstants.Literal o2) {
                    return o1.name().compareTo(o2.name());
                }
            });
        }

        @Override
        protected void setProperty(PropertyDefinition propertyDef, String value) {
            switch (propertyDef) {
                case Content: {
                    break;
                }
                default: {
                    super.setProperty(propertyDef, value);
                }
            }
        }

        static /* synthetic */ Column access$2500() {
            return LiteralName;
        }

        static /* synthetic */ Column access$2600() {
            return LiteralValue;
        }

        static /* synthetic */ Column access$2700() {
            return LiteralInvalidChars;
        }

        static /* synthetic */ Column access$2800() {
            return LiteralInvalidStartingChars;
        }

        static /* synthetic */ Column access$2900() {
            return LiteralMaxLength;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DiscoverKeywordsRowset
    extends Rowset {
        private static final Column Keyword = new Column("Keyword", Type.StringSometimesArray, null, true, false, "A list of all the keywords reserved by a provider.\nExample: AND");

        DiscoverKeywordsRowset(XmlaRequest request, XmlaHandler handler) {
            super(DISCOVER_KEYWORDS, request, handler);
        }

        @Override
        public void populate(XmlaResponse response, List<Rowset.Row> rows) throws XmlaException {
            MondrianServer mondrianServer = MondrianServer.forConnection(null);
            for (String keyword : mondrianServer.getKeywords()) {
                Rowset.Row row = new Rowset.Row();
                row.set(DiscoverKeywordsRowset.Keyword.name, keyword);
                this.addRow(row, rows);
            }
        }

        @Override
        protected void setProperty(PropertyDefinition propertyDef, String value) {
            switch (propertyDef) {
                case Content: {
                    break;
                }
                default: {
                    super.setProperty(propertyDef, value);
                }
            }
        }

        static /* synthetic */ Column access$2400() {
            return Keyword;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DiscoverEnumeratorsRowset
    extends Rowset {
        private static final Column EnumName = new Column("EnumName", Type.StringArray, null, true, false, "The name of the enumerator that contains a set of values.");
        private static final Column EnumDescription = new Column("EnumDescription", Type.String, null, false, true, "A localizable description of the enumerator.");
        private static final Column EnumType = new Column("EnumType", Type.String, null, false, false, "The data type of the Enum values.");
        private static final Column ElementName = new Column("ElementName", Type.String, null, false, false, "The name of one of the value elements in the enumerator set.\nExample: TDP");
        private static final Column ElementDescription = new Column("ElementDescription", Type.String, null, false, true, "A localizable description of the element (optional).");
        private static final Column ElementValue = new Column("ElementValue", Type.String, null, false, true, "The value of the element.\nExample: 01");

        DiscoverEnumeratorsRowset(XmlaRequest request, XmlaHandler handler) {
            super(DISCOVER_ENUMERATORS, request, handler);
        }

        @Override
        public void populate(XmlaResponse response, List<Rowset.Row> rows) throws XmlaException {
            List<Enumeration> enumerators = DiscoverEnumeratorsRowset.getEnumerators();
            for (Enumeration enumerator : enumerators) {
                List<? extends Enum> values = enumerator.getValues();
                for (Enum enum_ : values) {
                    String description;
                    Rowset.Row row = new Rowset.Row();
                    row.set(DiscoverEnumeratorsRowset.EnumName.name, enumerator.name);
                    row.set(DiscoverEnumeratorsRowset.EnumDescription.name, enumerator.description);
                    row.set(DiscoverEnumeratorsRowset.EnumType.name, "string");
                    String name = enum_ instanceof XmlaConstant ? ((XmlaConstant)enum_).xmlaName() : enum_.name();
                    row.set(DiscoverEnumeratorsRowset.ElementName.name, name);
                    String string = enum_ instanceof XmlaConstant ? ((XmlaConstant)enum_).getDescription() : (description = enum_ instanceof XmlaConstants.EnumWithDesc ? ((XmlaConstants.EnumWithDesc)enum_).getDescription() : null);
                    if (description != null) {
                        row.set(DiscoverEnumeratorsRowset.ElementDescription.name, description);
                    }
                    switch (enumerator.type) {
                        case String: 
                        case StringArray: {
                            break;
                        }
                        default: {
                            int ordinal = enum_ instanceof XmlaConstant && ((XmlaConstant)enum_).xmlaOrdinal() != -1 ? ((XmlaConstant)enum_).xmlaOrdinal() : enum_.ordinal();
                            row.set(DiscoverEnumeratorsRowset.ElementValue.name, ordinal);
                        }
                    }
                    this.addRow(row, rows);
                }
            }
        }

        private static List<Enumeration> getEnumerators() {
            TreeSet<Enumeration> enumeratorSet = new TreeSet<Enumeration>(new Comparator<Enumeration>(){

                @Override
                public int compare(Enumeration o1, Enumeration o2) {
                    return o1.name.compareTo(o2.name);
                }
            });
            for (RowsetDefinition rowsetDefinition : (RowsetDefinition[])RowsetDefinition.class.getEnumConstants()) {
                for (Column column : rowsetDefinition.columnDefinitions) {
                    if (column.enumeration == null) continue;
                    enumeratorSet.add(column.enumeration);
                }
            }
            return new ArrayList<Enumeration>(enumeratorSet);
        }

        @Override
        protected void setProperty(PropertyDefinition propertyDef, String value) {
            switch (propertyDef) {
                case Content: {
                    break;
                }
                default: {
                    super.setProperty(propertyDef, value);
                }
            }
        }

        static /* synthetic */ Column access$1200() {
            return EnumName;
        }

        static /* synthetic */ Column access$1300() {
            return EnumDescription;
        }

        static /* synthetic */ Column access$1400() {
            return EnumType;
        }

        static /* synthetic */ Column access$1500() {
            return ElementName;
        }

        static /* synthetic */ Column access$1600() {
            return ElementDescription;
        }

        static /* synthetic */ Column access$1700() {
            return ElementValue;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DiscoverPropertiesRowset
    extends Rowset {
        private final Rowset.RestrictionTest propertyNameRT = this.getRestrictionTest(PropertyName);
        private static final Column PropertyName = new Column("PropertyName", Type.StringSometimesArray, null, true, false, "The name of the property.");
        private static final Column PropertyDescription = new Column("PropertyDescription", Type.String, null, false, false, "A localizable text description of the property.");
        private static final Column PropertyType = new Column("PropertyType", Type.String, null, false, false, "The XML data type of the property.");
        private static final Column PropertyAccessType = new Column("PropertyAccessType", Type.EnumString, Enumeration.ACCESS, false, false, "Access for the property. The value can be Read, Write, or ReadWrite.");
        private static final Column IsRequired = new Column("IsRequired", Type.Boolean, null, false, false, "True if a property is required, false if it is not required.");
        private static final Column Value = new Column("Value", Type.String, null, false, false, "The current value of the property.");

        DiscoverPropertiesRowset(XmlaRequest request, XmlaHandler handler) {
            super(DISCOVER_PROPERTIES, request, handler);
        }

        @Override
        public void populate(XmlaResponse response, List<Rowset.Row> rows) throws XmlaException {
            for (PropertyDefinition propertyDefinition : (PropertyDefinition[])PropertyDefinition.class.getEnumConstants()) {
                if (!this.propertyNameRT.passes(propertyDefinition.name())) continue;
                Rowset.Row row = new Rowset.Row();
                row.set(DiscoverPropertiesRowset.PropertyName.name, propertyDefinition.name());
                row.set(DiscoverPropertiesRowset.PropertyDescription.name, propertyDefinition.description);
                row.set(DiscoverPropertiesRowset.PropertyType.name, propertyDefinition.type.getName());
                row.set(DiscoverPropertiesRowset.PropertyAccessType.name, propertyDefinition.access);
                row.set(DiscoverPropertiesRowset.IsRequired.name, false);
                row.set(DiscoverPropertiesRowset.Value.name, propertyDefinition.value);
                this.addRow(row, rows);
            }
        }

        @Override
        protected void setProperty(PropertyDefinition propertyDef, String value) {
            switch (propertyDef) {
                case Content: {
                    break;
                }
                default: {
                    super.setProperty(propertyDef, value);
                }
            }
        }

        static /* synthetic */ Column access$1800() {
            return PropertyName;
        }

        static /* synthetic */ Column access$1900() {
            return PropertyDescription;
        }

        static /* synthetic */ Column access$2000() {
            return PropertyType;
        }

        static /* synthetic */ Column access$2100() {
            return PropertyAccessType;
        }

        static /* synthetic */ Column access$2200() {
            return IsRequired;
        }

        static /* synthetic */ Column access$2300() {
            return Value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DiscoverSchemaRowsetsRowset
    extends Rowset {
        private static final Column SchemaName = new Column("SchemaName", Type.StringArray, null, true, false, "The name of the schema/request. This returns the values in the RequestTypes enumeration, plus any additional types supported by the provider. The provider defines rowset structures for the additional types");
        private static final Column SchemaGuid = new Column("SchemaGuid", Type.UUID, null, false, true, "The GUID of the schema.");
        private static final Column Restrictions = new Column("Restrictions", Type.Array, null, false, false, "An array of the restrictions suppoted by provider. An example follows this table.");
        private static final Column Description = new Column("Description", Type.String, null, false, false, "A localizable description of the schema");

        public DiscoverSchemaRowsetsRowset(XmlaRequest request, XmlaHandler handler) {
            super(DISCOVER_SCHEMA_ROWSETS, request, handler);
        }

        @Override
        public void populate(XmlaResponse response, List<Rowset.Row> rows) throws XmlaException {
            RowsetDefinition[] rowsetDefinitions = (RowsetDefinition[])((RowsetDefinition[])RowsetDefinition.class.getEnumConstants()).clone();
            Arrays.sort(rowsetDefinitions, new Comparator<RowsetDefinition>(){

                @Override
                public int compare(RowsetDefinition o1, RowsetDefinition o2) {
                    return o1.name().compareTo(o2.name());
                }
            });
            for (RowsetDefinition rowsetDefinition : rowsetDefinitions) {
                Rowset.Row row = new Rowset.Row();
                row.set(DiscoverSchemaRowsetsRowset.SchemaName.name, rowsetDefinition.name());
                row.set(DiscoverSchemaRowsetsRowset.Restrictions.name, this.getRestrictions(rowsetDefinition));
                String desc = rowsetDefinition.getDescription();
                row.set(DiscoverSchemaRowsetsRowset.Description.name, desc == null ? "" : desc);
                this.addRow(row, rows);
            }
        }

        private List<Rowset.XmlElement> getRestrictions(RowsetDefinition rowsetDefinition) {
            Column[] columns;
            ArrayList<Rowset.XmlElement> restrictionList = new ArrayList<Rowset.XmlElement>();
            for (Column column : columns = rowsetDefinition.columnDefinitions) {
                if (!column.restriction) continue;
                restrictionList.add(new Rowset.XmlElement(DiscoverSchemaRowsetsRowset.Restrictions.name, null, new Rowset.XmlElement[]{new Rowset.XmlElement("Name", null, column.name), new Rowset.XmlElement("Type", null, column.getColumnType())}));
            }
            return restrictionList;
        }

        @Override
        protected void setProperty(PropertyDefinition propertyDef, String value) {
            switch (propertyDef) {
                case Content: {
                    break;
                }
                default: {
                    super.setProperty(propertyDef, value);
                }
            }
        }

        static /* synthetic */ Column access$800() {
            return SchemaName;
        }

        static /* synthetic */ Column access$900() {
            return SchemaGuid;
        }

        static /* synthetic */ Column access$1100() {
            return Description;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DiscoverDatasourcesRowset
    extends Rowset {
        private static final Column DataSourceName = new Column("DataSourceName", Type.String, null, true, false, "The name of the data source, such as FoodMart 2000.");
        private static final Column DataSourceDescription = new Column("DataSourceDescription", Type.String, null, false, true, "A description of the data source, as entered by the publisher.");
        private static final Column URL = new Column("URL", Type.String, null, true, true, "The unique path that shows where to invoke the XML for Analysis methods for that data source.");
        private static final Column DataSourceInfo = new Column("DataSourceInfo", Type.String, null, false, true, "A string containing any additional information required to connect to the data source. This can include the Initial Catalog property or other information for the provider.\nExample: \"Provider=MSOLAP;Data Source=Local;\"");
        private static final Column ProviderName = new Column("ProviderName", Type.String, null, true, true, "The name of the provider behind the data source.\nExample: \"MSDASQL\"");
        private static final Column ProviderType = new Column("ProviderType", Type.EnumerationArray, Enumeration.PROVIDER_TYPE, true, false, true, "The types of data supported by the provider. May include one or more of the following types. Example follows this table.\nTDP: tabular data provider.\nMDP: multidimensional data provider.\nDMP: data mining provider. A DMP provider implements the OLE DB for Data Mining specification.");
        private static final Column AuthenticationMode = new Column("AuthenticationMode", Type.EnumString, Enumeration.AUTHENTICATION_MODE, true, false, "Specification of what type of security mode the data source uses. Values can be one of the following:\nUnauthenticated: no user ID or password needs to be sent.\nAuthenticated: User ID and Password must be included in the information required for the connection.\nIntegrated: the data source uses the underlying security to determine authorization, such as Integrated Security provided by Microsoft Internet Information Services (IIS).");

        public DiscoverDatasourcesRowset(XmlaRequest request, XmlaHandler handler) {
            super(DISCOVER_DATASOURCES, request, handler);
        }

        @Override
        public void populate(XmlaResponse response, List<Rowset.Row> rows) throws XmlaException {
            for (DataSourcesConfig.DataSource ds : this.handler.getDataSourceEntries().values()) {
                Rowset.Row row = new Rowset.Row();
                row.set(DiscoverDatasourcesRowset.DataSourceName.name, ds.getDataSourceName());
                row.set(DiscoverDatasourcesRowset.DataSourceDescription.name, ds.getDataSourceDescription());
                row.set(DiscoverDatasourcesRowset.URL.name, ds.getURL());
                row.set(DiscoverDatasourcesRowset.DataSourceInfo.name, ds.getDataSourceName());
                row.set(DiscoverDatasourcesRowset.ProviderName.name, ds.getProviderName());
                row.set(DiscoverDatasourcesRowset.ProviderType.name, ds.getProviderType());
                row.set(DiscoverDatasourcesRowset.AuthenticationMode.name, ds.getAuthenticationMode());
                this.addRow(row, rows);
            }
        }

        @Override
        protected void setProperty(PropertyDefinition propertyDef, String value) {
            switch (propertyDef) {
                case Content: {
                    break;
                }
                default: {
                    super.setProperty(propertyDef, value);
                }
            }
        }

        static /* synthetic */ Column access$000() {
            return DataSourceName;
        }

        static /* synthetic */ Column access$100() {
            return DataSourceDescription;
        }

        static /* synthetic */ Column access$200() {
            return URL;
        }

        static /* synthetic */ Column access$300() {
            return DataSourceInfo;
        }

        static /* synthetic */ Column access$400() {
            return ProviderName;
        }

        static /* synthetic */ Column access$500() {
            return ProviderType;
        }

        static /* synthetic */ Column access$600() {
            return AuthenticationMode;
        }
    }

    static class Column {
        static final boolean RESTRICTION = true;
        static final boolean NOT_RESTRICTION = false;
        static final boolean REQUIRED = false;
        static final boolean OPTIONAL = true;
        static final boolean ONE_MAX = false;
        static final boolean UNBOUNDED = true;
        final String name;
        final Type type;
        final Enumeration enumeration;
        final String description;
        final boolean restriction;
        final boolean nullable;
        final boolean unbounded;

        Column(String name, Type type, Enumeration enumeratedType, boolean restriction, boolean nullable, String description) {
            this(name, type, enumeratedType, restriction, nullable, false, description);
        }

        Column(String name, Type type, Enumeration enumeratedType, boolean restriction, boolean nullable, boolean unbounded, String description) {
            assert (type != null);
            assert ((type == Type.Enumeration || type == Type.EnumerationArray || type == Type.EnumString) == (enumeratedType != null));
            assert (description == null || description.indexOf(13) == -1);
            this.name = name;
            this.type = type;
            this.enumeration = enumeratedType;
            this.description = description;
            this.restriction = restriction;
            this.nullable = nullable;
            this.unbounded = unbounded;
        }

        protected Object get(Object row) {
            return this.getFromAccessor(row);
        }

        protected final Object getFromField(Object row) {
            try {
                String javaFieldName = this.name.substring(0, 1).toLowerCase() + this.name.substring(1);
                Field field = row.getClass().getField(javaFieldName);
                return field.get(row);
            }
            catch (NoSuchFieldException e) {
                throw Util.newInternal(e, "Error while accessing rowset column " + this.name);
            }
            catch (SecurityException e) {
                throw Util.newInternal(e, "Error while accessing rowset column " + this.name);
            }
            catch (IllegalAccessException e) {
                throw Util.newInternal(e, "Error while accessing rowset column " + this.name);
            }
        }

        protected final Object getFromAccessor(Object row) {
            try {
                String javaMethodName = "get" + this.name;
                Method method = row.getClass().getMethod(javaMethodName, new Class[0]);
                return method.invoke(row, new Object[0]);
            }
            catch (SecurityException e) {
                throw Util.newInternal(e, "Error while accessing rowset column " + this.name);
            }
            catch (IllegalAccessException e) {
                throw Util.newInternal(e, "Error while accessing rowset column " + this.name);
            }
            catch (NoSuchMethodException e) {
                throw Util.newInternal(e, "Error while accessing rowset column " + this.name);
            }
            catch (InvocationTargetException e) {
                throw Util.newInternal(e, "Error while accessing rowset column " + this.name);
            }
        }

        public String getColumnType() {
            if (this.type.isEnum()) {
                return this.enumeration.type.columnType;
            }
            return this.type.columnType;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Type {
        String("xsd:string"),
        StringArray("xsd:string"),
        Array("xsd:string"),
        Enumeration("xsd:string"),
        EnumerationArray("xsd:string"),
        EnumString("xsd:string"),
        Boolean("xsd:boolean"),
        StringSometimesArray("xsd:string"),
        Integer("xsd:int"),
        UnsignedInteger("xsd:unsignedInt"),
        DateTime("xsd:dateTime"),
        Rowset(null),
        Short("xsd:short"),
        UUID("uuid"),
        UnsignedShort("xsd:unsignedShort"),
        Long("xsd:long"),
        UnsignedLong("xsd:unsignedLong");

        public final String columnType;

        private Type(String columnType) {
            this.columnType = columnType;
        }

        boolean isEnum() {
            return this == Enumeration || this == EnumerationArray || this == EnumString;
        }

        String getName() {
            return this == String ? "string" : this.name();
        }
    }
}

