/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Enumerations {
    private Enumerations() {
    }

    public static final <T> Enumeration<T> empty() {
        List list = Collections.emptyList();
        return Collections.enumeration(list);
    }

    public static <T> Enumeration<T> singleton(T t) {
        return Collections.enumeration(Collections.singleton(t));
    }

    public static <T> Enumeration<T> concat(Enumeration<? extends T> enumeration, Enumeration<? extends T> enumeration2) {
        ArrayList<Enumeration<? extends T>> arrayList = new ArrayList<Enumeration<? extends T>>();
        arrayList.add(enumeration);
        arrayList.add(enumeration2);
        return new SeqEn(Collections.enumeration(arrayList));
    }

    public static <T> Enumeration<T> concat(Enumeration<? extends Enumeration<? extends T>> enumeration) {
        return new SeqEn(enumeration);
    }

    public static <T> Enumeration<T> removeDuplicates(Enumeration<T> enumeration) {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class RDupls
        implements Processor<T, T> {
            private Set<T> set = new HashSet();

            RDupls() {
            }

            @Override
            public T process(T t, Collection<T> collection) {
                return this.set.add(t) ? t : null;
            }
        }
        return Enumerations.filter(enumeration, new RDupls());
    }

    public static <T> Enumeration<T> array(T ... TArray) {
        return Collections.enumeration(Arrays.asList(TArray));
    }

    public static <T> Enumeration<T> removeNulls(Enumeration<T> enumeration) {
        return Enumerations.filter(enumeration, new RNulls());
    }

    public static <T, R> Enumeration<R> convert(Enumeration<? extends T> enumeration, Processor<T, R> processor) {
        return new AltEn<T, R>(enumeration, processor);
    }

    public static <T, R> Enumeration<R> filter(Enumeration<? extends T> enumeration, Processor<T, R> processor) {
        return new FilEn<T, R>(enumeration, processor);
    }

    public static <T, R> Enumeration<R> queue(Enumeration<? extends T> enumeration, Processor<T, R> processor) {
        QEn<T, R> qEn = new QEn<T, R>(processor);
        while (enumeration.hasMoreElements()) {
            qEn.put(enumeration.nextElement());
        }
        return qEn;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RNulls<T>
    implements Processor<T, T> {
        private RNulls() {
        }

        @Override
        public T process(T t, Collection<T> collection) {
            return t;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class FilEn<T, R>
    implements Enumeration<R> {
        private static final Object EMPTY = new Object();
        private Enumeration<? extends T> en;
        private R next = this.empty();
        private Processor<T, R> filter;

        public FilEn(Enumeration<? extends T> enumeration, Processor<T, R> processor) {
            this.en = enumeration;
            this.filter = processor;
        }

        @Override
        public boolean hasMoreElements() {
            if (this.next != this.empty()) {
                return true;
            }
            while (this.en.hasMoreElements()) {
                this.next = this.filter.process(this.en.nextElement(), null);
                if (this.next == null) continue;
                return true;
            }
            this.next = this.empty();
            return false;
        }

        @Override
        public R nextElement() {
            if (this.next == EMPTY && !this.hasMoreElements()) {
                throw new NoSuchElementException();
            }
            R r = this.next;
            this.next = this.empty();
            return r;
        }

        private R empty() {
            return (R)EMPTY;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class QEn<T, R>
    implements Enumeration<R> {
        private ListItem<T> next = null;
        private ListItem<T> last = null;
        private Processor<T, R> processor;

        public QEn(Processor<T, R> processor) {
            this.processor = processor;
        }

        public void put(T t) {
            if (this.last != null) {
                ListItem<T> listItem = new ListItem<T>(t);
                this.last.next = listItem;
                this.last = listItem;
            } else {
                this.last = new ListItem<T>(t);
                this.next = this.last;
            }
        }

        public void put(Collection<? extends T> collection) {
            for (T t : collection) {
                this.put(t);
            }
        }

        @Override
        public boolean hasMoreElements() {
            return this.next != null;
        }

        @Override
        public R nextElement() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            Object t = this.next.object;
            this.next = this.next.next;
            if (this.next == null) {
                this.last = null;
            }
            ToAdd toAdd = new ToAdd(this);
            R r = this.processor.process(t, toAdd);
            toAdd.finish();
            return r;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static final class ToAdd<T, R>
        implements Collection<T> {
            private QEn<T, R> q;

            public ToAdd(QEn<T, R> qEn) {
                this.q = qEn;
            }

            public void finish() {
                this.q = null;
            }

            @Override
            public boolean add(T t) {
                this.q.put(t);
                return true;
            }

            @Override
            public boolean addAll(Collection<? extends T> collection) {
                this.q.put(collection);
                return true;
            }

            private String msg() {
                return "Only add and addAll are implemented";
            }

            @Override
            public void clear() {
                throw new UnsupportedOperationException(this.msg());
            }

            @Override
            public boolean contains(Object object) {
                throw new UnsupportedOperationException(this.msg());
            }

            @Override
            public boolean containsAll(Collection collection) {
                throw new UnsupportedOperationException(this.msg());
            }

            @Override
            public boolean isEmpty() {
                throw new UnsupportedOperationException(this.msg());
            }

            @Override
            public Iterator<T> iterator() {
                throw new UnsupportedOperationException(this.msg());
            }

            @Override
            public boolean remove(Object object) {
                throw new UnsupportedOperationException(this.msg());
            }

            @Override
            public boolean removeAll(Collection collection) {
                throw new UnsupportedOperationException(this.msg());
            }

            @Override
            public boolean retainAll(Collection collection) {
                throw new UnsupportedOperationException(this.msg());
            }

            @Override
            public int size() {
                throw new UnsupportedOperationException(this.msg());
            }

            @Override
            public Object[] toArray() {
                throw new UnsupportedOperationException(this.msg());
            }

            @Override
            public <X> X[] toArray(X[] XArray) {
                throw new UnsupportedOperationException(this.msg());
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static final class ListItem<T> {
            T object;
            ListItem<T> next;

            ListItem(T t) {
                this.object = t;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class SeqEn<T>
    implements Enumeration<T> {
        private Enumeration<? extends Enumeration<? extends T>> en;
        private Enumeration<? extends T> current;
        private boolean checked = false;

        public SeqEn(Enumeration<? extends Enumeration<? extends T>> enumeration) {
            this.en = enumeration;
        }

        private void ensureCurrent() {
            while (this.current == null || !this.current.hasMoreElements()) {
                if (this.en.hasMoreElements()) {
                    this.current = this.en.nextElement();
                    continue;
                }
                this.current = null;
                return;
            }
        }

        @Override
        public boolean hasMoreElements() {
            if (!this.checked) {
                this.ensureCurrent();
                this.checked = true;
            }
            return this.current != null;
        }

        @Override
        public T nextElement() {
            if (!this.checked) {
                this.ensureCurrent();
            }
            if (this.current != null) {
                this.checked = false;
                return this.current.nextElement();
            }
            this.checked = true;
            throw new NoSuchElementException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class AltEn<T, R>
    implements Enumeration<R> {
        private Enumeration<? extends T> en;
        private Processor<T, R> process;

        public AltEn(Enumeration<? extends T> enumeration, Processor<T, R> processor) {
            this.en = enumeration;
            this.process = processor;
        }

        @Override
        public boolean hasMoreElements() {
            return this.en.hasMoreElements();
        }

        @Override
        public R nextElement() {
            return this.process.process(this.en.nextElement(), null);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Processor<T, R> {
        public R process(T var1, Collection<T> var2);
    }
}

