/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.mysql.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.db.explorer.ConnectionListener;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.modules.db.api.explorer.NodeProvider;
import org.netbeans.modules.db.mysql.DatabaseServer;
import org.netbeans.modules.db.mysql.DatabaseServerManager;
import org.netbeans.modules.db.mysql.impl.DbExplorerConnectionListener;
import org.netbeans.modules.db.mysql.impl.Installation;
import org.netbeans.modules.db.mysql.impl.InstallationManager;
import org.netbeans.modules.db.mysql.impl.MySQLOptions;
import org.netbeans.modules.db.mysql.nodes.ServerNode;
import org.netbeans.modules.db.mysql.util.DatabaseUtils;
import org.netbeans.modules.db.mysql.util.Utils;
import org.openide.nodes.Node;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ServerNodeProvider
implements NodeProvider {
    private static final Logger LOGGER = Logger.getLogger(NodeProvider.class.getName());
    private static final ServerNodeProvider DEFAULT = new ServerNodeProvider();
    private static final MySQLOptions options = MySQLOptions.getDefault();
    private final List<Node> nodes = new ArrayList<Node>();
    private final List<Node> unmodifiableNodes = Collections.unmodifiableList(this.nodes);
    private static final ArrayList<Node> emptyNodeList = new ArrayList();
    private final CopyOnWriteArrayList<ChangeListener> listeners = new CopyOnWriteArrayList();

    private ServerNodeProvider() {
    }

    public static ServerNodeProvider getDefault() {
        return DEFAULT;
    }

    private void findAndRegisterMySQL() {
        if (DatabaseUtils.getJDBCDriver() == null) {
            return;
        }
        if (options.isProviderRegistered() || options.isProviderRemoved()) {
            return;
        }
        this.registerConnectionListener();
        this.findAndRegisterInstallation();
    }

    private void registerConnectionListener() {
        ConnectionManager.getDefault().addConnectionListener((ConnectionListener)new DbExplorerConnectionListener());
    }

    private void findAndRegisterInstallation() {
        Installation installation = InstallationManager.detectInstallation();
        if (installation == null) {
            return;
        }
        String[] stringArray = installation.getAdminCommand();
        if (Utils.isValidExecutable(stringArray[0], true) || Utils.isValidURL(stringArray[0], true)) {
            options.setAdminPath(stringArray[0]);
            options.setAdminArgs(stringArray[1]);
        }
        if (Utils.isValidExecutable((stringArray = installation.getStartCommand())[0], true)) {
            options.setStartPath(stringArray[0]);
            options.setStartArgs(stringArray[1]);
        }
        if (Utils.isValidExecutable((stringArray = installation.getStopCommand())[0], true)) {
            options.setStopPath(stringArray[0]);
            options.setStopArgs(stringArray[1]);
        }
        options.setPort(installation.getDefaultPort());
        this.setRegistered(true);
    }

    public List<Node> getNodes() {
        if (!options.isProviderRegistered() && !options.isProviderRemoved()) {
            this.findAndRegisterMySQL();
        }
        this.checkNodeArray();
        if (options.isProviderRegistered()) {
            return this.unmodifiableNodes;
        }
        DatabaseServerManager.getDatabaseServer().disconnect();
        return emptyNodeList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkNodeArray() {
        if (this.nodes.size() == 0) {
            ServerNode serverNode = ServerNode.create(DatabaseServerManager.getDatabaseServer());
            ServerNodeProvider serverNodeProvider = this;
            synchronized (serverNodeProvider) {
                if (this.nodes.size() == 0) {
                    this.nodes.add((Node)serverNode);
                }
            }
        }
    }

    public void setRegistered(boolean bl) {
        boolean bl2 = this.isRegistered();
        if (bl != bl2) {
            final DatabaseServer databaseServer = DatabaseServerManager.getDatabaseServer();
            options.setProviderRegistered(bl);
            if (!bl) {
                databaseServer.disconnect();
            } else {
                RequestProcessor.getDefault().post(new Runnable(){

                    public void run() {
                        try {
                            databaseServer.checkConfiguration();
                        }
                        catch (DatabaseException databaseException) {
                            LOGGER.log(Level.INFO, null, databaseException);
                        }
                    }
                });
            }
            this.notifyChange();
        }
    }

    public synchronized boolean isRegistered() {
        return options.isProviderRegistered();
    }

    void notifyChange() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (ChangeListener changeListener : this.listeners) {
            changeListener.stateChanged(changeEvent);
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(changeListener);
    }
}

