/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.lang.ref.WeakReference;
import javax.swing.text.Position;
import org.netbeans.editor.BasePosition;
import org.netbeans.editor.MarkVector;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class MultiMark
extends WeakReference<BasePosition>
implements Runnable {
    static final int BACKWARD_BIAS = 1;
    static final int VALID = 2;
    static final int REMOVED = 4;
    static final int COMPATIBLE = 8;
    static final int ZERO = 16;
    int rawOffset;
    int flags;
    private final MarkVector markVector;

    MultiMark(BasePosition basePosition, MarkVector markVector, int n) {
        this(basePosition, markVector, n, n != 0 ? 8 : 25);
    }

    MultiMark(BasePosition basePosition, MarkVector markVector, int n, Position.Bias bias) {
        this(basePosition, markVector, n, bias == Position.Bias.Backward ? 1 : 0);
    }

    private MultiMark(BasePosition basePosition, MarkVector markVector, int n, int n2) {
        super(basePosition, Utilities.activeReferenceQueue());
        if (basePosition != null) {
            basePosition.setMark(this);
        }
        this.markVector = markVector;
        this.rawOffset = n;
        this.flags = n2;
    }

    public Position.Bias getBias() {
        return (this.flags & 1) != 0 ? Position.Bias.Backward : Position.Bias.Forward;
    }

    public int getOffset() {
        MarkVector markVector = this.markVector;
        synchronized (markVector) {
            if ((this.flags & 2) != 0) {
                return (this.flags & 0x10) == 0 ? this.markVector.getOffset(this.rawOffset) : 0;
            }
            throw new IllegalStateException();
        }
    }

    @Override
    public void run() {
        this.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        MarkVector markVector = this.markVector;
        synchronized (markVector) {
            if ((this.flags & 2) != 0) {
                this.flags &= 0xFFFFFFFD;
            } else {
                throw new IllegalStateException();
            }
            this.markVector.notifyMarkDisposed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isValid() {
        MarkVector markVector = this.markVector;
        synchronized (markVector) {
            return (this.flags & 2) != 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        MarkVector markVector = this.markVector;
        synchronized (markVector) {
            if ((this.flags & 2) != 0) {
                stringBuffer.append("offset=" + this.getOffset());
            } else {
                stringBuffer.append("removed");
            }
            stringBuffer.append(", bias=");
            stringBuffer.append(this.getBias());
            return stringBuffer.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toStringDetail() {
        StringBuffer stringBuffer = new StringBuffer();
        MarkVector markVector = this.markVector;
        synchronized (markVector) {
            stringBuffer.append(System.identityHashCode(this));
            stringBuffer.append(" (");
            stringBuffer.append(this.rawOffset);
            stringBuffer.append(" -> ");
            if ((this.flags & 2) != 0) {
                stringBuffer.append(this.getOffset());
            } else {
                stringBuffer.append('X');
                stringBuffer.append(this.markVector.getOffset(this.rawOffset));
                stringBuffer.append('X');
            }
            stringBuffer.append(", ");
            stringBuffer.append((this.flags & 1) != 0 ? (char)'B' : 'F');
            if ((this.flags & 2) != 0) {
                stringBuffer.append('V');
            }
            if ((this.flags & 4) != 0) {
                stringBuffer.append('R');
            }
            if ((this.flags & 8) != 0) {
                stringBuffer.append('C');
            }
            if ((this.flags & 0x10) != 0) {
                stringBuffer.append('Z');
            }
            stringBuffer.append(')');
            return stringBuffer.toString();
        }
    }
}

