/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.util.List;
import javax.swing.text.Position;
import org.netbeans.editor.BasePosition;
import org.netbeans.editor.MultiMark;

final class MarkVector {
    private static final MultiMark[] EMPTY = new MultiMark[0];
    private static final int INITIAL_OFFSET_GAP_SIZE = 0x3FFFFFFF;
    private MultiMark[] markArray = EMPTY;
    private int gapStart;
    private int gapLength;
    private int offsetGapStart;
    private int offsetGapLength = 0x3FFFFFFF;
    private int disposedMarkCount;

    MarkVector() {
    }

    MultiMark createBiasMark(int n, Position.Bias bias) {
        return new MultiMark(null, this, n, bias);
    }

    MultiMark createBiasMark(BasePosition basePosition, int n, Position.Bias bias) {
        return new MultiMark(basePosition, this, n, bias);
    }

    MultiMark createMark(int n) {
        return new MultiMark(null, this, n);
    }

    MultiMark createMark(BasePosition basePosition, int n) {
        return new MultiMark(basePosition, this, n);
    }

    synchronized int getMarkCount() {
        return this.markArray.length - this.gapLength;
    }

    synchronized MultiMark getMark(int n) {
        return this.markArray[this.getRawIndex(n)];
    }

    synchronized int getMarkOffsetInternal(int n) {
        return this.getOffset(this.getMark((int)n).rawOffset);
    }

    synchronized MultiMark insert(MultiMark multiMark) {
        int n = multiMark.flags;
        if ((n & 2) != 0) {
            throw new IllegalStateException();
        }
        int n2 = multiMark.rawOffset;
        int n3 = this.findInsertIndex(n2);
        if (this.gapLength == 0) {
            this.enlargeGap(1);
        }
        if (n3 != this.gapStart) {
            this.moveGap(n3);
        }
        if (n2 > this.offsetGapStart || n2 == this.offsetGapStart && (n & 1) == 0) {
            multiMark.rawOffset += this.offsetGapLength;
        }
        this.markArray[this.gapStart++] = multiMark;
        --this.gapLength;
        multiMark.flags |= 2;
        return multiMark;
    }

    synchronized void insertList(List list) {
        int n = Integer.MAX_VALUE;
        boolean bl = true;
        int n2 = 0;
        boolean bl2 = false;
        int n3 = this.getMarkCount();
        int n4 = list.size();
        if (this.gapLength < n4) {
            this.enlargeGap(n4);
        }
        for (int i = 0; i < n4; ++i) {
            MultiMark multiMark = (MultiMark)list.get(i);
            int n5 = multiMark.flags;
            if ((n5 & 2) != 0) {
                throw new IllegalStateException();
            }
            boolean bl3 = (n5 & 1) != 0;
            int n6 = multiMark.rawOffset;
            if (n6 < n || n6 == n && bl3 && !bl || n6 > n2 || n6 == n2 && !bl3 && bl2) {
                int n7 = this.findInsertIndex(n6);
                if (n7 != this.gapStart) {
                    this.moveGap(n7);
                }
                if (n7 < n3) {
                    MultiMark multiMark2 = this.markArray[this.getRawIndex(n7)];
                    n2 = this.getOffset(multiMark2.rawOffset);
                    bl2 = (multiMark2.flags & 1) != 0;
                } else {
                    n2 = Integer.MAX_VALUE;
                    bl2 = false;
                }
            }
            if (n6 > this.offsetGapStart || n6 == this.offsetGapStart && (n5 & 1) == 0) {
                multiMark.rawOffset += this.offsetGapLength;
            }
            this.markArray[this.gapStart++] = multiMark;
            --this.gapLength;
            multiMark.flags |= 2;
            n = n6;
            bl = bl3;
            ++n3;
        }
    }

    synchronized void notifyMarkDisposed() {
        ++this.disposedMarkCount;
        if (this.disposedMarkCount > Math.max(5, this.getMarkCount() / 10)) {
            this.removeDisposedMarks();
        }
    }

    synchronized void compact() {
        if (this.gapLength > 0) {
            int n = this.markArray.length - this.gapLength;
            MultiMark[] multiMarkArray = new MultiMark[n];
            int n2 = this.gapStart + this.gapLength;
            System.arraycopy(this.markArray, 0, multiMarkArray, 0, this.gapStart);
            System.arraycopy(this.markArray, n2, multiMarkArray, this.gapStart, this.markArray.length - n2);
            this.markArray = multiMarkArray;
            this.gapStart = this.markArray.length;
            this.gapLength = 0;
        }
    }

    synchronized Undo update(int n, int n2, Undo undo) {
        if (n2 < 0) {
            n -= n2;
        }
        int n3 = this.findInsertIndex(n);
        this.moveOffsetGap(n3, n);
        this.offsetGapStart += n2;
        this.offsetGapLength -= n2;
        if (n2 >= 0) {
            if (undo != null) {
                Object object;
                UndoItem undoItem = undo.fbItem;
                int n4 = 0;
                while (undoItem != null) {
                    if ((undoItem.mark.flags & 4) == 0) {
                        ++n4;
                        object = undoItem.logicalNext;
                        while (object != null) {
                            if ((((UndoItem)object).mark.flags & 4) == 0) {
                                ++n4;
                            } else {
                                ((UndoItem)object).mark = null;
                            }
                            object = ((UndoItem)object).logicalNext;
                        }
                        break;
                    }
                    undoItem.mark = null;
                    undoItem = undoItem.logicalNext;
                }
                if (undoItem != null) {
                    object = undoItem.mark;
                    int n5 = n3;
                    while (this.markArray[this.getRawIndex(n5)] != object) {
                        ++n5;
                    }
                    while (--n5 >= n3) {
                        this.markArray[this.getRawIndex((int)(n5 + n4))] = this.markArray[this.getRawIndex(n5)];
                    }
                }
                undoItem = undo.bbItem;
                int n6 = 0;
                while (undoItem != null) {
                    if ((undoItem.mark.flags & 4) == 0) {
                        ++n6;
                        UndoItem undoItem2 = undoItem.logicalNext;
                        while (undoItem2 != null) {
                            if ((undoItem2.mark.flags & 4) == 0) {
                                ++n6;
                            } else {
                                undoItem2.mark = null;
                            }
                            undoItem2 = undoItem2.logicalNext;
                        }
                        break;
                    }
                    undoItem.mark = null;
                    undoItem = undoItem.logicalNext;
                }
                if (undoItem != null) {
                    MultiMark multiMark = undoItem.mark;
                    int n7 = n3;
                    while (this.markArray[this.getRawIndex(--n7)] != multiMark) {
                    }
                    ++n7;
                    while (n7 < n3) {
                        this.markArray[this.getRawIndex((int)(n7 - n6))] = this.markArray[this.getRawIndex(n7)];
                        ++n7;
                    }
                }
                UndoItem undoItem3 = undo.firstItem;
                n3 -= n6;
                while (undoItem3 != null) {
                    MultiMark multiMark = undoItem3.mark;
                    if (multiMark != null) {
                        multiMark.rawOffset = undoItem3.undoOffset;
                        this.markArray[this.getRawIndex((int)n3++)] = multiMark;
                    }
                    undoItem3 = undoItem3.next;
                }
                if (n == 0) {
                    ZeroUndoItem zeroUndoItem = undo.zeroItem;
                    while (zeroUndoItem != null) {
                        MultiMark multiMark = zeroUndoItem.mark;
                        if ((multiMark.flags & 4) == 0) {
                            multiMark.flags &= 0xFFFFFFEF;
                        }
                        zeroUndoItem = zeroUndoItem.next;
                    }
                }
            }
            undo = null;
        } else {
            int n8;
            n += n2;
            UndoItem undoItem = null;
            UndoItem undoItem4 = null;
            UndoItem undoItem5 = null;
            UndoItem undoItem6 = null;
            int n9 = -1;
            int n10 = n + this.offsetGapLength;
            ZeroUndoItem zeroUndoItem = null;
            if (n == 0) {
                int n11 = n3;
                n8 = this.getMarkCount();
                while (n11 < n8) {
                    MultiMark multiMark = this.markArray[this.getRawIndex(n11++)];
                    if (multiMark.rawOffset != n10) break;
                    if ((multiMark.flags & 0x18) != 8) continue;
                    multiMark.flags |= 0x10;
                    zeroUndoItem = new ZeroUndoItem(multiMark, zeroUndoItem);
                }
            }
            while (n3 > 0) {
                boolean bl;
                MultiMark multiMark = this.markArray[this.getRawIndex(--n3)];
                n8 = multiMark.rawOffset;
                boolean bl2 = bl = (multiMark.flags & 1) != 0;
                if (n8 < n || multiMark.rawOffset == n && bl) break;
                undoItem = new UndoItem(multiMark, n8, undoItem);
                if (bl) {
                    if (undoItem5 != null) {
                        undoItem5.logicalNext = undoItem;
                    } else {
                        undoItem6 = undoItem;
                        n9 = n3;
                    }
                    undoItem5 = undoItem;
                    multiMark.rawOffset = n;
                    continue;
                }
                undoItem.logicalNext = undoItem4;
                undoItem4 = undoItem;
                multiMark.rawOffset = n10;
                if (n9 < 0) continue;
                int n12 = this.getRawIndex(n9--);
                this.markArray[this.getRawIndex((int)n3)] = this.markArray[n12];
                this.markArray[n12] = multiMark;
                UndoItem undoItem7 = undoItem6.logicalNext;
                if (undoItem7 == null) continue;
                undoItem5.logicalNext = undoItem6;
                undoItem5 = undoItem6;
                undoItem6.logicalNext = null;
                undoItem6 = undoItem7;
            }
            if (n == 0 && undoItem != null) {
                UndoItem undoItem8 = undoItem;
                while (undoItem8 != null) {
                    MultiMark multiMark = undoItem8.mark;
                    if ((multiMark.flags & 0x18) == 8) {
                        multiMark.flags |= 0x10;
                        zeroUndoItem = new ZeroUndoItem(multiMark, zeroUndoItem);
                    }
                    undoItem8 = undoItem8.next;
                }
            }
            undo = undoItem != null || zeroUndoItem != null ? new Undo(undoItem, undoItem4, undoItem6, zeroUndoItem) : null;
        }
        return undo;
    }

    private void removeDisposedMarks() {
        MultiMark multiMark;
        int n;
        int n2 = -1;
        int n3 = this.gapStart + this.gapLength;
        for (n = 0; n < this.gapStart; ++n) {
            multiMark = this.markArray[n];
            if ((multiMark.flags & 2) != 0) {
                if (n == ++n2) continue;
                this.markArray[n2] = multiMark;
                continue;
            }
            multiMark.flags |= 4;
        }
        this.gapStart = n2 + 1;
        n2 = n = this.markArray.length;
        while (--n >= n3) {
            multiMark = this.markArray[n];
            if ((multiMark.flags & 2) != 0) {
                if (n == --n2) continue;
                this.markArray[n2] = multiMark;
                continue;
            }
            multiMark.flags |= 4;
        }
        this.gapLength = n2 - this.gapStart;
        this.disposedMarkCount = 0;
    }

    synchronized int getOffset(int n) {
        return n <= this.offsetGapStart ? n : n - this.offsetGapLength;
    }

    private int getRawIndex(int n) {
        return n < this.gapStart ? n : n + this.gapLength;
    }

    private int findInsertIndex(int n) {
        int n2 = 0;
        int n3 = this.getMarkCount() - 1;
        while (n2 <= n3) {
            int n4 = (n2 + n3) / 2;
            MultiMark multiMark = this.markArray[this.getRawIndex(n4)];
            int n5 = this.getOffset(multiMark.rawOffset);
            if (n5 < n) {
                n2 = n4 + 1;
                continue;
            }
            if (n5 > n) {
                n3 = n4 - 1;
                continue;
            }
            if ((multiMark.flags & 1) != 0) {
                n2 = n4 + 1;
                continue;
            }
            n3 = n4 - 1;
        }
        return n2;
    }

    private void moveGap(int n) {
        if (n <= this.gapStart) {
            int n2 = this.gapStart - n;
            System.arraycopy(this.markArray, n, this.markArray, this.gapStart + this.gapLength - n2, n2);
            this.gapStart = n;
        } else {
            int n3 = n - this.gapStart;
            System.arraycopy(this.markArray, this.gapStart + this.gapLength, this.markArray, this.gapStart, n3);
            this.gapStart += n3;
        }
    }

    private void moveOffsetGap(int n, int n2) {
        int n3 = this.getRawIndex(n);
        int n4 = this.markArray.length;
        int n5 = this.offsetGapStart;
        this.offsetGapStart = n2;
        int n6 = this.offsetGapLength;
        if (n3 == n4 || this.markArray[n3].rawOffset > n5) {
            int n7;
            int n8 = n7 = n3 < this.gapStart ? 0 : this.gapStart + this.gapLength;
            while (true) {
                if (--n3 >= n7) {
                    MultiMark multiMark = this.markArray[n3];
                    if (multiMark.rawOffset <= n5) continue;
                    multiMark.rawOffset -= n6;
                    continue;
                }
                if (n7 > 0) {
                    n7 = 0;
                    n3 = this.gapStart;
                    continue;
                }
                break;
            }
        } else {
            int n9;
            int n10 = n9 = n3 < this.gapStart ? this.gapStart : n4;
            while (true) {
                if (n3 < n9) {
                    MultiMark multiMark = this.markArray[n3];
                    if (multiMark.rawOffset <= n5) {
                        multiMark.rawOffset += n6;
                    }
                    ++n3;
                    continue;
                }
                if (n9 >= n4) break;
                n9 = n4;
                n3 += this.gapLength;
            }
        }
    }

    private void enlargeGap(int n) {
        int n2 = Math.max(8, this.markArray.length * 3 / 2 + n);
        int n3 = this.gapStart + this.gapLength;
        int n4 = this.markArray.length - n3;
        int n5 = n2 - n4;
        MultiMark[] multiMarkArray = new MultiMark[n2];
        System.arraycopy(this.markArray, 0, multiMarkArray, 0, this.gapStart);
        System.arraycopy(this.markArray, n3, multiMarkArray, n5, n4);
        this.markArray = multiMarkArray;
        this.gapLength = n5 - this.gapStart;
    }

    public String toString() {
        return "markCount=" + this.getMarkCount() + ", gapStart=" + this.gapStart + ", gapLength=" + this.gapLength + ", offsetGapStart=" + this.offsetGapStart + ", offsetGapLength=" + this.offsetGapLength;
    }

    static final class ZeroUndoItem {
        final MultiMark mark;
        final ZeroUndoItem next;

        ZeroUndoItem(MultiMark multiMark, ZeroUndoItem zeroUndoItem) {
            this.mark = multiMark;
            this.next = zeroUndoItem;
        }
    }

    static final class UndoItem {
        MultiMark mark;
        int undoOffset;
        UndoItem next;
        UndoItem logicalNext;

        UndoItem(MultiMark multiMark, int n, UndoItem undoItem) {
            this.mark = multiMark;
            this.undoOffset = n;
            this.next = undoItem;
        }
    }

    static final class Undo {
        UndoItem firstItem;
        UndoItem fbItem;
        UndoItem bbItem;
        ZeroUndoItem zeroItem;

        Undo(UndoItem undoItem, UndoItem undoItem2, UndoItem undoItem3, ZeroUndoItem zeroUndoItem) {
            this.firstItem = undoItem;
            this.fbItem = undoItem2;
            this.bbItem = undoItem3;
            this.zeroItem = zeroUndoItem;
        }
    }
}

