/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import javax.swing.text.Position;
import javax.swing.text.ViewFactory;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.editor.settings.KeyBindingSettings;
import org.netbeans.editor.ActionFactory;
import org.netbeans.editor.BaseAction;
import org.netbeans.editor.BaseCaret;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseImageTokenID;
import org.netbeans.editor.BaseTextUI;
import org.netbeans.editor.BaseTokenID;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.Formatter;
import org.netbeans.editor.GuardedException;
import org.netbeans.editor.LocalBaseAction;
import org.netbeans.editor.MultiKeyBinding;
import org.netbeans.editor.MultiKeymap;
import org.netbeans.editor.Syntax;
import org.netbeans.editor.SyntaxSupport;
import org.netbeans.editor.TokenContext;
import org.netbeans.editor.TokenID;
import org.netbeans.editor.Utilities;
import org.netbeans.lib.editor.hyperlink.HyperlinkOperation;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.editor.lib.KitsTracker;
import org.netbeans.modules.editor.lib.NavigationHistory;
import org.netbeans.modules.editor.lib.SettingsConversions;
import org.openide.awt.StatusDisplayer;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.util.WeakSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseKit
extends DefaultEditorKit {
    static ThreadLocal<Boolean> IN_PASTE = new ThreadLocal();
    private static final Logger LOG = Logger.getLogger(BaseKit.class.getName());
    public static final String splitLineAction = "split-line";
    public static final String annotationsCyclingAction = "annotations-cycling";
    public static final String collapseFoldAction = "collapse-fold";
    public static final String expandFoldAction = "expand-fold";
    public static final String collapseAllFoldsAction = "collapse-all-folds";
    public static final String expandAllFoldsAction = "expand-all-folds";
    public static final String selectionPageUpAction = "selection-page-up";
    public static final String selectionPageDownAction = "selection-page-down";
    public static final String removeTabAction = "remove-tab";
    public static final String removeSelectionAction = "remove-selection";
    public static final String abbrevExpandAction = "abbrev-expand";
    public static final String abbrevResetAction = "abbrev-reset";
    public static final String removePreviousWordAction = "remove-word-previous";
    public static final String removeNextWordAction = "remove-word-next";
    public static final String removeLineBeginAction = "remove-line-begin";
    public static final String removeLineAction = "remove-line";
    static final String moveSelectionElseLineUpAction = "move-selection-else-line-up";
    static final String moveSelectionElseLineDownAction = "move-selection-else-line-down";
    static final String copySelectionElseLineUpAction = "copy-selection-else-line-up";
    static final String copySelectionElseLineDownAction = "copy-selection-else-line-down";
    public static final String toggleTypingModeAction = "toggle-typing-mode";
    public static final String toUpperCaseAction = "to-upper-case";
    public static final String toLowerCaseAction = "to-lower-case";
    public static final String switchCaseAction = "switch-case";
    public static final String findNextAction = "find-next";
    public static final String findPreviousAction = "find-previous";
    public static final String toggleHighlightSearchAction = "toggle-highlight-search";
    public static final String findSelectionAction = "find-selection";
    public static final String undoAction = "undo";
    public static final String redoAction = "redo";
    public static final String wordMatchNextAction = "word-match-next";
    public static final String wordMatchPrevAction = "word-match-prev";
    public static final String reindentLineAction = "reindent-line";
    public static final String shiftLineRightAction = "shift-line-right";
    public static final String shiftLineLeftAction = "shift-line-left";
    public static final String adjustWindowCenterAction = "adjust-window-center";
    public static final String adjustWindowTopAction = "adjust-window-top";
    public static final String adjustWindowBottomAction = "adjust-window-bottom";
    public static final String adjustCaretCenterAction = "adjust-caret-center";
    public static final String adjustCaretTopAction = "adjust-caret-top";
    public static final String adjustCaretBottomAction = "adjust-caret-bottom";
    public static final String formatAction = "format";
    public static final String firstNonWhiteAction = "first-non-white";
    public static final String lastNonWhiteAction = "last-non-white";
    public static final String selectionFirstNonWhiteAction = "selection-first-non-white";
    public static final String selectionLastNonWhiteAction = "selection-last-non-white";
    public static final String selectIdentifierAction = "select-identifier";
    public static final String selectNextParameterAction = "select-next-parameter";
    public static final String jumpListNextAction = "jump-list-next";
    public static final String jumpListPrevAction = "jump-list-prev";
    public static final String jumpListNextComponentAction = "jump-list-next-component";
    public static final String jumpListPrevComponentAction = "jump-list-prev-component";
    public static final String scrollUpAction = "scroll-up";
    public static final String scrollDownAction = "scroll-down";
    public static final String macroActionPrefix = "macro-";
    public static final String startMacroRecordingAction = "start-macro-recording";
    public static final String stopMacroRecordingAction = "stop-macro-recording";
    public static final String lineFirstColumnAction = "caret-line-first-column";
    public static final String insertDateTimeAction = "insert-date-time";
    public static final String selectionLineFirstColumnAction = "selection-line-first-column";
    public static final String generateGutterPopupAction = "generate-gutter-popup";
    public static final String toggleLineNumbersAction = "toggle-line-numbers";
    public static final String pasteFormatedAction = "paste-formated";
    public static final String startNewLineAction = "start-new-line";
    public static final String cutToLineBeginAction = "cut-to-line-begin";
    public static final String cutToLineEndAction = "cut-to-line-end";
    public static final String removeTrailingSpacesAction = "remove-trailing-spaces";
    public static final String DOC_REPLACE_SELECTION_PROPERTY = "doc-replace-selection-property";
    private static final int KIT_CNT_PREALLOC = 7;
    static final long serialVersionUID = -8570495408376659348L;
    private static final Map<Class, BaseKit> kits = new HashMap<Class, BaseKit>(7);
    private static final Object KEYMAPS_AND_ACTIONS_LOCK = new String("BaseKit.KEYMAPS_AND_ACTIONS_LOCK");
    private static final Map<MimePath, KeybindingsAndPreferencesTracker> keymapTrackers = new WeakHashMap<MimePath, KeybindingsAndPreferencesTracker>(7);
    private static final Map<MimePath, MultiKeymap> kitKeymaps = new WeakHashMap<MimePath, MultiKeymap>(7);
    private static final Map<MimePath, Action[]> kitActions = new WeakHashMap<MimePath, Action[]>(7);
    private static final Map<MimePath, Map<String, Action>> kitActionMaps = new WeakHashMap<MimePath, Map<String, Action>>(7);
    private static CopyAction copyActionDef = new CopyAction();
    private static CutAction cutActionDef = new CutAction();
    private static PasteAction pasteActionDef = new PasteAction(false);
    private static DeleteCharAction deletePrevCharActionDef = new DeleteCharAction("delete-previous", false);
    private static DeleteCharAction deleteNextCharActionDef = new DeleteCharAction("delete-next", true);
    private static ActionFactory.RemoveSelectionAction removeSelectionActionDef = new ActionFactory.RemoveSelectionAction();
    private static final Action insertTabActionDef = new InsertTabAction();
    private static final Action removeTabActionDef = new ActionFactory.RemoveTabAction();
    private static final Action insertBreakActionDef = new InsertBreakAction();
    private static ActionFactory.UndoAction undoActionDef = new ActionFactory.UndoAction();
    private static ActionFactory.RedoAction redoActionDef = new ActionFactory.RedoAction();
    public static final int MAGIC_POSITION_MAX = 0x7FFFFFFE;

    private void updateActionSettings(Action[] actionArray) {
        block2: for (Action action : actionArray) {
            if (!(action instanceof BaseAction)) continue;
            for (Method method : action.getClass().getDeclaredMethods()) {
                if (!method.getName().equals("settingsChange") || method.getParameterTypes().length != 2 || method.getParameterTypes()[1] != Class.class) continue;
                try {
                    method.setAccessible(true);
                    method.invoke((Object)action, new Object[]{null, this.getClass()});
                }
                catch (Exception exception) {
                    LOG.log(Level.FINE, null, exception);
                }
                continue block2;
            }
        }
    }

    public static BaseKit getKit(Class clazz) {
        Class<BaseKit> clazz2;
        Object object;
        if (clazz != null && BaseKit.class.isAssignableFrom(clazz) && BaseKit.class != clazz) {
            object = KitsTracker.getInstance().findMimeType(clazz);
            if (object != null && (clazz2 = (EditorKit)MimeLookup.getLookup((MimePath)MimePath.parse((String)object)).lookup(EditorKit.class)) instanceof BaseKit) {
                return (BaseKit)((Object)clazz2);
            }
        } else {
            clazz = BaseKit.class;
        }
        object = kits;
        synchronized (object) {
            BaseKit baseKit;
            clazz2 = clazz;
            while ((baseKit = kits.get(clazz2)) == null) {
                try {
                    baseKit = (BaseKit)clazz2.newInstance();
                    kits.put(clazz2, baseKit);
                    return baseKit;
                }
                catch (IllegalAccessException illegalAccessException) {
                    LOG.log(Level.WARNING, "Can't instantiate editor kit from: " + clazz2, illegalAccessException);
                }
                catch (InstantiationException instantiationException) {
                    LOG.log(Level.WARNING, "Can't instantiate editor kit from: " + clazz2, instantiationException);
                }
                if (clazz2 != BaseKit.class) {
                    clazz2 = BaseKit.class;
                    continue;
                }
                throw new IllegalStateException("Can't create editor kit for: " + clazz);
            }
            return baseKit;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseKit() {
        Map<Class, BaseKit> map = kits;
        synchronized (map) {
            if (kits.get(this.getClass()) == null) {
                kits.put(this.getClass(), this);
            }
        }
    }

    @Override
    public Object clone() {
        return this;
    }

    @Override
    public ViewFactory getViewFactory() {
        return null;
    }

    @Override
    public Caret createCaret() {
        return new BaseCaret();
    }

    @Override
    public Document createDefaultDocument() {
        return new BaseDocument(this.getClass(), true);
    }

    public Syntax createSyntax(Document document) {
        return new DefaultSyntax();
    }

    public Syntax createFormatSyntax(Document document) {
        return this.createSyntax(document);
    }

    public SyntaxSupport createSyntaxSupport(BaseDocument baseDocument) {
        return new SyntaxSupport(baseDocument);
    }

    public Formatter createFormatter() {
        return new Formatter(this.getClass());
    }

    protected BaseTextUI createTextUI() {
        return new BaseTextUI();
    }

    protected EditorUI createEditorUI() {
        return new EditorUI();
    }

    protected EditorUI createPrintEditorUI(BaseDocument baseDocument) {
        return new EditorUI(baseDocument);
    }

    protected EditorUI createPrintEditorUI(BaseDocument baseDocument, boolean bl, boolean bl2) {
        return new EditorUI(baseDocument, bl, bl2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MultiKeymap getKeymap() {
        Object object = KEYMAPS_AND_ACTIONS_LOCK;
        synchronized (object) {
            MimePath mimePath = MimePath.parse((String)this.getContentType());
            MultiKeymap multiKeymap = kitKeymaps.get(mimePath);
            if (multiKeymap == null) {
                multiKeymap = new MultiKeymap("Keymap for " + mimePath.getPath());
                KeyBindingSettings keyBindingSettings = (KeyBindingSettings)MimeLookup.getLookup((MimePath)mimePath).lookup(KeyBindingSettings.class);
                List list = keyBindingSettings.getKeyBindings();
                ArrayList<MultiKeyBinding> arrayList = new ArrayList<MultiKeyBinding>();
                for (org.netbeans.api.editor.settings.MultiKeyBinding multiKeyBinding : list) {
                    List list2 = multiKeyBinding.getKeyStrokeList();
                    MultiKeyBinding multiKeyBinding2 = new MultiKeyBinding(list2.toArray(new KeyStroke[list2.size()]), multiKeyBinding.getActionName());
                    arrayList.add(multiKeyBinding2);
                }
                multiKeymap.load(arrayList.toArray(new JTextComponent.KeyBinding[arrayList.size()]), this.getActionMap());
                multiKeymap.setDefaultAction(this.getActionMap().get("default-typed"));
                kitKeymaps.put(mimePath, multiKeymap);
            }
            return multiKeymap;
        }
    }

    @Override
    public void read(Reader reader, Document document, int n) throws IOException, BadLocationException {
        if (document instanceof BaseDocument) {
            ((BaseDocument)document).read(reader, n);
        } else {
            super.read(reader, document, n);
        }
    }

    @Override
    public void write(Writer writer, Document document, int n, int n2) throws IOException, BadLocationException {
        if (document instanceof BaseDocument) {
            ((BaseDocument)document).write(writer, n, n2);
        } else {
            super.write(writer, document, n, n2);
        }
    }

    public static Map<String, Action> actionsToMap(Action[] actionArray) {
        HashMap<String, Action> hashMap = new HashMap<String, Action>();
        for (Action action : actionArray) {
            String string = (String)action.getValue("Name");
            hashMap.put(string != null ? string : "", action);
        }
        return hashMap;
    }

    public static Action[] mapToActions(Map map) {
        Action[] actionArray = new Action[map.size()];
        int n = 0;
        Iterator iterator = map.values().iterator();
        while (iterator.hasNext()) {
            actionArray[n++] = (Action)iterator.next();
        }
        return actionArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void install(JEditorPane jEditorPane) {
        Object object;
        boolean bl;
        assert (SwingUtilities.isEventDispatchThread()) : "BaseKit.install() incorrectly called from non-AWT thread.";
        BaseTextUI baseTextUI = this.createTextUI();
        jEditorPane.setUI(baseTextUI);
        String string = "netbeans.editor.noinputmethods";
        String string2 = System.getProperty(string);
        if (string2 != null) {
            bl = !Boolean.getBoolean(string);
        } else {
            object = (Preferences)MimeLookup.getLookup((String)this.getContentType()).lookup(Preferences.class);
            bl = ((Preferences)object).getBoolean("input-methods-enabled", true);
        }
        jEditorPane.enableInputMethods(bl);
        HyperlinkOperation.ensureRegistered(jEditorPane, this.getContentType());
        jEditorPane.putClientProperty("context-api-aware", Boolean.TRUE);
        if (!(this instanceof HelpCtx.Provider)) {
            HelpCtx.setHelpIDString((JComponent)jEditorPane, (String)this.getContentType().replace('/', '.').replace('+', '.'));
        }
        Object object2 = KEYMAPS_AND_ACTIONS_LOCK;
        synchronized (object2) {
            MimePath mimePath = MimePath.get((String)this.getContentType());
            KeybindingsAndPreferencesTracker keybindingsAndPreferencesTracker = keymapTrackers.get(mimePath);
            if (keybindingsAndPreferencesTracker == null) {
                keybindingsAndPreferencesTracker = new KeybindingsAndPreferencesTracker(mimePath.getPath());
                keymapTrackers.put(mimePath, keybindingsAndPreferencesTracker);
            }
            keybindingsAndPreferencesTracker.addComponent(jEditorPane);
            object = this.getKeymap();
        }
        jEditorPane.setKeymap((Keymap)object);
        this.executeInstallActions(jEditorPane);
    }

    protected void executeInstallActions(JEditorPane jEditorPane) {
        MimePath mimePath = MimePath.parse((String)this.getContentType());
        Preferences preferences = (Preferences)MimeLookup.getLookup((MimePath)mimePath).lookup(Preferences.class);
        List list = (List)SettingsConversions.callFactory(preferences, mimePath, "kit-install-action-name-list", null);
        List<Action> list2 = this.translateActionNameList(list);
        for (Action action : list2) {
            action.actionPerformed(new ActionEvent(jEditorPane, 1001, ""));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deinstall(JEditorPane jEditorPane) {
        assert (SwingUtilities.isEventDispatchThread()) : "BaseKit.deinstall() incorrectly called from non-AWT thread.";
        this.executeDeinstallActions(jEditorPane);
        jEditorPane.setKeymap(null);
        Object object = KEYMAPS_AND_ACTIONS_LOCK;
        synchronized (object) {
            MimePath mimePath = MimePath.get((String)this.getContentType());
            KeybindingsAndPreferencesTracker keybindingsAndPreferencesTracker = keymapTrackers.get(mimePath);
            if (keybindingsAndPreferencesTracker != null) {
                keybindingsAndPreferencesTracker.removeComponent(jEditorPane);
            }
        }
        BaseTextUI.uninstallUIWatcher(jEditorPane);
        jEditorPane.updateUI();
        if (jEditorPane.getClientProperty("ancestorOverride") != null) {
            jEditorPane.putClientProperty("ancestorOverride", Boolean.FALSE);
        }
    }

    protected void executeDeinstallActions(JEditorPane jEditorPane) {
        MimePath mimePath = MimePath.parse((String)this.getContentType());
        Preferences preferences = (Preferences)MimeLookup.getLookup((MimePath)mimePath).lookup(Preferences.class);
        List list = (List)SettingsConversions.callFactory(preferences, mimePath, "kit-deinstall-action-name-list", null);
        List<Action> list2 = this.translateActionNameList(list);
        for (Action action : list2) {
            action.actionPerformed(new ActionEvent(jEditorPane, 1001, ""));
        }
    }

    protected void initDocument(BaseDocument baseDocument) {
    }

    protected Action[] createActions() {
        return new Action[]{new DefaultKeyTypedAction(), new InsertContentAction(), insertBreakActionDef, new SplitLineAction(), insertTabActionDef, deletePrevCharActionDef, deleteNextCharActionDef, new ReadOnlyAction(), new WritableAction(), cutActionDef, copyActionDef, pasteActionDef, new PasteAction(true), new BeepAction(), new UpAction("caret-up", false), new UpAction("selection-up", true), new PageUpAction("page-up", false), new PageUpAction(selectionPageUpAction, true), new DownAction("caret-down", false), new DownAction("selection-down", true), new PageDownAction(selectionPageDownAction, true), new PageDownAction("page-down", false), new ForwardAction("caret-forward", false), new ForwardAction("selection-forward", true), new BackwardAction("caret-backward", false), new BackwardAction("selection-backward", true), new BeginLineAction(lineFirstColumnAction, false, true), new BeginLineAction(selectionLineFirstColumnAction, true, true), new BeginLineAction("caret-begin-line", false), new BeginLineAction("selection-begin-line", true), new EndLineAction("caret-end-line", false), new EndLineAction("selection-end-line", true), new BeginAction("caret-begin", false), new BeginAction("selection-begin", true), new EndAction("caret-end", false), new EndAction("selection-end", true), new NextWordAction("caret-next-word", false), new NextWordAction("selection-next-word", true), new PreviousWordAction("caret-previous-word", false), new PreviousWordAction("selection-previous-word", true), new BeginWordAction("caret-begin-word", false), new BeginWordAction("selection-begin-word", true), new EndWordAction("caret-end-word", false), new EndWordAction("selection-end-word", true), new SelectWordAction(), new SelectLineAction(), new SelectAllAction(), new RemoveTrailingSpacesAction(), removeTabActionDef, new ActionFactory.RemoveWordPreviousAction(), new ActionFactory.RemoveWordNextAction(), new ActionFactory.RemoveLineBeginAction(), new ActionFactory.RemoveLineAction(), new ActionFactory.MoveSelectionElseLineUpAction(), new ActionFactory.MoveSelectionElseLineDownAction(), new ActionFactory.CopySelectionElseLineUpAction(), new ActionFactory.CopySelectionElseLineDownAction(), removeSelectionActionDef, new ActionFactory.ToggleTypingModeAction(), new ActionFactory.ChangeCaseAction(toUpperCaseAction, 0), new ActionFactory.ChangeCaseAction(toLowerCaseAction, 1), new ActionFactory.ChangeCaseAction(switchCaseAction, 2), new ActionFactory.FindNextAction(), new ActionFactory.FindPreviousAction(), new ActionFactory.FindSelectionAction(), new ActionFactory.ToggleHighlightSearchAction(), undoActionDef, redoActionDef, new ActionFactory.WordMatchAction(wordMatchNextAction, true), new ActionFactory.WordMatchAction(wordMatchPrevAction, false), new ActionFactory.ReindentLineAction(), new ActionFactory.ShiftLineAction(shiftLineLeftAction, false), new ActionFactory.ShiftLineAction(shiftLineRightAction, true), new ActionFactory.AdjustWindowAction(adjustWindowTopAction, 0), new ActionFactory.AdjustWindowAction(adjustWindowCenterAction, 50), new ActionFactory.AdjustWindowAction(adjustWindowBottomAction, 100), new ActionFactory.AdjustCaretAction(adjustCaretTopAction, 0), new ActionFactory.AdjustCaretAction(adjustCaretCenterAction, 50), new ActionFactory.AdjustCaretAction(adjustCaretBottomAction, 100), new ActionFactory.FormatAction(), new ActionFactory.FirstNonWhiteAction(firstNonWhiteAction, false), new ActionFactory.FirstNonWhiteAction(selectionFirstNonWhiteAction, true), new ActionFactory.LastNonWhiteAction(lastNonWhiteAction, false), new ActionFactory.LastNonWhiteAction(selectionLastNonWhiteAction, true), new ActionFactory.SelectIdentifierAction(), new ActionFactory.SelectNextParameterAction(), new ActionFactory.ScrollUpAction(), new ActionFactory.ScrollDownAction(), new ActionFactory.InsertDateTimeAction(), new ActionFactory.GenerateGutterPopupAction(), new ActionFactory.ToggleLineNumbersAction(), new ActionFactory.AnnotationsCyclingAction(), new ActionFactory.CollapseFold(), new ActionFactory.ExpandFold(), new ActionFactory.CollapseAllFolds(), new ActionFactory.ExpandAllFolds(), new ActionFactory.DumpViewHierarchyAction(), new ActionFactory.StartNewLine(), new ActionFactory.CutToLineBeginOrEndAction(false), new ActionFactory.CutToLineBeginOrEndAction(true)};
    }

    protected Action[] getCustomActions() {
        MimePath mimePath = MimePath.parse((String)this.getContentType());
        Preferences preferences = (Preferences)MimeLookup.getLookup((MimePath)mimePath).lookup(Preferences.class);
        List list = (List)SettingsConversions.callFactory(preferences, mimePath, "custom-action-list", null);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("custom-action-list for '" + this.getContentType() + "' {");
            if (list != null) {
                for (Action action : list) {
                    LOG.fine("    " + action);
                }
            }
            LOG.fine("} End of custom-action-list for '" + this.getContentType() + "'");
        }
        return list == null ? null : list.toArray(new Action[list.size()]);
    }

    protected Action[] getMacroActions() {
        return new Action[0];
    }

    @Override
    public final Action[] getActions() {
        return (Action[])this.getActionsAndMap()[0];
    }

    Map<String, Action> getActionMap() {
        return (Map)this.getActionsAndMap()[1];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object[] getActionsAndMap() {
        Object object = KEYMAPS_AND_ACTIONS_LOCK;
        synchronized (object) {
            MimePath mimePath = MimePath.parse((String)this.getContentType());
            Action[] actionArray = kitActions.get(mimePath);
            Map<String, Action> map = kitActionMaps.get(mimePath);
            if (actionArray == null || map == null) {
                actionArray = this.createActions();
                map = BaseKit.actionsToMap(actionArray);
                Action[] actionArray2 = this.getCustomActions();
                if (actionArray2 != null) {
                    map.putAll(BaseKit.actionsToMap(actionArray2));
                    actionArray = map.values().toArray(new Action[map.values().size()]);
                }
                kitActions.put(mimePath, actionArray);
                kitActionMaps.put(mimePath, map);
                this.updateActionSettings(actionArray);
                this.updateActions();
            }
            return new Object[]{actionArray, map};
        }
    }

    protected void updateActions() {
    }

    public Action getActionByName(String string) {
        return string != null ? this.getActionMap().get(string) : null;
    }

    public List<Action> translateActionNameList(List<String> list) {
        ArrayList<Action> arrayList = new ArrayList<Action>();
        if (list != null) {
            for (String string : list) {
                Action action = this.getActionByName(string);
                if (action == null) continue;
                arrayList.add(action);
            }
        }
        return arrayList;
    }

    private class KeybindingsAndPreferencesTracker
    implements LookupListener,
    PreferenceChangeListener {
        private final String mimeType;
        private final Lookup.Result<KeyBindingSettings> lookupResult;
        private final Preferences prefs;
        private final Set<JTextComponent> components = new WeakSet();

        public KeybindingsAndPreferencesTracker(String string) {
            this.mimeType = string;
            Lookup lookup = MimeLookup.getLookup((String)string);
            this.lookupResult = lookup.lookupResult(KeyBindingSettings.class);
            this.lookupResult.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)this, this.lookupResult));
            this.lookupResult.allInstances();
            this.prefs = (Preferences)lookup.lookup(Preferences.class);
            this.prefs.addPreferenceChangeListener((PreferenceChangeListener)WeakListeners.create(PreferenceChangeListener.class, (EventListener)this, (Object)this.prefs));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addComponent(JTextComponent jTextComponent) {
            Object object = KEYMAPS_AND_ACTIONS_LOCK;
            synchronized (object) {
                this.components.add(jTextComponent);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeComponent(JTextComponent jTextComponent) {
            Object object = KEYMAPS_AND_ACTIONS_LOCK;
            synchronized (object) {
                this.components.remove(jTextComponent);
            }
        }

        public void resultChanged(LookupEvent lookupEvent) {
            this.refreshShortcutsAndActions(false);
        }

        public void preferenceChange(PreferenceChangeEvent preferenceChangeEvent) {
            String string;
            String string2 = string = preferenceChangeEvent == null ? null : preferenceChangeEvent.getKey();
            if (string == null || "custom-action-list".equals(string)) {
                this.refreshShortcutsAndActions(true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void refreshShortcutsAndActions(boolean bl) {
            JTextComponent[] jTextComponentArray;
            MultiKeymap multiKeymap;
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("BaseKit.KeymapTracker('" + this.mimeType + "') refreshing keymap " + (bl ? "and actions" : ""));
            }
            JTextComponent[] jTextComponentArray2 = KEYMAPS_AND_ACTIONS_LOCK;
            synchronized (jTextComponentArray2) {
                MimePath mimePath = MimePath.parse((String)this.mimeType);
                if (bl) {
                    kitActions.remove(mimePath);
                    kitActionMaps.remove(mimePath);
                }
                kitKeymaps.remove(mimePath);
                multiKeymap = BaseKit.this.getKeymap();
                jTextComponentArray = this.components.toArray(new JTextComponent[this.components.size()]);
            }
            for (JTextComponent jTextComponent : jTextComponentArray) {
                jTextComponent.setKeymap(multiKeymap);
            }
        }
    }

    static final class DefaultSyntaxTokenContext
    extends TokenContext {
        public static final int TEXT_ID = 1;
        public static final int EOL_ID = 2;
        public static final BaseTokenID TEXT = new BaseTokenID("text", 1);
        public static final BaseImageTokenID EOL = new BaseImageTokenID("EOL", 2, "\n");
        public static final DefaultSyntaxTokenContext CONTEXT = new DefaultSyntaxTokenContext();

        private DefaultSyntaxTokenContext() {
            super("defaultSyntax-token-");
            try {
                this.addDeclaredTokenIDs();
            }
            catch (Exception exception) {
                LOG.log(Level.WARNING, "Can't load token IDs", exception);
            }
        }
    }

    static final class DefaultSyntax
    extends Syntax {
        private static final int ISI_TEXT = 0;

        public DefaultSyntax() {
            this.tokenContextPath = DefaultSyntaxTokenContext.CONTEXT.getContextPath();
        }

        protected TokenID parseToken() {
            while (this.offset < this.stopOffset) {
                char c = this.buffer[this.offset];
                switch (this.state) {
                    case -1: {
                        switch (c) {
                            case '\n': {
                                ++this.offset;
                                return DefaultSyntaxTokenContext.EOL;
                            }
                        }
                        this.state = 0;
                        break;
                    }
                    case 0: {
                        switch (c) {
                            case '\n': {
                                this.state = -1;
                                return DefaultSyntaxTokenContext.TEXT;
                            }
                        }
                    }
                }
                ++this.offset;
            }
            switch (this.state) {
                case 0: {
                    this.state = -1;
                    return DefaultSyntaxTokenContext.TEXT;
                }
            }
            return null;
        }
    }

    public static class RemoveTrailingSpacesAction
    extends LocalBaseAction {
        public RemoveTrailingSpacesAction() {
            super(BaseKit.removeTrailingSpacesAction);
        }

        protected boolean asynchonous() {
            return true;
        }

        public void actionPerformed(ActionEvent actionEvent, final JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                final BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
                baseDocument.runAtomic(new Runnable(){

                    public void run() {
                        try {
                            Element element = baseDocument.getDefaultRootElement();
                            int n = element.getElementCount();
                            boolean bl = false;
                            for (int i = 0; i < n; ++i) {
                                int n2;
                                int n3;
                                Element element2 = element.getElement(i);
                                int n4 = element2.getStartOffset();
                                CharSequence charSequence = DocumentUtilities.getText((Document)baseDocument, (int)n4, (int)((n3 = element2.getEndOffset()) - n4));
                                int n5 = charSequence.length() - 1;
                                if (n5 < 0 || charSequence.charAt(n5) != '\n' || --n5 < 0 || charSequence.charAt(n5) == '\r') {
                                    // empty if block
                                }
                                for (n2 = --n5; n2 >= 0 && Character.isWhitespace(charSequence.charAt(n2)) && charSequence.charAt(n2) != '\n'; --n2) {
                                }
                                if (n2 >= n5) continue;
                                baseDocument.remove(n4 + n2 + 1, n5 - n2);
                                bl = true;
                            }
                            if (bl) {
                                StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(BaseKit.class, (String)"TrailingSpacesWereRemoved_Lbl"));
                            } else {
                                StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(BaseKit.class, (String)"TrailingSpacesWereNotRemoved_Lbl"));
                            }
                        }
                        catch (BadLocationException badLocationException) {
                            badLocationException.printStackTrace();
                            jTextComponent.getToolkit().beep();
                        }
                    }
                });
            }
        }
    }

    public static class SelectAllAction
    extends KitCompoundAction {
        static final long serialVersionUID = -3502499718130556524L;

        public SelectAllAction() {
            super("select-all", new String[]{"caret-begin", "selection-end"});
        }
    }

    public static class SelectLineAction
    extends LocalBaseAction {
        static final long serialVersionUID = -7407681863035740281L;

        public SelectLineAction() {
            super("select-line");
        }

        public void actionPerformed(ActionEvent actionEvent, final JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                final Caret caret = jTextComponent.getCaret();
                final BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
                baseDocument.runAtomicAsUser(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        DocumentUtilities.setTypingModification((Document)baseDocument, (boolean)true);
                        try {
                            int n = caret.getDot();
                            int n2 = Utilities.getRowStart(jTextComponent, n);
                            int n3 = Utilities.getRowEnd(jTextComponent, n);
                            n3 = Math.min(n3 + 1, baseDocument.getLength());
                            caret.setDot(n2);
                            caret.moveDot(n3);
                        }
                        catch (BadLocationException badLocationException) {
                            jTextComponent.getToolkit().beep();
                        }
                        finally {
                            DocumentUtilities.setTypingModification((Document)baseDocument, (boolean)false);
                        }
                    }
                });
            }
        }
    }

    public static class SelectWordAction
    extends KitCompoundAction {
        static final long serialVersionUID = 7678848538073016357L;

        public SelectWordAction() {
            super("select-word", new String[]{"caret-begin-word", "selection-end-word"});
        }
    }

    public static class EndWordAction
    extends LocalBaseAction {
        boolean select;
        static final long serialVersionUID = 3812523676620144633L;

        public EndWordAction(String string, boolean bl) {
            super(string, 62);
            this.select = bl;
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                Caret caret = jTextComponent.getCaret();
                try {
                    int n = Utilities.getWordEnd(jTextComponent, caret.getDot());
                    if (this.select) {
                        caret.moveDot(n);
                    } else {
                        caret.setDot(n);
                    }
                }
                catch (BadLocationException badLocationException) {
                    jTextComponent.getToolkit().beep();
                }
            }
        }
    }

    public static class BeginWordAction
    extends LocalBaseAction {
        boolean select;
        static final long serialVersionUID = 3991338381212491110L;

        public BeginWordAction(String string, boolean bl) {
            super(string, 62);
            this.select = bl;
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                Caret caret = jTextComponent.getCaret();
                try {
                    int n = Utilities.getWordStart(jTextComponent, caret.getDot());
                    if (this.select) {
                        caret.moveDot(n);
                    } else {
                        caret.setDot(n);
                    }
                }
                catch (BadLocationException badLocationException) {
                    jTextComponent.getToolkit().beep();
                }
            }
        }
    }

    public static class PreviousWordAction
    extends LocalBaseAction {
        boolean select;
        static final long serialVersionUID = -5465143382669785799L;

        public PreviousWordAction(String string, boolean bl) {
            super(string, 62);
            this.select = bl;
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                Caret caret = jTextComponent.getCaret();
                try {
                    int n = Utilities.getPreviousWord(jTextComponent, caret.getDot());
                    if (caret instanceof BaseCaret) {
                        BaseCaret baseCaret = (BaseCaret)caret;
                        if (this.select) {
                            baseCaret.moveDot(n);
                        } else {
                            baseCaret.setDot(n, false);
                        }
                    } else if (this.select) {
                        caret.moveDot(n);
                    } else {
                        caret.setDot(n);
                    }
                }
                catch (BadLocationException badLocationException) {
                    jTextComponent.getToolkit().beep();
                }
            }
        }
    }

    public static class NextWordAction
    extends LocalBaseAction {
        boolean select;
        static final long serialVersionUID = -5909906947175434032L;

        public NextWordAction(String string, boolean bl) {
            super(string, 62);
            this.select = bl;
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                Caret caret = jTextComponent.getCaret();
                try {
                    int n = caret.getDot();
                    n = Utilities.getNextWord(jTextComponent, n);
                    if (caret instanceof BaseCaret) {
                        BaseCaret baseCaret = (BaseCaret)caret;
                        if (this.select) {
                            baseCaret.moveDot(n);
                        } else {
                            baseCaret.setDot(n, false);
                        }
                    } else if (this.select) {
                        caret.moveDot(n);
                    } else {
                        caret.setDot(n);
                    }
                }
                catch (BadLocationException badLocationException) {
                    jTextComponent.getToolkit().beep();
                }
            }
        }
    }

    public static class EndAction
    extends LocalBaseAction {
        boolean select;
        static final long serialVersionUID = 8547506353130203657L;

        public EndAction(String string, boolean bl) {
            super(string, 190);
            this.select = bl;
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                Caret caret = jTextComponent.getCaret();
                int n = jTextComponent.getDocument().getLength();
                if (this.select) {
                    caret.moveDot(n);
                } else {
                    caret.setDot(n);
                }
            }
        }
    }

    public static class BeginAction
    extends LocalBaseAction {
        boolean select;
        static final long serialVersionUID = 3463563396210234361L;

        public BeginAction(String string, boolean bl) {
            super(string, 190);
            this.select = bl;
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                Caret caret = jTextComponent.getCaret();
                int n = 0;
                if (this.select) {
                    caret.moveDot(n);
                } else {
                    caret.setDot(n);
                }
            }
        }
    }

    public static class EndLineAction
    extends LocalBaseAction {
        protected boolean select;
        static final long serialVersionUID = 5216077634055190170L;

        public EndLineAction(String string, boolean bl) {
            super(string, 62);
            this.select = bl;
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                Caret caret = jTextComponent.getCaret();
                try {
                    int n = Utilities.getRowEnd(jTextComponent, caret.getDot());
                    if (this.select) {
                        caret.moveDot(n);
                    } else {
                        caret.setDot(n);
                    }
                    Rectangle rectangle = jTextComponent.modelToView(n);
                    if (rectangle != null) {
                        Point point = new Point(0x7FFFFFFE, rectangle.y);
                        caret.setMagicCaretPosition(point);
                    }
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace();
                    jTextComponent.getToolkit().beep();
                }
            }
        }
    }

    public static class BeginLineAction
    extends LocalBaseAction {
        protected boolean select;
        boolean homeKeyColumnOne;
        static final long serialVersionUID = 3269462923524077779L;

        public BeginLineAction(String string, boolean bl) {
            super(string, 62);
            this.select = bl;
            this.homeKeyColumnOne = false;
        }

        public BeginLineAction(String string, boolean bl, boolean bl2) {
            this(string, bl);
            this.homeKeyColumnOne = bl2;
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                Caret caret = jTextComponent.getCaret();
                BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
                try {
                    int n = caret.getDot();
                    int n2 = Utilities.getRowStart(jTextComponent, n);
                    if (this.homeKeyColumnOne) {
                        n = n2;
                    } else {
                        int n3 = Utilities.getRowFirstNonWhite(baseDocument, n2);
                        if (n3 < 0) {
                            n3 = Utilities.getRowEnd(jTextComponent, n2);
                        }
                        n = n == n2 ? n3 : (n <= n3 ? n2 : n3);
                    }
                    if (this.select) {
                        caret.moveDot(n);
                    } else {
                        caret.setDot(n);
                    }
                }
                catch (BadLocationException badLocationException) {
                    jTextComponent.getToolkit().beep();
                }
            }
        }
    }

    public static class BackwardAction
    extends LocalBaseAction {
        boolean select;
        static final long serialVersionUID = -3048379822817847356L;

        public BackwardAction(String string, boolean bl) {
            super(string, 62);
            this.select = bl;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent == null) return;
            Caret caret = jTextComponent.getCaret();
            try {
                int n;
                if (!this.select && Utilities.isSelectionShowing(caret)) {
                    n = jTextComponent.getSelectionStart();
                    if (n == caret.getDot()) {
                        caret.setDot(n);
                        return;
                    }
                    ++n;
                } else {
                    n = caret.getDot();
                }
                int n2 = jTextComponent.getUI().getNextVisualPositionFrom(jTextComponent, n, Position.Bias.Backward, 7, null);
                if (this.select) {
                    caret.moveDot(n2);
                    return;
                }
                caret.setDot(n2);
                return;
            }
            catch (BadLocationException badLocationException) {
                jTextComponent.getToolkit().beep();
            }
        }
    }

    public static class PageDownAction
    extends LocalBaseAction {
        boolean select;
        static final long serialVersionUID = 8942534850985048862L;

        public PageDownAction(String string, boolean bl) {
            super(string, 60);
            this.select = bl;
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                try {
                    Rectangle rectangle;
                    int n;
                    Rectangle rectangle2;
                    Caret caret = jTextComponent.getCaret();
                    BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
                    int n2 = caret.getDot();
                    Rectangle rectangle3 = ((BaseTextUI)jTextComponent.getUI()).modelToView(jTextComponent, n2);
                    if (rectangle3 == null) {
                        return;
                    }
                    Point point = caret.getMagicCaretPosition();
                    if (point == null) {
                        point = new Point(rectangle3.x, rectangle3.y);
                    }
                    if ((rectangle2 = jTextComponent.getVisibleRect()).contains(rectangle3)) {
                        Rectangle rectangle4 = new Rectangle(rectangle2);
                        int n3 = jTextComponent.viewToModel(new Point(rectangle2.x, rectangle2.y + rectangle2.height));
                        Rectangle rectangle5 = jTextComponent.modelToView(n3);
                        rectangle4.y = rectangle5.y;
                        int n4 = rectangle3.y - rectangle2.y;
                        int n5 = rectangle4.y + n4;
                        n = jTextComponent.viewToModel(new Point(point.x, n5));
                        rectangle = jTextComponent.modelToView(n);
                        if (rectangle.y > n5) {
                            n = jTextComponent.viewToModel(new Point(point.x, rectangle.y - rectangle.height));
                            rectangle = jTextComponent.modelToView(n);
                        }
                        rectangle4.y = rectangle.y - n4;
                        jTextComponent.scrollRectToVisible(rectangle4);
                    } else {
                        Point point2 = new Point(point.x, rectangle3.y + rectangle2.height);
                        n = jTextComponent.viewToModel(point2);
                        rectangle = jTextComponent.modelToView(n);
                    }
                    if (this.select) {
                        caret.moveDot(n);
                    } else {
                        caret.setDot(n);
                    }
                    point.y = rectangle.y;
                    caret.setMagicCaretPosition(point);
                }
                catch (BadLocationException badLocationException) {
                    jTextComponent.getToolkit().beep();
                }
            }
        }
    }

    public static class ForwardAction
    extends LocalBaseAction {
        boolean select;
        static final long serialVersionUID = 8007293230193334414L;

        public ForwardAction(String string, boolean bl) {
            super(string, 62);
            this.select = bl;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent == null) return;
            Caret caret = jTextComponent.getCaret();
            try {
                int n;
                if (!this.select && Utilities.isSelectionShowing(caret)) {
                    n = jTextComponent.getSelectionEnd();
                    if (n == caret.getDot()) {
                        caret.setDot(n);
                        return;
                    }
                    --n;
                } else {
                    n = caret.getDot();
                }
                int n2 = jTextComponent.getUI().getNextVisualPositionFrom(jTextComponent, n, Position.Bias.Forward, 3, null);
                if (this.select) {
                    caret.moveDot(n2);
                    return;
                }
                caret.setDot(n2);
                return;
            }
            catch (BadLocationException badLocationException) {
                jTextComponent.getToolkit().beep();
            }
        }
    }

    public static class PageUpAction
    extends LocalBaseAction {
        boolean select;
        static final long serialVersionUID = -3107382148581661079L;

        public PageUpAction(String string, boolean bl) {
            super(string, 60);
            this.select = bl;
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                try {
                    Rectangle rectangle;
                    int n;
                    Rectangle rectangle2;
                    Caret caret = jTextComponent.getCaret();
                    BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
                    int n2 = caret.getDot();
                    Rectangle rectangle3 = ((BaseTextUI)jTextComponent.getUI()).modelToView(jTextComponent, n2);
                    if (rectangle3 == null) {
                        return;
                    }
                    Point point = caret.getMagicCaretPosition();
                    if (point == null) {
                        point = new Point(rectangle3.x, rectangle3.y);
                    }
                    if ((rectangle2 = jTextComponent.getVisibleRect()).contains(rectangle3)) {
                        Rectangle rectangle4 = new Rectangle(rectangle2);
                        int n3 = jTextComponent.viewToModel(new Point(rectangle2.x, rectangle2.y));
                        Rectangle rectangle5 = jTextComponent.modelToView(n3);
                        if (rectangle5.y != rectangle2.y) {
                            rectangle4.y = rectangle5.y + rectangle5.height;
                        }
                        rectangle4.y -= rectangle2.height;
                        int n4 = rectangle3.y - rectangle2.y;
                        int n5 = rectangle4.y + n4;
                        n = jTextComponent.viewToModel(new Point(point.x, n5));
                        rectangle = jTextComponent.modelToView(n);
                        if (rectangle.y < n5) {
                            n = jTextComponent.viewToModel(new Point(point.x, rectangle.y + rectangle.height));
                            rectangle = jTextComponent.modelToView(n);
                        }
                        rectangle4.y = rectangle.y - n4;
                        jTextComponent.scrollRectToVisible(rectangle4);
                    } else {
                        Point point2 = new Point(point.x, rectangle3.y - rectangle2.height);
                        n = jTextComponent.viewToModel(point2);
                        rectangle = jTextComponent.modelToView(n);
                    }
                    if (this.select) {
                        caret.moveDot(n);
                    } else {
                        caret.setDot(n);
                    }
                    point.y = rectangle.y;
                    caret.setMagicCaretPosition(point);
                }
                catch (BadLocationException badLocationException) {
                    jTextComponent.getToolkit().beep();
                }
            }
        }
    }

    public static class DownAction
    extends LocalBaseAction {
        boolean select;
        static final long serialVersionUID = -5635702355125266822L;

        public DownAction(String string, boolean bl) {
            super(string, 60);
            this.select = bl;
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            block9: {
                if (jTextComponent != null) {
                    try {
                        Caret caret = jTextComponent.getCaret();
                        int n = caret.getDot();
                        Point point = caret.getMagicCaretPosition();
                        if (point == null) {
                            Rectangle rectangle = jTextComponent.modelToView(n);
                            if (rectangle != null) {
                                point = new Point(rectangle.x, rectangle.y);
                                caret.setMagicCaretPosition(point);
                            } else {
                                return;
                            }
                        }
                        try {
                            n = Utilities.getPositionBelow(jTextComponent, n, point.x);
                            if (this.select) {
                                caret.moveDot(n);
                                break block9;
                            }
                            caret.setDot(n);
                        }
                        catch (BadLocationException badLocationException) {}
                    }
                    catch (BadLocationException badLocationException) {
                        jTextComponent.getToolkit().beep();
                    }
                }
            }
        }
    }

    public static class UpAction
    extends LocalBaseAction {
        boolean select;
        static final long serialVersionUID = 4621760742646981563L;

        public UpAction(String string, boolean bl) {
            super(string, 60);
            this.select = bl;
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            block9: {
                if (jTextComponent != null) {
                    try {
                        Caret caret = jTextComponent.getCaret();
                        int n = caret.getDot();
                        Point point = caret.getMagicCaretPosition();
                        if (point == null) {
                            Rectangle rectangle = jTextComponent.modelToView(n);
                            if (rectangle != null) {
                                point = new Point(rectangle.x, rectangle.y);
                                caret.setMagicCaretPosition(point);
                            } else {
                                return;
                            }
                        }
                        try {
                            n = Utilities.getPositionAbove(jTextComponent, n, point.x);
                            if (this.select) {
                                caret.moveDot(n);
                                break block9;
                            }
                            caret.setDot(n);
                        }
                        catch (BadLocationException badLocationException) {}
                    }
                    catch (BadLocationException badLocationException) {
                        jTextComponent.getToolkit().beep();
                    }
                }
            }
        }
    }

    public static class BeepAction
    extends LocalBaseAction {
        static final long serialVersionUID = -4474054576633223968L;

        public BeepAction() {
            super("beep");
            this.putValue("no-keybinding", Boolean.TRUE);
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                jTextComponent.getToolkit().beep();
            }
        }
    }

    public static class PasteAction
    extends LocalBaseAction {
        static final long serialVersionUID = 5839791453996432149L;
        private boolean formatted;

        public PasteAction(boolean bl) {
            super(bl ? BaseKit.pasteFormatedAction : "paste-from-clipboard", 28);
            this.formatted = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent actionEvent, final JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                if (!jTextComponent.isEditable() || !jTextComponent.isEnabled()) {
                    jTextComponent.getToolkit().beep();
                    return;
                }
                final BaseDocument baseDocument = Utilities.getDocument(jTextComponent);
                if (baseDocument == null) {
                    return;
                }
                try {
                    NavigationHistory.getEdits().markWaypoint(jTextComponent, jTextComponent.getCaret().getDot(), false, true);
                }
                catch (BadLocationException badLocationException) {
                    LOG.log(Level.WARNING, "Can't add position to the history of edits.", badLocationException);
                }
                final Formatter formatter = baseDocument.getFormatter();
                if (this.formatted) {
                    formatter.reformatLock();
                }
                try {
                    baseDocument.runAtomicAsUser(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            DocumentUtilities.setTypingModification((Document)baseDocument, (boolean)true);
                            try {
                                Caret caret = jTextComponent.getCaret();
                                int n = jTextComponent.getSelectionStart();
                                IN_PASTE.set(true);
                                try {
                                    jTextComponent.paste();
                                }
                                finally {
                                    IN_PASTE.set(false);
                                }
                                int n2 = caret.getDot();
                                if (PasteAction.this.formatted) {
                                    formatter.reformat(baseDocument, n, n2);
                                }
                            }
                            catch (Exception exception) {
                                jTextComponent.getToolkit().beep();
                            }
                            finally {
                                DocumentUtilities.setTypingModification((Document)baseDocument, (boolean)false);
                            }
                        }
                    });
                }
                finally {
                    if (this.formatted) {
                        formatter.reformatUnlock();
                    }
                }
            }
        }

        public static void indentBlock(BaseDocument baseDocument, int n, int n2) throws BadLocationException {
            char[] cArray = baseDocument.getChars(n, n2 - n);
            String[] stringArray = PasteAction.toLines(new String(cArray));
            baseDocument.remove(n, n2 - n);
            int n3 = n;
            for (int i = 0; i < stringArray.length - 1; ++i) {
                String string = PasteAction.getIndentString(baseDocument, n3, stringArray[i]);
                String string2 = string + stringArray[i].trim() + '\n';
                baseDocument.insertString(n3, string2, null);
                n3 += string2.length();
            }
            baseDocument.insertString(n3, stringArray[stringArray.length - 1], null);
        }

        private static String[] toLines(String string) {
            Vector<String> vector = new Vector<String>();
            int n = 0;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) != '\n') continue;
                vector.add(string.substring(n, i + 1));
                n = i + 1;
            }
            if (n < string.length()) {
                vector.add(string.substring(n, string.length()));
            } else {
                vector.add("");
            }
            return vector.toArray(new String[0]);
        }

        private static String getIndentString(BaseDocument baseDocument, int n, String string) {
            try {
                int n2;
                Formatter formatter = baseDocument.getFormatter();
                CharArrayWriter charArrayWriter = new CharArrayWriter();
                Writer writer = formatter.createWriter(baseDocument, n, charArrayWriter);
                writer.write(string, 0, string.length());
                writer.close();
                String string2 = new String(charArrayWriter.toCharArray());
                for (n2 = 0; n2 < string2.length() && (string2.charAt(n2) == ' ' || string2.charAt(n2) == '\t'); ++n2) {
                }
                return string2.substring(0, n2);
            }
            catch (IOException iOException) {
                return "";
            }
        }
    }

    public static class CopyAction
    extends LocalBaseAction {
        static final long serialVersionUID = -5119779005431986964L;

        public CopyAction() {
            super("copy-to-clipboard", 28);
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                try {
                    if (!Utilities.isSelectionShowing(jTextComponent)) {
                        Element element = ((AbstractDocument)jTextComponent.getDocument()).getParagraphElement(jTextComponent.getCaretPosition());
                        if (!Utilities.isRowWhite((BaseDocument)jTextComponent.getDocument(), element.getStartOffset())) {
                            jTextComponent.select(element.getStartOffset(), element.getEndOffset());
                        }
                    }
                    jTextComponent.copy();
                }
                catch (BadLocationException badLocationException) {
                    LOG.log(Level.FINE, null, badLocationException);
                }
            }
        }
    }

    public static class CutAction
    extends LocalBaseAction {
        static final long serialVersionUID = 6377157040901778853L;

        public CutAction() {
            super("cut-to-clipboard", 28);
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent, final JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                if (!jTextComponent.isEditable() || !jTextComponent.isEnabled()) {
                    jTextComponent.getToolkit().beep();
                    return;
                }
                try {
                    NavigationHistory.getEdits().markWaypoint(jTextComponent, jTextComponent.getCaret().getDot(), false, true);
                }
                catch (BadLocationException badLocationException) {
                    LOG.log(Level.WARNING, "Can't add position to the history of edits.", badLocationException);
                }
                final BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
                baseDocument.runAtomicAsUser(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        DocumentUtilities.setTypingModification((Document)baseDocument, (boolean)true);
                        try {
                            if (!Utilities.isSelectionShowing(jTextComponent)) {
                                Element element = ((AbstractDocument)jTextComponent.getDocument()).getParagraphElement(jTextComponent.getCaretPosition());
                                jTextComponent.select(element.getStartOffset(), element.getEndOffset());
                            }
                            jTextComponent.cut();
                        }
                        finally {
                            DocumentUtilities.setTypingModification((Document)baseDocument, (boolean)false);
                        }
                    }
                });
            }
        }
    }

    public static class WritableAction
    extends LocalBaseAction {
        static final long serialVersionUID = -5982547952800937954L;

        public WritableAction() {
            super("set-writable");
            this.putValue("no-keybinding", Boolean.TRUE);
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                jTextComponent.setEditable(true);
            }
        }
    }

    public static class ReadOnlyAction
    extends LocalBaseAction {
        static final long serialVersionUID = 9204335480208463193L;

        public ReadOnlyAction() {
            super("set-read-only");
            this.putValue("no-keybinding", Boolean.TRUE);
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                jTextComponent.setEditable(false);
            }
        }
    }

    public static class DeleteCharAction
    extends LocalBaseAction {
        protected boolean nextChar;
        static final long serialVersionUID = -4321971925753148556L;

        public DeleteCharAction(String string, boolean bl) {
            super(string, 22);
            this.nextChar = bl;
        }

        public void actionPerformed(ActionEvent actionEvent, final JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                if (!jTextComponent.isEditable() || !jTextComponent.isEnabled()) {
                    jTextComponent.getToolkit().beep();
                    return;
                }
                final BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
                final Caret caret = jTextComponent.getCaret();
                final int n = caret.getDot();
                final int n2 = caret.getMark();
                baseDocument.runAtomicAsUser(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        DocumentUtilities.setTypingModification((Document)baseDocument, (boolean)true);
                        try {
                            if (n != n2) {
                                baseDocument.remove(Math.min(n, n2), Math.abs(n - n2));
                            } else if (DeleteCharAction.this.nextChar) {
                                char c = baseDocument.getChars(n, 1)[0];
                                baseDocument.remove(n, 1);
                                DeleteCharAction.this.charDeleted(baseDocument, n, caret, c);
                            } else {
                                char c = baseDocument.getChars(n - 1, 1)[0];
                                baseDocument.remove(n - 1, 1);
                                DeleteCharAction.this.charBackspaced(baseDocument, n - 1, caret, c);
                            }
                        }
                        catch (BadLocationException badLocationException) {
                            jTextComponent.getToolkit().beep();
                        }
                        finally {
                            DocumentUtilities.setTypingModification((Document)baseDocument, (boolean)false);
                        }
                    }
                });
            }
        }

        protected void charBackspaced(BaseDocument baseDocument, int n, Caret caret, char c) throws BadLocationException {
        }

        protected void charDeleted(BaseDocument baseDocument, int n, Caret caret, char c) throws BadLocationException {
        }
    }

    public static class InsertStringAction
    extends LocalBaseAction {
        String text;
        static final long serialVersionUID = -2755852016584693328L;

        public InsertStringAction(String string, String string2) {
            super(string, 22);
            this.text = string2;
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                if (!jTextComponent.isEditable() || !jTextComponent.isEnabled()) {
                    jTextComponent.getToolkit().beep();
                    return;
                }
                jTextComponent.replaceSelection(this.text);
            }
        }
    }

    public static class InsertContentAction
    extends LocalBaseAction {
        static final long serialVersionUID = 5647751370952797218L;

        public InsertContentAction() {
            super("insert-content", 22);
            this.putValue("no-keybinding", Boolean.TRUE);
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null && actionEvent != null) {
                if (!jTextComponent.isEditable() || !jTextComponent.isEnabled()) {
                    jTextComponent.getToolkit().beep();
                    return;
                }
                String string = actionEvent.getActionCommand();
                if (string != null) {
                    jTextComponent.replaceSelection(string);
                } else {
                    jTextComponent.getToolkit().beep();
                }
            }
        }
    }

    public static class KitCompoundAction
    extends LocalBaseAction {
        private String[] actionNames;
        static final long serialVersionUID = 8415246475764264835L;

        public KitCompoundAction(String string, String[] stringArray) {
            this(string, 0, stringArray);
        }

        public KitCompoundAction(String string, int n, String[] stringArray) {
            super(string, n);
            this.actionNames = stringArray;
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            BaseKit baseKit;
            if (jTextComponent != null && (baseKit = Utilities.getKit(jTextComponent)) != null) {
                for (int i = 0; i < this.actionNames.length; ++i) {
                    Action action = baseKit.getActionByName(this.actionNames[i]);
                    if (action == null) continue;
                    if (action instanceof BaseAction) {
                        ((BaseAction)action).actionPerformed(actionEvent, jTextComponent);
                        continue;
                    }
                    action.actionPerformed(actionEvent);
                }
            }
        }
    }

    public static class CompoundAction
    extends LocalBaseAction {
        Action[] actions;
        static final long serialVersionUID = 1649688300969753758L;

        public CompoundAction(String string, Action[] actionArray) {
            this(string, 0, actionArray);
        }

        public CompoundAction(String string, int n, Action[] actionArray) {
            super(string, n);
            this.actions = actionArray;
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                for (int i = 0; i < this.actions.length; ++i) {
                    Action action = this.actions[i];
                    if (action instanceof BaseAction) {
                        ((BaseAction)action).actionPerformed(actionEvent, jTextComponent);
                        continue;
                    }
                    action.actionPerformed(actionEvent);
                }
            }
        }
    }

    public static class InsertTabAction
    extends LocalBaseAction {
        static final long serialVersionUID = -3379768531715989243L;

        public InsertTabAction() {
            super("insert-tab", 22);
        }

        public void actionPerformed(ActionEvent actionEvent, final JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                if (!jTextComponent.isEditable() || !jTextComponent.isEnabled()) {
                    jTextComponent.getToolkit().beep();
                    return;
                }
                final Caret caret = jTextComponent.getCaret();
                final BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
                baseDocument.runAtomicAsUser(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        block14: {
                            DocumentUtilities.setTypingModification((Document)baseDocument, (boolean)true);
                            Formatter.pushFormattingContextDocument(baseDocument);
                            try {
                                int n;
                                if (Utilities.isSelectionShowing(caret)) {
                                    try {
                                        baseDocument.getFormatter().changeBlockIndent(baseDocument, jTextComponent.getSelectionStart(), jTextComponent.getSelectionEnd(), 1);
                                    }
                                    catch (GuardedException guardedException) {
                                        jTextComponent.getToolkit().beep();
                                    }
                                    catch (BadLocationException badLocationException) {
                                        badLocationException.printStackTrace();
                                    }
                                    break block14;
                                }
                                int n2 = caret.getDot();
                                try {
                                    n = baseDocument.getVisColFromPos(n2);
                                }
                                catch (BadLocationException badLocationException) {
                                    LOG.log(Level.WARNING, null, badLocationException);
                                    n = 0;
                                }
                                try {
                                    int n3;
                                    int n4 = Utilities.getRowIndent(baseDocument, n2, false);
                                    if (n4 == -1) {
                                        n4 = 0;
                                    }
                                    if ((n3 = Utilities.getRowIndent(baseDocument, n2)) == -1) {
                                        n3 = n4 > n ? n4 : Utilities.getNextTabColumn(baseDocument, n2);
                                        int n5 = Utilities.getRowStart(baseDocument, n2);
                                        baseDocument.getFormatter().changeRowIndent(baseDocument, n2, n3);
                                        int n6 = baseDocument.getOffsetFromVisCol(n3, n5);
                                        if (n6 >= 0) {
                                            caret.setDot(n6);
                                        }
                                        break block14;
                                    }
                                    baseDocument.getFormatter().insertTabString(baseDocument, n2);
                                }
                                catch (BadLocationException badLocationException) {
                                    // empty catch block
                                }
                            }
                            finally {
                                Formatter.popFormattingContextDocument(baseDocument);
                                DocumentUtilities.setTypingModification((Document)baseDocument, (boolean)false);
                            }
                        }
                    }
                });
            }
        }
    }

    public static class SplitLineAction
    extends LocalBaseAction {
        static final long serialVersionUID = 7966576342334158659L;

        public SplitLineAction() {
            super(BaseKit.splitLineAction, 22);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent actionEvent, final JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                if (!jTextComponent.isEditable() || !jTextComponent.isEnabled()) {
                    jTextComponent.getToolkit().beep();
                    return;
                }
                final BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
                final Caret caret = jTextComponent.getCaret();
                final Formatter formatter = baseDocument.getFormatter();
                formatter.indentLock();
                try {
                    baseDocument.runAtomicAsUser(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            DocumentUtilities.setTypingModification((Document)baseDocument, (boolean)true);
                            try {
                                jTextComponent.replaceSelection("");
                                int n = caret.getDot();
                                formatter.indentNewLine(baseDocument, n);
                                caret.setDot(n);
                            }
                            finally {
                                DocumentUtilities.setTypingModification((Document)baseDocument, (boolean)false);
                            }
                        }
                    });
                }
                finally {
                    formatter.indentUnlock();
                }
            }
        }
    }

    public static class InsertBreakAction
    extends LocalBaseAction {
        static final long serialVersionUID = 7966576342334158659L;

        public InsertBreakAction() {
            super("insert-break", 22);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent actionEvent, final JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                if (!jTextComponent.isEditable() || !jTextComponent.isEnabled()) {
                    jTextComponent.getToolkit().beep();
                    return;
                }
                final BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
                final Formatter formatter = baseDocument.getFormatter();
                formatter.indentLock();
                try {
                    baseDocument.runAtomicAsUser(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            DocumentUtilities.setTypingModification((Document)baseDocument, (boolean)true);
                            try {
                                jTextComponent.replaceSelection("");
                                Caret caret = jTextComponent.getCaret();
                                Object object = InsertBreakAction.this.beforeBreak(jTextComponent, baseDocument, caret);
                                int n = caret.getDot();
                                int n2 = formatter.indentNewLine(baseDocument, n);
                                caret.setDot(n2);
                                InsertBreakAction.this.afterBreak(jTextComponent, baseDocument, caret, object);
                            }
                            finally {
                                DocumentUtilities.setTypingModification((Document)baseDocument, (boolean)false);
                            }
                        }
                    });
                }
                finally {
                    formatter.indentUnlock();
                }
            }
        }

        protected Object beforeBreak(JTextComponent jTextComponent, BaseDocument baseDocument, Caret caret) {
            return null;
        }

        protected void afterBreak(JTextComponent jTextComponent, BaseDocument baseDocument, Caret caret, Object object) {
        }
    }

    public static class DefaultKeyTypedAction
    extends LocalBaseAction {
        static final long serialVersionUID = 3069164318144463899L;
        private static final boolean isMac = System.getProperty("mrj.version") != null;

        public DefaultKeyTypedAction() {
            super("default-typed", 34);
            this.putValue("no-keybinding", Boolean.TRUE);
            LOG.fine("DefaultKeyTypedAction with enhanced logging, see issue #145306");
        }

        public void actionPerformed(ActionEvent actionEvent, final JTextComponent jTextComponent) {
            if (jTextComponent != null && actionEvent != null) {
                boolean bl;
                boolean bl2;
                int n = actionEvent.getModifiers();
                boolean bl3 = bl2 = (n & 2) != 0;
                boolean bl4 = isMac ? (n & 4) != 0 : (bl = (n & 8) != 0);
                if (bl || bl2) {
                    return;
                }
                if (!jTextComponent.isEditable() || !jTextComponent.isEnabled()) {
                    jTextComponent.getToolkit().beep();
                    return;
                }
                final Caret caret = jTextComponent.getCaret();
                final BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
                final EditorUI editorUI = Utilities.getEditorUI(jTextComponent);
                final String string = actionEvent.getActionCommand();
                if (string != null && string.length() == 1) {
                    try {
                        NavigationHistory.getEdits().markWaypoint(jTextComponent, caret.getDot(), false, true);
                    }
                    catch (BadLocationException badLocationException) {
                        LOG.log(Level.WARNING, "Can't add position to the history of edits.", badLocationException);
                    }
                    baseDocument.runAtomicAsUser(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            DocumentUtilities.setTypingModification((Document)baseDocument, (boolean)true);
                            try {
                                block12: {
                                    char c = string.charAt(0);
                                    if (c >= ' ' && c != '\u007f') {
                                        LOG.fine("Processing command char: " + Integer.toHexString(c));
                                        editorUI.getWordMatch().clear();
                                        Boolean bl = (Boolean)editorUI.getProperty("overwriteMode");
                                        try {
                                            boolean bl2 = true;
                                            if (!bl2) break block12;
                                            if (Utilities.isSelectionShowing(caret)) {
                                                boolean bl3 = bl != null && bl != false;
                                                try {
                                                    baseDocument.putProperty(BaseKit.DOC_REPLACE_SELECTION_PROPERTY, true);
                                                    DefaultKeyTypedAction.this.replaceSelection(jTextComponent, caret.getDot(), caret, string, bl3);
                                                    break block12;
                                                }
                                                finally {
                                                    baseDocument.putProperty(BaseKit.DOC_REPLACE_SELECTION_PROPERTY, null);
                                                }
                                            }
                                            int n = caret.getDot();
                                            if (bl != null && bl.booleanValue() && n < baseDocument.getLength() && baseDocument.getChars(n, 1)[0] != '\n') {
                                                DefaultKeyTypedAction.this.insertString(baseDocument, n, caret, string, true);
                                                break block12;
                                            }
                                            DefaultKeyTypedAction.this.insertString(baseDocument, n, caret, string, false);
                                        }
                                        catch (BadLocationException badLocationException) {
                                            LOG.log(Level.FINE, null, badLocationException);
                                            jTextComponent.getToolkit().beep();
                                        }
                                    } else {
                                        LOG.fine("Invalid command char: " + Integer.toHexString(c));
                                    }
                                }
                                DefaultKeyTypedAction.this.checkIndent(jTextComponent, string);
                            }
                            finally {
                                DocumentUtilities.setTypingModification((Document)baseDocument, (boolean)false);
                            }
                        }
                    });
                } else if (LOG.isLoggable(Level.FINE)) {
                    StringBuilder stringBuilder = new StringBuilder();
                    for (int i = 0; i < string.length(); ++i) {
                        String string2 = Integer.toHexString(string.charAt(i));
                        stringBuilder.append(string2);
                        if (i + 1 >= string.length()) continue;
                        stringBuilder.append(" ");
                    }
                    LOG.fine("Invalid command: '" + stringBuilder + "'");
                }
            }
        }

        protected void insertString(BaseDocument baseDocument, int n, Caret caret, String string, boolean bl) throws BadLocationException {
            if (bl) {
                baseDocument.remove(n, 1);
            }
            baseDocument.insertString(n, string, null);
        }

        protected void replaceSelection(JTextComponent jTextComponent, int n, Caret caret, String string, boolean bl) throws BadLocationException {
            jTextComponent.replaceSelection(string);
        }

        protected void checkIndent(JTextComponent jTextComponent, String string) {
        }
    }
}

