/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.sheet.properties.style;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.sheet.Tag;
import com.jaspersoft.ireport.designer.sheet.editors.ComboBoxPropertyEditor;
import com.jaspersoft.ireport.designer.undo.ObjectPropertyUndoableEdit;
import com.jaspersoft.ireport.locale.I18n;
import java.beans.PropertyEditor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import net.sf.jasperreports.engine.base.JRBaseStyle;
import net.sf.jasperreports.engine.type.RotationEnum;
import org.openide.nodes.PropertySupport;

public final class RotationProperty
extends PropertySupport {
    private final JRBaseStyle style;
    private ComboBoxPropertyEditor editor;

    public RotationProperty(JRBaseStyle style) {
        super("rotation", RotationEnum.class, I18n.getString("AbstractStyleNode.Property.Rotation"), I18n.getString("AbstractStyleNode.Property.RotationDetail"), true, true);
        this.style = style;
        this.setValue("suppressCustomEditor", Boolean.TRUE);
    }

    public PropertyEditor getPropertyEditor() {
        if (this.editor == null) {
            ArrayList<Tag> l = new ArrayList<Tag>();
            l.add(new Tag(null, "<Default>"));
            l.add(new Tag(RotationEnum.NONE, I18n.getString("AbstractStyleNode.Property.None")));
            l.add(new Tag(RotationEnum.LEFT, I18n.getString("AbstractStyleNode.Property.Left")));
            l.add(new Tag(RotationEnum.RIGHT, I18n.getString("AbstractStyleNode.Property.Right")));
            l.add(new Tag(RotationEnum.UPSIDE_DOWN, I18n.getString("AbstractStyleNode.Property.Upside_Down")));
            this.editor = new ComboBoxPropertyEditor(false, l);
        }
        return this.editor;
    }

    public Object getValue() throws IllegalAccessException, InvocationTargetException {
        return this.style.getRotationValue();
    }

    public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        this.setPropertyValue(val);
    }

    private void setPropertyValue(Object val) {
        if (val == null || val instanceof RotationEnum) {
            RotationEnum oldValue = this.style.getOwnRotationValue();
            RotationEnum newValue = (RotationEnum)val;
            this.style.setRotation(newValue);
            ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.style, "Rotation", RotationEnum.class, oldValue, newValue);
            IReportManager.getInstance().addUndoableEdit(urob);
        }
    }

    public boolean isDefaultValue() {
        return this.style.getOwnRotationValue() == null;
    }

    public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
        this.setValue(null);
    }

    public boolean supportsDefaultValue() {
        return true;
    }
}

