/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.actions;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.ModelUtils;
import com.jaspersoft.ireport.designer.outline.nodes.CellNode;
import com.jaspersoft.ireport.designer.outline.nodes.ElementNode;
import com.jaspersoft.ireport.designer.sheet.editors.box.BoxPanel;
import com.jaspersoft.ireport.designer.utils.Misc;
import com.jaspersoft.ireport.locale.I18n;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JDialog;
import net.sf.jasperreports.crosstabs.design.JRDesignCellContents;
import net.sf.jasperreports.engine.JRBoxContainer;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.base.JRBaseLineBox;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.actions.NodeAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PaddingAndBordersAction
extends NodeAction {
    public String getName() {
        return I18n.getString("PaddingAndBordersAction.Property.PaddingAndBorders");
    }

    protected void initialize() {
        super.initialize();
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }

    protected void performAction(Node[] activatedNodes) {
        JasperDesign design = null;
        if (activatedNodes[0] instanceof ElementNode) {
            design = ((ElementNode)activatedNodes[0]).getJasperDesign();
        } else if (activatedNodes[0] instanceof CellNode) {
            design = ((CellNode)activatedNodes[0]).getJasperDesign();
        }
        ArrayList<JRLineBox> boxes = new ArrayList<JRLineBox>();
        JRDesignCellContents firstContainer = null;
        for (int i = 0; i < activatedNodes.length; ++i) {
            if (activatedNodes[i] instanceof ElementNode && ((ElementNode)activatedNodes[i]).getElement() instanceof JRBoxContainer) {
                boxes.add(((JRBoxContainer)((ElementNode)activatedNodes[i]).getElement()).getLineBox());
                if (firstContainer != null) continue;
                firstContainer = (JRBoxContainer)((ElementNode)activatedNodes[i]).getElement();
                continue;
            }
            if (!(activatedNodes[i] instanceof CellNode)) continue;
            boxes.add(((CellNode)activatedNodes[i]).getCellContents().getLineBox());
            if (firstContainer != null) continue;
            firstContainer = ((CellNode)activatedNodes[i]).getCellContents();
        }
        JDialog dialog = new JDialog(Misc.getMainFrame(), true);
        BoxPanel panel = new BoxPanel();
        JRLineBox box = this.createCommonBox((List<JRLineBox>)boxes, (JRBoxContainer)firstContainer);
        panel.setLineBox(box);
        box = panel.showDialog(box);
        if (box != null) {
            for (JRLineBox bb : boxes) {
                ModelUtils.applyBoxProperties(bb, box);
            }
            if (boxes.size() > 0) {
                IReportManager.getInstance().notifyReportChange();
            }
        }
    }

    private JRLineBox createCommonBox(List<JRLineBox> boxes, JRBoxContainer container) {
        if (boxes == null || boxes.size() == 0) {
            return new JRBaseLineBox(container);
        }
        if (boxes.size() == 1) {
            return boxes.get(0).clone(container);
        }
        JRBaseLineBox finalbox = new JRBaseLineBox(null);
        boolean isFirst = true;
        for (JRLineBox box : boxes) {
            if (isFirst) {
                ModelUtils.applyBoxProperties((JRLineBox)finalbox, box);
                isFirst = false;
                continue;
            }
            ModelUtils.applyDiff((JRLineBox)finalbox, box);
        }
        return finalbox;
    }

    protected boolean enable(Node[] activatedNodes) {
        if (activatedNodes == null || activatedNodes.length == 0) {
            return false;
        }
        for (int i = 0; i < activatedNodes.length; ++i) {
            if (activatedNodes[i] instanceof ElementNode && ((ElementNode)activatedNodes[i]).getElement() instanceof JRBoxContainer || activatedNodes[i] instanceof CellNode) continue;
            return false;
        }
        return true;
    }
}

