/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.highlights;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.text.Document;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Coloring;
import org.netbeans.editor.DrawContext;
import org.netbeans.editor.DrawLayer;
import org.netbeans.editor.MarkFactory;
import org.netbeans.modules.editor.highlights.HighlightComparator;
import org.netbeans.modules.editor.highlights.spi.Highlight;
import org.openide.ErrorManager;

final class HighlightLayer
extends DrawLayer.AbstractLayer {
    static final String NAME = "highlight-layer";
    private Map type2Highlights = new HashMap();
    private Highlight fakeHighlight = new FakeHighlight();
    private int fakePosition;
    public static final int VISIBILITY = 3000;
    private boolean initialized = false;

    public HighlightLayer() {
        super(NAME);
    }

    private void checkDocument(Document document) {
    }

    public boolean extendsEOL() {
        return true;
    }

    public synchronized void init(DrawContext drawContext) {
        if (!this.initialized) {
            BaseDocument baseDocument = drawContext.getEditorUI().getDocument();
            this.initialized = true;
            this.checkDocument((Document)baseDocument);
        }
        if (this.isActive()) {
            this.setNextActivityChangeOffset(0);
        }
    }

    private boolean isActive() {
        return true;
    }

    public boolean isActive(DrawContext drawContext, MarkFactory.DrawMark drawMark) {
        if (this.isActive()) {
            int n = drawContext.getFragmentOffset();
            List list = this.getHighlightsForOffset(n);
            int n2 = Integer.MAX_VALUE;
            for (Highlight highlight : list) {
                if (highlight.getStart() <= n) {
                    if (n2 <= highlight.getEnd()) continue;
                    n2 = highlight.getEnd();
                    continue;
                }
                if (n2 <= highlight.getStart()) continue;
                n2 = highlight.getStart();
            }
            if (n2 == n) {
                ++n2;
            }
            this.setNextActivityChangeOffset(n2);
            return true;
        }
        return false;
    }

    public void updateContext(DrawContext drawContext) {
        if (!this.isActive()) {
            return;
        }
        int n = drawContext.getFragmentOffset();
        List list = this.getHighlightsForOffset(n);
        int n2 = Integer.MAX_VALUE;
        int n3 = Integer.MAX_VALUE;
        boolean bl = false;
        for (Highlight highlight : list) {
            if (highlight.getStart() <= n && n < highlight.getEnd()) {
                highlight.getColoring().apply(drawContext);
                bl = true;
            }
            if (n2 > highlight.getEnd()) {
                n2 = highlight.getEnd();
            }
            if (n3 <= highlight.getStart()) continue;
            n3 = highlight.getStart();
        }
        if (!bl && n3 < n2) {
            n2 = n3;
        }
        this.setNextActivityChangeOffset(n2);
    }

    public synchronized void setHighlights(String string, Collection collection) {
        TreeSet<Highlight> treeSet = (TreeSet<Highlight>)this.type2Highlights.get(string);
        if (treeSet == null) {
            treeSet = new TreeSet<Highlight>(new HighlightComparator());
            this.type2Highlights.put(string, treeSet);
        } else {
            treeSet.clear();
        }
        for (Highlight highlight : collection) {
            if (highlight != null) {
                treeSet.add(highlight);
                continue;
            }
            ErrorManager.getDefault().log(16, "Got a null highlight, type: " + string);
        }
    }

    private synchronized List getHighlightsForOffset(int n) {
        ArrayList<Highlight> arrayList = new ArrayList<Highlight>();
        this.fakePosition = n;
        for (String string : this.type2Highlights.keySet()) {
            SortedSet<Highlight> sortedSet = ((SortedSet)this.type2Highlights.get(string)).tailSet(this.fakeHighlight);
            if (sortedSet.isEmpty()) continue;
            Highlight highlight = sortedSet.first();
            arrayList.add(highlight);
        }
        return arrayList;
    }

    private final class FakeHighlight
    implements Highlight {
        private FakeHighlight() {
        }

        public int getStart() {
            return -1;
        }

        public int getEnd() {
            return HighlightLayer.this.fakePosition;
        }

        public Coloring getColoring() {
            return null;
        }
    }
}

