/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.persister.collection;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.access.CollectionRegionAccessStrategy;
import org.hibernate.cfg.Configuration;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.SubselectFetch;
import org.hibernate.exception.JDBCExceptionHelper;
import org.hibernate.jdbc.Expectation;
import org.hibernate.jdbc.Expectations;
import org.hibernate.loader.collection.BatchingCollectionInitializer;
import org.hibernate.loader.collection.CollectionInitializer;
import org.hibernate.loader.collection.SubselectCollectionLoader;
import org.hibernate.mapping.Collection;
import org.hibernate.persister.collection.AbstractCollectionPersister;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.Joinable;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.sql.Delete;
import org.hibernate.sql.Insert;
import org.hibernate.sql.SelectFragment;
import org.hibernate.sql.Update;
import org.hibernate.type.AssociationType;
import org.hibernate.util.ArrayHelper;

public class BasicCollectionPersister
extends AbstractCollectionPersister {
    public boolean isCascadeDeleteEnabled() {
        return false;
    }

    public BasicCollectionPersister(Collection collection, CollectionRegionAccessStrategy cacheAccessStrategy, Configuration cfg, SessionFactoryImplementor factory) throws MappingException, CacheException {
        super(collection, cacheAccessStrategy, cfg, factory);
    }

    protected String generateDeleteString() {
        Delete delete = new Delete().setTableName(this.qualifiedTableName).setPrimaryKeyColumnNames(this.keyColumnNames);
        if (this.hasWhere) {
            delete.setWhere(this.sqlWhereString);
        }
        if (this.getFactory().getSettings().isCommentsEnabled()) {
            delete.setComment("delete collection " + this.getRole());
        }
        return delete.toStatementString();
    }

    protected String generateInsertRowString() {
        Insert insert = new Insert(this.getDialect()).setTableName(this.qualifiedTableName).addColumns(this.keyColumnNames);
        if (this.hasIdentifier) {
            insert.addColumn(this.identifierColumnName);
        }
        if (this.hasIndex) {
            insert.addColumns(this.indexColumnNames, this.indexColumnIsSettable);
        }
        if (this.getFactory().getSettings().isCommentsEnabled()) {
            insert.setComment("insert collection row " + this.getRole());
        }
        insert.addColumns(this.elementColumnNames, this.elementColumnIsSettable);
        return insert.toStatementString();
    }

    protected String generateUpdateRowString() {
        Update update = new Update(this.getDialect()).setTableName(this.qualifiedTableName);
        update.addColumns(this.elementColumnNames, this.elementColumnIsSettable);
        if (this.hasIdentifier) {
            update.setPrimaryKeyColumnNames(new String[]{this.identifierColumnName});
        } else if (this.hasIndex && !this.indexContainsFormula) {
            update.setPrimaryKeyColumnNames(ArrayHelper.join(this.keyColumnNames, this.indexColumnNames));
        } else {
            update.setPrimaryKeyColumnNames(ArrayHelper.join(this.keyColumnNames, this.elementColumnNames, this.elementColumnIsInPrimaryKey));
        }
        if (this.getFactory().getSettings().isCommentsEnabled()) {
            update.setComment("update collection row " + this.getRole());
        }
        return update.toStatementString();
    }

    protected String generateDeleteRowString() {
        Delete delete = new Delete().setTableName(this.qualifiedTableName);
        if (this.hasIdentifier) {
            delete.setPrimaryKeyColumnNames(new String[]{this.identifierColumnName});
        } else if (this.hasIndex && !this.indexContainsFormula) {
            delete.setPrimaryKeyColumnNames(ArrayHelper.join(this.keyColumnNames, this.indexColumnNames));
        } else {
            delete.setPrimaryKeyColumnNames(ArrayHelper.join(this.keyColumnNames, this.elementColumnNames, this.elementColumnIsInPrimaryKey));
        }
        if (this.getFactory().getSettings().isCommentsEnabled()) {
            delete.setComment("delete collection row " + this.getRole());
        }
        return delete.toStatementString();
    }

    public boolean consumesEntityAlias() {
        return false;
    }

    public boolean consumesCollectionAlias() {
        return true;
    }

    public boolean isOneToMany() {
        return false;
    }

    public boolean isManyToMany() {
        return this.elementType.isEntityType();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int doUpdateRows(Serializable id, PersistentCollection collection, SessionImplementor session) throws HibernateException {
        if (ArrayHelper.isAllFalse(this.elementColumnIsSettable)) {
            return 0;
        }
        try {
            PreparedStatement st = null;
            Expectation expectation = Expectations.appropriateExpectation(this.getUpdateCheckStyle());
            boolean callable = this.isUpdateCallable();
            boolean useBatch = expectation.canBeBatched();
            Iterator entries = collection.entries(this);
            String sql = this.getSQLUpdateRowString();
            int i = 0;
            int count = 0;
            while (true) {
                if (!entries.hasNext()) {
                    return count;
                }
                Object entry = entries.next();
                if (collection.needsUpdating(entry, i, this.elementType)) {
                    block22: {
                        Object var16_17;
                        int offset = 1;
                        if (useBatch) {
                            if (st == null) {
                                st = callable ? session.getBatcher().prepareBatchCallableStatement(sql) : session.getBatcher().prepareBatchStatement(sql);
                            }
                        } else {
                            st = callable ? session.getBatcher().prepareCallableStatement(sql) : session.getBatcher().prepareStatement(sql);
                        }
                        try {
                            try {
                                int loc = this.writeElement(st, collection.getElement(entry), offset += expectation.prepare(st), session);
                                if (this.hasIdentifier) {
                                    this.writeIdentifier(st, collection.getIdentifier(entry, i), loc, session);
                                } else {
                                    loc = this.writeKey(st, id, loc, session);
                                    if (this.hasIndex && !this.indexContainsFormula) {
                                        this.writeIndexToWhere(st, collection.getIndex(entry, i, this), loc, session);
                                    } else {
                                        this.writeElementToWhere(st, collection.getSnapshotElement(entry, i), loc, session);
                                    }
                                }
                                if (useBatch) {
                                    session.getBatcher().addToBatch(expectation);
                                } else {
                                    expectation.verifyOutcome(st.executeUpdate(), st, -1);
                                }
                            }
                            catch (SQLException sqle) {
                                if (useBatch) {
                                    session.getBatcher().abortBatch(sqle);
                                }
                                throw sqle;
                            }
                            var16_17 = null;
                            if (useBatch) break block22;
                        }
                        catch (Throwable throwable) {
                            var16_17 = null;
                            if (!useBatch) {
                                session.getBatcher().closeStatement(st);
                            }
                            throw throwable;
                        }
                        session.getBatcher().closeStatement(st);
                    }
                    ++count;
                }
                ++i;
            }
        }
        catch (SQLException sqle) {
            throw JDBCExceptionHelper.convert(this.getSQLExceptionConverter(), sqle, "could not update collection rows: " + MessageHelper.collectionInfoString((CollectionPersister)this, id, this.getFactory()), this.getSQLUpdateRowString());
        }
    }

    public String selectFragment(Joinable rhs, String rhsAlias, String lhsAlias, String entitySuffix, String collectionSuffix, boolean includeCollectionColumns) {
        AssociationType elementType;
        if (rhs != null && this.isManyToMany() && !rhs.isCollection() && rhs.equals((elementType = (AssociationType)this.getElementType()).getAssociatedJoinable(this.getFactory()))) {
            return this.manyToManySelectFragment(rhs, rhsAlias, lhsAlias, collectionSuffix);
        }
        return includeCollectionColumns ? this.selectFragment(lhsAlias, collectionSuffix) : "";
    }

    private String manyToManySelectFragment(Joinable rhs, String rhsAlias, String lhsAlias, String collectionSuffix) {
        SelectFragment frag = this.generateSelectFragment(lhsAlias, collectionSuffix);
        String[] elementColumnNames = rhs.getKeyColumnNames();
        frag.addColumns(rhsAlias, elementColumnNames, this.elementColumnAliases);
        this.appendIndexColumns(frag, lhsAlias);
        this.appendIdentifierColumns(frag, lhsAlias);
        return frag.toFragmentString().substring(2);
    }

    protected CollectionInitializer createCollectionInitializer(Map enabledFilters) throws MappingException {
        return BatchingCollectionInitializer.createBatchingCollectionInitializer(this, this.batchSize, this.getFactory(), enabledFilters);
    }

    public String fromJoinFragment(String alias, boolean innerJoin, boolean includeSubclasses) {
        return "";
    }

    public String whereJoinFragment(String alias, boolean innerJoin, boolean includeSubclasses) {
        return "";
    }

    protected CollectionInitializer createSubselectInitializer(SubselectFetch subselect, SessionImplementor session) {
        return new SubselectCollectionLoader(this, subselect.toSubselectString(this.getCollectionType().getLHSPropertyName()), subselect.getResult(), subselect.getQueryParameters(), subselect.getNamedParameterLocMap(), session.getFactory(), session.getEnabledFilters());
    }
}

