/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.diff.builtin.visualizer.editable;

import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.Reader;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import org.netbeans.api.diff.DiffView;
import org.netbeans.api.diff.Difference;
import org.netbeans.api.diff.StreamSource;
import org.netbeans.modules.diff.builtin.visualizer.editable.EditableDiffView;
import org.netbeans.spi.diff.DiffVisualizer;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class EditableDiffVisualizer
extends DiffVisualizer {
    public String getDisplayName() {
        return NbBundle.getMessage(EditableDiffVisualizer.class, (String)"CTL_EditableDiffVisualizer_Name");
    }

    public String getShortDescription() {
        return NbBundle.getMessage(EditableDiffVisualizer.class, (String)"CTL_EditableDiffVisualizer_Desc");
    }

    public Component createView(Difference[] differenceArray, String string, String string2, Reader reader, String string3, String string4, Reader reader2, String string5) throws IOException {
        return this.createDiff(differenceArray, StreamSource.createSource(string, string2, string5, reader), StreamSource.createSource(string3, string4, string5, reader2)).getComponent();
    }

    public DiffView createDiff(Difference[] differenceArray, StreamSource streamSource, StreamSource streamSource2) throws IOException {
        EDVManager eDVManager = new EDVManager(streamSource, streamSource2);
        eDVManager.init();
        return eDVManager.getView();
    }

    private static class EDVManager
    implements PropertyChangeListener {
        private final StreamSource s1;
        private final StreamSource s2;
        private EditableDiffView view;
        private Action nextAction;
        private Action prevAction;

        public EDVManager(StreamSource streamSource, StreamSource streamSource2) {
            this.s1 = streamSource;
            this.s2 = streamSource2;
        }

        public EditableDiffView getView() {
            return this.view;
        }

        public void init() throws IOException {
            this.view = new EditableDiffView(this.s1, this.s2);
            this.view.addPropertyChangeListener(this);
            JComponent jComponent = this.view.getComponent();
            JToolBar jToolBar = new JToolBar();
            jToolBar.setBorder(BorderFactory.createEmptyBorder());
            jToolBar.setRollover(true);
            this.nextAction = new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    EDVManager.this.onNext();
                }
            };
            this.nextAction.putValue("SmallIcon", new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/diff/builtin/visualizer/editable/diff-next.png")));
            JButton jButton = new JButton(this.nextAction);
            jButton.setMargin(new Insets(2, 2, 2, 2));
            jToolBar.add(jButton);
            this.prevAction = new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    EDVManager.this.onPrev();
                }
            };
            this.prevAction.putValue("SmallIcon", new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/diff/builtin/visualizer/editable/diff-prev.png")));
            JButton jButton2 = new JButton(this.prevAction);
            jButton2.setMargin(new Insets(2, 2, 2, 2));
            jToolBar.add(jButton2);
            jComponent.putClientProperty("DiffPresenter.toolbarPanel", jToolBar);
            jComponent.getActionMap().put("jumpNext", this.nextAction);
            jComponent.getActionMap().put("jumpPrev", this.prevAction);
            this.refreshComponents();
        }

        private void onPrev() {
            int n = this.view.getCurrentDifference();
            if (n > 0) {
                this.view.setCurrentDifference(n - 1);
            }
        }

        private void onNext() {
            int n = this.view.getCurrentDifference();
            if (n < this.view.getDifferenceCount() - 1) {
                this.view.setCurrentDifference(n + 1);
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            this.refreshComponents();
        }

        private void refreshComponents() {
            this.nextAction.setEnabled(this.view.getCurrentDifference() < this.view.getDifferenceCount() - 1);
            this.prevAction.setEnabled(this.view.getCurrentDifference() > 0);
        }
    }
}

