/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.xam.dom;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.ModelSource;
import org.netbeans.modules.xml.xam.dom.AbstractDocumentComponent;
import org.netbeans.modules.xml.xam.dom.AbstractDocumentModel;
import org.netbeans.modules.xml.xam.dom.DocumentModelAccess;
import org.netbeans.modules.xml.xam.dom.ElementIdentity;
import org.netbeans.modules.xml.xam.spi.DocumentModelAccessProvider;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReadOnlyAccess
extends DocumentModelAccess {
    private AbstractDocumentModel model;
    private org.w3c.dom.Document rootDoc;

    public ReadOnlyAccess(AbstractDocumentModel abstractDocumentModel) {
        this.model = abstractDocumentModel;
    }

    @Override
    public AbstractDocumentModel getModel() {
        return this.model;
    }

    @Override
    public void setPrefix(Element element, String string) {
        throw new UnsupportedOperationException("setPrefix access not supported.");
    }

    @Override
    public List<Element> getPathFromRoot(org.w3c.dom.Document document, Element element) {
        throw new UnsupportedOperationException("getPathFromRoot access not supported.");
    }

    @Override
    public String getXPath(org.w3c.dom.Document document, Element element) {
        throw new UnsupportedOperationException("getXPath access not supported.");
    }

    @Override
    public Map<QName, String> getAttributeMap(Element element) {
        HashMap<QName, String> hashMap = new HashMap<QName, String>();
        NamedNodeMap namedNodeMap = element.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Attr attr = (Attr)namedNodeMap.item(i);
            if (ReadOnlyAccess.isXmlnsAttribute(attr)) continue;
            QName qName = AbstractDocumentComponent.getQName(attr);
            hashMap.put(qName, attr.getValue());
        }
        return hashMap;
    }

    public static boolean isXmlnsAttribute(Attr attr) {
        return "xmlns".equals(attr.getPrefix()) || "xmlns".equals(attr.getName());
    }

    @Override
    public Element duplicate(Element element) {
        throw new UnsupportedOperationException("getXPath access not supported.");
    }

    @Override
    public String getXmlFragment(Element element) {
        String string = this.getXmlFragmentInclusive(element);
        if (string.endsWith("/>")) {
            return null;
        }
        int n = string.indexOf(">");
        int n2 = string.lastIndexOf("<");
        if (++n == -1 || n2 == -1) {
            return null;
        }
        return string.substring(n, n2);
    }

    @Override
    public void setXmlFragment(Element element, String string, DocumentModelAccess.NodeUpdater nodeUpdater) throws IOException {
        throw new UnsupportedOperationException("setXmlFragment access not supported.");
    }

    @Override
    public void setText(Element element, String string, DocumentModelAccess.NodeUpdater nodeUpdater) {
        throw new UnsupportedOperationException("setText access not supported.");
    }

    @Override
    public void removeAttribute(Element element, String string, DocumentModelAccess.NodeUpdater nodeUpdater) {
        throw new UnsupportedOperationException("removeAttribute access not supported.");
    }

    @Override
    public void setAttribute(Element element, String string, String string2, DocumentModelAccess.NodeUpdater nodeUpdater) {
        throw new UnsupportedOperationException("setAttribute access not supported.");
    }

    @Override
    public int findPosition(Node node) {
        Element element = this.model.getRootComponent().getPeer();
        Document document = this.model.getBaseDocument();
        try {
            String string = document.getText(0, document.getLength());
            if (node instanceof Element) {
                int n = this.getRootElementPosition(string, element);
                StringScanner stringScanner = new StringScanner(string, n);
                return this.findPosition((Element)node, element, stringScanner);
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return -1;
    }

    private int getRootElementPosition(String string, Element element) {
        Node node;
        NodeList nodeList = element.getOwnerDocument().getChildNodes();
        int n = 0;
        for (int i = 0; i < nodeList.getLength() && (node = nodeList.item(i)) != element; ++i) {
            String string2 = node.getNodeValue();
            assert (string2 != null) : "Invalid document";
            n += string2.length();
        }
        n = string.indexOf(element.getTagName(), n) - 1;
        assert (n > 0) : "Root element position should be greater than 0";
        return n;
    }

    private int findPosition(Element element, Element element2, StringScanner stringScanner) {
        if (element == element2) {
            return stringScanner.pos;
        }
        stringScanner.skip(">");
        NodeList nodeList = element2.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Object object;
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) {
                object = node.getNodeValue();
                if (object == null) {
                    object = node.getTextContent();
                }
                if (object == null) continue;
                stringScanner.skip(((String)object).length());
                continue;
            }
            object = (Element)nodeList.item(i);
            String string = "<" + object.getTagName();
            stringScanner.scanTo(string);
            if (object == element) {
                return stringScanner.pos;
            }
            int n = this.findPosition(element, (Element)object, stringScanner);
            if (n <= -1) continue;
            return n;
        }
        if (nodeList.getLength() > 0) {
            stringScanner.skip(">");
        }
        return -1;
    }

    @Override
    public int getElementIndexOf(Node node, Element element) {
        throw new UnsupportedOperationException("getElementIndexOf access not supported.");
    }

    @Override
    public List<Node> findNodes(org.w3c.dom.Document document, String string) {
        throw new UnsupportedOperationException("findNodes access not supported.");
    }

    @Override
    public Node findNode(org.w3c.dom.Document document, String string) {
        throw new UnsupportedOperationException("findNode access not supported.");
    }

    @Override
    public Element getContainingElement(int n) {
        try {
            Document document = this.model.getBaseDocument();
            String string = document.getText(0, document.getLength());
            Element element = this.model.getDocument().getDocumentElement();
            if (n < 0) {
                return null;
            }
            return this.findElement(n, string, element, this.getRootElementPosition(string, element));
        }
        catch (Exception exception) {
            return null;
        }
    }

    private String getNonElementString(String string, int n, Node node) {
        assert (!(node instanceof Element)) : "Element is not expected";
        String string2 = node.getNodeValue();
        if (string2 == null) {
            string2 = node.getTextContent();
        }
        assert (string2 != null) : "Expected node has string value";
        return string2;
    }

    protected Element findElement(int n, String string, Element element, int n2) {
        if (n2 == n) {
            return element;
        }
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String string2;
            int n3;
            Object object;
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) {
                object = this.getNonElementString(string, n2, node);
                if (n < (n2 = string.indexOf((String)object, n2))) {
                    return element;
                }
                n2 += ((String)object).length();
                continue;
            }
            object = (Element)nodeList.item(i);
            String string3 = "<" + object.getTagName();
            n2 = string.indexOf(string3, n2);
            if (n2 > n) {
                return element;
            }
            Element element2 = this.findElement(n, string, (Element)object, n2);
            if (element2 != null) {
                return element2;
            }
            if (i + 1 >= nodeList.getLength() || nodeList.item(i + 1) instanceof Element || (n3 = string.indexOf(string2 = this.getNonElementString(string, n2, nodeList.item(i + 1)), n2)) <= n) continue;
            return object;
        }
        return null;
    }

    @Override
    public void addUndoableEditListener(UndoableEditListener undoableEditListener) {
        throw new UnsupportedOperationException("addUndoableEditListener access not supported.");
    }

    @Override
    public void removeUndoableEditListener(UndoableEditListener undoableEditListener) {
        throw new UnsupportedOperationException("removeUndoableEditListener access not supported.");
    }

    @Override
    public void appendChild(Node node, Node node2, DocumentModelAccess.NodeUpdater nodeUpdater) {
        throw new UnsupportedOperationException("appendChild access not supported.");
    }

    @Override
    public void insertBefore(Node node, Node node2, Node node3, DocumentModelAccess.NodeUpdater nodeUpdater) {
        throw new UnsupportedOperationException("insertBefore access not supported.");
    }

    @Override
    public void removeChild(Node node, Node node2, DocumentModelAccess.NodeUpdater nodeUpdater) {
        throw new UnsupportedOperationException("removeChild access not supported.");
    }

    @Override
    public void replaceChild(Node node, Node node2, Node node3, DocumentModelAccess.NodeUpdater nodeUpdater) {
        throw new UnsupportedOperationException("replaceChild access not supported.");
    }

    @Override
    public Model.State sync() throws IOException {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            documentBuilderFactory.setIgnoringComments(true);
            documentBuilderFactory.setIgnoringElementContentWhitespace(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = this.model.getBaseDocument();
            String string = document.getText(0, document.getLength());
            BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
            this.rootDoc = documentBuilder.parse(new InputSource(bufferedReader));
            Element element = this.rootDoc.getDocumentElement();
            if (this.model.createRootComponent(element) == null) {
                throw new IOException("Cannot create model with " + new QName(element.getNamespaceURI(), element.getLocalName()));
            }
            return Model.State.VALID;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            IOException iOException = new IOException();
            iOException.initCause(parserConfigurationException);
            throw iOException;
        }
        catch (BadLocationException badLocationException) {
            IOException iOException = new IOException();
            iOException.initCause(badLocationException);
            throw iOException;
        }
        catch (SAXException sAXException) {
            IOException iOException = new IOException();
            iOException.initCause(sAXException);
            throw iOException;
        }
    }

    @Override
    public ElementIdentity getElementIdentity() {
        throw new UnsupportedOperationException("getElementIdentity access not supported.");
    }

    @Override
    public org.w3c.dom.Document getDocumentRoot() {
        return this.rootDoc;
    }

    @Override
    public void flush() {
    }

    @Override
    public void finishUndoRedo() {
        throw new UnsupportedOperationException("finishUndoRedo access not supported.");
    }

    @Override
    public boolean areSameNodes(Node node, Node node2) {
        return node.equals(node2);
    }

    @Override
    public void prepareForUndoRedo() {
        throw new UnsupportedOperationException("prepareForUndoRedo access not supported.");
    }

    @Override
    public void addMergeEventHandler(PropertyChangeListener propertyChangeListener) {
    }

    @Override
    public void removeMergeEventHandler(PropertyChangeListener propertyChangeListener) {
    }

    @Override
    public Node getOldEventParentNode(PropertyChangeEvent propertyChangeEvent) {
        return null;
    }

    @Override
    public Node getOldEventNode(PropertyChangeEvent propertyChangeEvent) {
        return null;
    }

    @Override
    public Node getNewEventParentNode(PropertyChangeEvent propertyChangeEvent) {
        return null;
    }

    @Override
    public Node getNewEventNode(PropertyChangeEvent propertyChangeEvent) {
        return null;
    }

    @Override
    public String normalizeUndefinedAttributeValue(String string) {
        return "".equals(string) ? null : string;
    }

    public static class Provider
    implements DocumentModelAccessProvider {
        private static Provider instance;

        protected Provider() {
        }

        public static Provider getInstance() {
            if (instance == null) {
                instance = new Provider();
            }
            return instance;
        }

        public DocumentModelAccess createModelAccess(AbstractDocumentModel abstractDocumentModel) {
            return new ReadOnlyAccess(abstractDocumentModel);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Document loadSwingDocument(InputStream inputStream) throws IOException, BadLocationException {
            PlainDocument plainDocument = new PlainDocument();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            try {
                String string = null;
                while ((string = bufferedReader.readLine()) != null) {
                    plainDocument.insertString(plainDocument.getLength(), string + System.getProperty("line.separator"), null);
                }
            }
            finally {
                bufferedReader.close();
            }
            return plainDocument;
        }

        public Object getModelSourceKey(ModelSource modelSource) {
            return modelSource.getLookup().lookup(File.class);
        }
    }

    private static class StringScanner {
        String buf;
        int pos = -1;

        public StringScanner(String string, int n) {
            this.buf = string;
            this.pos = n;
        }

        public void scanTo(String string) {
            this.pos = this.buf.indexOf(string, this.pos);
            if (this.pos == -1) {
                throw new IllegalArgumentException("Scan failed: position -1");
            }
        }

        public void skip(String string) {
            this.scanTo(string);
            this.skip(string.length());
        }

        public void skip(int n) {
            this.pos += n;
        }
    }
}

