/*
 * Decompiled with CFR 0.152.
 */
package mondrian.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mondrian.olap.Cube;
import mondrian.olap.Hierarchy;
import mondrian.olap.Id;
import mondrian.olap.Member;
import mondrian.olap.MondrianProperties;
import mondrian.olap.OlapElement;
import mondrian.olap.SchemaReader;
import mondrian.olap.Util;
import mondrian.olap.fun.FunUtil;
import mondrian.resource.MondrianResource;
import mondrian.rolap.RolapCube;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdentifierParser {
    public static final int START = 0;
    public static final int BEFORE_SEG = 1;
    public static final int IN_BRACKET_SEG = 2;
    public static final int AFTER_SEG = 3;
    public static final int IN_SEG = 4;

    private static char charAt(String s, int pos) {
        return pos < s.length() ? s.charAt(pos) : (char)'\u0000';
    }

    public static void parseTupleList(Builder builder, String string) {
        char c;
        int i = 0;
        while ((c = IdentifierParser.charAt(string, i++)) == ' ') {
        }
        if (c != '{') {
            throw IdentifierParser.fail(string, i, "{");
        }
        do {
            i = IdentifierParser.parseTuple(builder, string, i);
            while ((c = IdentifierParser.charAt(string, i++)) == ' ') {
            }
        } while (c == ',');
        if (c == '}') {
            return;
        }
        throw IdentifierParser.fail(string, i, ", or }");
    }

    public static int parseTuple(Builder builder, String string, int i) {
        char c;
        while ((c = IdentifierParser.charAt(string, i++)) == ' ') {
        }
        if (c != '(') {
            throw IdentifierParser.fail(string, i, "(");
        }
        do {
            i = IdentifierParser.parseMember(builder, string, i);
            while ((c = IdentifierParser.charAt(string, i++)) == ' ') {
            }
        } while (c == ',' || c != ')');
        builder.tupleComplete();
        return i;
    }

    public static void parseMemberList(Builder builder, String string) {
        int i = 0;
        char c = IdentifierParser.charAt(string, i);
        while (c > '\u0000' && c <= ' ') {
            c = IdentifierParser.charAt(string, ++i);
        }
        boolean leadingBrace = false;
        boolean trailingBrace = false;
        if (c == '{') {
            leadingBrace = true;
            ++i;
        }
        block6: while (true) {
            i = IdentifierParser.parseMember(builder, string, i);
            c = IdentifierParser.charAt(string, i);
            while (c > '\u0000' && c <= ' ') {
                c = IdentifierParser.charAt(string, ++i);
            }
            switch (c) {
                case '\u0000': {
                    break block6;
                }
                case ',': {
                    ++i;
                    continue block6;
                }
                case '}': {
                    trailingBrace = true;
                    break block6;
                }
                default: {
                    throw IdentifierParser.fail(string, i, ", or }");
                }
            }
            break;
        }
        if (leadingBrace != trailingBrace) {
            throw Util.newInternal("mismatched '{' and '}' in '" + string + "'");
        }
    }

    public static int parseMember(Builder builder, String string, int i) {
        int k = string.length();
        int state = 0;
        int start = 0;
        block29: while (i < k + 1) {
            char c = IdentifierParser.charAt(string, i);
            switch (state) {
                case 0: 
                case 1: {
                    switch (c) {
                        case '[': {
                            start = ++i;
                            state = 2;
                            continue block29;
                        }
                        case ' ': {
                            ++i;
                            continue block29;
                        }
                        case '\u0000': 
                        case ',': 
                        case '}': {
                            break block29;
                        }
                        case '.': {
                            throw Util.newInternal("unexpected: '.'");
                        }
                    }
                    state = 4;
                    start = i;
                    continue block29;
                }
                case 4: {
                    switch (c) {
                        case '\u0000': 
                        case ')': 
                        case ',': 
                        case '}': {
                            builder.segmentComplete(new Id.Segment(string.substring(start, i).trim(), Id.Quoting.UNQUOTED));
                            state = 3;
                            break block29;
                        }
                        case '.': {
                            builder.segmentComplete(new Id.Segment(string.substring(start, i).trim(), Id.Quoting.UNQUOTED));
                            state = 1;
                            ++i;
                            continue block29;
                        }
                    }
                    ++i;
                    continue block29;
                }
                case 2: {
                    switch (c) {
                        case '\u0000': {
                            throw Util.newInternal("Expected ']', in member identifier '" + string + "'");
                        }
                        case ']': {
                            if (IdentifierParser.charAt(string, i + 1) == ']') {
                                ++i;
                                break;
                            }
                            builder.segmentComplete(new Id.Segment(Util.replace(string.substring(start, i), "]]", "]"), Id.Quoting.QUOTED));
                            ++i;
                            state = 3;
                            continue block29;
                        }
                    }
                    ++i;
                    continue block29;
                }
                case 3: {
                    switch (c) {
                        case ' ': {
                            ++i;
                            continue block29;
                        }
                        case '.': {
                            state = 1;
                            ++i;
                            continue block29;
                        }
                    }
                    break block29;
                }
                default: {
                    throw Util.newInternal("unexpected state: " + state);
                }
            }
        }
        switch (state) {
            case 0: {
                return i;
            }
            case 1: {
                throw Util.newInternal("Expected identifier after '.', in member identifier '" + string + "'");
            }
            case 2: {
                throw Util.newInternal("Expected ']', in member identifier '" + string + "'");
            }
        }
        builder.memberComplete();
        return i;
    }

    public static RuntimeException fail(String string, int i, String expecting) {
        throw Util.newInternal("expected '" + expecting + "' at position " + i + " in '" + string + "'");
    }

    public static List<Id.Segment> parseIdentifier(String s) {
        final ArrayList<Id.Segment> list = new ArrayList<Id.Segment>();
        Builder builder = new Builder(){

            public void tupleComplete() {
                throw new UnsupportedOperationException();
            }

            public void memberComplete() {
            }

            public void segmentComplete(Id.Segment segment) {
                list.add(segment);
            }
        };
        int i = IdentifierParser.parseMember(builder, s, 0);
        if (i < s.length()) {
            throw MondrianResource.instance().MdxInvalidMember.ex(s);
        }
        return list;
    }

    public static List<List<Id.Segment>> parseIdentifierList(String s) {
        final ArrayList<List<Id.Segment>> list = new ArrayList<List<Id.Segment>>();
        Builder builder = new Builder(){
            final List<Id.Segment> segmentList = new ArrayList<Id.Segment>();

            public void tupleComplete() {
                throw new UnsupportedOperationException();
            }

            public void memberComplete() {
                list.add(new ArrayList<Id.Segment>(this.segmentList));
                this.segmentList.clear();
            }

            public void segmentComplete(Id.Segment segment) {
                this.segmentList.add(segment);
            }
        };
        IdentifierParser.parseMemberList(builder, s);
        return list;
    }

    public static class MemberListBuilder
    extends BuilderImpl {
        public final List<Member> memberList = new ArrayList<Member>();

        public MemberListBuilder(SchemaReader schemaReader, Cube cube, Hierarchy hierarchy) {
            super(schemaReader, cube, Collections.singletonList(hierarchy));
        }

        public void memberComplete() {
            Member member = this.resolveMember((Hierarchy)this.hierarchyList.get(0));
            if (!member.isNull()) {
                this.memberList.add(member);
            }
            this.nameList.clear();
        }

        public void tupleComplete() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TupleListBuilder
    extends TupleBuilder {
        public final List<Member[]> tupleList = new ArrayList<Member[]>();

        public TupleListBuilder(SchemaReader schemaReader, Cube cube, List<Hierarchy> hierarchyList) {
            super(schemaReader, cube, hierarchyList);
        }

        @Override
        public void tupleComplete() {
            super.tupleComplete();
            Member[] members = this.memberList.toArray(new Member[this.memberList.size()]);
            if (!FunUtil.tupleContainsNullMember(members)) {
                this.tupleList.add(members);
            }
            this.memberList.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TupleBuilder
    extends BuilderImpl {
        protected final List<Member> memberList = new ArrayList<Member>();

        public TupleBuilder(SchemaReader schemaReader, Cube cube, List<Hierarchy> hierarchyList) {
            super(schemaReader, cube, hierarchyList);
        }

        @Override
        public void memberComplete() {
            if (this.memberList.size() >= this.hierarchyList.size()) {
                throw Util.newInternal("expected ')");
            }
            Hierarchy hierarchy = (Hierarchy)this.hierarchyList.get(this.memberList.size());
            Member member = this.resolveMember(hierarchy);
            this.memberList.add(member);
            this.nameList.clear();
        }

        @Override
        public void tupleComplete() {
            if (this.memberList.size() < this.hierarchyList.size()) {
                throw Util.newInternal("too few members");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BuilderImpl
    implements Builder {
        private final SchemaReader schemaReader;
        private final Cube cube;
        protected final List<Hierarchy> hierarchyList;
        protected final List<Id.Segment> nameList = new ArrayList<Id.Segment>();
        private final boolean ignoreInvalid;

        BuilderImpl(SchemaReader schemaReader, Cube cube, List<Hierarchy> hierarchyList) {
            this.schemaReader = schemaReader;
            this.cube = cube;
            this.hierarchyList = hierarchyList;
            MondrianProperties props = MondrianProperties.instance();
            boolean load = ((RolapCube)cube).isLoadInProgress();
            this.ignoreInvalid = load ? props.IgnoreInvalidMembers.get() : props.IgnoreInvalidMembersDuringQuery.get();
        }

        @Override
        public void segmentComplete(Id.Segment segment) {
            this.nameList.add(segment);
        }

        @Override
        public void tupleComplete() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void memberComplete() {
            throw new UnsupportedOperationException();
        }

        protected Member resolveMember(Hierarchy expectedHierarchy) {
            Member member = (Member)Util.lookupCompound(this.schemaReader, this.cube, this.nameList, !this.ignoreInvalid, 6);
            if (member == null) {
                assert (this.ignoreInvalid);
                if (expectedHierarchy != null) {
                    return expectedHierarchy.getNullMember();
                }
                for (int i = this.nameList.size() - 1; i > 0; --i) {
                    List<Id.Segment> partialName = this.nameList.subList(0, i);
                    OlapElement olapElement = this.schemaReader.lookupCompound(this.cube, partialName, false, 0);
                    if (olapElement == null) continue;
                    return olapElement.getHierarchy().getNullMember();
                }
                throw MondrianResource.instance().MdxChildObjectNotFound.ex(Util.implode(this.nameList), this.cube.getQualifiedName());
            }
            if (expectedHierarchy != null && member.getHierarchy() != expectedHierarchy) {
                throw Util.newInternal("member is of wrong hierarchy");
            }
            return member;
        }
    }

    public static interface Builder {
        public void tupleComplete();

        public void memberComplete();

        public void segmentComplete(Id.Segment var1);
    }
}

