/*
 * Decompiled with CFR 0.152.
 */
package mondrian.spi.impl;

import java.sql.Connection;
import java.sql.SQLException;
import mondrian.olap.Util;
import mondrian.spi.Dialect;
import mondrian.spi.impl.JdbcDialectFactory;
import mondrian.spi.impl.PostgreSqlDialect;

public class GreenplumDialect
extends PostgreSqlDialect {
    public static final JdbcDialectFactory FACTORY = new JdbcDialectFactory(GreenplumDialect.class, Dialect.DatabaseProduct.POSTGRESQL){

        protected boolean acceptsConnection(Connection connection) {
            try {
                return super.acceptsConnection(connection) && PostgreSqlDialect.isGreenplum(connection.getMetaData());
            }
            catch (SQLException e) {
                throw Util.newError(e, "Error while instantiating dialect");
            }
        }
    };

    public GreenplumDialect(Connection connection) throws SQLException {
        super(connection);
    }

    public boolean supportsGroupingSets() {
        return true;
    }

    public boolean allowsCountDistinct() {
        return false;
    }

    public boolean allowsFromQuery() {
        return true;
    }

    public Dialect.DatabaseProduct getDatabaseProduct() {
        return Dialect.DatabaseProduct.GREENPLUM;
    }
}

