/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap.agg;

import mondrian.rolap.CellKey;
import mondrian.rolap.SqlStatement;
import mondrian.rolap.agg.DenseNativeSegmentDataset;
import mondrian.rolap.agg.Segment;
import mondrian.rolap.agg.SegmentDataset;
import mondrian.rolap.agg.SegmentLoader;

class DenseIntSegmentDataset
extends DenseNativeSegmentDataset {
    private final int[] values;

    DenseIntSegmentDataset(Segment segment, int size) {
        super(segment, size);
        this.values = new int[size];
    }

    public int getInt(CellKey key) {
        int offset = key.getOffset(this.axisMultipliers);
        return this.values[offset];
    }

    public Object getObject(CellKey pos) {
        int offset = pos.getOffset(this.axisMultipliers);
        return this.getObject(offset);
    }

    protected Integer getObject(int offset) {
        int value = this.values[offset];
        if (value == 0 && this.isNull(offset)) {
            return null;
        }
        return value;
    }

    public boolean exists(CellKey pos) {
        return true;
    }

    public void populateFrom(int[] pos, SegmentDataset data, CellKey key) {
        int offset = this.getOffset(pos);
        this.values[offset] = data.getInt(key);
        int value = this.values[offset];
        if (value == 0) {
            this.nullIndicators.set(offset, !data.isNull(key));
        }
    }

    public void populateFrom(int[] pos, SegmentLoader.RowList rowList, int column) {
        int offset = this.getOffset(pos);
        this.values[offset] = rowList.getInt(column);
        int value = this.values[offset];
        if (value == 0) {
            this.nullIndicators.set(offset, !rowList.isNull(column));
        }
    }

    public SqlStatement.Type getType() {
        return SqlStatement.Type.INT;
    }

    public void put(CellKey key, int value) {
        int offset = key.getOffset(this.axisMultipliers);
        this.values[offset] = value;
    }

    public void put(int[] ordinals, int value) {
        int offset = this.getOffset(ordinals);
        this.values[offset] = value;
    }

    void set(int k, int o) {
        this.values[k] = o;
    }

    protected int size() {
        return this.values.length;
    }
}

