/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap.agg;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import mondrian.olap.Util;
import mondrian.rolap.BitKey;
import mondrian.rolap.RolapStar;
import mondrian.rolap.StarPredicate;
import mondrian.rolap.agg.CellRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AggregationKey {
    private final RolapStar star;
    private final BitKey constrainedColumnsBitKey;
    private final Map<BitKey, StarPredicate> compoundPredicateMap;
    private int hashCode;

    public AggregationKey(CellRequest request) {
        this.constrainedColumnsBitKey = request.getConstrainedColumnsBitKey();
        this.star = request.getMeasure().getStar();
        this.compoundPredicateMap = request.getCompoundPredicateMap();
    }

    public int computeHashCode() {
        int retCode = this.constrainedColumnsBitKey.hashCode();
        retCode = Util.hash(retCode, this.star);
        if (this.compoundPredicateMap != null) {
            for (BitKey bitKey : this.compoundPredicateMap.keySet()) {
                retCode = Util.hash(retCode, bitKey.hashCode());
            }
        }
        return retCode;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = this.computeHashCode();
        }
        return this.hashCode;
    }

    public boolean equals(Object other) {
        if (!(other instanceof AggregationKey)) {
            return false;
        }
        AggregationKey that = (AggregationKey)other;
        return this.constrainedColumnsBitKey.equals(that.constrainedColumnsBitKey) && this.star.equals(that.star) && AggregationKey.equal(this.compoundPredicateMap, that.compoundPredicateMap);
    }

    private static boolean equal(Map<BitKey, StarPredicate> map1, Map<BitKey, StarPredicate> map2) {
        if (map1 == null) {
            return map2 == null;
        }
        if (map2 == null) {
            return false;
        }
        if (map1.size() != map2.size()) {
            return false;
        }
        for (BitKey bitKey : map1.keySet()) {
            StarPredicate thisPred = map1.get(bitKey);
            StarPredicate otherPred = map2.get(bitKey);
            if (thisPred != null && otherPred != null && thisPred.equalConstraint(otherPred)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.star.getFactTable().getTableName() + " " + this.constrainedColumnsBitKey.toString() + "\n" + (this.compoundPredicateMap == null ? "{}" : this.compoundPredicateMap.toString());
    }

    public final BitKey getConstrainedColumnsBitKey() {
        return this.constrainedColumnsBitKey;
    }

    public final RolapStar getStar() {
        return this.star;
    }

    public List<StarPredicate> getCompoundPredicateList() {
        if (this.compoundPredicateMap == null) {
            return Collections.emptyList();
        }
        return new ArrayList<StarPredicate>(this.compoundPredicateMap.values());
    }
}

