/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.sql.DataSource;
import mondrian.olap.Query;
import mondrian.olap.Util;
import mondrian.olap.fun.FunUtil;
import mondrian.rolap.ResultLoader;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapLevel;
import mondrian.rolap.RolapMember;
import mondrian.rolap.RolapUtil;
import mondrian.rolap.SqlStatement;
import mondrian.rolap.SqlTupleReader;
import mondrian.rolap.Target;
import mondrian.rolap.TargetBase;
import mondrian.rolap.TupleReader;
import mondrian.rolap.sql.TupleConstraint;
import mondrian.util.TraversalList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HighCardSqlTupleReader
extends SqlTupleReader {
    private ResultLoader resultLoader;
    private boolean moreRows;
    int maxRows = 0;

    public HighCardSqlTupleReader(TupleConstraint constraint) {
        super(constraint);
    }

    @Override
    public void addLevelMembers(RolapLevel level, TupleReader.MemberBuilder memberBuilder, List<RolapMember> srcMembers) {
        this.targets.add(new Target(level, memberBuilder, srcMembers, this.constraint, this));
    }

    @Override
    protected void prepareTuples(DataSource dataSource, List<List<RolapMember>> partialResult, List<List<RolapMember>> newPartialResult) {
        String message = "Populating member cache with members for " + this.targets;
        SqlStatement stmt = null;
        boolean execQuery = partialResult == null;
        try {
            if (execQuery) {
                ArrayList<TargetBase> partialTargets = new ArrayList<TargetBase>();
                for (TargetBase target : this.targets) {
                    if (target.getSrcMembers() != null) continue;
                    partialTargets.add(target);
                }
                String sql = this.makeLevelMembersSql(dataSource);
                stmt = RolapUtil.executeQuery(dataSource, sql, this.maxRows, 0, "HighCardSqlTupleReader.readTuples " + partialTargets, message, -1, -1);
            }
            for (TargetBase target : this.targets) {
                target.open();
            }
            int enumTargetCount = this.getEnumTargetCount();
            int currPartialResultIdx = 0;
            if (execQuery) {
                this.moreRows = stmt.getResultSet().next();
                if (this.moreRows) {
                    ++stmt.rowCount;
                }
            } else {
                this.moreRows = currPartialResultIdx < partialResult.size();
            }
            this.resultLoader = new ResultLoader(enumTargetCount, this.targets, stmt, execQuery, partialResult, newPartialResult);
            this.readNextTuple();
            this.readNextTuple();
        }
        catch (SQLException sqle) {
            if (stmt != null) {
                throw stmt.handle(sqle);
            }
            throw Util.newError(sqle, message);
        }
        finally {
            if (!this.moreRows && stmt != null) {
                stmt.close();
            }
        }
    }

    @Override
    public List<RolapMember> readMembers(DataSource dataSource, List<List<RolapMember>> partialResult, List<List<RolapMember>> newPartialResult) {
        this.prepareTuples(dataSource, partialResult, newPartialResult);
        assert (this.targets.size() == 1);
        return ((TargetBase)this.targets.get(0)).close();
    }

    @Override
    public List<RolapMember[]> readTuples(DataSource jdbcConnection, List<List<RolapMember>> partialResult, List<List<RolapMember>> newPartialResult) {
        this.prepareTuples(jdbcConnection, partialResult, newPartialResult);
        int n = this.targets.size();
        List[] lists = new List[n];
        for (int i = 0; i < n; ++i) {
            lists[i] = ((TargetBase)this.targets.get(i)).close();
        }
        TraversalList<RolapMember> tupleList = new TraversalList<RolapMember>(lists, RolapMember.class);
        int enumTargetCount = this.getEnumTargetCount();
        if (enumTargetCount > 0) {
            FunUtil.hierarchizeTupleList(Util.cast(tupleList), false, n);
        }
        return tupleList;
    }

    public boolean readNextTuple() {
        if (!this.moreRows) {
            return false;
        }
        try {
            this.moreRows = this.resultLoader.loadResult();
        }
        catch (SQLException sqle) {
            this.moreRows = false;
            throw this.resultLoader.handle(sqle);
        }
        if (!this.moreRows) {
            this.resultLoader.close();
        }
        return this.moreRows;
    }

    @Override
    public void setMaxRows(int maxRows) {
        this.maxRows = maxRows;
    }

    @Override
    public int getMaxRows() {
        return this.maxRows;
    }

    @Override
    Collection<RolapCube> getBaseCubeCollection(Query query) {
        return query.getBaseCubes();
    }
}

