/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import mondrian.calc.Calc;
import mondrian.calc.DummyExp;
import mondrian.calc.ExpCompiler;
import mondrian.calc.ListCalc;
import mondrian.calc.MemberCalc;
import mondrian.calc.MemberListCalc;
import mondrian.calc.TupleCalc;
import mondrian.calc.TupleListCalc;
import mondrian.calc.impl.AbstractCalc;
import mondrian.calc.impl.AbstractIntegerCalc;
import mondrian.calc.impl.CacheCalc;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.ExpCacheDescriptor;
import mondrian.olap.FunDef;
import mondrian.olap.Hierarchy;
import mondrian.olap.Member;
import mondrian.olap.MondrianProperties;
import mondrian.olap.Util;
import mondrian.olap.fun.FunDefBase;
import mondrian.olap.fun.FunUtil;
import mondrian.olap.fun.ReflectiveMultiResolver;
import mondrian.olap.type.SetType;
import mondrian.olap.type.TupleType;
import mondrian.olap.type.Type;
import mondrian.rolap.RolapUtil;

public class RankFunDef
extends FunDefBase {
    static final boolean debug = false;
    static final ReflectiveMultiResolver Resolver = new ReflectiveMultiResolver("Rank", "Rank(<Tuple>, <Set> [, <Calc Expression>])", "Returns the one-based rank of a tuple in a set.", new String[]{"fitx", "fitxn", "fimx", "fimxn"}, RankFunDef.class);

    public RankFunDef(FunDef dummyFunDef) {
        super(dummyFunDef);
    }

    public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
        switch (call.getArgCount()) {
            case 2: {
                return this.compileCall2(call, compiler);
            }
            case 3: {
                return this.compileCall3(call, compiler);
            }
        }
        throw Util.newInternal("invalid arg count " + call.getArgCount());
    }

    public Calc compileCall3(ResolvedFunCall call, ExpCompiler compiler) {
        Type type0 = call.getArg(0).getType();
        ListCalc listCalc = compiler.compileList(call.getArg(1));
        SetType setType = (SetType)call.getArg(1).getType();
        boolean isTupleList = setType.getElementType() instanceof TupleType;
        Calc keyCalc = compiler.compileScalar(call.getArg(2), true);
        SortedListCalc sortedListCalc = new SortedListCalc(call, listCalc, keyCalc, isTupleList);
        ExpCacheDescriptor cacheDescriptor = new ExpCacheDescriptor(call, sortedListCalc, compiler.getEvaluator());
        if (type0 instanceof TupleType) {
            TupleCalc tupleCalc = compiler.compileTuple(call.getArg(0));
            return new Rank3TupleCalc(call, tupleCalc, keyCalc, cacheDescriptor);
        }
        MemberCalc memberCalc = compiler.compileMember(call.getArg(0));
        return new Rank3MemberCalc(call, memberCalc, keyCalc, cacheDescriptor);
    }

    public Calc compileCall2(ResolvedFunCall call, ExpCompiler compiler) {
        AbstractCalc listCalc;
        boolean tuple = call.getArg(0).getType() instanceof TupleType;
        Exp listExp = call.getArg(1);
        ListCalc listCalc0 = compiler.compileList(listExp);
        RankedListCalc listCalc1 = new RankedListCalc(listCalc0, tuple);
        if (MondrianProperties.instance().EnableExpCache.get()) {
            ExpCacheDescriptor key = new ExpCacheDescriptor(listExp, listCalc1, compiler.getEvaluator());
            listCalc = new CacheCalc(listExp, key);
        } else {
            listCalc = listCalc1;
        }
        if (tuple) {
            TupleCalc tupleCalc = compiler.compileTuple(call.getArg(0));
            return new Rank2TupleCalc(call, tupleCalc, listCalc);
        }
        MemberCalc memberCalc = compiler.compileMember(call.getArg(0));
        return new Rank2MemberCalc(call, memberCalc, listCalc);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class RankedTupleList {
        final Map<List<Member>, Integer> map = new HashMap<List<Member>, Integer>();

        RankedTupleList(List<Member[]> tupleList) {
            int i = -1;
            for (Member[] tupleMembers : tupleList) {
                List<Member> key = Arrays.asList(tupleMembers);
                Integer value = this.map.put(key, ++i);
                if (value == null) continue;
                this.map.put(key, value);
            }
        }

        int indexOf(Member[] tupleMembers) {
            List<Member> key = Arrays.asList(tupleMembers);
            Integer integer = this.map.get(key);
            if (integer == null) {
                return -1;
            }
            return integer;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class RankedMemberList {
        Map<Member, Integer> map = new HashMap<Member, Integer>();

        RankedMemberList(List<Member> members) {
            int i = -1;
            for (Member member : members) {
                Integer value = this.map.put(member, ++i);
                if (value == null) continue;
                this.map.put(member, value);
            }
        }

        int indexOf(Member m) {
            Integer integer = this.map.get(m);
            if (integer == null) {
                return -1;
            }
            return integer;
        }
    }

    private static class RankedListCalc
    extends AbstractCalc {
        private final ListCalc listCalc;
        private final boolean tuple;

        public RankedListCalc(ListCalc listCalc, boolean tuple) {
            super(new DummyExp(listCalc.getType()), new Calc[]{listCalc});
            this.listCalc = listCalc;
            this.tuple = tuple;
        }

        public Object evaluate(Evaluator evaluator) {
            if (this.tuple) {
                List<Member[]> tupleList = ((TupleListCalc)this.listCalc).evaluateTupleList(evaluator);
                assert (tupleList != null);
                return new RankedTupleList(tupleList);
            }
            List<Member> memberList = ((MemberListCalc)this.listCalc).evaluateMemberList(evaluator);
            assert (memberList != null);
            return new RankedMemberList(memberList);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SortResult {
        final Object[] values;
        final Map<List<Member>, Integer> rankMap;
        final boolean isMemberResultSet;
        List<Member> tmpList = new ArrayList<Member>(1);

        public SortResult(Object[] values, Map<List<Member>, Integer> rankMap) {
            List anyKey;
            this.values = values;
            this.rankMap = rankMap;
            this.isMemberResultSet = rankMap != null && !rankMap.isEmpty() ? (anyKey = (List)rankMap.keySet().toArray()[0]).size() == 1 : false;
        }

        public boolean isEmpty() {
            return this.values == null;
        }

        public Integer rankOf(Member member) {
            if (this.rankMap == null || !this.isMemberResultSet) {
                return null;
            }
            this.tmpList.clear();
            this.tmpList.add(member);
            return this.rankMap.get(this.tmpList);
        }

        public Integer rankOf(Member[] tuple) {
            if (this.rankMap == null || this.isMemberResultSet) {
                return null;
            }
            return this.rankMap.get(Arrays.asList(tuple));
        }

        public void print(PrintWriter pw) {
            if (this.values == null) {
                pw.println("SortResult: empty");
            } else {
                pw.println("SortResult {");
                for (int i = 0; i < this.values.length; ++i) {
                    if (i > 0) {
                        pw.println(",");
                    }
                    Object value = this.values[i];
                    pw.print(value);
                }
                pw.println("}");
            }
            pw.flush();
        }
    }

    private static class SortedListCalc
    extends AbstractCalc {
        private final ListCalc listCalc;
        private final Calc keyCalc;
        private final boolean tupleList;
        private static final Integer ONE = 1;

        public SortedListCalc(Exp exp, ListCalc listCalc, Calc keyCalc, boolean tupleList) {
            super(exp, new Calc[]{listCalc, keyCalc});
            this.listCalc = listCalc;
            this.keyCalc = keyCalc;
            this.tupleList = tupleList;
        }

        public boolean dependsOn(Hierarchy hierarchy) {
            return SortedListCalc.anyDependsButFirst(this.getCalcs(), hierarchy);
        }

        public Object evaluate(Evaluator evaluator) {
            Evaluator evaluator2 = evaluator.push(false);
            List members = (List)this.listCalc.evaluate(evaluator2);
            assert (members != null);
            if (members.isEmpty()) {
                return new SortResult(null, null);
            }
            RuntimeException exception = null;
            TreeMap<Object, Integer> uniqueValueCounterMap = new TreeMap<Object, Integer>(FunUtil.DescendingValueComparator.instance);
            HashMap<Member[], Object> valueMap = new HashMap<Member[], Object>();
            if (!this.tupleList) {
                for (Object o : members) {
                    Member[] tmpMember = new Member[]{(Member)o};
                    evaluator2.setContext(tmpMember);
                    Object keyValue = this.keyCalc.evaluate(evaluator2);
                    if (keyValue instanceof RuntimeException) {
                        if (exception != null) continue;
                        exception = (RuntimeException)keyValue;
                        continue;
                    }
                    if (Util.isNull(keyValue)) continue;
                    Integer valueCounter = uniqueValueCounterMap.put(keyValue, ONE);
                    if (valueCounter != null) {
                        uniqueValueCounterMap.put(keyValue, valueCounter + 1);
                    }
                    valueMap.put(tmpMember, keyValue);
                }
            } else {
                for (Object o : members) {
                    evaluator2.setContext((Member[])o);
                    Object keyValue = this.keyCalc.evaluate(evaluator2);
                    if (keyValue instanceof RuntimeException) {
                        if (exception != null) continue;
                        exception = (RuntimeException)keyValue;
                        continue;
                    }
                    if (Util.isNull(keyValue)) continue;
                    Integer valueCounter = uniqueValueCounterMap.put(keyValue, ONE);
                    if (valueCounter != null) {
                        uniqueValueCounterMap.put(keyValue, valueCounter + 1);
                    }
                    valueMap.put((Member[])o, keyValue);
                }
            }
            if (exception != null) {
                return exception;
            }
            int numValues = valueMap.keySet().size();
            Object[] allValuesSorted = new Object[numValues];
            Integer currentOrdinal = 0;
            Integer valueCount = 0;
            TreeMap uniqueValueRankMap = new TreeMap(FunUtil.DescendingValueComparator.instance);
            for (Object keyValue : uniqueValueCounterMap.keySet()) {
                valueCount = (Integer)uniqueValueCounterMap.get(keyValue);
                for (int i = 0; i < valueCount; ++i) {
                    allValuesSorted[currentOrdinal.intValue() + i] = keyValue;
                }
                uniqueValueRankMap.put(keyValue, currentOrdinal + 1);
                currentOrdinal = currentOrdinal + valueCount;
            }
            HashMap<List<Member>, Integer> rankMap = new HashMap<List<Member>, Integer>();
            for (Member[] memberKey : valueMap.keySet()) {
                int oneBasedRank = (Integer)uniqueValueRankMap.get(valueMap.get(memberKey));
                rankMap.put(Arrays.asList(memberKey), oneBasedRank);
            }
            return new SortResult(allValuesSorted, rankMap);
        }
    }

    private static class Rank3MemberCalc
    extends AbstractIntegerCalc {
        private final MemberCalc memberCalc;
        private final Calc sortCalc;
        private final ExpCacheDescriptor cacheDescriptor;

        public Rank3MemberCalc(ResolvedFunCall call, MemberCalc memberCalc, Calc sortCalc, ExpCacheDescriptor cacheDescriptor) {
            super(call, new Calc[]{memberCalc, sortCalc});
            this.memberCalc = memberCalc;
            this.sortCalc = sortCalc;
            this.cacheDescriptor = cacheDescriptor;
        }

        public int evaluateInteger(Evaluator evaluator) {
            Member member = this.memberCalc.evaluateMember(evaluator);
            if (member == null || member.isNull()) {
                return -2147483647;
            }
            SortResult sortResult = (SortResult)evaluator.getCachedResult(this.cacheDescriptor);
            if (sortResult.isEmpty()) {
                return -2147483647;
            }
            Integer rank = sortResult.rankOf(member);
            if (rank != null) {
                return rank;
            }
            Evaluator evaluator2 = evaluator.push(member);
            Object value = this.sortCalc.evaluate(evaluator2);
            if (value == RolapUtil.valueNotReadyException) {
                return 0;
            }
            if (value == Util.nullValue) {
                return sortResult.values.length + 1;
            }
            int j = FunUtil.searchValuesDesc(sortResult.values, value);
            if (j < 0) {
                j = -(j + 1);
            }
            return j + 1;
        }
    }

    private static class Rank3TupleCalc
    extends AbstractIntegerCalc {
        private final TupleCalc tupleCalc;
        private final Calc sortCalc;
        private final ExpCacheDescriptor cacheDescriptor;

        public Rank3TupleCalc(ResolvedFunCall call, TupleCalc tupleCalc, Calc sortCalc, ExpCacheDescriptor cacheDescriptor) {
            super(call, new Calc[]{tupleCalc, sortCalc});
            this.tupleCalc = tupleCalc;
            this.sortCalc = sortCalc;
            this.cacheDescriptor = cacheDescriptor;
        }

        public int evaluateInteger(Evaluator evaluator) {
            Member[] members = this.tupleCalc.evaluateTuple(evaluator);
            if (members == null) {
                return -2147483647;
            }
            assert (!FunUtil.tupleContainsNullMember(members));
            SortResult sortResult = (SortResult)evaluator.getCachedResult(this.cacheDescriptor);
            if (sortResult.isEmpty()) {
                return -2147483647;
            }
            Integer rank = sortResult.rankOf(members);
            if (rank != null) {
                return rank;
            }
            Evaluator evaluator2 = evaluator.push(members);
            Object value = this.sortCalc.evaluate(evaluator2);
            if (value == RolapUtil.valueNotReadyException) {
                return 0;
            }
            if (value == Util.nullValue) {
                return sortResult.values.length + 1;
            }
            int j = FunUtil.searchValuesDesc(sortResult.values, value);
            if (j < 0) {
                j = -(j + 1);
            }
            return j + 1;
        }
    }

    private static class Rank2MemberCalc
    extends AbstractIntegerCalc {
        private final MemberCalc memberCalc;
        private final Calc listCalc;

        public Rank2MemberCalc(ResolvedFunCall call, MemberCalc memberCalc, Calc listCalc) {
            super(call, new Calc[]{memberCalc, listCalc});
            this.memberCalc = memberCalc;
            this.listCalc = listCalc;
        }

        public int evaluateInteger(Evaluator evaluator) {
            Member member = this.memberCalc.evaluateMember(evaluator);
            if (member == null || member.isNull()) {
                return -2147483647;
            }
            RankedMemberList rankedMemberList = (RankedMemberList)this.listCalc.evaluate(evaluator);
            if (rankedMemberList == null) {
                return 0;
            }
            int i = rankedMemberList.indexOf(member);
            return i + 1;
        }
    }

    private static class Rank2TupleCalc
    extends AbstractIntegerCalc {
        private final TupleCalc tupleCalc;
        private final Calc listCalc;

        public Rank2TupleCalc(ResolvedFunCall call, TupleCalc tupleCalc, Calc listCalc) {
            super(call, new Calc[]{tupleCalc, listCalc});
            this.tupleCalc = tupleCalc;
            this.listCalc = listCalc;
        }

        public int evaluateInteger(Evaluator evaluator) {
            Member[] members = this.tupleCalc.evaluateTuple(evaluator);
            if (members == null) {
                return -2147483647;
            }
            assert (!FunUtil.tupleContainsNullMember(members));
            RankedTupleList rankedTupleList = (RankedTupleList)this.listCalc.evaluate(evaluator);
            if (rankedTupleList == null) {
                return 0;
            }
            int i = rankedTupleList.indexOf(members);
            return i + 1;
        }
    }
}

