/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap;

import java.io.PrintWriter;
import java.util.List;
import mondrian.olap.Exp;
import mondrian.olap.ExpBase;
import mondrian.olap.Query;
import mondrian.olap.QueryPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DrillThrough
extends QueryPart {
    private final Query query;
    private final int maxRowCount;
    private final int firstRowOrdinal;
    private final List<Exp> returnList;

    DrillThrough(Query query, int maxRowCount, int firstRowOrdinal, List<Exp> returnList) {
        this.query = query;
        this.maxRowCount = maxRowCount;
        this.firstRowOrdinal = firstRowOrdinal;
        this.returnList = returnList;
    }

    @Override
    public void unparse(PrintWriter pw) {
        pw.print("DRILLTHROUGH");
        if (this.maxRowCount >= 0) {
            pw.print(" MAXROWS ");
            pw.print(this.maxRowCount);
        }
        if (this.firstRowOrdinal >= 0) {
            pw.print(" FIRSTROWSET ");
            pw.print(this.firstRowOrdinal);
        }
        pw.print(" ");
        this.query.unparse(pw);
        if (this.returnList != null) {
            ExpBase.unparseList(pw, this.returnList.toArray(new Exp[this.returnList.size()]), " RETURN ", ", ", "");
        }
    }

    @Override
    public Object[] getChildren() {
        return new Object[]{this.maxRowCount, this.firstRowOrdinal, this.query, this.returnList};
    }

    public Query getQuery() {
        return this.query;
    }

    public int getMaxRowCount() {
        return this.maxRowCount;
    }

    public int getFirstRowOrdinal() {
        return this.firstRowOrdinal;
    }
}

