/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap;

import java.util.List;
import mondrian.olap.Cube;
import mondrian.olap.Dimension;
import mondrian.olap.DimensionType;
import mondrian.olap.Hierarchy;
import mondrian.olap.Id;
import mondrian.olap.Level;
import mondrian.olap.LevelType;
import mondrian.olap.MatchType;
import mondrian.olap.Member;
import mondrian.olap.MondrianProperties;
import mondrian.olap.OlapElement;
import mondrian.olap.OlapElementBase;
import mondrian.olap.SchemaReader;
import mondrian.olap.Util;
import mondrian.resource.MondrianResource;

public abstract class CubeBase
extends OlapElementBase
implements Cube {
    public static final int CATALOG_NAME = 0;
    public static final int SCHEMA_NAME = 1;
    public static final int CUBE_NAME = 2;
    public static final int DIMENSION_UNIQUE_NAME = 3;
    public static final int HIERARCHY_UNIQUE_NAME = 4;
    public static final int LEVEL_UNIQUE_NAME = 5;
    public static final int LEVEL_NUMBER = 6;
    public static final int MEMBER_NAME = 7;
    public static final int MEMBER_UNIQUE_NAME = 8;
    public static final int MEMBER_CAPTION = 9;
    public static final int MEMBER_TYPE = 10;
    public static final int Tree_Operator = 11;
    public static final int maxNofConstraintsForAdSchemaMember = 12;
    public static final int MDTREEOP_SELF = 0;
    public static final int MDTREEOP_CHILDREN = 1;
    public static final int MDPROP_USERDEFINED0 = 19;
    protected final String name;
    private final String uniqueName;
    private final String description;
    protected Dimension[] dimensions;

    protected CubeBase(String name, String caption, String description, Dimension[] dimensions) {
        this.name = name;
        this.caption = caption;
        this.description = description;
        this.dimensions = dimensions;
        this.uniqueName = Util.quoteMdxIdentifier(name);
    }

    public String getName() {
        return this.name;
    }

    public String getUniqueName() {
        return this.uniqueName;
    }

    public String getQualifiedName() {
        return MondrianResource.instance().MdxCubeName.str(this.getName());
    }

    public Dimension getDimension() {
        return null;
    }

    public Hierarchy getHierarchy() {
        return null;
    }

    public String getDescription() {
        return this.description;
    }

    public Dimension[] getDimensions() {
        return this.dimensions;
    }

    public Hierarchy lookupHierarchy(Id.Segment s, boolean unique) {
        for (Dimension dimension : this.dimensions) {
            Hierarchy[] hierarchies;
            for (Hierarchy hierarchy : hierarchies = dimension.getHierarchies()) {
                String name;
                String string = name = unique ? hierarchy.getUniqueName() : hierarchy.getName();
                if (!name.equals(s.name)) continue;
                return hierarchy;
            }
        }
        return null;
    }

    public OlapElement lookupChild(SchemaReader schemaReader, Id.Segment s, MatchType matchType) {
        Dimension mdxDimension = this.lookupDimension(s);
        if (mdxDimension != null) {
            return mdxDimension;
        }
        List<Dimension> dimensions = schemaReader.getCubeDimensions(this);
        if (MondrianProperties.instance().SsasCompatibleNaming.get() && s.name.contains(".")) {
            for (Dimension dimension : dimensions) {
                if (!s.name.startsWith(dimension.getName())) continue;
                for (Hierarchy hierarchy : schemaReader.getDimensionHierarchies(dimension)) {
                    if (!Util.equalName(s.name, dimension.getName() + "." + hierarchy.getName())) continue;
                    return hierarchy;
                }
            }
        }
        for (Dimension dimension : dimensions) {
            OlapElement mdxElement = dimension.lookupChild(schemaReader, s, matchType);
            if (mdxElement == null || mdxElement instanceof Member && MondrianProperties.instance().NeedDimensionPrefix.get()) continue;
            return mdxElement;
        }
        return null;
    }

    public Dimension lookupDimension(Id.Segment s) {
        for (Dimension dimension : this.dimensions) {
            if (!Util.equalName(dimension.getName(), s.name)) continue;
            return dimension;
        }
        return null;
    }

    private Level getTimeLevel(LevelType levelType) {
        for (Dimension dimension : this.dimensions) {
            Hierarchy[] hierarchies;
            if (dimension.getDimensionType() != DimensionType.TimeDimension) continue;
            for (Hierarchy hierarchy : hierarchies = dimension.getHierarchies()) {
                Level[] levels;
                for (Level level : levels = hierarchy.getLevels()) {
                    if (level.getLevelType() != levelType) continue;
                    return level;
                }
            }
        }
        return null;
    }

    public Level getYearLevel() {
        return this.getTimeLevel(LevelType.TimeYears);
    }

    public Level getQuarterLevel() {
        return this.getTimeLevel(LevelType.TimeQuarters);
    }

    public Level getMonthLevel() {
        return this.getTimeLevel(LevelType.TimeMonths);
    }

    public Level getWeekLevel() {
        return this.getTimeLevel(LevelType.TimeWeeks);
    }
}

