/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.TextUI;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.View;
import org.netbeans.api.editor.fold.Fold;
import org.netbeans.api.editor.fold.FoldHierarchy;
import org.netbeans.api.editor.fold.FoldHierarchyEvent;
import org.netbeans.api.editor.fold.FoldHierarchyListener;
import org.netbeans.api.editor.fold.FoldUtilities;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.settings.AttributesUtilities;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseDocumentEvent;
import org.netbeans.editor.BaseTextUI;
import org.netbeans.editor.Coloring;
import org.netbeans.editor.DrawEngineLineView;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.Utilities;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.editor.lib.SettingsConversions;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CodeFoldingSideBar
extends JComponent
implements Accessible {
    private static final Logger LOG = Logger.getLogger(CodeFoldingSideBar.class.getName());
    protected Color backColor;
    protected Color foreColor;
    protected Font font;
    protected JTextComponent component;
    private volatile AttributeSet attribs;
    private Lookup.Result<? extends FontColorSettings> fcsLookupResult;
    private final LookupListener fcsTracker = new LookupListener(){

        public void resultChanged(LookupEvent lookupEvent) {
            CodeFoldingSideBar.this.attribs = null;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    CodeFoldingSideBar.this.repaint();
                }
            });
        }
    };
    private final Listener listener = new Listener();
    private boolean enabled = false;
    protected List<Mark> visibleMarks = new ArrayList<Mark>();
    private final TreeMap<Integer, PaintInfo> cache = new TreeMap();
    public static final int PAINT_NOOP = 0;
    public static final int PAINT_MARK = 1;
    public static final int PAINT_LINE = 2;
    public static final int PAINT_END_MARK = 3;
    public static final int SINGLE_PAINT_MARK = 4;
    private final Preferences prefs;
    private final PreferenceChangeListener prefsListener = new PreferenceChangeListener(){

        public void preferenceChange(PreferenceChangeEvent preferenceChangeEvent) {
            String string;
            String string2 = string = preferenceChangeEvent == null ? null : preferenceChangeEvent.getKey();
            if (string == null || "code-folding-enable".equals(string)) {
                CodeFoldingSideBar.this.updateColors();
                boolean bl = CodeFoldingSideBar.this.prefs.getBoolean("code-folding-enable", false);
                if (CodeFoldingSideBar.this.enabled != bl) {
                    CodeFoldingSideBar.this.enabled = bl;
                    CodeFoldingSideBar.this.updatePreferredSize();
                }
            }
            SettingsConversions.callSettingsChange(CodeFoldingSideBar.this);
        }
    };

    public CodeFoldingSideBar() {
        this.component = null;
        this.prefs = null;
        throw new IllegalStateException("Do not use this constructor!");
    }

    public CodeFoldingSideBar(JTextComponent jTextComponent) {
        this.component = jTextComponent;
        this.addMouseListener(this.listener);
        FoldHierarchy foldHierarchy = FoldHierarchy.get((JTextComponent)jTextComponent);
        foldHierarchy.addFoldHierarchyListener((FoldHierarchyListener)WeakListeners.create(FoldHierarchyListener.class, (EventListener)this.listener, (Object)foldHierarchy));
        Document document = this.getDocument();
        document.addDocumentListener(WeakListeners.document((DocumentListener)this.listener, (Object)document));
        this.setOpaque(true);
        this.prefs = (Preferences)MimeLookup.getLookup((String)DocumentUtilities.getMimeType((JTextComponent)jTextComponent)).lookup(Preferences.class);
        this.prefs.addPreferenceChangeListener((PreferenceChangeListener)WeakListeners.create(PreferenceChangeListener.class, (EventListener)this.prefsListener, (Object)this.prefs));
        this.prefsListener.preferenceChange(null);
    }

    private void updatePreferredSize() {
        if (this.enabled) {
            this.setPreferredSize(new Dimension(this.getColoring().getFont().getSize(), this.component.getHeight()));
            this.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        } else {
            this.setPreferredSize(new Dimension(0, 0));
            this.setMaximumSize(new Dimension(0, 0));
        }
        this.revalidate();
    }

    private void updateColors() {
        Coloring coloring = this.getColoring();
        this.backColor = coloring.getBackColor();
        this.foreColor = coloring.getForeColor();
        this.font = coloring.getFont();
    }

    protected Color getBackColor() {
        if (this.backColor == null) {
            this.updateColors();
        }
        return this.backColor;
    }

    protected Color getForeColor() {
        if (this.foreColor == null) {
            this.updateColors();
        }
        return this.foreColor;
    }

    protected Font getColoringFont() {
        if (this.font == null) {
            this.updateColors();
        }
        return this.font;
    }

    @Override
    public void update(Graphics graphics) {
    }

    protected void collectPaintInfos(View view, Fold fold, Map<Integer, PaintInfo> map, int n, int n2, int n3) throws BadLocationException {
        PaintInfo paintInfo;
        int n4;
        Rectangle rectangle;
        int n5;
        int n6;
        for (n6 = 0; n6 < fold.getFoldCount(); ++n6) {
            Fold fold2 = fold.getFold(n6);
            this.collectPaintInfos(view, fold2, map, n + 1, n2, n3);
        }
        n6 = fold.getStartOffset();
        int n7 = fold.getEndOffset();
        if (n7 > (n5 = view.getDocument().getLength())) {
            return;
        }
        int n8 = view.getViewIndex(n6, Position.Bias.Forward);
        int n9 = view.getViewIndex(n7, Position.Bias.Forward);
        BaseTextUI baseTextUI = (BaseTextUI)this.component.getUI();
        int n10 = -1;
        int n11 = -1;
        View view2 = view.getView(n8);
        Rectangle rectangle2 = baseTextUI.modelToView(this.component, view2.getStartOffset());
        if (rectangle2 != null) {
            rectangle = rectangle2.getBounds();
            n11 = rectangle.y + rectangle.height;
            int n12 = n4 = n8 == n9 ? 1 : 0;
            if (fold.isCollapsed() || n4 != 0) {
                int n13;
                int n14 = fold.isCollapsed();
                if (n14 != 0) {
                    n13 = fold.getEndOffset();
                    int n15 = javax.swing.text.Utilities.getRowEnd(this.component, n13);
                    for (Fold fold3 = fold.getParent(); fold3 != null && !FoldUtilities.isRootFold((Fold)fold3); fold3 = fold3.getParent()) {
                        if (n15 == javax.swing.text.Utilities.getRowEnd(this.component, fold3.getEndOffset())) continue;
                        n14 = 0;
                        break;
                    }
                }
                n13 = fold.isCollapsed() ? n14 : n4;
                map.put(rectangle.y, new PaintInfo(n13 != 0 ? 4 : 1, n, rectangle.y, rectangle.height, fold.isCollapsed()));
                return;
            }
            n10 = rectangle.y;
            map.put(rectangle.y, new PaintInfo(1, n, rectangle.y, rectangle.height, fold.isCollapsed()));
        }
        if (n == 0) {
            n4 = n8 + 1;
            int n16 = n9;
            rectangle = null;
            for (int i = n4; i <= n16; ++i) {
                view2 = view.getView(i);
                if (view2 instanceof DrawEngineLineView && n11 > -1) {
                    int n17 = (int)((DrawEngineLineView)view2).getLayoutMajorAxisPreferredSpan();
                    rectangle = new Rectangle(0, n11, 0, n17);
                    if (i < n16 && n16 > n4) {
                        n11 += n17;
                    }
                } else {
                    rectangle2 = baseTextUI.modelToView(this.component, view2.getStartOffset());
                    if (rectangle2 != null) {
                        rectangle = rectangle2.getBounds();
                        if (i < n16 && n16 > n4) {
                            n11 = rectangle.y + rectangle.height;
                        }
                    }
                }
                if (rectangle == null || map.containsKey(rectangle.y)) continue;
                map.put(rectangle.y, new PaintInfo(2, n, rectangle.y, rectangle.height));
            }
        }
        view2 = view.getView(n9);
        rectangle = null;
        if (view2 instanceof DrawEngineLineView && n11 > -1 && n == 0) {
            n4 = (int)((DrawEngineLineView)view2).getLayoutMajorAxisPreferredSpan();
            rectangle = new Rectangle(0, n11, 0, n4);
            n11 += n4;
        } else {
            rectangle2 = baseTextUI.modelToView(this.component, view2.getStartOffset());
            if (rectangle2 != null) {
                rectangle = rectangle2.getBounds();
                n11 = rectangle.y + rectangle.height;
            }
        }
        if (rectangle != null && n10 != rectangle.y && ((paintInfo = map.get(rectangle.y)) == null || paintInfo.getPaintOperation() != 1 && paintInfo.getPaintOperation() != 4 || n >= paintInfo.getInnerLevel())) {
            map.put(rectangle.y, new PaintInfo(3, n, rectangle.y, rectangle.height));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<? extends PaintInfo> getPaintInfo(int n, int n2) throws BadLocationException {
        BaseDocument baseDocument = Utilities.getDocument(this.component);
        if (baseDocument == null) {
            return Collections.emptyList();
        }
        baseDocument.readLock();
        try {
            FoldHierarchy foldHierarchy;
            block10: {
                Cloneable cloneable;
                foldHierarchy = FoldHierarchy.get((JTextComponent)this.component);
                foldHierarchy.lock();
                try {
                    Object object;
                    Object object2;
                    View view = Utilities.getDocumentView(this.component);
                    if (view == null) break block10;
                    int n3 = view.getViewIndex(n, Position.Bias.Forward);
                    int n4 = view.getViewIndex(n2, Position.Bias.Forward);
                    List<? extends Fold> list = this.getFoldList(foldHierarchy, n, n2);
                    for (int i = 0; i < list.size(); ++i) {
                        object2 = list.get(i);
                        object = this.component.modelToView(object2.getStartOffset());
                        cloneable = this.component.modelToView(object2.getEndOffset());
                        if (this.cache.containsKey(((Rectangle)object).y) && this.cache.containsKey(cloneable.y)) continue;
                        this.collectPaintInfos(view, (Fold)object2, (Map<Integer, PaintInfo>)this.cache, 0, n3, n4);
                    }
                    Rectangle rectangle = this.component.modelToView(view.getView(n3).getStartOffset());
                    object2 = this.component.modelToView(view.getView(n4).getStartOffset());
                    object = this.cache.subMap(rectangle.y, object2.y + 1);
                    cloneable = new ArrayList(object.values());
                }
                catch (Throwable throwable) {
                    foldHierarchy.unlock();
                    throw throwable;
                }
                foldHierarchy.unlock();
                return cloneable;
            }
            List list = Collections.emptyList();
            foldHierarchy.unlock();
            return list;
        }
        finally {
            baseDocument.readUnlock();
        }
    }

    protected EditorUI getEditorUI() {
        return Utilities.getEditorUI(this.component);
    }

    protected Document getDocument() {
        return this.component.getDocument();
    }

    private Fold getLastLineFold(FoldHierarchy foldHierarchy, int n, int n2) {
        Fold fold = FoldUtilities.findNearestFold((FoldHierarchy)foldHierarchy, (int)n);
        while (fold != null && fold.getStartOffset() < n2) {
            Fold fold2 = FoldUtilities.findNearestFold((FoldHierarchy)foldHierarchy, (int)(fold.isCollapsed() ? fold.getEndOffset() : fold.getStartOffset() + 1));
            if (fold2 == fold) {
                return fold;
            }
            if (fold2 != null && fold2.getStartOffset() < n2) {
                fold = fold2;
                continue;
            }
            return fold;
        }
        return fold;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performAction(Mark mark) {
        BaseTextUI baseTextUI = (BaseTextUI)this.component.getUI();
        Element element = baseTextUI.getRootView(this.component).getElement();
        View view = Utilities.getDocumentView(this.component);
        if (view == null) {
            return;
        }
        try {
            int n = view.getViewIndex(baseTextUI.getPosFromY(mark.y + mark.size / 2), Position.Bias.Forward);
            View view2 = view.getView(n);
            FoldHierarchy foldHierarchy = FoldHierarchy.get((JTextComponent)this.component);
            AbstractDocument abstractDocument = (AbstractDocument)foldHierarchy.getComponent().getDocument();
            abstractDocument.readLock();
            try {
                foldHierarchy.lock();
                try {
                    int n2 = view2.getStartOffset();
                    int n3 = javax.swing.text.Utilities.getRowStart(this.component, n2);
                    int n4 = javax.swing.text.Utilities.getRowEnd(this.component, n2);
                    Fold fold = this.getLastLineFold(foldHierarchy, n3, n4);
                    if (fold != null && fold.getStartOffset() < view2.getEndOffset()) {
                        foldHierarchy.toggle(fold);
                    }
                }
                finally {
                    foldHierarchy.unlock();
                }
            }
            finally {
                abstractDocument.readUnlock();
            }
        }
        catch (BadLocationException badLocationException) {
            LOG.log(Level.WARNING, null, badLocationException);
        }
    }

    protected int getMarkSize(Graphics graphics) {
        FontMetrics fontMetrics;
        if (graphics != null && (fontMetrics = graphics.getFontMetrics(this.getColoring().getFont())) != null) {
            int n = fontMetrics.getAscent() - fontMetrics.getDescent();
            return n - n % 2;
        }
        return -1;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        if (!this.enabled) {
            return;
        }
        Rectangle rectangle = this.getVisibleRect();
        this.visibleMarks.clear();
        Coloring coloring = this.getColoring();
        graphics.setColor(coloring.getBackColor());
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics.setColor(coloring.getForeColor());
        TextUI textUI = this.component.getUI();
        if (!(textUI instanceof BaseTextUI)) {
            return;
        }
        BaseTextUI baseTextUI = (BaseTextUI)textUI;
        try {
            int n = baseTextUI.getPosFromY(rectangle.y);
            int n2 = baseTextUI.viewToModel(this.component, 16383, rectangle.y + rectangle.height);
            List<? extends PaintInfo> list = this.getPaintInfo(n, n2);
            Font font = coloring.getFont();
            for (PaintInfo paintInfo : list) {
                if (paintInfo.getPaintOperation() == 0 && paintInfo.getInnerLevel() == 0) continue;
                boolean bl = paintInfo.isCollapsed();
                int n3 = paintInfo.getPaintY();
                int n4 = paintInfo.getPaintHeight();
                int n5 = this.getMarkSize(graphics);
                int n6 = n5 / 2;
                int n7 = (font.getSize() - n5) / 2;
                int n8 = n3 + graphics.getFontMetrics(font).getDescent();
                int n9 = (int)Math.round((double)n5 / 3.8);
                int n10 = n7 + n6;
                int n11 = paintInfo.getPaintOperation();
                if (n11 == 1 || n11 == 4) {
                    graphics.drawRect(n7, n8, n5, n5);
                    graphics.drawLine(n9 + n7, n8 + n6, n5 + n7 - n9, n8 + n6);
                    if (bl) {
                        graphics.drawLine(n10, n8 + n9, n10, n8 + n5 - n9);
                    } else if (n11 != 4) {
                        graphics.drawLine(n10, n8 + n5, n10, n3 + n4);
                    }
                    if (paintInfo.getInnerLevel() > 0) {
                        graphics.drawLine(n10, n3, n10, n8);
                        if (n11 != 4) {
                            graphics.drawLine(n10, n8 + n5, n10, n3 + n4);
                        }
                    }
                    this.visibleMarks.add(new Mark(n7, n8, n5, bl));
                    continue;
                }
                if (n11 == 2) {
                    graphics.drawLine(n10, n3, n10, n3 + n4);
                    continue;
                }
                if (n11 != 3) continue;
                graphics.drawLine(n10, n3, n10, n3 + n4 / 2);
                graphics.drawLine(n10, n3 + n4 / 2, n10 + n6, n3 + n4 / 2);
                if (paintInfo.getInnerLevel() <= 0) continue;
                graphics.drawLine(n10, n3 + n4 / 2, n10, n3 + n4);
            }
        }
        catch (BadLocationException badLocationException) {
            LOG.log(Level.WARNING, null, badLocationException);
        }
    }

    private List<? extends Fold> getFoldList(FoldHierarchy foldHierarchy, int n, int n2) {
        Fold fold;
        ArrayList<Fold> arrayList = new ArrayList<Fold>();
        Fold fold2 = foldHierarchy.getRootFold();
        int n3 = fold2.getFoldCount();
        for (int i = FoldUtilities.findFoldEndIndex((Fold)fold2, (int)n); i < n3 && (fold = fold2.getFold(i)).getStartOffset() <= n2; ++i) {
            arrayList.add(fold);
        }
        return arrayList;
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new JComponent.AccessibleJComponent(){

                public AccessibleRole getAccessibleRole() {
                    return AccessibleRole.PANEL;
                }
            };
            this.accessibleContext.setAccessibleName(NbBundle.getMessage(CodeFoldingSideBar.class, (String)"ACSN_CodeFoldingSideBar"));
            this.accessibleContext.setAccessibleDescription(NbBundle.getMessage(CodeFoldingSideBar.class, (String)"ACSD_CodeFoldingSideBar"));
        }
        return this.accessibleContext;
    }

    private Coloring getColoring() {
        if (this.attribs == null) {
            FontColorSettings fontColorSettings;
            AttributeSet attributeSet;
            if (this.fcsLookupResult == null) {
                this.fcsLookupResult = MimeLookup.getLookup((String)DocumentUtilities.getMimeType((JTextComponent)this.component)).lookupResult(FontColorSettings.class);
                this.fcsLookupResult.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)this.fcsTracker, this.fcsLookupResult));
            }
            attributeSet = (attributeSet = (fontColorSettings = (FontColorSettings)this.fcsLookupResult.allInstances().iterator().next()).getFontColors("code-folding-bar")) == null ? fontColorSettings.getFontColors("default") : AttributesUtilities.createComposite((AttributeSet[])new AttributeSet[]{attributeSet, fontColorSettings.getFontColors("default")});
            this.attribs = attributeSet;
        }
        return Coloring.fromAttributeSet(this.attribs);
    }

    private final class Listener
    extends MouseAdapter
    implements FoldHierarchyListener,
    DocumentListener {
        public void foldHierarchyChanged(FoldHierarchyEvent foldHierarchyEvent) {
            this.refresh();
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            if (!(documentEvent instanceof BaseDocumentEvent)) {
                return;
            }
            BaseDocumentEvent baseDocumentEvent = (BaseDocumentEvent)documentEvent;
            if (baseDocumentEvent.getLFCount() > 0) {
                this.refresh();
            }
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            if (!(documentEvent instanceof BaseDocumentEvent)) {
                return;
            }
            BaseDocumentEvent baseDocumentEvent = (BaseDocumentEvent)documentEvent;
            if (baseDocumentEvent.getLFCount() > 0) {
                this.refresh();
            }
        }

        public void changedUpdate(DocumentEvent documentEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            Mark mark = this.getClickedMark(mouseEvent);
            if (mark != null) {
                mouseEvent.consume();
                CodeFoldingSideBar.this.performAction(mark);
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            mouseEvent.consume();
        }

        private Mark getClickedMark(MouseEvent mouseEvent) {
            if (mouseEvent == null || !SwingUtilities.isLeftMouseButton(mouseEvent)) {
                return null;
            }
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            for (Mark mark : CodeFoldingSideBar.this.visibleMarks) {
                if (n < mark.x || n > mark.x + mark.size || n2 < mark.y || n2 > mark.y + mark.size) continue;
                return mark;
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void refresh() {
            BaseDocument baseDocument = Utilities.getDocument(CodeFoldingSideBar.this.component);
            if (baseDocument != null) {
                baseDocument.readLock();
                try {
                    FoldHierarchy foldHierarchy = FoldHierarchy.get((JTextComponent)CodeFoldingSideBar.this.component);
                    foldHierarchy.lock();
                    try {
                        CodeFoldingSideBar.this.cache.clear();
                        CodeFoldingSideBar.this.visibleMarks.clear();
                    }
                    finally {
                        foldHierarchy.unlock();
                    }
                }
                finally {
                    baseDocument.readUnlock();
                }
            }
            CodeFoldingSideBar.this.repaint();
        }
    }

    public class Mark {
        public int x;
        public int y;
        public int size;
        public boolean isFolded;

        public Mark(int n, int n2, int n3, boolean bl) {
            this.x = n;
            this.y = n2;
            this.size = n3;
            this.isFolded = bl;
        }
    }

    public class PaintInfo {
        int paintOperation;
        int innerLevel;
        int paintY;
        int paintHeight;
        boolean isCollapsed;

        public PaintInfo(int n, int n2, int n3, int n4, boolean bl) {
            this.paintOperation = n;
            this.innerLevel = n2;
            this.paintY = n3;
            this.paintHeight = n4;
            this.isCollapsed = bl;
        }

        public PaintInfo(int n, int n2, int n3, int n4) {
            this(n, n2, n3, n4, false);
        }

        public int getPaintOperation() {
            return this.paintOperation;
        }

        public int getInnerLevel() {
            return this.innerLevel;
        }

        public int getPaintY() {
            return this.paintY;
        }

        public int getPaintHeight() {
            return this.paintHeight;
        }

        public boolean isCollapsed() {
            return this.isCollapsed;
        }

        public void setPaintOperation(int n) {
            this.paintOperation = n;
        }

        public void setInnerLevel(int n) {
            this.innerLevel = n;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer("");
            if (this.paintOperation == 0) {
                stringBuffer.append("PAINT_NOOP\n");
            } else if (this.paintOperation == 1) {
                stringBuffer.append("PAINT_MARK\n");
            } else if (this.paintOperation == 2) {
                stringBuffer.append("PAINT_LINE\n");
            } else if (this.paintOperation == 3) {
                stringBuffer.append("PAINT_END_MARK\n");
            }
            stringBuffer.append("level:" + this.innerLevel);
            stringBuffer.append("\ncollapsedFold:" + this.isCollapsed);
            return stringBuffer.toString();
        }
    }
}

