/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.infos;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.lib.ddl.impl.DriverSpecification;
import org.netbeans.modules.db.explorer.infos.DatabaseNodeInfo;
import org.netbeans.modules.db.explorer.infos.IndexNodeInfo;

public class IndexListNodeInfo
extends DatabaseNodeInfo {
    static final long serialVersionUID = 5809643799834921044L;

    public void initChildren(Vector vector) throws DatabaseException {
        try {
            if (!this.ensureConnected()) {
                return;
            }
            String string = (String)this.get("table");
            DriverSpecification driverSpecification = this.getDriverSpecification();
            Connection connection = this.getConnection();
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            ResultSet resultSet = databaseMetaData.getIndexInfo(driverSpecification.getCatalog(), driverSpecification.getSchema(), string, false, true);
            if (resultSet != null) {
                HashSet<String> hashSet = new HashSet<String>();
                while (resultSet.next()) {
                    HashMap hashMap = this.getRow(resultSet);
                    if (hashMap == null || hashMap.get(new Integer(6)) == null) continue;
                    IndexNodeInfo indexNodeInfo = (IndexNodeInfo)DatabaseNodeInfo.createNodeInfo(this, "index", hashMap);
                    if (indexNodeInfo != null) {
                        if (hashSet.contains(indexNodeInfo.getName())) continue;
                        hashSet.add(indexNodeInfo.getName());
                        indexNodeInfo.put("index", (Object)indexNodeInfo.getName());
                        vector.add(indexNodeInfo);
                        continue;
                    }
                    throw new Exception(IndexListNodeInfo.bundle().getString("EXC_UnableToCreateIndexNodeInfo"));
                }
                resultSet.close();
            }
        }
        catch (Exception exception) {
            throw new DatabaseException(exception);
        }
    }

    public HashMap getRow(ResultSet resultSet) {
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        try {
            int n = resultSet.getMetaData().getColumnCount();
            for (int i = 1; i <= n; ++i) {
                String string = null;
                try {
                    string = resultSet.getString(i);
                }
                catch (SQLException sQLException) {
                    Logger.getLogger("global").log(Level.INFO, null, sQLException);
                    hashMap = null;
                    break;
                }
                hashMap.put(new Integer(i), string);
            }
        }
        catch (SQLException sQLException) {
            Logger.getLogger("global").log(Level.INFO, null, sQLException);
            hashMap = null;
        }
        return hashMap;
    }

    public void addIndex(String string) throws DatabaseException {
        try {
            String string2 = (String)this.get("table");
            DriverSpecification driverSpecification = this.getDriverSpecification();
            driverSpecification.getIndexInfo(string2, false, true);
            ResultSet resultSet = driverSpecification.getResultSet();
            if (resultSet != null) {
                HashMap hashMap = new HashMap();
                IndexNodeInfo indexNodeInfo = null;
                while (resultSet.next()) {
                    hashMap = driverSpecification.getRow();
                    String string3 = (String)hashMap.get(new Integer(6));
                    if (string3 != null && string3.equalsIgnoreCase(string)) {
                        indexNodeInfo = (IndexNodeInfo)DatabaseNodeInfo.createNodeInfo(this, "index", hashMap);
                    }
                    hashMap.clear();
                }
                resultSet.close();
                if (indexNodeInfo != null) {
                    this.addChild(indexNodeInfo);
                }
                this.notifyChange();
            }
        }
        catch (Exception exception) {
            throw new DatabaseException(exception);
        }
    }

    public String getDisplayName() {
        return IndexListNodeInfo.bundle().getString("NDN_Indexes");
    }

    public String getShortDescription() {
        return IndexListNodeInfo.bundle().getString("ND_IndexList");
    }
}

