/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.environment.mdi;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.border.EmptyBorder;
import nickyb.sqleonardo.common.gui.Toolbar;
import nickyb.sqleonardo.environment.Application;
import nickyb.sqleonardo.environment.ctrl.DefinitionPane;
import nickyb.sqleonardo.environment.ctrl.content.AbstractActionContent;
import nickyb.sqleonardo.environment.ctrl.define.ColumnsChooser;
import nickyb.sqleonardo.environment.ctrl.define.TableMetaData;
import nickyb.sqleonardo.environment.mdi.ClientContent;
import nickyb.sqleonardo.environment.mdi.MDIClient;
import nickyb.sqleonardo.environment.mdi.MDIMenubar;
import nickyb.sqleonardo.querybuilder.syntax.QueryTokens;

public class ClientDefinition
extends MDIClient {
    public static final String DEFAULT_TITLE = "DEFINITION";
    private DefinitionPane control;
    private JMenuItem[] m_actions;
    private String type;

    public ClientDefinition(String keycah, QueryTokens.Table table, String type) {
        super("DEFINITION : " + table.getIdentifier() + " : " + keycah);
        this.setMaximizable(true);
        this.setResizable(true);
        this.type = type;
        this.control = new DefinitionPane(keycah, table);
        this.setComponentCenter(this.control);
        this.control.setBorder(new EmptyBorder(2, 2, 2, 2));
        this.initMenuActions();
    }

    private void initMenuActions() {
        this.m_actions = new JMenuItem[]{MDIMenubar.createItem(new ActionChooseColumns()), null, MDIMenubar.createItem(new ActionCopyList()), MDIMenubar.createItem(new ActionRefreshList()), null, MDIMenubar.createItem(new ActionShowContent())};
    }

    public JMenuItem[] getMenuActions() {
        return this.m_actions;
    }

    public Toolbar getSubToolbar() {
        return null;
    }

    protected void setPreferences() {
    }

    private class ActionShowContent
    extends AbstractActionContent {
        ActionShowContent() {
            this.putValue("Name", "show content");
        }

        protected TableMetaData getTableMetaData() {
            int i = ClientDefinition.this.getTitle().indexOf(58);
            int j = ClientDefinition.this.getTitle().lastIndexOf(58);
            String keycah = ClientDefinition.this.getTitle().substring(j + 2).trim();
            String name = ClientDefinition.this.getTitle().substring(i + 2, j).trim();
            String schema = null;
            i = name.indexOf(46);
            if (i != -1) {
                schema = name.substring(0, i);
                name = name.substring(i + 1);
            }
            return new TableMetaData(keycah, schema, name, ClientDefinition.this.type);
        }

        protected void onActionPerformed(int records, int option) {
            if (option == 2 || records == 0 && option == 1) {
                return;
            }
            boolean retrieve = records > 0 && option == 0;
            ClientContent client = new ClientContent(this.getTableMetaData(), retrieve);
            client.setTitle("CONTENT : " + this.getTableMetaData() + " : " + this.getTableMetaData().getHandlerKey());
            Application.window.add(client);
        }

        protected int showConfirmDialog(int records) {
            if (records == 0) {
                String message = this.getDefaultMessage(records) + "\ndo you want continue?";
                return JOptionPane.showConfirmDialog(Application.window, message, "show content", 0);
            }
            String message = this.getDefaultMessage(records) + "\ndo you want retrieve?";
            return JOptionPane.showConfirmDialog(Application.window, message, "show content", 1);
        }
    }

    private class ActionRefreshList
    extends AbstractAction {
        private ActionRefreshList() {
            this.putValue("Name", "refresh list");
        }

        public void actionPerformed(ActionEvent ae) {
            ClientDefinition.this.control.getSelectedView().reset();
            ClientDefinition.this.control.stateChanged(null);
        }
    }

    private class ActionCopyList
    extends AbstractAction {
        private ActionCopyList() {
            this.putValue("Name", "copy list");
        }

        public void actionPerformed(ActionEvent ae) {
            ClientDefinition.this.control.getSelectedView().copyAllRows();
        }
    }

    private class ActionChooseColumns
    extends AbstractAction {
        private ActionChooseColumns() {
            this.putValue("Name", "choose columns...");
        }

        public void actionPerformed(ActionEvent ae) {
            int i = ClientDefinition.this.getTitle().lastIndexOf(58);
            int j = ClientDefinition.this.getTitle().lastIndexOf(46);
            String dvname = ClientDefinition.this.getTitle().substring(i + 2, j);
            String mvname = ClientDefinition.this.control.getSelectedTitle();
            ColumnsChooser.showDialog(dvname, mvname);
        }
    }
}

