/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.environment.ctrl;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import nickyb.sqleonardo.common.gui.BorderLayoutPanel;
import nickyb.sqleonardo.common.gui.TextView;
import nickyb.sqleonardo.environment.Application;
import nickyb.sqleonardo.environment.ctrl.editor.SQLStyledDocument;
import nickyb.sqleonardo.environment.ctrl.editor.Task;
import nickyb.sqleonardo.environment.ctrl.editor._TaskSource;
import nickyb.sqleonardo.environment.ctrl.editor._TaskTarget;
import nickyb.sqleonardo.environment.mdi.ClientCommandEditor;

public class CommandEditor
extends BorderLayoutPanel
implements _TaskTarget {
    private boolean stopped;
    private Thread queryThread;
    private TextView request;
    private TextView response;
    protected MutableAttributeSet errorAttributSet;
    protected MutableAttributeSet keycahAttributSet;

    public CommandEditor() {
        JSplitPane split = new JSplitPane(0);
        this.request = new TextView(new SQLStyledDocument());
        split.setTopComponent(this.request);
        this.response = new TextView(new DefaultStyledDocument());
        split.setBottomComponent(this.response);
        split.setOneTouchExpandable(true);
        this.response.setTabSize(4);
        this.response.setEditable(false);
        this.setComponentCenter(split);
        this.request.getViewActionMap().put("stop-task", new ActionStopTask());
        this.request.getViewActionMap().put("start-task", new ActionStartTask());
        this.request.getViewInputMap().put(KeyStroke.getKeyStroke(10, 2), "start-task");
        this.getActionMap().setParent(this.request.getViewActionMap());
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent evt) {
                JSplitPane split = (JSplitPane)CommandEditor.this.getComponent(0);
                split.setDividerLocation(0.5);
                split.validate();
            }
        });
        this.errorAttributSet = new SimpleAttributeSet();
        StyleConstants.setForeground(this.errorAttributSet, Color.red);
        this.keycahAttributSet = new SimpleAttributeSet();
        StyleConstants.setForeground(this.keycahAttributSet, new Color(0, 128, 0));
        StyleConstants.setBold(this.keycahAttributSet, true);
    }

    public void append(String text) {
        this.request.append(text);
    }

    public void clearResponse() {
        this.response.setText(null);
        this.request.requestFocus();
    }

    public TextView getRequestArea() {
        return this.request;
    }

    public TextView getResponseArea() {
        return this.request;
    }

    public String getSelectedText() {
        return this.request.getSelectedText();
    }

    public SQLStyledDocument getDocument() {
        return (SQLStyledDocument)this.request.getDocument();
    }

    public void setDocument(SQLStyledDocument doc) {
        this.request.setDocument(doc);
        this.request.setCaretPosition(0);
        this.request.requestFocus();
    }

    public boolean continueRun() {
        return this.queryThread != null;
    }

    public void onTaskFinished(String message, boolean error) {
        this.write(message);
        if (error) {
            int offset = this.response.getDocument().getLength() - message.length();
            this.response.getDocument().setCharacterAttributes(offset, message.length(), this.errorAttributSet, true);
        }
        this.response.append("\n");
    }

    public void write(String text) {
        this.response.append(text);
        try {
            int line = this.response.getLineCount();
            int off = this.response.getLineStartOffset(line - 1);
            this.response.setCaretPosition(off);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    private class TaskSource
    implements _TaskSource {
        private String query;

        private TaskSource(String query) {
            this.query = query;
        }

        public String getHandlerKey() {
            ClientCommandEditor client = (ClientCommandEditor)Application.window.getClient("command editor");
            return client.getActiveConnection();
        }

        public String getSyntax() {
            return this.query;
        }
    }

    private class ActionStopTask
    extends AbstractAction {
        ActionStopTask() {
            this.putValue("SmallIcon", Application.resources.getIcon("icon.011"));
            this.putValue("ShortDescription", "stop");
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent ae) {
            CommandEditor.this.stopped = true;
            this.setEnabled(false);
            CommandEditor.this.queryThread = null;
        }
    }

    private class ActionStartTask
    extends AbstractAction
    implements Runnable {
        ActionStartTask() {
            this.putValue("SmallIcon", Application.resources.getIcon("icon.122"));
            this.putValue("ShortDescription", "launch");
        }

        public void actionPerformed(ActionEvent ae) {
            CommandEditor.this.setCursor(new Cursor(3));
            CommandEditor.this.getActionMap().get("stop-task").setEnabled(true);
            this.setEnabled(false);
            CommandEditor.this.stopped = false;
            CommandEditor.this.queryThread = new Thread(this);
            CommandEditor.this.queryThread.start();
        }

        public void run() {
            String requestString = CommandEditor.this.request.getSelectedText();
            if (requestString == null || requestString.trim().length() == 0) {
                try {
                    int line = CommandEditor.this.request.getLineOfOffset(CommandEditor.this.request.getCaretPosition());
                    CommandEditor.this.request.setSelectionStart(CommandEditor.this.request.getLineStartOffset(line));
                    CommandEditor.this.request.setSelectionEnd(CommandEditor.this.request.getLineEndOffset(line));
                    requestString = CommandEditor.this.request.getSelectedText();
                }
                catch (BadLocationException e) {
                    Application.println(e, false);
                }
            }
            if (requestString == null || requestString.trim().length() == 0) {
                CommandEditor.this.request.setSelectionStart(0);
                CommandEditor.this.request.setSelectionEnd(CommandEditor.this.request.getText().length());
                requestString = CommandEditor.this.request.getSelectedText();
            }
            if (requestString != null && requestString.trim().length() > 0) {
                requestString = requestString.trim();
                StringTokenizer st = new StringTokenizer(requestString, ";");
                int len = 0;
                while (!CommandEditor.this.stopped && st.hasMoreTokens()) {
                    String sql = st.nextToken();
                    while ((len += sql.length() + 1) < requestString.length() && requestString.charAt(len) != '\n' && st.hasMoreTokens()) {
                        sql = sql + ";" + st.nextToken();
                        if (!CommandEditor.this.stopped) continue;
                    }
                    TaskSource source = new TaskSource(sql);
                    String keycah = "*** " + source.getHandlerKey() + " ***";
                    CommandEditor.this.response.append("\n" + keycah);
                    int offset = CommandEditor.this.response.getDocument().getLength() - keycah.length();
                    CommandEditor.this.response.getDocument().setCharacterAttributes(offset, keycah.length(), CommandEditor.this.keycahAttributSet, true);
                    CommandEditor.this.response.append("\n" + source.getSyntax() + "\n");
                    ClientCommandEditor cce = (ClientCommandEditor)Application.window.getClient("command editor");
                    new Task(source, CommandEditor.this, cce.getLimitRows()).run();
                }
            }
            this.setEnabled(true);
            CommandEditor.this.transferFocus();
            CommandEditor.this.getActionMap().get("stop-task").setEnabled(false);
            CommandEditor.this.setCursor(new Cursor(0));
        }
    }
}

