/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.repo;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import net.sf.jasperreports.data.DataAdapter;
import net.sf.jasperreports.data.XmlUtil;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.util.JRResourcesUtil;
import net.sf.jasperreports.engine.util.JRSaver;
import net.sf.jasperreports.engine.util.SimpleFileResolver;
import net.sf.jasperreports.repo.DefaultRepositoryService;
import net.sf.jasperreports.repo.ReportResource;
import net.sf.jasperreports.repo.Resource;
import org.exolab.castor.mapping.Mapping;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileRepositoryService
extends DefaultRepositoryService {
    private static final Mapping mapping = new Mapping();

    private static void loadMapping(Mapping mapping, String mappingFile) {
        InputStream mis = null;
        try {
            mis = JRLoader.getLocationInputStream(mappingFile);
            mapping.loadMapping(new InputSource(mis));
        }
        catch (JRException e) {
            throw new JRRuntimeException(e);
        }
        finally {
            if (mis != null) {
                try {
                    mis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public void saveResource(String uri, Resource resource) {
        if (ReportResource.class.getName().equals(resource.getClass().getName())) {
            SimpleFileResolver fileResolver = (SimpleFileResolver)JRResourcesUtil.getFileResolver(null);
            File rootFolder = fileResolver.getFolders().get(0);
            File jasperFile = new File(rootFolder, uri);
            try {
                JRSaver.saveObject(((ReportResource)resource).getValue(), jasperFile);
            }
            catch (JRException e) {
                throw new JRRuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <K extends Resource> K getResource(String uri, Class<? extends Resource> resourceType) {
        if (ReportResource.class.getName().equals(resourceType.getName())) {
            ReportResource resource;
            String reportUri = uri;
            String lcReportUri = reportUri.toLowerCase();
            if (lcReportUri.endsWith(".jasper")) {
                reportUri = reportUri.substring(0, lcReportUri.lastIndexOf(".jasper"));
            } else if (lcReportUri.endsWith(".jrxml")) {
                reportUri = reportUri.substring(0, lcReportUri.lastIndexOf(".jrxml"));
            }
            String jasperUri = reportUri + ".jasper";
            String jrxmlUri = reportUri + ".jrxml";
            InputStream jrxmlIs = this.getInputStream(jrxmlUri);
            InputStream jasperIs = this.getInputStream(jasperUri);
            boolean toCompile = false;
            if (jasperIs == null) {
                if (jrxmlIs == null) {
                    throw new JRRuntimeException("Report not found: " + reportUri);
                }
                toCompile = true;
            } else if (jrxmlIs == null) {
                // empty if block
            }
            JasperReport jasperReport = null;
            if (toCompile) {
                try {
                    jasperReport = JasperCompileManager.compileReport(jrxmlIs);
                    resource = new ReportResource();
                    resource.setReport(jasperReport);
                    this.saveResource(jasperUri, resource);
                }
                catch (JRException e) {
                    throw new JRRuntimeException(e);
                }
            }
            try {
                jasperReport = (JasperReport)JRLoader.loadObject(jasperIs);
            }
            catch (JRException e) {
                throw new JRRuntimeException(e);
            }
            finally {
                try {
                    jasperIs.close();
                }
                catch (IOException e) {}
            }
            resource = null;
            resource = new ReportResource();
            resource.setReport(jasperReport);
            return (K)resource;
        }
        if (DataAdapter.class.isAssignableFrom(resourceType)) {
            DataAdapter dataAdapter = null;
            InputStream is = this.getInputStream(uri);
            if (is != null) {
                try {
                    dataAdapter = (DataAdapter)XmlUtil.read(is, mapping);
                }
                finally {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException e) {}
                    }
                }
            }
            return (K)dataAdapter;
        }
        return super.getResource(uri, resourceType);
    }

    static {
        FileRepositoryService.loadMapping(mapping, "net/sf/jasperreports/data/csv/CsvDataAdapterImpl.xml");
        FileRepositoryService.loadMapping(mapping, "net/sf/jasperreports/data/ds/DataSourceDataAdapterImpl.xml");
        FileRepositoryService.loadMapping(mapping, "net/sf/jasperreports/data/empty/EmptyDataAdapterImpl.xml");
        FileRepositoryService.loadMapping(mapping, "net/sf/jasperreports/data/jdbc/JdbcDataAdapterImpl.xml");
        FileRepositoryService.loadMapping(mapping, "net/sf/jasperreports/data/jndi/JndiDataAdapterImpl.xml");
        FileRepositoryService.loadMapping(mapping, "net/sf/jasperreports/data/provider/DataSourceProviderDataAdapterImpl.xml");
        FileRepositoryService.loadMapping(mapping, "net/sf/jasperreports/data/qe/QueryExecuterDataAdapterImpl.xml");
        FileRepositoryService.loadMapping(mapping, "net/sf/jasperreports/data/xls/XlsDataAdapterImpl.xml");
        FileRepositoryService.loadMapping(mapping, "net/sf/jasperreports/data/xml/RemoteXmlDataAdapterImpl.xml");
        FileRepositoryService.loadMapping(mapping, "net/sf/jasperreports/data/xml/XmlDataAdapterImpl.xml");
    }
}

