/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRVariable;
import net.sf.jasperreports.engine.fill.JRCalculable;
import net.sf.jasperreports.engine.fill.JRDefaultIncrementerFactory;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import net.sf.jasperreports.engine.fill.JRIncrementer;
import net.sf.jasperreports.engine.fill.JRIncrementerFactory;
import net.sf.jasperreports.engine.fill.JRIncrementerFactoryCache;
import net.sf.jasperreports.engine.type.CalculationEnum;
import net.sf.jasperreports.engine.type.IncrementTypeEnum;
import net.sf.jasperreports.engine.type.ResetTypeEnum;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JRFillVariable
implements JRVariable,
JRCalculable {
    protected JRVariable parent;
    private JRGroup resetGroup;
    private JRGroup incrementGroup;
    private Object previousOldValue;
    private Object oldValue;
    private Object estimatedValue;
    private Object incrementedValue;
    private Object value;
    private boolean isInitialized;
    private Object savedValue;
    private JRFillVariable[] helperVariables;
    private JRIncrementer incrementer;

    protected JRFillVariable(JRVariable variable, JRFillObjectFactory factory) {
        factory.put(variable, this);
        this.parent = variable;
        this.resetGroup = factory.getGroup(variable.getResetGroup());
        this.incrementGroup = factory.getGroup(variable.getIncrementGroup());
        this.helperVariables = new JRFillVariable[3];
    }

    @Override
    public String getName() {
        return this.parent.getName();
    }

    @Override
    public Class<?> getValueClass() {
        return this.parent.getValueClass();
    }

    @Override
    public String getValueClassName() {
        return this.parent.getValueClassName();
    }

    @Override
    public Class<?> getIncrementerFactoryClass() {
        return this.parent.getIncrementerFactoryClass();
    }

    @Override
    public String getIncrementerFactoryClassName() {
        return this.parent.getIncrementerFactoryClassName();
    }

    @Override
    public JRExpression getExpression() {
        return this.parent.getExpression();
    }

    @Override
    public JRExpression getInitialValueExpression() {
        return this.parent.getInitialValueExpression();
    }

    @Override
    public ResetTypeEnum getResetTypeValue() {
        return this.parent.getResetTypeValue();
    }

    @Override
    public IncrementTypeEnum getIncrementTypeValue() {
        return this.parent.getIncrementTypeValue();
    }

    @Override
    public CalculationEnum getCalculationValue() {
        return this.parent.getCalculationValue();
    }

    @Override
    public boolean isSystemDefined() {
        return this.parent.isSystemDefined();
    }

    @Override
    public JRGroup getResetGroup() {
        return this.resetGroup;
    }

    @Override
    public JRGroup getIncrementGroup() {
        return this.incrementGroup;
    }

    public Object getOldValue() {
        return this.oldValue;
    }

    public void setOldValue(Object oldValue) {
        this.oldValue = oldValue;
    }

    public Object getEstimatedValue() {
        return this.estimatedValue;
    }

    public void setEstimatedValue(Object estimatedValue) {
        this.estimatedValue = estimatedValue;
    }

    @Override
    public Object getIncrementedValue() {
        return this.incrementedValue;
    }

    public void setIncrementedValue(Object incrementedValue) {
        this.incrementedValue = incrementedValue;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    @Override
    public boolean isInitialized() {
        return this.isInitialized;
    }

    @Override
    public void setInitialized(boolean isInitialized) {
        this.isInitialized = isInitialized;
    }

    public JRIncrementer getIncrementer() {
        if (this.incrementer == null) {
            Class<?> incrementerFactoryClass = this.getIncrementerFactoryClass();
            JRIncrementerFactory incrementerFactory = incrementerFactoryClass == null ? JRDefaultIncrementerFactory.getFactory(this.getValueClass()) : JRIncrementerFactoryCache.getInstance(incrementerFactoryClass);
            this.incrementer = incrementerFactory.getIncrementer(this.getCalculationValue().getValue());
        }
        return this.incrementer;
    }

    public JRFillVariable setHelperVariable(JRFillVariable helperVariable, byte type) {
        JRFillVariable old = this.helperVariables[type];
        this.helperVariables[type] = helperVariable;
        return old;
    }

    @Override
    public JRCalculable getHelperVariable(byte type) {
        return this.helperVariables[type];
    }

    public Object getValue(byte evaluation) {
        Object returnValue;
        switch (evaluation) {
            case 1: {
                returnValue = this.oldValue;
                break;
            }
            case 2: {
                returnValue = this.estimatedValue;
                break;
            }
            default: {
                returnValue = this.value;
            }
        }
        return returnValue;
    }

    public void overwriteValue(Object newValue, byte evaluation) {
        switch (evaluation) {
            case 1: {
                this.savedValue = this.oldValue;
                this.oldValue = newValue;
                break;
            }
            case 2: {
                this.savedValue = this.estimatedValue;
                this.estimatedValue = newValue;
                break;
            }
            default: {
                this.savedValue = this.value;
                this.value = newValue;
            }
        }
    }

    public void restoreValue(byte evaluation) {
        switch (evaluation) {
            case 1: {
                this.oldValue = this.savedValue;
                break;
            }
            case 2: {
                this.estimatedValue = this.savedValue;
                break;
            }
            default: {
                this.value = this.savedValue;
            }
        }
        this.savedValue = null;
    }

    public Object getPreviousOldValue() {
        return this.previousOldValue;
    }

    public void setPreviousOldValue(Object previousOldValue) {
        this.previousOldValue = previousOldValue;
    }

    @Override
    public Object clone() {
        throw new UnsupportedOperationException();
    }
}

