/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRDatasetParameter;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRScriptlet;
import net.sf.jasperreports.engine.JRSubreport;
import net.sf.jasperreports.engine.JRSubreportParameter;
import net.sf.jasperreports.engine.JRSubreportReturnValue;
import net.sf.jasperreports.engine.JRVisitor;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.design.JRDesignSubreportReturnValue;
import net.sf.jasperreports.engine.design.JRValidationException;
import net.sf.jasperreports.engine.design.JRValidationFault;
import net.sf.jasperreports.engine.design.JRVerifier;
import net.sf.jasperreports.engine.fill.AbstractValueProvider;
import net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator;
import net.sf.jasperreports.engine.fill.JRBaseFiller;
import net.sf.jasperreports.engine.fill.JREvaluator;
import net.sf.jasperreports.engine.fill.JRFillCloneFactory;
import net.sf.jasperreports.engine.fill.JRFillCloneable;
import net.sf.jasperreports.engine.fill.JRFillElement;
import net.sf.jasperreports.engine.fill.JRFillExpressionEvaluator;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import net.sf.jasperreports.engine.fill.JRFillSubreportReturnValue;
import net.sf.jasperreports.engine.fill.JRFillVariable;
import net.sf.jasperreports.engine.fill.JRHorizontalFiller;
import net.sf.jasperreports.engine.fill.JRSubreportRunResult;
import net.sf.jasperreports.engine.fill.JRSubreportRunner;
import net.sf.jasperreports.engine.fill.JRSubreportRunnerFactory;
import net.sf.jasperreports.engine.fill.JRTemplateElement;
import net.sf.jasperreports.engine.fill.JRTemplatePrintRectangle;
import net.sf.jasperreports.engine.fill.JRTemplateRectangle;
import net.sf.jasperreports.engine.fill.JRVerticalFiller;
import net.sf.jasperreports.engine.type.CalculationEnum;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.util.JRProperties;
import net.sf.jasperreports.engine.util.JRSingletonCache;
import net.sf.jasperreports.engine.util.JRStyleResolver;
import net.sf.jasperreports.repo.RepositoryUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JRFillSubreport
extends JRFillElement
implements JRSubreport {
    private static final Log log = LogFactory.getLog(JRFillSubreport.class);
    private static final JRSingletonCache runnerFactoryCache = new JRSingletonCache(JRSubreportRunnerFactory.class);
    private Map<String, Object> parameterValues;
    private JRSubreportParameter[] parameters;
    private Connection connection;
    private JRDataSource dataSource;
    private JasperReport jasperReport;
    private Object source;
    private Map<JasperReport, JREvaluator> loadedEvaluators;
    private JRFillSubreportReturnValue[] returnValues;
    protected JRBaseFiller subreportFiller;
    private JRPrintPage printPage;
    private JRSubreportRunner runner;
    private Set<JasperReport> checkedReports;

    protected JRFillSubreport(JRBaseFiller filler, JRSubreport subreport, JRFillObjectFactory factory) {
        super(filler, subreport, factory);
        this.parameters = subreport.getParameters();
        JRSubreportReturnValue[] subrepReturnValues = subreport.getReturnValues();
        if (subrepReturnValues != null) {
            ArrayList<JRFillSubreportReturnValue> returnValuesList = new ArrayList<JRFillSubreportReturnValue>(subrepReturnValues.length * 2);
            this.returnValues = new JRFillSubreportReturnValue[subrepReturnValues.length];
            for (int i = 0; i < subrepReturnValues.length; ++i) {
                this.addReturnValue(subrepReturnValues[i], returnValuesList, factory);
            }
            this.returnValues = new JRFillSubreportReturnValue[returnValuesList.size()];
            returnValuesList.toArray(this.returnValues);
        }
        this.loadedEvaluators = new HashMap<JasperReport, JREvaluator>();
        this.checkedReports = new HashSet<JasperReport>();
    }

    @Override
    public ModeEnum getModeValue() {
        return JRStyleResolver.getMode(this, ModeEnum.TRANSPARENT);
    }

    @Override
    public boolean isUsingCache() {
        return ((JRSubreport)this.parent).isUsingCache();
    }

    public boolean usingCache() {
        Boolean isUsingCache = this.getUsingCache();
        if (isUsingCache == null) {
            return this.source instanceof String;
        }
        return isUsingCache;
    }

    @Override
    public Boolean isRunToBottom() {
        return ((JRSubreport)this.parent).isRunToBottom();
    }

    @Override
    public void setRunToBottom(Boolean runToBottom) {
        throw new UnsupportedOperationException();
    }

    @Override
    public JRExpression getParametersMapExpression() {
        return ((JRSubreport)this.parent).getParametersMapExpression();
    }

    @Override
    public JRSubreportParameter[] getParameters() {
        return this.parameters;
    }

    @Override
    public JRExpression getConnectionExpression() {
        return ((JRSubreport)this.parent).getConnectionExpression();
    }

    @Override
    public JRExpression getDataSourceExpression() {
        return ((JRSubreport)this.parent).getDataSourceExpression();
    }

    @Override
    public JRExpression getExpression() {
        return ((JRSubreport)this.parent).getExpression();
    }

    protected JRTemplateRectangle getJRTemplateRectangle() {
        return (JRTemplateRectangle)this.getElementTemplate();
    }

    @Override
    protected JRTemplateElement createElementTemplate() {
        return new JRTemplateRectangle(this.getElementOrigin(), this.filler.getJasperPrint().getDefaultStyleProvider(), this);
    }

    protected Collection<JRPrintElement> getPrintElements() {
        List<JRPrintElement> printElements = null;
        if (this.printPage != null) {
            printElements = this.printPage.getElements();
        }
        return printElements;
    }

    @Override
    protected void evaluate(byte evaluation) throws JRException {
        this.reset();
        this.evaluatePrintWhenExpression(evaluation);
        this.evaluateProperties(evaluation);
        if (this.isPrintWhenExpressionNull() || this.isPrintWhenTrue()) {
            this.evaluateSubreport(evaluation);
        }
    }

    protected JasperReport evaluateReport(byte evaluation) throws JRException {
        JasperReport report = null;
        JRExpression expression = this.getExpression();
        this.source = this.evaluateExpression(expression, evaluation);
        if (this.source != null) {
            Boolean isUsingCache = this.getUsingCache();
            if (isUsingCache == null) {
                isUsingCache = this.source instanceof String;
            }
            if (isUsingCache.booleanValue() && this.filler.fillContext.hasLoadedSubreport(this.source)) {
                report = this.filler.fillContext.getLoadedSubreport(this.source);
            } else {
                if (this.source instanceof JasperReport) {
                    report = (JasperReport)this.source;
                } else if (this.source instanceof InputStream) {
                    report = (JasperReport)JRLoader.loadObject((InputStream)this.source);
                } else if (this.source instanceof URL) {
                    report = (JasperReport)JRLoader.loadObject((URL)this.source);
                } else if (this.source instanceof File) {
                    report = (JasperReport)JRLoader.loadObject((File)this.source);
                } else if (this.source instanceof String) {
                    report = RepositoryUtil.getReport((String)this.source);
                } else {
                    throw new JRRuntimeException("Unknown subreport source class " + this.source.getClass().getName());
                }
                if (isUsingCache.booleanValue()) {
                    this.filler.fillContext.registerLoadedSubreport(this.source, report);
                }
            }
        }
        return report;
    }

    protected void evaluateSubreport(byte evaluation) throws JRException {
        this.jasperReport = this.evaluateReport(evaluation);
        if (this.jasperReport != null) {
            this.connection = (Connection)this.evaluateExpression(this.getConnectionExpression(), evaluation);
            this.dataSource = (JRDataSource)this.evaluateExpression(this.getDataSourceExpression(), evaluation);
            this.parameterValues = this.evaluateParameterValues(evaluation);
            if (this.subreportFiller != null) {
                this.filler.unregisterSubfiller(this.subreportFiller);
            }
            DatasetExpressionEvaluator evaluator = this.loadReportEvaluator();
            this.initSubreportFiller(evaluator);
            this.validateReport();
            this.saveReturnVariables();
        }
    }

    protected Map<String, Object> evaluateParameterValues(byte evaluation) throws JRException {
        return JRFillSubreport.getParameterValues(this.filler, this.getParametersMapExpression(), this.getParameters(), evaluation, false, this.jasperReport.getResourceBundle() != null, this.jasperReport.getFormatFactoryClass() != null);
    }

    protected DatasetExpressionEvaluator loadReportEvaluator() throws JRException {
        DatasetExpressionEvaluator evaluator = null;
        if (this.isUsingCache()) {
            evaluator = this.loadedEvaluators.get(this.jasperReport);
        }
        if (evaluator == null) {
            evaluator = this.createEvaluator();
            if (this.isUsingCache()) {
                this.loadedEvaluators.put(this.jasperReport, (JREvaluator)evaluator);
            }
        }
        return evaluator;
    }

    protected DatasetExpressionEvaluator createEvaluator() throws JRException {
        return JasperCompileManager.loadEvaluator(this.jasperReport);
    }

    protected void initSubreportFiller(DatasetExpressionEvaluator evaluator) throws JRException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Fill " + this.filler.fillerId + ": creating subreport filler"));
        }
        switch (this.jasperReport.getPrintOrderValue()) {
            case HORIZONTAL: {
                this.subreportFiller = new JRHorizontalFiller(this.jasperReport, evaluator, this);
                break;
            }
            case VERTICAL: {
                this.subreportFiller = new JRVerticalFiller(this.jasperReport, evaluator, this);
                break;
            }
            default: {
                throw new JRRuntimeException("Unkown print order " + this.jasperReport.getPrintOrderValue().getValue() + ".");
            }
        }
        this.runner = JRFillSubreport.getRunnerFactory().createSubreportRunner(this, this.subreportFiller);
        this.subreportFiller.setSubreportRunner(this.runner);
    }

    protected void saveReturnVariables() {
        if (this.returnValues != null) {
            for (int i = 0; i < this.returnValues.length; ++i) {
                String varName = this.returnValues[i].getToVariable();
                this.band.saveVariable(varName);
            }
        }
    }

    public static Map<String, Object> getParameterValues(JRBaseFiller filler, JRExpression parametersMapExpression, JRDatasetParameter[] subreportParameters, byte evaluation, boolean ignoreNullExpressions, boolean removeResourceBundle, boolean removeFormatFactory) throws JRException {
        return JRFillSubreport.getParameterValues(filler, filler.getExpressionEvaluator(), parametersMapExpression, subreportParameters, evaluation, ignoreNullExpressions, removeResourceBundle, removeFormatFactory);
    }

    public static Map<String, Object> getParameterValues(JRBaseFiller filler, JRFillExpressionEvaluator expressionEvaluator, JRExpression parametersMapExpression, JRDatasetParameter[] subreportParameters, byte evaluation, boolean ignoreNullExpressions, boolean removeResourceBundle, boolean removeFormatFactory) throws JRException {
        int i;
        HashMap<String, Object> parameterValues = null;
        if (parametersMapExpression != null) {
            parameterValues = (HashMap<String, Object>)expressionEvaluator.evaluate(parametersMapExpression, evaluation);
        }
        if (parameterValues != null) {
            if (parameterValues == filler.getParameterValuesMap()) {
                parameterValues = new HashMap(parameterValues);
            }
            if (removeResourceBundle) {
                parameterValues.remove("REPORT_RESOURCE_BUNDLE");
            }
            if (removeFormatFactory) {
                parameterValues.remove("REPORT_FORMAT_FACTORY");
            }
            parameterValues.remove("JASPER_REPORT");
            parameterValues.remove("REPORT_CONNECTION");
            parameterValues.remove("REPORT_MAX_COUNT");
            parameterValues.remove("REPORT_DATA_SOURCE");
            parameterValues.remove("REPORT_SCRIPTLET");
            JRScriptlet[] scriptlets = filler.getJasperReport().getScriptlets();
            if (scriptlets != null) {
                for (i = 0; i < scriptlets.length; ++i) {
                    parameterValues.remove(scriptlets[i].getName() + "_SCRIPTLET");
                }
            }
            parameterValues.remove("REPORT_VIRTUALIZER");
            parameterValues.remove("IS_IGNORE_PAGINATION");
            parameterValues.remove("SORT_FIELDS");
            parameterValues.remove("REPORT_PARAMETERS_MAP");
        }
        if (parameterValues == null) {
            parameterValues = new HashMap<String, Object>();
        }
        if (subreportParameters != null && subreportParameters.length > 0) {
            Object parameterValue = null;
            for (i = 0; i < subreportParameters.length; ++i) {
                JRExpression expression = subreportParameters[i].getExpression();
                if (expression == null && ignoreNullExpressions) continue;
                parameterValue = expressionEvaluator.evaluate(expression, evaluation);
                if (parameterValue == null) {
                    parameterValues.remove(subreportParameters[i].getName());
                    continue;
                }
                parameterValues.put(subreportParameters[i].getName(), parameterValue);
            }
        }
        if (!parameterValues.containsKey("REPORT_LOCALE")) {
            parameterValues.put("REPORT_LOCALE", filler.getLocale());
        }
        if (!parameterValues.containsKey("REPORT_TIME_ZONE")) {
            parameterValues.put("REPORT_TIME_ZONE", filler.getTimeZone());
        }
        if (!parameterValues.containsKey("REPORT_FORMAT_FACTORY") && !removeFormatFactory) {
            parameterValues.put("REPORT_FORMAT_FACTORY", filler.getFormatFactory());
        }
        if (!parameterValues.containsKey("REPORT_CLASS_LOADER") && filler.reportClassLoader != null) {
            parameterValues.put("REPORT_CLASS_LOADER", filler.reportClassLoader);
        }
        if (!parameterValues.containsKey("REPORT_URL_HANDLER_FACTORY") && filler.urlHandlerFactory != null) {
            parameterValues.put("REPORT_URL_HANDLER_FACTORY", filler.urlHandlerFactory);
        }
        if (!parameterValues.containsKey("REPORT_FILE_RESOLVER") && filler.fileResolver != null) {
            parameterValues.put("REPORT_FILE_RESOLVER", filler.fileResolver);
        }
        return parameterValues;
    }

    protected void fillSubreport() throws JRException {
        if (this.getConnectionExpression() != null) {
            this.subreportFiller.fill(this.parameterValues, this.connection);
        } else if (this.getDataSourceExpression() != null) {
            this.subreportFiller.fill(this.parameterValues, this.dataSource);
        } else {
            this.subreportFiller.fill(this.parameterValues);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean prepare(int availableHeight, boolean isOverflow) throws JRException {
        boolean reprinted;
        boolean willOverflow = false;
        super.prepare(availableHeight, isOverflow);
        if (this.subreportFiller == null) {
            this.setToPrint(false);
        }
        if (!this.isToPrint()) {
            return willOverflow;
        }
        if (availableHeight < this.getRelativeY() + this.getHeight()) {
            this.setToPrint(false);
            return true;
        }
        boolean filling = this.runner.isFilling();
        boolean toPrint = !isOverflow || this.isPrintWhenDetailOverflows() || !this.isAlreadyPrinted();
        boolean bl = reprinted = isOverflow && this.isPrintWhenDetailOverflows();
        if (!filling && toPrint && reprinted) {
            this.rewind();
        }
        this.subreportFiller.setPageHeight(availableHeight - this.getRelativeY());
        JRBaseFiller jRBaseFiller = this.subreportFiller;
        synchronized (jRBaseFiller) {
            JRSubreportRunResult result;
            if (filling) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Fill " + this.filler.fillerId + ": resuming " + this.subreportFiller.fillerId));
                }
                result = this.runner.resume();
            } else if (toPrint) {
                this.setReprinted(reprinted);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Fill " + this.filler.fillerId + ": starting " + this.subreportFiller.fillerId));
                }
                result = this.runner.start();
            } else {
                this.printPage = null;
                this.setStretchHeight(this.getHeight());
                this.setToPrint(false);
                return willOverflow;
            }
            if (result.getException() != null) {
                Throwable error = result.getException();
                if (log.isErrorEnabled()) {
                    log.error((Object)("Fill " + this.filler.fillerId + ": exception"), error);
                }
                if (error instanceof RuntimeException) {
                    throw (RuntimeException)error;
                }
                throw new JRRuntimeException(error);
            }
            if (result.hasFinished()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Fill " + this.filler.fillerId + ": subreport " + this.subreportFiller.fillerId + " finished"));
                }
                this.copyValues();
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("Fill " + this.filler.fillerId + ": subreport " + this.subreportFiller.fillerId + " to continue"));
            }
            this.printPage = this.subreportFiller.getCurrentPage();
            this.setStretchHeight(result.hasFinished() ? this.subreportFiller.getCurrentPageStretchHeight() : availableHeight - this.getRelativeY());
            boolean bl2 = willOverflow = !result.hasFinished();
            if (!willOverflow) {
                this.runner.reset();
            }
        }
        Collection<JRPrintElement> printElements = this.getPrintElements();
        if ((printElements == null || printElements.size() == 0) && this.isRemoveLineWhenBlank()) {
            this.setToPrint(false);
        }
        return willOverflow;
    }

    @Override
    public void rewind() throws JRException {
        if (this.subreportFiller == null) {
            return;
        }
        this.cancelSubreportFill();
        this.initSubreportFiller(null);
        if (this.getConnectionExpression() == null && this.dataSource != null) {
            if (this.dataSource instanceof JRRewindableDataSource) {
                ((JRRewindableDataSource)this.dataSource).moveFirst();
            } else {
                throw new JRException("The subreport is placed on a non-splitting band, but it does not have a rewindable data source.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cancelSubreportFill() throws JRException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Fill " + this.filler.fillerId + ": cancelling " + this.subreportFiller.fillerId));
        }
        this.subreportFiller.setInterrupted(true);
        JRBaseFiller jRBaseFiller = this.subreportFiller;
        synchronized (jRBaseFiller) {
            this.runner.cancel();
            this.runner.reset();
        }
        this.filler.unregisterSubfiller(this.subreportFiller);
    }

    @Override
    protected JRPrintElement fill() {
        JRTemplatePrintRectangle printRectangle = new JRTemplatePrintRectangle(this.getJRTemplateRectangle());
        printRectangle.setX(this.getX());
        printRectangle.setY(this.getRelativeY());
        printRectangle.setWidth(this.getWidth());
        printRectangle.setHeight(this.getStretchHeight());
        return printRectangle;
    }

    @Override
    public void collectExpressions(JRExpressionCollector collector) {
        collector.collect(this);
    }

    @Override
    public void visit(JRVisitor visitor) {
        visitor.visitSubreport(this);
    }

    private JRFillSubreportReturnValue addReturnValue(JRSubreportReturnValue parentReturnValue, List<JRFillSubreportReturnValue> returnValueList, JRFillObjectFactory factory) {
        JRFillSubreportReturnValue returnValue = factory.getSubreportReturnValue(parentReturnValue);
        CalculationEnum calculation = returnValue.getCalculationValue();
        switch (calculation) {
            case AVERAGE: 
            case VARIANCE: {
                JRSubreportReturnValue countVal = this.createHelperReturnValue(parentReturnValue, "_COUNT", CalculationEnum.COUNT);
                this.addReturnValue(countVal, returnValueList, factory);
                JRSubreportReturnValue sumVal = this.createHelperReturnValue(parentReturnValue, "_SUM", CalculationEnum.SUM);
                this.addReturnValue(sumVal, returnValueList, factory);
                this.filler.addVariableCalculationReq(returnValue.getToVariable(), calculation);
                break;
            }
            case STANDARD_DEVIATION: {
                JRSubreportReturnValue varianceVal = this.createHelperReturnValue(parentReturnValue, "_VARIANCE", CalculationEnum.VARIANCE);
                this.addReturnValue(varianceVal, returnValueList, factory);
                this.filler.addVariableCalculationReq(returnValue.getToVariable(), calculation);
                break;
            }
            case DISTINCT_COUNT: {
                JRSubreportReturnValue countVal = this.createDistinctCountHelperReturnValue(parentReturnValue);
                this.addReturnValue(countVal, returnValueList, factory);
                this.filler.addVariableCalculationReq(returnValue.getToVariable(), calculation);
                break;
            }
        }
        returnValueList.add(returnValue);
        return returnValue;
    }

    protected JRSubreportReturnValue createHelperReturnValue(JRSubreportReturnValue returnValue, String nameSuffix, CalculationEnum calculation) {
        JRDesignSubreportReturnValue helper = new JRDesignSubreportReturnValue();
        helper.setToVariable(returnValue.getToVariable() + nameSuffix);
        helper.setSubreportVariable(returnValue.getSubreportVariable());
        helper.setCalculation(calculation);
        helper.setIncrementerFactoryClassName(helper.getIncrementerFactoryClassName());
        return helper;
    }

    protected JRSubreportReturnValue createDistinctCountHelperReturnValue(JRSubreportReturnValue returnValue) {
        JRDesignSubreportReturnValue helper = new JRDesignSubreportReturnValue();
        helper.setToVariable(returnValue.getToVariable() + "_DISTINCT_COUNT");
        helper.setSubreportVariable(returnValue.getSubreportVariable());
        helper.setCalculation(CalculationEnum.NOTHING);
        helper.setIncrementerFactoryClassName(helper.getIncrementerFactoryClassName());
        return helper;
    }

    @Override
    public JRSubreportReturnValue[] getReturnValues() {
        return this.returnValues;
    }

    public boolean usesForReturnValue(String variableName) {
        boolean used = false;
        if (this.returnValues != null) {
            for (int j = 0; j < this.returnValues.length; ++j) {
                JRFillSubreportReturnValue returnValue = this.returnValues[j];
                if (!returnValue.getToVariable().equals(variableName)) continue;
                used = true;
                break;
            }
        }
        return used;
    }

    protected void copyValues() {
        if (this.returnValues != null && this.returnValues.length > 0) {
            for (int i = 0; i < this.returnValues.length; ++i) {
                this.copyValue(this.returnValues[i]);
            }
        }
    }

    protected void copyValue(JRFillSubreportReturnValue returnValue) {
        try {
            JRFillVariable variable = this.filler.getVariable(returnValue.getToVariable());
            Object value = this.subreportFiller.getVariableValue(returnValue.getSubreportVariable());
            Object newValue = returnValue.getIncrementer().increment(variable, value, AbstractValueProvider.getCurrentValueProvider());
            variable.setOldValue(newValue);
            variable.setValue(newValue);
            variable.setIncrementedValue(newValue);
        }
        catch (JRException e) {
            throw new JRRuntimeException(e);
        }
    }

    protected void validateReport() throws JRException {
        if (!this.checkedReports.contains(this.jasperReport)) {
            this.verifyBandHeights();
            this.checkReturnValues();
            if (this.isUsingCache()) {
                this.checkedReports.add(this.jasperReport);
            }
        }
    }

    protected void verifyBandHeights() throws JRException {
        if (!this.filler.fillContext.isIgnorePagination()) {
            int pageHeight;
            int topMargin = this.jasperReport.getTopMargin();
            int bottomMargin = this.jasperReport.getBottomMargin();
            JRBaseFiller parentFiller = this.filler;
            do {
                pageHeight = parentFiller.jasperReport.getPageHeight();
                topMargin += parentFiller.jasperReport.getTopMargin();
                bottomMargin += parentFiller.jasperReport.getBottomMargin();
            } while ((parentFiller = parentFiller.parentFiller) != null);
            ArrayList<JRValidationFault> brokenRules = new ArrayList<JRValidationFault>();
            JRVerifier.verifyBandHeights(brokenRules, this.jasperReport, pageHeight, topMargin, bottomMargin);
            if (!brokenRules.isEmpty()) {
                throw new JRValidationException("Band height validation for subreport \"" + this.jasperReport.getName() + "\" failed in the current page context " + "(height = " + pageHeight + ", top margin = " + topMargin + ", bottom margin = " + bottomMargin + ") : ", brokenRules);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Band height validation for subreport \"" + this.jasperReport.getName() + "\" succeeded in the current page context " + "(height = " + pageHeight + ", top margin = " + topMargin + ", bottom margin = " + bottomMargin + ")"));
            }
        }
    }

    private void checkReturnValues() throws JRException {
        if (this.returnValues != null && this.returnValues.length > 0) {
            for (int i = 0; i < this.returnValues.length; ++i) {
                JRFillSubreportReturnValue returnValue = this.returnValues[i];
                String subreportVariableName = returnValue.getSubreportVariable();
                JRFillVariable subrepVariable = this.subreportFiller.getVariable(subreportVariableName);
                if (subrepVariable == null) {
                    throw new JRException("Subreport variable " + subreportVariableName + " not found.");
                }
                JRFillVariable variable = this.filler.getVariable(returnValue.getToVariable());
                if (returnValue.getCalculationValue() == CalculationEnum.COUNT || returnValue.getCalculationValue() == CalculationEnum.DISTINCT_COUNT) {
                    if (Number.class.isAssignableFrom(variable.getValueClass())) continue;
                    throw new JRException("Variable " + returnValue.getToVariable() + " must have a numeric type.");
                }
                if (variable.getValueClass().isAssignableFrom(subrepVariable.getValueClass()) || Number.class.isAssignableFrom(variable.getValueClass()) && Number.class.isAssignableFrom(subrepVariable.getValueClass())) continue;
                throw new JRException("Variable " + returnValue.getToVariable() + " is not assignable from subreport variable " + subreportVariableName);
            }
        }
    }

    @Override
    protected void resolveElement(JRPrintElement element, byte evaluation) {
    }

    @Override
    public Boolean isOwnUsingCache() {
        return ((JRSubreport)this.parent).isOwnUsingCache();
    }

    @Override
    public Boolean getUsingCache() {
        return ((JRSubreport)this.parent).getUsingCache();
    }

    @Override
    public void setUsingCache(Boolean isUsingCache) {
    }

    @Override
    public JRFillCloneable createClone(JRFillCloneFactory factory) {
        return null;
    }

    protected static JRSubreportRunnerFactory getRunnerFactory() throws JRException {
        String factoryClassName = JRProperties.getProperty("net.sf.jasperreports.subreport.runner.factory");
        if (factoryClassName == null) {
            throw new JRException("Property \"net.sf.jasperreports.subreport.runner.factory\" must be set");
        }
        return (JRSubreportRunnerFactory)runnerFactoryCache.getCachedInstance(factoryClassName);
    }

    protected int getContentsStretchHeight() {
        return this.subreportFiller.getCurrentPageStretchHeight();
    }
}

