/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.data;

import java.util.Collection;
import java.util.Iterator;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.data.JRAbstractBeanDataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JRBeanCollectionDataSource
extends JRAbstractBeanDataSource {
    private Collection<?> data;
    private Iterator<?> iterator;
    private Object currentBean;

    public JRBeanCollectionDataSource(Collection<?> beanCollection) {
        this(beanCollection, true);
    }

    public JRBeanCollectionDataSource(Collection<?> beanCollection, boolean isUseFieldDescription) {
        super(isUseFieldDescription);
        this.data = beanCollection;
        if (this.data != null) {
            this.iterator = this.data.iterator();
        }
    }

    @Override
    public boolean next() {
        boolean hasNext = false;
        if (this.iterator != null && (hasNext = this.iterator.hasNext())) {
            this.currentBean = this.iterator.next();
        }
        return hasNext;
    }

    @Override
    public Object getFieldValue(JRField field) throws JRException {
        return this.getFieldValue(this.currentBean, field);
    }

    @Override
    public void moveFirst() {
        if (this.data != null) {
            this.iterator = this.data.iterator();
        }
    }

    public Collection<?> getData() {
        return this.data;
    }

    public int getRecordCount() {
        return this.data == null ? 0 : this.data.size();
    }

    public JRBeanCollectionDataSource cloneDataSource() {
        return new JRBeanCollectionDataSource(this.data);
    }
}

