/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.sf.jasperreports.engine.JRPropertiesHolder;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.design.events.JRPropertyChangeSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JRPropertiesMap
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 10200L;
    private static final Log log = LogFactory.getLog(JRPropertiesMap.class);
    public static final String PROPERTY_VALUE = "value";
    private Map<String, String> propertiesMap;
    private List<String> propertiesList;
    private JRPropertiesMap base;
    private transient JRPropertyChangeSupport eventSupport;

    public JRPropertiesMap() {
    }

    public JRPropertiesMap(JRPropertiesMap propertiesMap) {
        this();
        this.base = propertiesMap.base;
        String[] propertyNames = propertiesMap.getPropertyNames();
        if (propertyNames != null && propertyNames.length > 0) {
            for (int i = 0; i < propertyNames.length; ++i) {
                this.setProperty(propertyNames[i], propertiesMap.getProperty(propertyNames[i]));
            }
        }
    }

    protected synchronized void ensureInit() {
        if (this.propertiesMap == null) {
            this.init();
        }
    }

    private void init() {
        this.propertiesMap = new HashMap<String, String>();
        this.propertiesList = new ArrayList<String>();
    }

    public String[] getPropertyNames() {
        String[] names;
        if (this.hasOwnProperties()) {
            if (this.base == null) {
                names = this.propertiesList.toArray(new String[this.propertiesList.size()]);
            } else {
                LinkedHashSet<String> namesSet = new LinkedHashSet<String>();
                this.collectPropertyNames(namesSet);
                names = namesSet.toArray(new String[namesSet.size()]);
            }
        } else {
            names = this.base != null ? this.base.getPropertyNames() : new String[]{};
        }
        return names;
    }

    protected void collectPropertyNames(Collection<String> names) {
        if (this.base != null) {
            this.base.collectPropertyNames(names);
        }
        if (this.propertiesList != null) {
            names.addAll(this.propertiesList);
        }
    }

    public String getProperty(String propName) {
        String val = this.hasOwnProperty(propName) ? this.getOwnProperty(propName) : (this.base != null ? this.base.getProperty(propName) : null);
        return val;
    }

    public boolean containsProperty(String propName) {
        return this.hasOwnProperty(propName) || this.base != null && this.base.containsProperty(propName);
    }

    protected boolean hasOwnProperty(String propName) {
        return this.propertiesMap != null && this.propertiesMap.containsKey(propName);
    }

    protected String getOwnProperty(String propName) {
        return this.propertiesMap != null ? this.propertiesMap.get(propName) : null;
    }

    public void setProperty(String propName, String value) {
        String old = this.getOwnProperty(propName);
        this.ensureInit();
        if (!this.hasOwnProperty(propName)) {
            this.propertiesList.add(propName);
        }
        this.propertiesMap.put(propName, value);
        this.getEventSupport().firePropertyChange(PROPERTY_VALUE, old, value);
    }

    public void removeProperty(String propName) {
        if (this.hasOwnProperty(propName)) {
            this.propertiesList.remove(propName);
            this.propertiesMap.remove(propName);
        }
    }

    public JRPropertiesMap cloneProperties() {
        return new JRPropertiesMap(this);
    }

    public Object clone() {
        return this.cloneProperties();
    }

    public String toString() {
        return this.propertiesMap == null ? "" : this.propertiesMap.toString();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.propertiesList == null && this.propertiesMap != null) {
            this.propertiesList = new ArrayList<String>(this.propertiesMap.keySet());
            this.propertiesMap = new HashMap<String, String>(this.propertiesMap);
        }
    }

    public boolean hasProperties() {
        return this.hasOwnProperties() || this.base != null && this.base.hasProperties();
    }

    public boolean hasOwnProperties() {
        return this.propertiesList != null && !this.propertiesList.isEmpty();
    }

    public static JRPropertiesMap getPropertiesClone(JRPropertiesHolder propertiesHolder) {
        JRPropertiesMap clone = propertiesHolder.hasProperties() ? propertiesHolder.getPropertiesMap().cloneProperties() : null;
        return clone;
    }

    public JRPropertiesMap getBaseProperties() {
        return this.base;
    }

    public void setBaseProperties(JRPropertiesMap base) {
        this.base = base;
    }

    public static JRPropertiesMap loadProperties(URL location) {
        boolean close = true;
        InputStream stream = null;
        try {
            stream = location.openStream();
            Properties props = new Properties();
            props.load(stream);
            close = false;
            stream.close();
            JRPropertiesMap properties = new JRPropertiesMap();
            Enumeration<?> names = props.propertyNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                String value = props.getProperty(name);
                properties.setProperty(name, value);
            }
            JRPropertiesMap jRPropertiesMap = properties;
            return jRPropertiesMap;
        }
        catch (IOException e) {
            throw new JRRuntimeException(e);
        }
        finally {
            block11: {
                if (close && stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException e) {
                        if (!log.isWarnEnabled()) break block11;
                        log.warn((Object)("Error closing stream for " + location), (Throwable)e);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JRPropertyChangeSupport getEventSupport() {
        JRPropertiesMap jRPropertiesMap = this;
        synchronized (jRPropertiesMap) {
            if (this.eventSupport == null) {
                this.eventSupport = new JRPropertyChangeSupport(this);
            }
        }
        return this.eventSupport;
    }
}

