/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.charts.xml;

import net.sf.jasperreports.charts.design.JRDesignThermometerPlot;
import net.sf.jasperreports.charts.type.ValueLocationEnum;
import net.sf.jasperreports.engine.JRChart;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.util.JRColorUtil;
import net.sf.jasperreports.engine.xml.JRBaseFactory;
import org.xml.sax.Attributes;

public class JRThermometerPlotFactory
extends JRBaseFactory {
    public static final String ELEMENT_thermometerPlot = "thermometerPlot";
    public static final String ELEMENT_lowRange = "lowRange";
    public static final String ELEMENT_mediumRange = "mediumRange";
    public static final String ELEMENT_highRange = "highRange";
    public static final String ATTRIBUTE_showValueLines = "isShowValueLines";
    public static final String ATTRIBUTE_valueLocation = "valueLocation";
    public static final String ATTRIBUTE_mercuryColor = "mercuryColor";

    public Object createObject(Attributes atts) throws JRException {
        JRChart chart = (JRChart)this.digester.peek();
        JRDesignThermometerPlot thermometerPlot = (JRDesignThermometerPlot)chart.getPlot();
        String location = atts.getValue(ATTRIBUTE_valueLocation);
        ValueLocationEnum loc = ValueLocationEnum.getByName(atts.getValue(ATTRIBUTE_valueLocation));
        if (loc == null) {
            throw new JRException("Invalid thermometer value location: " + location);
        }
        thermometerPlot.setValueLocation(loc);
        String mercuryColor = atts.getValue(ATTRIBUTE_mercuryColor);
        if (mercuryColor != null && mercuryColor.length() > 0) {
            thermometerPlot.setMercuryColor(JRColorUtil.getColor(mercuryColor, null));
        }
        return thermometerPlot;
    }
}

