/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.components.table.actions;

import com.jaspersoft.ireport.components.table.TableMatrix;
import com.jaspersoft.ireport.components.table.TableObjectScene;
import com.jaspersoft.ireport.components.table.widgets.IndicatorWidget;
import java.awt.Point;
import java.util.List;
import net.sf.jasperreports.components.table.BaseColumn;
import net.sf.jasperreports.components.table.StandardColumn;
import net.sf.jasperreports.components.table.StandardColumnGroup;
import net.sf.jasperreports.components.table.StandardTable;
import org.netbeans.api.visual.action.MoveProvider;
import org.netbeans.api.visual.widget.Widget;

public class TableColumnMoveProvider
implements MoveProvider {
    Point originalLocation = null;
    boolean reversOrder = false;
    int sepIndex = -1;

    public TableColumnMoveProvider() {
        this(false);
    }

    public TableColumnMoveProvider(boolean reversOrder) {
        this.reversOrder = reversOrder;
    }

    public void movementStarted(Widget w) {
        this.originalLocation = w.getPreferredLocation();
    }

    public void movementFinished(Widget w) {
        if (this.sepIndex < 0 || !(w instanceof IndicatorWidget) || !(((IndicatorWidget)w).getData() instanceof BaseColumn)) {
            w.setPreferredLocation(this.originalLocation);
            return;
        }
        IndicatorWidget widget = (IndicatorWidget)w;
        BaseColumn column = (BaseColumn)widget.getData();
        TableObjectScene scene = (TableObjectScene)widget.getScene();
        TableMatrix matrix = scene.getTableMatrix();
        List<StandardColumn> columns = matrix.getStandardColumns();
        StandardColumn siblingColumn = null;
        siblingColumn = this.sepIndex >= columns.size() ? columns.get(columns.size() - 1) : columns.get(this.sepIndex);
        Object newParent = matrix.getColumnParent((BaseColumn)siblingColumn);
        List newColumns = newParent instanceof StandardTable ? ((StandardTable)newParent).getColumns() : ((StandardColumnGroup)newParent).getColumns();
        int newPosition = newColumns.indexOf(siblingColumn);
        if (this.sepIndex >= columns.size()) {
            ++newPosition;
        }
        matrix.moveColumn(column, newParent, newPosition);
        this.originalLocation.x = matrix.getColumnBounds((BaseColumn)((BaseColumn)widget.getData())).x;
        w.setPreferredLocation(this.originalLocation);
        if (scene.getIndicatorsLayer().getChildren().size() == 0) {
            scene.getIndicatorsLayer().addChild(w);
            scene.validate();
        }
    }

    public Point getOriginalLocation(Widget widget) {
        return widget.getPreferredLocation();
    }

    public void setNewLocation(Widget widget, Point newLocation) {
        widget.setPreferredLocation(newLocation);
        if (widget instanceof IndicatorWidget) {
            TableObjectScene scene = (TableObjectScene)widget.getScene();
            TableMatrix matrix = scene.getTableMatrix();
            List<Integer> vertLines = matrix.getVerticalSeparators();
            List<Integer> horizLines = matrix.getHorizontalSeparators();
            int closest = widget.getBounds().width / 2;
            int mid = newLocation.x + closest;
            int i = 0;
            this.sepIndex = -1;
            for (Integer v : vertLines) {
                if (Math.abs(mid - v) < closest) {
                    closest = Math.abs(mid - v);
                    this.sepIndex = i;
                }
                ++i;
            }
            ((IndicatorWidget)widget).setLastIndicatedIndex(this.sepIndex);
        }
    }
}

