/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.editor;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.editor.ExpressionContext;
import java.awt.Font;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JEditorPane;
import javax.swing.text.EditorKit;
import org.openide.text.CloneableEditorSupport;

public class ExpressionEditorPane
extends JEditorPane {
    private ExpressionContext expressionContext = null;

    public ExpressionEditorPane() {
        this((ExpressionContext)null);
    }

    public void removeHyperlinkEditorKitListeners() {
        KeyListener[] hls = (KeyListener[])this.getListeners(KeyListener.class);
        for (int i = 0; i < hls.length; ++i) {
            if (!hls[i].getClass().getName().equals("org.netbeans.modules.languages.features.HyperlinkListener")) continue;
            this.removeKeyListener(hls[i]);
        }
        MouseMotionListener[] hls1 = (MouseMotionListener[])this.getListeners(MouseMotionListener.class);
        for (int i = 0; i < hls1.length; ++i) {
            if (!hls1[i].getClass().getName().equals("org.netbeans.modules.languages.features.HyperlinkListener")) continue;
            this.removeMouseMotionListener(hls1[i]);
        }
        MouseListener[] hls2 = (MouseListener[])this.getListeners(MouseListener.class);
        for (int i = 0; i < hls2.length; ++i) {
            if (!hls2[i].getClass().getName().equals("org.netbeans.modules.languages.features.HyperlinkListener")) continue;
            this.removeMouseListener(hls2[i]);
        }
    }

    public ExpressionEditorPane(ExpressionContext context) {
        this.expressionContext = context;
        if (IReportManager.getPreferences().getBoolean("useSyntaxHighlighting", true)) {
            EditorKit kit = CloneableEditorSupport.getEditorKit((String)"text/jrxml-expression");
            this.setEditorKit(kit);
        }
        Font font = new Font("Monospaced", 0, IReportManager.getPreferences().getInt("editorFontSize", 12));
        this.setFont(font);
        this.removeHyperlinkEditorKitListeners();
        this.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                ExpressionContext.setGlobalContext(ExpressionEditorPane.this.getExpressionContext());
                ExpressionContext.activeEditor = ExpressionEditorPane.this;
            }

            public void focusLost(FocusEvent e) {
            }
        });
    }

    public ExpressionContext getExpressionContext() {
        return this.expressionContext;
    }

    public void setExpressionContext(ExpressionContext expressionContext) {
        this.expressionContext = expressionContext;
    }
}

