/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.editor;

import com.jaspersoft.ireport.designer.editor.ExpObject;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JRVariable;

public class ExpObjectCellRenderer
extends JTextPane
implements ListCellRenderer,
TableCellRenderer {
    private Color selectionBackground;
    private Color background;
    private boolean showObjectType = true;
    private boolean showObjectClass = true;
    Style typeStyle = null;
    Style classTypeStyle = null;
    Style parameterStyle = null;
    Style variableStyle = null;
    Style fieldStyle = null;
    Style whiteStyle = null;
    Style normalStyle = null;

    public ExpObjectCellRenderer(JList list) {
        this.initColors();
        this.selectionBackground = list.getSelectionBackground();
        this.background = list.getBackground();
    }

    protected Component getRendererComponent(Object object, boolean isSelected, boolean cellHasFocus) {
        this.setText("");
        StyledDocument doc = (StyledDocument)this.getDocument();
        if (object instanceof JRVariable || object instanceof JRField || object instanceof JRParameter) {
            object = new ExpObject(object);
        }
        this.setBackground(isSelected || cellHasFocus ? this.selectionBackground : this.background);
        StyleConstants.setBackground(this.typeStyle, isSelected || cellHasFocus ? this.selectionBackground : this.background);
        StyleConstants.setBackground(this.classTypeStyle, isSelected || cellHasFocus ? this.selectionBackground : this.background);
        StyleConstants.setBackground(this.parameterStyle, isSelected || cellHasFocus ? this.selectionBackground : this.background);
        StyleConstants.setBackground(this.variableStyle, isSelected || cellHasFocus ? this.selectionBackground : this.background);
        StyleConstants.setBackground(this.fieldStyle, isSelected || cellHasFocus ? this.selectionBackground : this.background);
        StyleConstants.setBackground(this.whiteStyle, isSelected || cellHasFocus ? this.selectionBackground : this.background);
        if (object instanceof ExpObject) {
            ExpObject eo = (ExpObject)object;
            try {
                doc.insertString(doc.getLength(), eo.getName() + "   ", isSelected || cellHasFocus ? this.whiteStyle : null);
                if (this.isShowObjectType()) {
                    Style s = this.parameterStyle;
                    String type = "Parameter";
                    if (eo.getType() == 0) {
                        s = this.fieldStyle;
                        type = "Field";
                    } else if (eo.getType() == 1) {
                        s = this.variableStyle;
                        type = "Variable";
                    }
                    if (isSelected || cellHasFocus) {
                        s = this.whiteStyle;
                    }
                    doc.insertString(doc.getLength(), type + " ", s);
                }
                if (this.isShowObjectClass()) {
                    String tp = eo.getClassType() + "";
                    if (tp.lastIndexOf(".") > 0) {
                        tp = tp.substring(tp.lastIndexOf(".") + 1);
                    }
                    doc.insertString(doc.getLength(), tp, this.classTypeStyle);
                    doc.setLogicalStyle(0, this.normalStyle);
                }
            }
            catch (Exception ex) {}
        } else {
            try {
                if (object != null) {
                    doc.insertString(doc.getLength(), "" + object, null);
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        this.setOpaque(true);
        this.revalidate();
        return this;
    }

    private void initColors() {
        this.selectionBackground = UIManager.getColor("List.selectionBackground");
        this.background = UIManager.getColor("List.background");
        DefaultStyledDocument doc = new DefaultStyledDocument();
        this.setDocument(doc);
        this.normalStyle = doc.addStyle("normalStyle", null);
        Font font = UIManager.getFont("List.font");
        StyleConstants.setFontFamily(this.normalStyle, font.getFamily());
        StyleConstants.setFontSize(this.normalStyle, font.getSize());
        StyleConstants.setForeground(this.normalStyle, UIManager.getColor("List.foreground"));
        this.typeStyle = doc.addStyle("typeStyle", null);
        StyleConstants.setItalic(this.typeStyle, true);
        StyleConstants.setForeground(this.typeStyle, Color.gray);
        this.classTypeStyle = doc.addStyle("classTypeStyle", null);
        StyleConstants.setForeground(this.classTypeStyle, Color.gray);
        this.parameterStyle = doc.addStyle("parameterStyle", null);
        StyleConstants.setForeground(this.parameterStyle, Color.red.darker());
        this.variableStyle = doc.addStyle("variableStyle", null);
        StyleConstants.setForeground(this.variableStyle, Color.blue);
        this.fieldStyle = doc.addStyle("fieldStyle", null);
        StyleConstants.setForeground(this.fieldStyle, Color.green.darker().darker());
        this.whiteStyle = doc.addStyle("whiteStyle", null);
        StyleConstants.setForeground(this.whiteStyle, Color.white);
    }

    public ExpObjectCellRenderer() {
        this.initColors();
    }

    public Component getListCellRendererComponent(JList list, Object object, int index, boolean isSelected, boolean cellHasFocus) {
        return this.getRendererComponent(object, isSelected, cellHasFocus);
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        return this.getRendererComponent(value, isSelected, hasFocus);
    }

    public boolean isShowObjectType() {
        return this.showObjectType;
    }

    public void setShowObjectType(boolean showObjectType) {
        this.showObjectType = showObjectType;
    }

    public boolean isShowObjectClass() {
        return this.showObjectClass;
    }

    public void setShowObjectClass(boolean showObjectClass) {
        this.showObjectClass = showObjectClass;
    }
}

