/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.data.fieldsproviders.xml;

import com.jaspersoft.ireport.designer.FieldsProviderEditor;
import com.jaspersoft.ireport.designer.IReportConnection;
import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.data.ReportQueryDialog;
import com.jaspersoft.ireport.designer.data.fieldsproviders.xml.XMLDocumentTreeCellRenderer;
import com.jaspersoft.ireport.designer.data.fieldsproviders.xml.XMLTreeTransfertHandler;
import com.jaspersoft.ireport.designer.utils.Misc;
import com.jaspersoft.ireport.locale.I18n;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.design.JRDesignField;
import net.sf.jasperreports.engine.util.xml.JRXPathExecuter;
import net.sf.jasperreports.engine.util.xml.JRXPathExecuterUtils;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLFieldMappingEditor
extends JPanel
implements FieldsProviderEditor {
    private String xpathExpression = null;
    private Document document = null;
    private JRXPathExecuter xpathExecuter = null;
    private ReportQueryDialog reportQueryDialog = null;
    private List recordNodes = new ArrayList();
    private JLabel jLabelHelp;
    private JMenuItem jMenuItemAddAbsoluteField;
    private JMenuItem jMenuItemAddField;
    private JMenuItem jMenuItemChangeRoot;
    private JMenuItem jMenuItemCollapseAll;
    private JMenuItem jMenuItemExpandAll;
    private JMenuItem jMenuItemRefresh;
    private JMenuItem jMenuItemSetRecordNode;
    private JPanel jPanel1;
    private JPopupMenu jPopupMenuFields;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JTree jTree1;

    public ReportQueryDialog getReportQueryDialog() {
        return this.reportQueryDialog;
    }

    public void setReportQueryDialog(ReportQueryDialog reportQueryDialog) {
        this.reportQueryDialog = reportQueryDialog;
    }

    public List getRecordNodes() {
        return this.recordNodes;
    }

    public void setRecordNodes(List recordNodes) {
        this.recordNodes = recordNodes;
    }

    public Document getDocument() {
        return this.document;
    }

    public void setDocument(Document document) {
        this.document = document;
    }

    public String getXpathExpression() {
        return this.xpathExpression;
    }

    public void setXpathExpression(String xpathExpression) {
        this.xpathExpression = xpathExpression;
    }

    public XMLFieldMappingEditor(ReportQueryDialog rqd) {
        this.initComponents();
        try {
            Thread.currentThread().setContextClassLoader(IReportManager.getReportClassLoader());
            this.xpathExecuter = JRXPathExecuterUtils.getXPathExecuter();
        }
        catch (JRException ex) {
            ex.printStackTrace();
        }
        this.reportQueryDialog = rqd;
        this.jTree1.setCellRenderer(new XMLDocumentTreeCellRenderer(this));
        this.jTree1.setTransferHandler(new XMLTreeTransfertHandler(this));
        this.setXpathExpression(rqd.getQueryEditorPane().getText());
        this.updateView();
    }

    private void initComponents() {
        this.jPopupMenuFields = new JPopupMenu();
        this.jMenuItemSetRecordNode = new JMenuItem();
        this.jMenuItemChangeRoot = new JMenuItem();
        this.jSeparator2 = new JSeparator();
        this.jMenuItemAddField = new JMenuItem();
        this.jMenuItemAddAbsoluteField = new JMenuItem();
        this.jSeparator1 = new JSeparator();
        this.jMenuItemExpandAll = new JMenuItem();
        this.jMenuItemCollapseAll = new JMenuItem();
        this.jMenuItemRefresh = new JMenuItem();
        this.jScrollPane1 = new JScrollPane();
        this.jTree1 = new JTree();
        this.jPanel1 = new JPanel();
        this.jLabelHelp = new JLabel();
        this.jPopupMenuFields.addPopupMenuListener(new PopupMenuListener(){

            public void popupMenuCanceled(PopupMenuEvent evt) {
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent evt) {
            }

            public void popupMenuWillBecomeVisible(PopupMenuEvent evt) {
                XMLFieldMappingEditor.this.jPopupMenuFieldsPopupMenuWillBecomeVisible(evt);
            }
        });
        this.jMenuItemSetRecordNode.setText(I18n.getString("XMLFieldMappingEditor.Menu.RecordNode"));
        this.jMenuItemSetRecordNode.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                XMLFieldMappingEditor.this.jMenuItemSetRecordNodeActionPerformed(evt);
            }
        });
        this.jPopupMenuFields.add(this.jMenuItemSetRecordNode);
        this.jMenuItemChangeRoot.setText(I18n.getString("XMLFieldMappingEditor.Menu.DocRoot"));
        this.jMenuItemChangeRoot.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                XMLFieldMappingEditor.this.jMenuItemChangeRootActionPerformed(evt);
            }
        });
        this.jPopupMenuFields.add(this.jMenuItemChangeRoot);
        this.jPopupMenuFields.add(this.jSeparator2);
        this.jMenuItemAddField.setText(I18n.getString("XMLFieldMappingEditor.Menu.AddNode"));
        this.jMenuItemAddField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                XMLFieldMappingEditor.this.jMenuItemAddFieldActionPerformed(evt);
            }
        });
        this.jPopupMenuFields.add(this.jMenuItemAddField);
        this.jMenuItemAddAbsoluteField.setText(I18n.getString("XMLFieldMappingEditor.Menu.AddNode2"));
        this.jMenuItemAddAbsoluteField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                XMLFieldMappingEditor.this.jMenuItemAddAbsoluteFieldActionPerformed(evt);
            }
        });
        this.jPopupMenuFields.add(this.jMenuItemAddAbsoluteField);
        this.jPopupMenuFields.add(this.jSeparator1);
        this.jMenuItemExpandAll.setText(I18n.getString("XMLFieldMappingEditor.Menu.Expand"));
        this.jMenuItemExpandAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                XMLFieldMappingEditor.this.jMenuItemExpandAllActionPerformed(evt);
            }
        });
        this.jPopupMenuFields.add(this.jMenuItemExpandAll);
        this.jMenuItemCollapseAll.setText(I18n.getString("XMLFieldMappingEditor.Menu.Collapse"));
        this.jMenuItemCollapseAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                XMLFieldMappingEditor.this.jMenuItemCollapseAllActionPerformed(evt);
            }
        });
        this.jPopupMenuFields.add(this.jMenuItemCollapseAll);
        this.jMenuItemRefresh.setText(I18n.getString("XMLFieldMappingEditor.Menu.ResRefDoc"));
        this.jMenuItemRefresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                XMLFieldMappingEditor.this.jMenuItemRefreshActionPerformed(evt);
            }
        });
        this.jPopupMenuFields.add(this.jMenuItemRefresh);
        this.setMinimumSize(new Dimension(250, 23));
        this.setPreferredSize(new Dimension(280, 322));
        this.setLayout(new BorderLayout());
        this.jScrollPane1.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                XMLFieldMappingEditor.this.jScrollPane1MouseClicked(evt);
            }
        });
        this.jTree1.setDragEnabled(true);
        this.jTree1.setMinimumSize(new Dimension(73, 64));
        this.jTree1.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                XMLFieldMappingEditor.this.jTree1MouseClicked(evt);
            }

            public void mousePressed(MouseEvent evt) {
                XMLFieldMappingEditor.this.jTree1MousePressed(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTree1);
        this.add((Component)this.jScrollPane1, "Center");
        this.jPanel1.setBackground(new Color(255, 255, 204));
        this.jPanel1.setLayout(new GridBagLayout());
        this.jLabelHelp.setBackground(new Color(255, 255, 204));
        this.jLabelHelp.setText(I18n.getString("XMLFieldMappingEditor.Label.Info"));
        this.jLabelHelp.setVerticalTextPosition(1);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.jLabelHelp, gridBagConstraints);
        this.add((Component)this.jPanel1, "North");
    }

    private void jMenuItemCollapseAllActionPerformed(ActionEvent evt) {
        this.expandAll(this.jTree1, false);
    }

    private void jMenuItemExpandAllActionPerformed(ActionEvent evt) {
        this.expandAll(this.jTree1, true);
    }

    public void expandAll(JTree tree, boolean expand) {
        TreeNode root = (TreeNode)tree.getModel().getRoot();
        this.expandAll(tree, new TreePath(root), expand);
    }

    private void expandAll(JTree tree, TreePath parent, boolean expand) {
        TreeNode node = (TreeNode)parent.getLastPathComponent();
        if (node.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                TreeNode n = e.nextElement();
                TreePath path = parent.pathByAddingChild(n);
                this.expandAll(tree, path, expand);
            }
        }
        if (expand) {
            tree.expandPath(parent);
        } else {
            tree.collapsePath(parent);
        }
    }

    private void jMenuItemAddAbsoluteFieldActionPerformed(ActionEvent evt) {
        TreePath tp = this.jTree1.getSelectionPath();
        if (tp == null) {
            return;
        }
        JRDesignField field = this.createField(tp, false);
        if (field != null) {
            this.getReportQueryDialog().addField((JRField)field);
        }
    }

    private void jMenuItemAddFieldActionPerformed(ActionEvent evt) {
        TreePath tp = this.jTree1.getSelectionPath();
        if (tp == null) {
            return;
        }
        JRDesignField field = this.createField(tp, true);
        if (field != null) {
            this.getReportQueryDialog().addField((JRField)field);
        }
    }

    private void jMenuItemChangeRootActionPerformed(ActionEvent evt) {
        TreePath tp = this.jTree1.getSelectionPath();
        if (tp == null) {
            return;
        }
        Node newRoot = (Node)((DefaultMutableTreeNode)tp.getLastPathComponent()).getUserObject();
        this.jTree1.setModel(new DefaultTreeModel(this.addTreeDocument(newRoot)));
    }

    private void jTree1MouseClicked(MouseEvent evt) {
        if (SwingUtilities.isRightMouseButton(evt) && evt.getClickCount() == 1) {
            Misc.ensurePathIsSelected(this.jTree1.getPathForLocation(evt.getX(), evt.getY()), this.jTree1);
            this.jPopupMenuFields.show(this.jTree1, evt.getX(), evt.getY());
        }
    }

    private void jScrollPane1MouseClicked(MouseEvent evt) {
    }

    private void jMenuItemSetRecordNodeActionPerformed(ActionEvent evt) {
        TreePath tp = this.jTree1.getSelectionPath();
        if (tp == null) {
            return;
        }
        String expression = this.generateXpathExpression(tp, false);
        if (this.reportQueryDialog != null) {
            this.reportQueryDialog.getQueryEditorPane().setText(expression);
        }
    }

    private void jTree1MousePressed(MouseEvent evt) {
    }

    private void jMenuItemRefreshActionPerformed(ActionEvent evt) {
        this.updateView();
    }

    private void jPopupMenuFieldsPopupMenuWillBecomeVisible(PopupMenuEvent evt) {
        TreePath tp = this.jTree1.getSelectionPath();
        this.jMenuItemSetRecordNode.setEnabled(false);
        this.jMenuItemChangeRoot.setEnabled(false);
        this.jMenuItemAddField.setEnabled(false);
        this.jMenuItemAddAbsoluteField.setEnabled(false);
        if (tp == null) {
            return;
        }
        if (((DefaultMutableTreeNode)tp.getLastPathComponent()).getUserObject() instanceof Node) {
            Node node = (Node)((DefaultMutableTreeNode)tp.getLastPathComponent()).getUserObject();
            if (node.getNodeType() == 1) {
                this.jMenuItemSetRecordNode.setEnabled(true);
                this.jMenuItemChangeRoot.setEnabled(true);
            }
            this.jMenuItemAddField.setEnabled(true);
            this.jMenuItemAddAbsoluteField.setEnabled(true);
        }
    }

    public void updateView() {
        IReportConnection conn = IReportManager.getInstance().getDefaultConnection();
        InputStream inputStream = this.getInputStream(conn);
        if (inputStream == null) {
            this.jTree1.setModel(new DefaultTreeModel(new DefaultMutableTreeNode(I18n.getString("XMLFieldMappingEditor.Node.Warning"))));
        } else {
            try {
                this.document = XMLFieldMappingEditor.createDocumentBuilder().parse(inputStream);
                DefaultMutableTreeNode root = this.addTreeDocument(this.document.getDocumentElement());
                this.jTree1.setModel(new DefaultTreeModel(root));
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.jTree1.setModel(new DefaultTreeModel(new DefaultMutableTreeNode("Error loading the XML file.")));
            }
        }
        this.updateXpathView();
        this.jTree1.updateUI();
    }

    public DefaultMutableTreeNode addTreeDocument(Node node) {
        if (node.getNodeType() != 1 && node.getNodeType() != 2) {
            return null;
        }
        DefaultMutableTreeNode tnode = new DefaultMutableTreeNode(node);
        NamedNodeMap nm = node.getAttributes();
        for (int i = 0; nm != null && i < nm.getLength(); ++i) {
            Node childNode = nm.item(i);
            DefaultMutableTreeNode cnode = this.addTreeDocument(childNode);
            if (cnode == null) continue;
            tnode.add(cnode);
        }
        NodeList nl = node.getChildNodes();
        for (int i = 0; nl != null && i < nl.getLength(); ++i) {
            Node childNode = nl.item(i);
            DefaultMutableTreeNode cnode = this.addTreeDocument(childNode);
            if (cnode == null) continue;
            tnode.add(cnode);
        }
        return tnode;
    }

    public void queryChanged(String newQuery) {
        this.setXpathExpression(newQuery);
        try {
            Runnable r = new Runnable(){

                public void run() {
                    XMLFieldMappingEditor.this.updateXpathView();
                }
            };
            if (!SwingUtilities.isEventDispatchThread()) {
                SwingUtilities.invokeAndWait(r);
            } else {
                r.run();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void updateXpathView() {
        block5: {
            if (this.document == null || this.getXpathExpression() == null || this.getXpathExpression().trim().length() == 0) {
                return;
            }
            try {
                NodeList nodeList = this.xpathExecuter.selectNodeList((Node)this.document, this.getXpathExpression());
                this.getRecordNodes().clear();
                for (int i = 0; nodeList != null && i < nodeList.getLength(); ++i) {
                    this.getRecordNodes().add(nodeList.item(i));
                }
                if (this.reportQueryDialog != null) {
                    this.reportQueryDialog.getJLabelStatusSQL().setText(I18n.getString("XMLFieldMappingEditor.Label.StatusSQL") + nodeList.getLength());
                }
                this.jTree1.updateUI();
            }
            catch (Exception ex) {
                if (this.reportQueryDialog == null) break block5;
                this.reportQueryDialog.getJLabelStatusSQL().setText(I18n.getString("XMLFieldMappingEditor.Label.StatusSQL2") + ex.getMessage() + " (" + this.getXpathExpression() + ")");
                ex.printStackTrace();
            }
        }
    }

    public String generateXpathExpression(TreePath tp, boolean relative) {
        Node node;
        int i;
        String xpath = "";
        boolean rootFound = false;
        Object[] nodes = ((DefaultMutableTreeNode)tp.getLastPathComponent()).getUserObjectPath();
        if (relative) {
            for (i = nodes.length - 1; i >= 0; --i) {
                node = (Node)nodes[i];
                if (!this.getRecordNodes().contains(node)) continue;
                rootFound = true;
                break;
            }
            if (!rootFound) {
                String postfix = "";
                node = (Node)nodes[nodes.length - 1];
                if (node.getNodeType() == 2) {
                    postfix = "/@" + node.getNodeName();
                    node = (Node)nodes[nodes.length - 2];
                }
                String exp = "ancestor::" + node.getNodeName();
                for (int i2 = 0; i2 < this.getRecordNodes().size(); ++i2) {
                    try {
                        Node currentNode = (Node)this.getRecordNodes().get(i2);
                        NodeList list = this.xpathExecuter.selectNodeList(currentNode, exp);
                        Node foundNode = null;
                        if (list.getLength() > 0) {
                            foundNode = list.item(0);
                        }
                        if (foundNode == node) {
                            return exp + postfix;
                        }
                        continue;
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
            }
        }
        rootFound = false;
        for (i = nodes.length - 1; i >= 0; --i) {
            node = (Node)nodes[i];
            if (relative && this.getRecordNodes().contains(node)) {
                if (xpath.length() == 0) {
                    xpath = "child::text()";
                }
                rootFound = true;
                break;
            }
            if (xpath.length() > 0) {
                xpath = "/" + xpath;
            }
            xpath = node.getNodeType() == 1 ? node.getNodeName() + xpath : "@" + node.getNodeName();
        }
        if (!(rootFound && relative || xpath.startsWith("/"))) {
            xpath = "/" + xpath;
        }
        return xpath;
    }

    public JRDesignField createField(TreePath path, boolean mode) {
        JRDesignField jrField = null;
        DefaultMutableTreeNode dmtn = (DefaultMutableTreeNode)path.getLastPathComponent();
        if (dmtn.getUserObject() != null && dmtn.getUserObject() instanceof Node) {
            Node node = (Node)dmtn.getUserObject();
            jrField = new JRDesignField();
            jrField.setName(node.getNodeName());
            jrField.setValueClassName("java.lang.String");
            jrField.setDescription(this.generateXpathExpression(path, mode));
            boolean found = true;
            String name = node.getNodeName();
            int i = 2;
            while (found) {
                found = false;
                DefaultTableModel dtm = (DefaultTableModel)this.getReportQueryDialog().getFieldsTable().getModel();
                for (int k = 0; k < dtm.getRowCount(); ++k) {
                    JRDesignField tmpField = (JRDesignField)dtm.getValueAt(k, 0);
                    if (!tmpField.getName().equals(name)) continue;
                    found = true;
                    break;
                }
                if (found) {
                    name = node.getNodeName() + i;
                }
                ++i;
            }
            jrField.setName(name);
        }
        return jrField;
    }

    private InputStream getInputStream(IReportConnection conn) {
        String file = null;
        try {
            Method m = conn.getClass().getMethod("getFilename", new Class[0]);
            if (m != null) {
                file = (String)m.invoke((Object)conn, new Object[0]);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (file == null) {
            return null;
        }
        try {
            return new FileInputStream(new File(file));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            try {
                URL url = new URL(file);
                return url.openStream();
            }
            catch (Exception ex2) {
                ex2.printStackTrace();
                return null;
            }
        }
    }

    public static DocumentBuilder createDocumentBuilder() throws JRException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setValidating(false);
        dbf.setIgnoringComments(true);
        dbf.setNamespaceAware(true);
        try {
            return dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new JRException("Failed to create a document builder factory", (Throwable)e);
        }
    }
}

