/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer;

import com.jaspersoft.ireport.designer.AbstractReportObjectScene;
import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.ModelUtils;
import com.jaspersoft.ireport.designer.ThreadUtils;
import com.jaspersoft.ireport.designer.actions.BandDblClickResizeAction;
import com.jaspersoft.ireport.designer.actions.BandMoveAction;
import com.jaspersoft.ireport.designer.actions.BandSelectionAction;
import com.jaspersoft.ireport.designer.actions.ExMoveAction;
import com.jaspersoft.ireport.designer.actions.KeyboardElementMoveAction;
import com.jaspersoft.ireport.designer.actions.ReportAlignWithMoveStrategyProvider;
import com.jaspersoft.ireport.designer.actions.ReportAlignWithResizeStrategyProvider;
import com.jaspersoft.ireport.designer.actions.ReportAlignWithWidgetCollector;
import com.jaspersoft.ireport.designer.actions.TranslucentRectangularSelectDecorator;
import com.jaspersoft.ireport.designer.widgets.BandSeparatorWidget;
import com.jaspersoft.ireport.designer.widgets.BandWidget;
import com.jaspersoft.ireport.designer.widgets.JRDesignChartWidget;
import com.jaspersoft.ireport.designer.widgets.JRDesignElementWidget;
import com.jaspersoft.ireport.designer.widgets.JRDesignImageWidget;
import com.jaspersoft.ireport.designer.widgets.PageWidget;
import com.jaspersoft.ireport.designer.widgets.SelectionWidget;
import com.jaspersoft.ireport.designer.widgets.visitor.ConfigurableDrawVisitor;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.UIManager;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.convert.ReportConverter;
import net.sf.jasperreports.engine.design.JRDesignBand;
import net.sf.jasperreports.engine.design.JRDesignChart;
import net.sf.jasperreports.engine.design.JRDesignComponentElement;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignElementGroup;
import net.sf.jasperreports.engine.design.JRDesignFrame;
import net.sf.jasperreports.engine.design.JRDesignGroup;
import net.sf.jasperreports.engine.design.JRDesignImage;
import net.sf.jasperreports.engine.design.JRDesignSection;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.export.draw.DrawVisitor;
import net.sf.jasperreports.engine.type.BandTypeEnum;
import org.netbeans.api.visual.action.ActionFactory;
import org.netbeans.api.visual.action.RectangularSelectDecorator;
import org.netbeans.api.visual.action.RectangularSelectProvider;
import org.netbeans.api.visual.action.ResizeProvider;
import org.netbeans.api.visual.action.ResizeStrategy;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.model.ObjectScene;
import org.netbeans.api.visual.widget.EventProcessingType;
import org.netbeans.api.visual.widget.LayerWidget;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;

public class ReportObjectScene
extends AbstractReportObjectScene
implements PropertyChangeListener {
    private List<JRDesignElement> selectedElements = new ArrayList<JRDesignElement>();
    private ReportAlignWithWidgetCollector reportAlignWithWidgetCollector = null;
    private ReportAlignWithMoveStrategyProvider reportAlignWithMoveStrategyProvider = null;
    private ReportAlignWithResizeStrategyProvider reportAlignWithResizeStrategyProvider = null;
    private KeyboardElementMoveAction keyboardElementMoveAction = null;
    private BandSelectionAction bandSelectionAction = null;
    private JasperDesign jasperDesign = null;
    private DrawVisitor drawVisitor = null;
    LayerWidget backgroundLayer = null;
    LayerWidget pageLayer = null;
    LayerWidget interractionLayer = null;
    LayerWidget bandSeparatorsLayer = null;
    LayerWidget bandLayer = null;

    public void setSnapToGrid(boolean snapToGrid) {
        if (this.snapToGrid != snapToGrid) {
            this.snapToGrid = snapToGrid;
            this.reportAlignWithMoveStrategyProvider.setSnapToGrid(snapToGrid);
            this.reportAlignWithResizeStrategyProvider.setSnapToGrid(snapToGrid);
        }
    }

    public void setGridVisible(boolean gridVisible) {
        if (this.gridVisible != gridVisible) {
            this.gridVisible = gridVisible;
            this.pageLayer.revalidate(true);
            this.validate();
        }
    }

    public ReportAlignWithWidgetCollector getReportAlignWithWidgetCollector() {
        return this.reportAlignWithWidgetCollector;
    }

    public void setReportAlignWithWidgetCollector(ReportAlignWithWidgetCollector reportAlignWithWidgetCollector) {
        this.reportAlignWithWidgetCollector = reportAlignWithWidgetCollector;
    }

    public DrawVisitor getDrawVisitor() {
        return this.drawVisitor;
    }

    public void setDrawVisitor(DrawVisitor drawVisitor) {
        this.drawVisitor = drawVisitor;
    }

    public JasperDesign getJasperDesign() {
        return this.jasperDesign;
    }

    public void setJasperDesign(JasperDesign jasperDesign) {
        this.jasperDesign = jasperDesign;
        if (jasperDesign == null) {
            this.drawVisitor = null;
            this.rebuildDocument();
            return;
        }
        jasperDesign.getEventSupport().addPropertyChangeListener((PropertyChangeListener)this);
        this.updateSectionListeners();
        this.drawVisitor = new ConfigurableDrawVisitor(new ReportConverter((JRReport)jasperDesign, true), null);
        ThreadUtils.invokeInAWTThread(new Runnable(){

            public void run() {
                ReportObjectScene.this.rebuildDocument();
            }
        });
    }

    public void updateSectionListeners() {
        ((JRDesignSection)this.getJasperDesign().getDetailSection()).getEventSupport().removePropertyChangeListener((PropertyChangeListener)this);
        ((JRDesignSection)this.getJasperDesign().getDetailSection()).getEventSupport().addPropertyChangeListener((PropertyChangeListener)this);
        for (int i = 0; i < this.getJasperDesign().getGroupsList().size(); ++i) {
            JRDesignGroup grp = (JRDesignGroup)this.getJasperDesign().getGroupsList().get(i);
            grp.getEventSupport().removePropertyChangeListener((PropertyChangeListener)this);
            grp.getEventSupport().addPropertyChangeListener((PropertyChangeListener)this);
            if ((JRDesignSection)grp.getGroupHeaderSection() != null) {
                ((JRDesignSection)grp.getGroupHeaderSection()).getEventSupport().removePropertyChangeListener((PropertyChangeListener)this);
                ((JRDesignSection)grp.getGroupHeaderSection()).getEventSupport().addPropertyChangeListener((PropertyChangeListener)this);
            }
            if ((JRDesignSection)grp.getGroupFooterSection() == null) continue;
            ((JRDesignSection)grp.getGroupFooterSection()).getEventSupport().removePropertyChangeListener((PropertyChangeListener)this);
            ((JRDesignSection)grp.getGroupFooterSection()).getEventSupport().addPropertyChangeListener((PropertyChangeListener)this);
        }
    }

    public void addBandSeparatorWidget(JRBand b, int yLocation) {
        if (b == null) {
            return;
        }
        if (b instanceof JRDesignBand && ((JRDesignBand)b).getOrigin().getBandTypeValue() == BandTypeEnum.BACKGROUND) {
            ((JRDesignBand)b).getEventSupport().removePropertyChangeListener("height", (PropertyChangeListener)this);
            if (IReportManager.getInstance().isBackgroundSeparated() && b.getHeight() == 0) {
                ((JRDesignBand)b).getEventSupport().addPropertyChangeListener("height", (PropertyChangeListener)this);
                return;
            }
        }
        BandSeparatorWidget bbw = new BandSeparatorWidget(this, b);
        bbw.getActions().addAction((WidgetAction)new BandMoveAction(true, 64));
        bbw.getActions().addAction((WidgetAction)new BandMoveAction());
        bbw.getActions().addAction((WidgetAction)new BandDblClickResizeAction());
        this.bandSeparatorsLayer.addChild((Widget)bbw);
        this.bandLayer.addChild((Widget)new BandWidget(this, b));
    }

    public JRDesignElementWidget addElementWidget(JRDesignElement de) {
        if (de == null) {
            return null;
        }
        JRDesignElementWidget widget = null;
        if (de instanceof JRDesignComponentElement) {
            widget = IReportManager.getComponentWidget(this, (JRDesignComponentElement)de);
        } else if (de instanceof JRDesignImage) {
            widget = new JRDesignImageWidget((AbstractReportObjectScene)this, (JRDesignImage)de);
        } else if (de instanceof JRDesignChart) {
            widget = new JRDesignChartWidget((AbstractReportObjectScene)this, (JRDesignChart)de);
        }
        if (widget == null) {
            widget = new JRDesignElementWidget(this, de);
        }
        widget.getActions().addAction(this.getReportSelectAction());
        widget.getSelectionWidget().getActions().addAction((WidgetAction)this.keyboardElementMoveAction);
        widget.getSelectionWidget().getActions().addAction(this.getReportSelectAction());
        widget.getSelectionWidget().getActions().addAction(this.createObjectHoverAction());
        widget.getSelectionWidget().getActions().addAction(ActionFactory.createResizeAction((ResizeStrategy)this.reportAlignWithResizeStrategyProvider, (ResizeProvider)this.reportAlignWithResizeStrategyProvider));
        widget.getSelectionWidget().getActions().addAction((WidgetAction)new ExMoveAction(this.reportAlignWithMoveStrategyProvider, this.reportAlignWithMoveStrategyProvider));
        widget.getActions().addAction(ActionFactory.createResizeAction((ResizeStrategy)this.reportAlignWithResizeStrategyProvider, (ResizeProvider)this.reportAlignWithResizeStrategyProvider));
        widget.getActions().addAction((WidgetAction)new ExMoveAction(this.reportAlignWithMoveStrategyProvider, this.reportAlignWithMoveStrategyProvider));
        widget.getActions().addAction(this.inplaceEditorAction);
        widget.getSelectionWidget().getActions().addAction(this.inplaceEditorAction);
        widget.getActions().addAction(elementPopupMenuAction);
        widget.getSelectionWidget().getActions().addAction(elementPopupMenuAction);
        widget.getActions().addAction(ActionFactory.createActionMapAction((InputMap)elementInputMap, (ActionMap)elementActionMap));
        widget.getSelectionWidget().getActions().addAction(ActionFactory.createActionMapAction((InputMap)elementInputMap, (ActionMap)elementActionMap));
        this.elementsLayer.addChild((Widget)widget);
        this.selectionLayer.addChild((Widget)widget.getSelectionWidget());
        this.addObject(de, new Widget[]{widget});
        return widget;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rebuildDocument() {
        boolean oldUpdateingStatus = this.isUpdatingView();
        try {
            this.setUpdatingView(true);
            this.pageLayer.removeChildren();
            this.elementsLayer.removeChildren();
            this.bandLayer.removeChildren();
            this.bandSeparatorsLayer.removeChildren();
            this.selectionLayer.removeChildren();
            this.backgroundLayer.removeChildren();
            this.interractionLayer.removeChildren();
            while (this.getObjects().size() > 0) {
                this.removeObject(this.getObjects().iterator().next());
            }
            if (this.jasperDesign == null) {
                return;
            }
            PageWidget pageWidget = new PageWidget(this);
            this.pageLayer.addChild((Widget)pageWidget);
            this.refreshBands();
        }
        finally {
            this.setUpdatingView(oldUpdateingStatus);
        }
    }

    public void refreshDocument() {
        if (this.pageLayer.getChildren().size() != 0) {
            PageWidget pageWidget = (PageWidget)((Object)this.pageLayer.getChildren().get(0));
            pageWidget.updateBounds();
            pageWidget.repaint();
            this.refreshBands();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshBands() {
        boolean oldUpdateingStatus = this.isUpdatingView();
        try {
            this.setUpdatingView(true);
            int yLocation = this.getJasperDesign().getTopMargin();
            List bWidgets = this.bandSeparatorsLayer.getChildren();
            for (Widget w : bWidgets) {
                ((JRDesignBand)((BandSeparatorWidget)w).getBand()).getEventSupport().removePropertyChangeListener((PropertyChangeListener)((BandSeparatorWidget)w));
            }
            bWidgets = this.bandLayer.getChildren();
            for (Widget w : bWidgets) {
                ((JRDesignBand)((BandWidget)w).getBand()).getEventSupport().removePropertyChangeListener((PropertyChangeListener)((BandWidget)w));
            }
            this.bandSeparatorsLayer.removeChildren();
            this.bandLayer.removeChildren();
            if (this.getSelectedObjects().size() > 0) {
                this.setSelectedObjects(Collections.EMPTY_SET);
            }
            List<JRBand> bands = ModelUtils.getBands(this.getJasperDesign());
            for (JRBand b : bands) {
                this.addBandSeparatorWidget(b, yLocation += b.getHeight());
                this.addElements(b.getChildren());
            }
            List widgets = this.elementsLayer.getChildren();
            ArrayList<Widget> toBeRemoved = new ArrayList<Widget>();
            ArrayList<SelectionWidget> toBeRemovedSelection = new ArrayList<SelectionWidget>();
            ArrayList toBeRemovedObject = new ArrayList();
            for (Widget widget : widgets) {
                JRElementGroup grp2;
                JRDesignElementWidget dew;
                JRElementGroup grp;
                if (!(widget instanceof JRDesignElementWidget) || bands.contains(grp = ModelUtils.getTopElementGroup((dew = (JRDesignElementWidget)widget).getElement()))) continue;
                boolean remove = true;
                JRDesignElementWidget owner = this.findCustomComponentOwner(dew.getElement());
                if (owner != null && bands.contains(grp2 = ModelUtils.getTopElementGroup(owner.getElement()))) {
                    remove = false;
                }
                if (!remove) continue;
                this.removeObject(dew.getElement());
                toBeRemoved.add(widget);
                toBeRemovedSelection.add(dew.getSelectionWidget());
            }
            if (toBeRemoved.size() > 0) {
                this.elementsLayer.removeChildren(toBeRemoved);
                this.selectionLayer.removeChildren(toBeRemovedSelection);
            }
            this.validate();
        }
        finally {
            this.setUpdatingView(oldUpdateingStatus);
        }
    }

    public JRDesignElementWidget findCustomComponentOwner(JRDesignElement element) {
        while (element.getElementGroup() != null && element.getElementGroup() instanceof JRDesignFrame) {
            element = (JRDesignFrame)element.getElementGroup();
        }
        List widgets = this.elementsLayer.getChildren();
        for (Widget widget : widgets) {
            JRDesignElementWidget dew;
            if (!(widget instanceof JRDesignElementWidget) || !((dew = (JRDesignElementWidget)widget).getElement() instanceof JRDesignComponentElement) || dew.getChildrenElements() == null || !dew.getChildrenElements().contains(element)) continue;
            return dew;
        }
        return null;
    }

    private void addElements(List children) {
        for (int i = 0; i < children.size(); ++i) {
            Object obj = children.get(i);
            if (obj instanceof JRDesignElementGroup) {
                if (!this.elementGroupListeners.containsKey(obj)) {
                    AbstractReportObjectScene.GroupChangeListener gcl = new AbstractReportObjectScene.GroupChangeListener((JRDesignElementGroup)obj);
                    ((JRDesignElementGroup)obj).getEventSupport().addPropertyChangeListener((PropertyChangeListener)gcl);
                    this.elementGroupListeners.put(obj, gcl);
                }
                this.addElements(((JRDesignElementGroup)obj).getChildren());
            }
            if (!(obj instanceof JRDesignElement)) continue;
            JRDesignElement de = (JRDesignElement)obj;
            JRDesignElementWidget w = this.findElementWidget(de);
            if (w != null) {
                w.updateBounds();
                w.bringToFront();
            } else {
                w = this.addElementWidget(de);
            }
            if (w == null || w.getChildrenElements() == null) continue;
            this.addElements(w.getChildrenElements());
        }
    }

    public JRDesignElementWidget findElementWidget(JRDesignElement de) {
        List widgets = this.elementsLayer.getChildren();
        for (Widget w : widgets) {
            JRDesignElementWidget dew;
            if (!(w instanceof JRDesignElementWidget) || (dew = (JRDesignElementWidget)w).getElement() != de) continue;
            return dew;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshElementGroup(JRElementGroup group) {
        boolean oldUpdateingStatus = this.isUpdatingView();
        try {
            this.setUpdatingView(true);
            HashSet selectedObjects = new HashSet();
            selectedObjects.addAll(this.getSelectedObjects());
            if (selectedObjects.size() == 0) {
                selectedObjects = null;
            }
            List children = this.getElementsLayer().getChildren();
            ArrayList<JRDesignElementWidget> toRemove = new ArrayList<JRDesignElementWidget>();
            for (Widget w : children) {
                JRDesignElementWidget dw;
                if (!(w instanceof JRDesignElementWidget) || !ModelUtils.isOrphan((dw = (JRDesignElementWidget)w).getElement(), this.getJasperDesign())) continue;
                boolean remove = true;
                JRDesignElementWidget owner = this.findCustomComponentOwner(dw.getElement());
                if (owner != null) {
                    remove = ModelUtils.isOrphan(owner.getElement(), this.getJasperDesign());
                }
                if (!remove) continue;
                toRemove.add(dw);
                JRDesignElement element = dw.getElement();
                if (selectedObjects == null || !selectedObjects.contains(element)) continue;
                boolean found = false;
                JRElement[] ele = group.getElements();
                for (int i = 0; i < ele.length; ++i) {
                    if (ele[i] != element) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                selectedObjects.remove(element);
            }
            for (JRDesignElementWidget dw : toRemove) {
                dw.getSelectionWidget().removeFromParent();
                dw.removeFromParent();
                if (!this.getObjects().contains(dw.getElement())) continue;
                this.removeObject(dw.getElement());
            }
            this.addElements(group.getChildren());
            if (selectedObjects != null) {
                this.setSelectedObjects(selectedObjects);
            }
            this.validate();
        }
        finally {
            this.setUpdatingView(oldUpdateingStatus);
        }
    }

    public LayerWidget getBackgroundLayer() {
        return this.backgroundLayer;
    }

    public LayerWidget getPageLayer() {
        return this.pageLayer;
    }

    public LayerWidget getInterractionLayer() {
        return this.interractionLayer;
    }

    public LayerWidget getBandSeparatorsLayer() {
        return this.bandSeparatorsLayer;
    }

    public void setBandSeparatorsLayer(LayerWidget bandSeparatorsLayer) {
        this.bandSeparatorsLayer = bandSeparatorsLayer;
    }

    public LayerWidget getBandLayer() {
        return this.bandLayer;
    }

    public void setBandLayer(LayerWidget bandLayer) {
        this.bandLayer = bandLayer;
    }

    public ReportObjectScene() {
        this.initScene();
    }

    private void initScene() {
        this.setBackground(UIManager.getColor("Panel.background"));
        this.setKeyEventProcessingType(EventProcessingType.FOCUSED_WIDGET_AND_ITS_PARENTS);
        this.backgroundLayer = new LayerWidget((Scene)this);
        this.addChild((Widget)this.backgroundLayer);
        this.pageLayer = new LayerWidget((Scene)this);
        this.addChild((Widget)this.pageLayer);
        this.elementsLayer = new LayerWidget((Scene)this);
        this.addChild((Widget)this.elementsLayer);
        this.bandLayer = new LayerWidget((Scene)this);
        this.addChild((Widget)this.bandLayer);
        this.bandSeparatorsLayer = new LayerWidget((Scene)this);
        this.addChild((Widget)this.bandSeparatorsLayer);
        this.selectionLayer = new LayerWidget((Scene)this);
        this.addChild((Widget)this.selectionLayer);
        this.guideLinesLayer = new LayerWidget((Scene)this);
        this.addChild((Widget)this.guideLinesLayer);
        this.interractionLayer = new LayerWidget((Scene)this);
        this.addChild((Widget)this.interractionLayer);
        this.reportAlignWithWidgetCollector = new ReportAlignWithWidgetCollector(this);
        this.reportAlignWithMoveStrategyProvider = new ReportAlignWithMoveStrategyProvider(this.reportAlignWithWidgetCollector, this.interractionLayer, ALIGN_WITH_MOVE_DECORATOR_DEFAULT, false);
        this.reportAlignWithResizeStrategyProvider = new ReportAlignWithResizeStrategyProvider(this.reportAlignWithWidgetCollector, this.interractionLayer, ALIGN_WITH_MOVE_DECORATOR_DEFAULT, false);
        this.bandSelectionAction = new BandSelectionAction();
        this.getActions().addAction(reportPopupMenuAction);
        this.getActions().addAction((WidgetAction)this.bandSelectionAction);
        this.getActions().addAction(ActionFactory.createRectangularSelectAction((RectangularSelectDecorator)new TranslucentRectangularSelectDecorator((Scene)this), (LayerWidget)this.interractionLayer, (RectangularSelectProvider)ActionFactory.createObjectSceneRectangularSelectProvider((ObjectScene)this)));
        this.getActions().addAction(ActionFactory.createMouseCenteredZoomAction((double)1.1));
        this.getActions().addAction(ActionFactory.createPanAction());
        this.keyboardElementMoveAction = new KeyboardElementMoveAction();
        this.getActions().addAction((WidgetAction)this.keyboardElementMoveAction);
        this.setMaximumBounds(new Rectangle(-10, -10, Integer.MAX_VALUE, Integer.MAX_VALUE));
    }

    public void propertyChange(PropertyChangeEvent evt) {
        Runnable r = null;
        if (evt.getPropertyName() == null) {
            return;
        }
        if (evt.getPropertyName().equals("background") || evt.getPropertyName().equals("title") || evt.getPropertyName().equals("pageHeader") || evt.getPropertyName().equals("columnHeader") || evt.getPropertyName().equals("detail") || evt.getPropertyName().equals("columnFooter") || evt.getPropertyName().equals("pageFooter") || evt.getPropertyName().equals("lastPageFooter") || evt.getPropertyName().equals("summary") || evt.getPropertyName().equals("noData") || evt.getPropertyName().equals("pageWidth") || evt.getPropertyName().equals("pageHeight") || evt.getPropertyName().equals("topMargin") || evt.getPropertyName().equals("bottomMargin") || evt.getPropertyName().equals("leftMargin") || evt.getPropertyName().equals("rightMargin") || evt.getPropertyName().equals("columnCount") || evt.getPropertyName().equals("columnSpacing") || evt.getPropertyName().equals("columnWidth") || evt.getPropertyName().equals("groupHeader") || evt.getPropertyName().equals("groupFooter") || evt.getPropertyName().equals("groups") || evt.getPropertyName().equals("bands") || evt.getPropertyName().equals("printOrder") || evt.getPropertyName().equals("columnDirection") || evt.getPropertyName().equals("height")) {
            this.updateSectionListeners();
            r = new Runnable(){

                public void run() {
                    ReportObjectScene.this.refreshDocument();
                }
            };
        }
        if (r != null) {
            ThreadUtils.invokeInAWTThread(r);
        }
        if (evt.getPropertyName().equals("groups")) {
            for (int i = 0; i < this.jasperDesign.getGroupsList().size(); ++i) {
                JRDesignGroup grp = (JRDesignGroup)this.jasperDesign.getGroupsList().get(i);
                grp.getEventSupport().removePropertyChangeListener((PropertyChangeListener)this);
                grp.getEventSupport().addPropertyChangeListener((PropertyChangeListener)this);
            }
        }
    }

    public boolean acceptDropAt(Point location) {
        Point p = this.convertViewToScene(location);
        return ModelUtils.getBandAt(IReportManager.getInstance().getActiveReport(), p) != null;
    }
}

